/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public CreateShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        log.info("Create shard invoked: {}", (Object)message);
        if (collectionName == null || sliceName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        DocCollection collection = clusterState.getCollection(collectionName);
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", collection.getInt("nrtReplicas", collection.getInt("replicationFactor", Integer.valueOf(1)))));
        int numPullReplicas = message.getInt("pullReplicas", collection.getInt("pullReplicas", Integer.valueOf(0)));
        int numTlogReplicas = message.getInt("tlogReplicas", collection.getInt("tlogReplicas", Integer.valueOf(0)));
        int totalReplicas = numNrtReplicas + numPullReplicas + numTlogReplicas;
        if (numNrtReplicas + numTlogReplicas <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "nrtReplicas + tlogReplicas must be greater than 0");
        }
        Object createNodeSetStr = message.get("createNodeSet");
        List<Assign.ReplicaCount> sortedNodeList = Assign.getNodesForNewReplicas(clusterState, collectionName, sliceName, totalReplicas, createNodeSetStr, this.ocmh.overseer.getZkController().getCoreContainer());
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)message));
        this.ocmh.waitForNewShard(collectionName, sliceName);
        String async = message.getStr("async");
        int createdNrtReplicas = 0;
        int createdTlogReplicas = 0;
        int createdPullReplicas = 0;
        CountDownLatch countDownLatch = new CountDownLatch(totalReplicas);
        for (int j = 1; j <= totalReplicas; ++j) {
            Replica.Type typeToCreate;
            int coreNameNumber;
            if (createdNrtReplicas < numNrtReplicas) {
                coreNameNumber = ++createdNrtReplicas;
                typeToCreate = Replica.Type.NRT;
            } else if (createdTlogReplicas < numTlogReplicas) {
                coreNameNumber = ++createdTlogReplicas;
                typeToCreate = Replica.Type.TLOG;
            } else {
                coreNameNumber = ++createdPullReplicas;
                typeToCreate = Replica.Type.PULL;
            }
            String nodeName = sortedNodeList.get((int)((j - 1) % sortedNodeList.size())).nodeName;
            String coreName = Assign.buildCoreName(collectionName, sliceName, typeToCreate, coreNameNumber);
            log.info("Creating replica " + coreName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
            ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", collectionName, "shard", sliceName, "replicaType", typeToCreate.name(), "node", nodeName, "name", coreName});
            HashMap<String, Object> propertyParams = new HashMap<String, Object>();
            this.ocmh.addPropertyParams(message, propertyParams);
            addReplicasProps = addReplicasProps.plus(propertyParams);
            if (async != null) {
                addReplicasProps.getProperties().put("async", async);
            }
            NamedList addResult = new NamedList();
            this.ocmh.addReplica(zkStateReader.getClusterState(), addReplicasProps, addResult, () -> {
                countDownLatch.countDown();
                Object addResultFailure = addResult.get("failure");
                if (addResultFailure != null) {
                    SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
                    if (failure == null) {
                        failure = new SimpleOrderedMap();
                        results.add("failure", (Object)failure);
                    }
                    failure.addAll((NamedList)addResultFailure);
                } else {
                    SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
                    if (success == null) {
                        success = new SimpleOrderedMap();
                        results.add("success", (Object)success);
                    }
                    success.addAll((NamedList)addResult.get("success"));
                }
            });
        }
        log.debug("Waiting for create shard action to complete");
        countDownLatch.await(5L, TimeUnit.MINUTES);
        log.debug("Finished waiting for create shard action to complete");
        log.info("Finished create command on all shards for collection: " + collectionName);
    }
}

