/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCollectionCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;
    private SolrZkClient zkClient;

    public CreateCollectionCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
        this.zkClient = ocmh.zkStateReader.getZkClient();
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("name");
        log.info("Create collection {}", (Object)collectionName);
        if (clusterState.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        boolean usePolicyFramework = CreateCollectionCmd.usePolicyFramework(this.ocmh.zkStateReader, message);
        String configName = this.getConfigName(collectionName, message);
        if (configName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No config set found to associate with the collection.");
        }
        this.ocmh.validateConfigOrThrowSolrException(configName);
        try {
            List<Object> replicaPositions;
            int numTlogReplicas = message.getInt("tlogReplicas", Integer.valueOf(0));
            int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", Integer.valueOf(numTlogReplicas > 0 ? 0 : 1)));
            int numPullReplicas = message.getInt("pullReplicas", Integer.valueOf(0));
            ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
            String async = message.getStr("async");
            Integer numSlices = message.getInt("numShards", null);
            String router = message.getStr("router.name", "compositeId");
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(router)) {
                ClusterStateMutator.getShardNames(shardNames, message.getStr("shards", null));
                numSlices = shardNames.size();
            } else {
                if (numSlices == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param (when using CompositeId router).");
                }
                ClusterStateMutator.getShardNames(numSlices, shardNames);
            }
            int maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(1));
            if (usePolicyFramework && message.getStr("maxShardsPerNode") != null && maxShardsPerNode > 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'maxShardsPerNode>0' is not supported when autoScaling policies are used");
            }
            if (maxShardsPerNode == -1 || usePolicyFramework) {
                maxShardsPerNode = Integer.MAX_VALUE;
            }
            if (numNrtReplicas + numTlogReplicas <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "nrtReplicas + tlogReplicas must be greater than 0");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            List<String> nodeList = Assign.getLiveOrLiveAndCreateNodeSetList(clusterState.getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM);
            if (nodeList.isEmpty()) {
                log.warn("It is unusual to create a collection (" + collectionName + ") without cores.");
                replicaPositions = new ArrayList();
            } else {
                int requestedShardsToCreate;
                int maxShardsAllowedToCreate;
                int totalNumReplicas = numNrtReplicas + numTlogReplicas + numPullReplicas;
                if (totalNumReplicas > nodeList.size()) {
                    log.warn("Specified number of replicas of " + totalNumReplicas + " on collection " + collectionName + " is higher than the number of Solr instances currently live or live and part of your " + "createNodeSet" + "(" + nodeList.size() + "). It's unusual to run two replica of the same slice on the same Solr-instance.");
                }
                if ((maxShardsAllowedToCreate = maxShardsPerNode == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * totalNumReplicas)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + "maxShardsPerNode" + " is " + maxShardsPerNode + ", and the number of nodes currently live or live and part of your " + "createNodeSet" + " is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + "numShards" + " is " + numSlices + ", value of " + "nrtReplicas" + " is " + numNrtReplicas + ", value of " + "tlogReplicas" + " is " + numTlogReplicas + " and value of " + "pullReplicas" + " is " + numPullReplicas + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
                }
                replicaPositions = Assign.identifyNodes(() -> this.ocmh.overseer.getZkController().getCoreContainer(), this.ocmh.zkStateReader, clusterState, nodeList, collectionName, message, shardNames, numNrtReplicas, numTlogReplicas, numPullReplicas);
            }
            ZkStateReader zkStateReader = this.ocmh.zkStateReader;
            boolean isLegacyCloud = Overseer.isLegacy(zkStateReader);
            this.ocmh.createConfNode(configName, collectionName, isLegacyCloud);
            HashMap<String, String> collectionParams = new HashMap<String, String>();
            Map collectionProps = message.getProperties();
            for (String propName : collectionProps.keySet()) {
                if (!propName.startsWith("collection.")) continue;
                collectionParams.put(propName.substring("collection.".length()), (String)collectionProps.get(propName));
            }
            CreateCollectionCmd.createCollectionZkNode(this.zkClient, collectionName, collectionParams);
            Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)message));
            TimeOut waitUntil = new TimeOut(30L, TimeUnit.SECONDS);
            boolean created = false;
            while (!waitUntil.hasTimedOut()) {
                Thread.sleep(100L);
                created = zkStateReader.getClusterState().hasCollection(collectionName);
                if (!created) continue;
            }
            if (!created) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create collection: " + collectionName);
            }
            if (nodeList.isEmpty()) {
                log.debug("Finished create command for collection: {}", (Object)collectionName);
                return;
            }
            HashMap<String, String> requestMap = new HashMap<String, String>();
            log.debug(StrUtils.formatString((String)"Creating SolrCores for new collection {0}, shardNames {1} , nrtReplicas : {2}, tlogReplicas: {3}, pullReplicas: {4}", (Object[])new Object[]{collectionName, shardNames, numNrtReplicas, numTlogReplicas, numPullReplicas}));
            LinkedHashMap<String, ShardRequest> coresToCreate = new LinkedHashMap<String, ShardRequest>();
            for (ReplicaPosition replicaPosition : replicaPositions) {
                String nodeName = replicaPosition.node;
                String coreName = Assign.buildCoreName(collectionName, replicaPosition.shard, replicaPosition.type, replicaPosition.index + 1);
                log.debug(StrUtils.formatString((String)"Creating core {0} as part of shard {1} of collection {2} on {3}", (Object[])new Object[]{coreName, replicaPosition.shard, collectionName, nodeName}));
                String baseUrl = zkStateReader.getBaseUrlForNodeName(nodeName);
                if (!isLegacyCloud) {
                    ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", collectionName, "shard", replicaPosition.shard, "core", coreName, "state", Replica.State.DOWN.toString(), "base_url", baseUrl, "type", replicaPosition.type.name()});
                    Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)props));
                }
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                params.set("name", new String[]{coreName});
                params.set("collection.configName", new String[]{configName});
                params.set("collection", new String[]{collectionName});
                params.set("shard", new String[]{replicaPosition.shard});
                params.set("numShards", numSlices.intValue());
                params.set("newCollection", new String[]{"true"});
                params.set("replicaType", new String[]{replicaPosition.type.name()});
                if (async != null) {
                    String coreAdminAsyncId = async + Math.abs(System.nanoTime());
                    params.add("async", new String[]{coreAdminAsyncId});
                    requestMap.put(nodeName, coreAdminAsyncId);
                }
                this.ocmh.addPropertyParams(message, params);
                ShardRequest sreq = new ShardRequest();
                sreq.nodeName = nodeName;
                params.set("qt", new String[]{this.ocmh.adminPath});
                sreq.purpose = 1;
                sreq.shards = new String[]{baseUrl};
                sreq.actualShards = sreq.shards;
                sreq.params = params;
                if (isLegacyCloud) {
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                    continue;
                }
                coresToCreate.put(coreName, sreq);
            }
            if (!isLegacyCloud) {
                Map<String, Replica> replicas = this.ocmh.waitToSeeReplicasInState(collectionName, coresToCreate.keySet());
                for (Map.Entry e : coresToCreate.entrySet()) {
                    ShardRequest sreq = (ShardRequest)e.getValue();
                    sreq.params.set("coreNodeName", new String[]{replicas.get(e.getKey()).getName()});
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                }
            }
            this.ocmh.processResponses(results, shardHandler, false, null, async, requestMap, Collections.emptySet());
            if (results.get("failure") != null && ((SimpleOrderedMap)results.get("failure")).size() > 0) {
                this.ocmh.cleanupCollection(collectionName, new NamedList());
                log.info("Cleaned up artifacts for failed create collection for [{}]", (Object)collectionName);
            } else {
                boolean defaultConfigSetUsed;
                log.debug("Finished create command on all shards for collection: {}", (Object)collectionName);
                boolean bl = defaultConfigSetUsed = message.getStr("collection.configName") == null || message.getStr("collection.configName").equals("_default");
                if (defaultConfigSetUsed) {
                    results.add("warning", (Object)("Using _default configset. Data driven schema functionality is enabled by default, which is NOT RECOMMENDED for production use. To turn it off: curl http://{host:port}/solr/" + collectionName + "/config -d '{\"set-user-property\": {\"update.autoCreateFields\":\"false\"}}'"));
                }
            }
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    String getConfigName(String coll, ZkNodeProps message) throws KeeperException, InterruptedException {
        String configName = message.getStr("collection.configName");
        if (configName == null) {
            List configNames = null;
            try {
                configNames = this.ocmh.zkStateReader.getZkClient().getChildren("/configs", null, true);
                if (configNames.contains("_default")) {
                    if (!".system".equals(coll)) {
                        this.copyDefaultConfigSetTo(configNames, coll);
                    }
                    return coll;
                }
                if (configNames != null && configNames.size() == 1) {
                    configName = (String)configNames.get(0);
                    log.info("Only one config set found in zk - using it:" + configName);
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        return "".equals(configName) ? null : configName;
    }

    private void copyDefaultConfigSetTo(List<String> configNames, String targetConfig) {
        ZkConfigManager configManager = new ZkConfigManager(this.ocmh.zkStateReader.getZkClient());
        if (configNames.contains(targetConfig)) {
            log.info("There exists a configset by the same name as the collection we're trying to create: " + targetConfig + ", deleting it so that we can copy the _default configs over and create the collection.");
            try {
                configManager.deleteConfigDir(targetConfig);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Error while deleting configset: " + targetConfig, (Throwable)e);
            }
        } else {
            log.info("Only _default config set found, using it.");
        }
        try {
            configManager.copyConfigDir("_default", targetConfig, new HashSet());
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Error while copying _default to " + targetConfig, (Throwable)e);
        }
    }

    public static void createCollectionZkNode(SolrZkClient zkClient, String collection, Map<String, String> params) {
        block17: {
            log.debug("Check for collection zkNode:" + collection);
            String collectionPath = "/collections/" + collection;
            try {
                if (!zkClient.exists(collectionPath, true).booleanValue()) {
                    log.debug("Creating collection in ZooKeeper:" + collection);
                    try {
                        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
                        String defaultConfigName = System.getProperty("collection.configName", collection);
                        if (params.size() > 0) {
                            collectionProps.putAll(params);
                            if (!collectionProps.containsKey("configName")) {
                                CreateCollectionCmd.getConfName(zkClient, collection, collectionPath, collectionProps);
                            }
                        } else if (System.getProperty("bootstrap_confdir") != null) {
                            log.info("Setting config for collection:" + collection + " to " + defaultConfigName);
                            Properties sysProps = System.getProperties();
                            for (String sprop : System.getProperties().stringPropertyNames()) {
                                if (!sprop.startsWith("collection.")) continue;
                                collectionProps.put(sprop.substring("collection.".length()), sysProps.getProperty(sprop));
                            }
                            if (!collectionProps.containsKey("configName")) {
                                collectionProps.put("configName", defaultConfigName);
                            }
                        } else if (Boolean.getBoolean("bootstrap_conf")) {
                            collectionProps.put("configName", collection);
                        } else {
                            CreateCollectionCmd.getConfName(zkClient, collection, collectionPath, collectionProps);
                        }
                        collectionProps.remove("numShards");
                        ZkNodeProps zkProps = new ZkNodeProps(collectionProps);
                        zkClient.makePath(collectionPath, Utils.toJSON((Object)zkProps), CreateMode.PERSISTENT, null, true);
                        break block17;
                    }
                    catch (KeeperException e) {
                        if (e.code() != KeeperException.Code.NODEEXISTS) {
                            throw e;
                        }
                        break block17;
                    }
                }
                log.debug("Collection zkNode exists");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
        }
    }

    private static void getConfName(SolrZkClient zkClient, String collection, String collectionPath, Map<String, Object> collectionProps) throws KeeperException, InterruptedException {
        ZkNodeProps cProps;
        int retry;
        log.debug("Looking for collection configName");
        if (collectionProps.containsKey("configName")) {
            log.info("configName was passed as a param {}", collectionProps.get("configName"));
            return;
        }
        List configNames = null;
        int retryLimt = 6;
        for (retry = 1; !(retry >= retryLimt || zkClient.exists(collectionPath, true).booleanValue() && (cProps = ZkNodeProps.load((byte[])zkClient.getData(collectionPath, null, null, true))).containsKey("configName")); ++retry) {
            try {
                configNames = zkClient.getChildren("/configs", null, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            if (configNames != null && configNames.contains(collection)) {
                log.info("Could not find explicit collection configName, but found config name matching collection name - using that set.");
                collectionProps.put("configName", collection);
                break;
            }
            if (configNames != null && configNames.contains("_default")) {
                log.info("Could not find explicit collection configName, but found _default config set - using that set.");
                collectionProps.put("configName", "_default");
                break;
            }
            if (configNames != null && configNames.size() == 1) {
                log.info("Only one config set found in zk - using it:" + (String)configNames.get(0));
                collectionProps.put("configName", configNames.get(0));
                break;
            }
            log.info("Could not find collection configName - pausing for 3 seconds and trying again - try: " + retry);
            Thread.sleep(3000L);
        }
        if (retry == retryLimt) {
            log.error("Could not find configName for collection " + collection);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find configName for collection " + collection + " found:" + configNames);
        }
    }

    public static boolean usePolicyFramework(ZkStateReader zkStateReader, ZkNodeProps message) {
        Map autoScalingJson = Collections.emptyMap();
        try {
            autoScalingJson = Utils.getJson((SolrZkClient)zkStateReader.getZkClient(), (String)"/autoscaling.json", (boolean)true);
        }
        catch (Exception e) {
            return false;
        }
        return autoScalingJson.get("cluster-policy") != null || message.getStr("policy") != null;
    }
}

