/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.ClusterDataProvider;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.SolrClientDataProvider;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.zookeeper.KeeperException;

public class Assign {
    private static Pattern COUNT = Pattern.compile("core_node(\\d+)");

    public static String assignNode(DocCollection collection) {
        Map sliceMap;
        Map map = sliceMap = collection != null ? collection.getSlicesMap() : null;
        if (sliceMap == null) {
            return "core_node1";
        }
        int max = 0;
        for (Slice slice : sliceMap.values()) {
            for (Replica replica : slice.getReplicas()) {
                Matcher m = COUNT.matcher(replica.getName());
                if (!m.matches()) continue;
                max = Math.max(max, Integer.parseInt(m.group(1)));
            }
        }
        return "core_node" + (max + 1);
    }

    public static String assignShard(DocCollection collection, Integer numShards) {
        Map sliceMap;
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map map = sliceMap = collection != null ? collection.getActiveSlicesMap() : null;
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList shardIdNames = new ArrayList(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = ((Slice)sliceMap.get(shardId)).getReplicasMap().size();
            map2.put(shardId, cnt);
        }
        Collections.sort(shardIdNames, (o1, o2) -> {
            Integer one = (Integer)map2.get(o1);
            Integer two = (Integer)map2.get(o2);
            return one.compareTo(two);
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }

    public static String buildCoreName(String collectionName, String shard, Replica.Type type, int replicaNum) {
        return String.format(Locale.ROOT, "%s_%s_replica_%s%s", collectionName, shard, type.name().substring(0, 1).toLowerCase(Locale.ROOT), replicaNum);
    }

    public static String buildCoreName(DocCollection collection, String shard, Replica.Type type) {
        String replicaName;
        Slice slice = collection.getSlice(shard);
        int replicaNum = slice.getReplicas().size();
        while (true) {
            replicaName = Assign.buildCoreName(collection.getName(), shard, type, replicaNum);
            boolean exists = false;
            for (Replica replica : slice.getReplicas()) {
                if (!replicaName.equals(replica.getStr("core"))) continue;
                exists = true;
                break;
            }
            if (!exists) break;
            ++replicaNum;
        }
        return replicaName;
    }

    public static List<String> getLiveOrLiveAndCreateNodeSetList(Set<String> liveNodes, ZkNodeProps message, Random random) {
        ArrayList<Object> nodeList;
        List createNodeList;
        String createNodeSetStr = message.getStr("createNodeSet");
        List list = createNodeSetStr == null ? null : (createNodeList = StrUtils.splitSmart((String)("EMPTY".equals(createNodeSetStr) ? "" : createNodeSetStr), (String)",", (boolean)true));
        if (createNodeList != null) {
            nodeList = new ArrayList(createNodeList);
            nodeList.retainAll(liveNodes);
            if (message.getBool("createNodeSet.shuffle", true)) {
                Collections.shuffle(nodeList, random);
            }
        } else {
            nodeList = new ArrayList<String>(liveNodes);
            Collections.shuffle(nodeList, random);
        }
        return nodeList;
    }

    public static List<ReplicaPosition> identifyNodes(Supplier<CoreContainer> coreContainer, ZkStateReader zkStateReader, ClusterState clusterState, List<String> nodeList, String collectionName, ZkNodeProps message, List<String> shardNames, int numNrtReplicas, int numTlogReplicas, int numPullReplicas) throws KeeperException, InterruptedException {
        List rulesMap = (List)message.get("rule");
        String policyName = message.getStr("policy");
        Map autoScalingJson = Utils.getJson((SolrZkClient)zkStateReader.getZkClient(), (String)"/autoscaling.json", (boolean)true);
        if (rulesMap == null && policyName == null && autoScalingJson.get("cluster-policy") == null) {
            int i = 0;
            ArrayList<ReplicaPosition> result = new ArrayList<ReplicaPosition>();
            for (String aShard : shardNames) {
                for (Map.Entry e2 : ImmutableMap.of((Object)Replica.Type.NRT, (Object)numNrtReplicas, (Object)Replica.Type.TLOG, (Object)numTlogReplicas, (Object)Replica.Type.PULL, (Object)numPullReplicas).entrySet()) {
                    for (int j = 0; j < (Integer)e2.getValue(); ++j) {
                        result.add(new ReplicaPosition(aShard, j, (Replica.Type)e2.getKey(), nodeList.get(i % nodeList.size())));
                        ++i;
                    }
                }
            }
            return result;
        }
        if (numTlogReplicas + numPullReplicas != 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, Replica.Type.TLOG + " or " + Replica.Type.PULL + " replica types not supported with placement rules or cluster policies");
        }
        if (rulesMap != null && !rulesMap.isEmpty()) {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            for (Object map : rulesMap) {
                rules.add(new Rule((Map)map));
            }
            HashMap<String, Integer> sharVsReplicaCount = new HashMap<String, Integer>();
            for (String shard : shardNames) {
                sharVsReplicaCount.put(shard, numNrtReplicas);
            }
            ReplicaAssigner replicaAssigner = new ReplicaAssigner(rules, sharVsReplicaCount, (List)message.get("snitch"), new HashMap<String, Map<String, Integer>>(), nodeList, coreContainer.get(), clusterState);
            Map<ReplicaPosition, String> nodeMappings = replicaAssigner.getNodeMappings();
            return nodeMappings.entrySet().stream().map(e -> new ReplicaPosition(((ReplicaPosition)e.getKey()).shard, ((ReplicaPosition)e.getKey()).index, ((ReplicaPosition)e.getKey()).type, (String)e.getValue())).collect(Collectors.toList());
        }
        return Assign.getPositionsUsingPolicy(collectionName, shardNames, numNrtReplicas, policyName, zkStateReader, nodeList);
    }

    public static List<ReplicaCount> getNodesForNewReplicas(ClusterState clusterState, String collectionName, String shard, int numberOfNodes, Object createNodeSet, CoreContainer cc) throws KeeperException, InterruptedException {
        DocCollection coll = clusterState.getCollection(collectionName);
        Integer maxShardsPerNode = coll.getInt("maxShardsPerNode", Integer.valueOf(1));
        List createNodeList = null;
        createNodeList = createNodeSet instanceof List ? (List)createNodeSet : (createNodeSet == null ? null : StrUtils.splitSmart((String)((String)createNodeSet), (String)",", (boolean)true));
        HashMap<String, ReplicaCount> nodeNameVsShardCount = Assign.getNodeNameVsShardCount(collectionName, clusterState, createNodeList);
        if (createNodeList == null) {
            int availableSlots = 0;
            for (Map.Entry<String, ReplicaCount> ent : nodeNameVsShardCount.entrySet()) {
                if (maxShardsPerNode <= ent.getValue().thisCollectionNodes) continue;
                availableSlots += maxShardsPerNode - ent.getValue().thisCollectionNodes;
            }
            if (availableSlots < numberOfNodes) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Cannot create %d new replicas for collection %s given the current number of live nodes and a maxShardsPerNode of %d", numberOfNodes, collectionName, maxShardsPerNode));
            }
        }
        List l = (List)coll.get("rule");
        List<ReplicaPosition> replicaPositions = null;
        if (l != null) {
            replicaPositions = Assign.getNodesViaRules(clusterState, shard, numberOfNodes, cc, coll, createNodeList, l);
        }
        String policyName = coll.getStr("policy");
        Map autoScalingJson = Utils.getJson((SolrZkClient)cc.getZkController().getZkClient(), (String)"/autoscaling.json", (boolean)true);
        if (policyName != null || autoScalingJson.get("cluster-policy") != null) {
            replicaPositions = Assign.getPositionsUsingPolicy(collectionName, Collections.singletonList(shard), numberOfNodes, policyName, cc.getZkController().getZkStateReader(), createNodeList);
        }
        if (replicaPositions != null) {
            ArrayList<ReplicaCount> repCounts = new ArrayList<ReplicaCount>();
            for (ReplicaPosition p : replicaPositions) {
                repCounts.add(new ReplicaCount(p.node));
            }
            return repCounts;
        }
        ArrayList<ReplicaCount> sortedNodeList = new ArrayList<ReplicaCount>(nodeNameVsShardCount.values());
        Collections.sort(sortedNodeList, (x, y) -> x.weight() < y.weight() ? -1 : (x.weight() == y.weight() ? 0 : 1));
        return sortedNodeList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ReplicaPosition> getPositionsUsingPolicy(String collName, List<String> shardNames, int numReplicas, String policyName, ZkStateReader zkStateReader, List<String> nodesList) throws KeeperException, InterruptedException {
        try (CloudSolrClient csc = new CloudSolrClient.Builder().withClusterStateProvider((ClusterStateProvider)new ZkClientClusterStateProvider(zkStateReader)).build();){
            SolrClientDataProvider clientDataProvider = new SolrClientDataProvider(csc);
            Map autoScalingJson = Utils.getJson((SolrZkClient)zkStateReader.getZkClient(), (String)"/autoscaling.json", (boolean)true);
            Map locations = PolicyHelper.getReplicaLocations((String)collName, (Map)autoScalingJson, (ClusterDataProvider)clientDataProvider, Collections.singletonMap(collName, policyName), shardNames, (int)numReplicas, nodesList);
            ArrayList<ReplicaPosition> result = new ArrayList<ReplicaPosition>();
            for (Map.Entry e : locations.entrySet()) {
                List value = (List)e.getValue();
                for (int i = 0; i < value.size(); ++i) {
                    result.add(new ReplicaPosition((String)e.getKey(), i, Replica.Type.NRT, (String)value.get(i)));
                }
            }
            ArrayList<ReplicaPosition> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error closing CloudSolrClient", (Throwable)e);
        }
    }

    private static List<ReplicaPosition> getNodesViaRules(ClusterState clusterState, String shard, int numberOfNodes, CoreContainer cc, DocCollection coll, List<String> createNodeList, List l) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Object o : l) {
            rules.add(new Rule((Map)o));
        }
        LinkedHashMap<String, Map<String, Integer>> shardVsNodes = new LinkedHashMap<String, Map<String, Integer>>();
        for (Slice slice : coll.getSlices()) {
            LinkedHashMap<String, Integer> n = new LinkedHashMap<String, Integer>();
            shardVsNodes.put(slice.getName(), n);
            for (Replica replica : slice.getReplicas()) {
                Integer count = (Integer)n.get(replica.getNodeName());
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                n.put(replica.getNodeName(), count);
            }
        }
        List snitches = (List)coll.get("snitch");
        ArrayList<String> nodesList = createNodeList == null ? new ArrayList<String>(clusterState.getLiveNodes()) : createNodeList;
        Map<ReplicaPosition, String> positions = new ReplicaAssigner(rules, Collections.singletonMap(shard, numberOfNodes), snitches, shardVsNodes, nodesList, cc, clusterState).getNodeMappings();
        return positions.entrySet().stream().map(e -> ((ReplicaPosition)e.getKey()).setNode((String)e.getValue())).collect(Collectors.toList());
    }

    private static HashMap<String, ReplicaCount> getNodeNameVsShardCount(String collectionName, ClusterState clusterState, List<String> createNodeList) {
        Set nodes = clusterState.getLiveNodes();
        ArrayList nodeList = new ArrayList(nodes.size());
        nodeList.addAll(nodes);
        if (createNodeList != null) {
            nodeList.retainAll(createNodeList);
        }
        HashMap<String, ReplicaCount> nodeNameVsShardCount = new HashMap<String, ReplicaCount>();
        for (String s : nodeList) {
            nodeNameVsShardCount.put(s, new ReplicaCount(s));
        }
        if (createNodeList != null) {
            if (createNodeList.size() != nodeNameVsShardCount.size()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of the node(s) specified are not currently active, no action taken.");
            }
            return nodeNameVsShardCount;
        }
        DocCollection coll = clusterState.getCollection(collectionName);
        Integer maxShardsPerNode = coll.getInt("maxShardsPerNode", Integer.valueOf(1));
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            DocCollection c = (DocCollection)entry.getValue();
            for (Slice slice : c.getSlices()) {
                Collection replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    ReplicaCount count = nodeNameVsShardCount.get(replica.getNodeName());
                    if (count == null) continue;
                    ++count.totalNodes;
                    if (!((String)entry.getKey()).equals(collectionName)) continue;
                    ++count.thisCollectionNodes;
                    if (count.thisCollectionNodes < maxShardsPerNode) continue;
                    nodeNameVsShardCount.remove(replica.getNodeName());
                }
            }
        }
        return nodeNameVsShardCount;
    }

    static class ReplicaCount {
        public final String nodeName;
        public int thisCollectionNodes = 0;
        public int totalNodes = 0;

        ReplicaCount(String nodeName) {
            this.nodeName = nodeName;
        }

        public int weight() {
            return this.thisCollectionNodes * 100 + this.totalNodes;
        }
    }
}

