/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddReplicaCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public AddReplicaCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.addReplica(this.ocmh.zkStateReader.getClusterState(), message, results, null);
    }

    ZkNodeProps addReplica(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete) throws KeeperException, InterruptedException {
        log.debug("addReplica() : {}", (Object)Utils.toJSONString((Object)message));
        String collection = message.getStr("collection");
        String node = message.getStr("node");
        String shard = message.getStr("shard");
        String coreName = message.getStr("name");
        Replica.Type replicaType = Replica.Type.valueOf((String)message.getStr("type", Replica.Type.NRT.name()).toUpperCase(Locale.ROOT));
        boolean parallel = message.getBool("parallel", false);
        if (StringUtils.isBlank((String)coreName)) {
            coreName = message.getStr("property.name");
        }
        String asyncId = message.getStr("async");
        DocCollection coll = clusterState.getCollection(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " does not exist");
        }
        if (coll.getSlice(shard) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " shard: " + shard + " does not exist");
        }
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        boolean skipCreateReplicaInClusterState = message.getBool("skipCreateReplicaInClusterState", false);
        if (!skipCreateReplicaInClusterState) {
            node = Assign.getNodesForNewReplicas((ClusterState)clusterState, (String)collection, (String)shard, (int)1, (Object)node, (CoreContainer)this.ocmh.overseer.getZkController().getCoreContainer()).get((int)0).nodeName;
        }
        log.info("Node Identified {} for creating new replica", (Object)node);
        if (!clusterState.liveNodesContain(node)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Node: " + node + " is not live");
        }
        if (coreName == null) {
            coreName = Assign.buildCoreName(coll, shard, replicaType);
        } else if (!skipCreateReplicaInClusterState) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    String replicaCoreName = replica.getStr("core");
                    if (!coreName.equals(replicaCoreName)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Another replica with the same core name already exists for this collection");
                }
            }
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        if (!Overseer.isLegacy(zkStateReader)) {
            if (!skipCreateReplicaInClusterState) {
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collection, "shard", shard, "core", coreName, "state", Replica.State.DOWN.toString(), "base_url", zkStateReader.getBaseUrlForNodeName(node), "node_name", node, "type", replicaType.name()});
                Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)props));
            }
            params.set("coreNodeName", new String[]{this.ocmh.waitToSeeReplicasInState(collection, Collections.singletonList(coreName)).get(coreName).getName()});
        }
        String configName = zkStateReader.readConfigName(collection);
        String routeKey = message.getStr("_route_");
        String dataDir = message.getStr("dataDir");
        String ulogDir = message.getStr("ulogDir");
        String instanceDir = message.getStr("instanceDir");
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
        params.set("name", new String[]{coreName});
        params.set("collection.configName", new String[]{configName});
        params.set("collection", new String[]{collection});
        params.set("replicaType", new String[]{replicaType.name()});
        if (shard != null) {
            params.set("shard", new String[]{shard});
        } else if (routeKey != null) {
            Collection slices = coll.getRouter().getSearchSlicesSingle(routeKey, null, coll);
            if (slices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active shard serving _route_=" + routeKey + " found");
            }
            params.set("shard", new String[]{((Slice)slices.iterator().next()).getName()});
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify either 'shard' or _route_ param");
        }
        if (dataDir != null) {
            params.set("dataDir", new String[]{dataDir});
        }
        if (ulogDir != null) {
            params.set("ulogDir", new String[]{ulogDir});
        }
        if (instanceDir != null) {
            params.set("instanceDir", new String[]{instanceDir});
        }
        this.ocmh.addPropertyParams(message, params);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        this.ocmh.sendShardRequest(node, params, shardHandler, asyncId, requestMap);
        String fnode = node;
        String fcoreName = coreName;
        Runnable runnable = () -> {
            this.ocmh.processResponses(results, shardHandler, true, "ADDREPLICA failed to create replica", asyncId, requestMap);
            this.ocmh.waitForCoreNodeName(collection, fnode, fcoreName);
            if (onComplete != null) {
                onComplete.run();
            }
        };
        if (!parallel) {
            runnable.run();
        } else {
            this.ocmh.tpe.submit(runnable);
        }
        return new ZkNodeProps(new String[]{"collection", collection, "shard", shard, "core", coreName, "node_name", node});
    }
}

