/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.solr.util.stats.Clock;
import org.apache.solr.util.stats.Sample;
import org.apache.solr.util.stats.Snapshot;

public class ExponentiallyDecayingSample
implements Sample {
    private static final long RESCALE_THRESHOLD = TimeUnit.HOURS.toNanos(1L);
    private final ConcurrentSkipListMap<Double, Long> values;
    private final ReentrantReadWriteLock lock;
    private final double alpha;
    private final int reservoirSize;
    private final AtomicLong count = new AtomicLong(0L);
    private volatile long startTime;
    private final AtomicLong nextScaleTime = new AtomicLong(0L);
    private final Clock clock;
    private final Random random = new Random();

    public ExponentiallyDecayingSample(int reservoirSize, double alpha) {
        this(reservoirSize, alpha, Clock.defaultClock());
    }

    public ExponentiallyDecayingSample(int reservoirSize, double alpha, Clock clock) {
        this.values = new ConcurrentSkipListMap();
        this.lock = new ReentrantReadWriteLock();
        this.alpha = alpha;
        this.reservoirSize = reservoirSize;
        this.clock = clock;
        this.clear();
    }

    @Override
    public void clear() {
        this.lockForRescale();
        try {
            this.values.clear();
            this.count.set(0L);
            this.startTime = this.currentTimeInSeconds();
            this.nextScaleTime.set(this.clock.getTick() + RESCALE_THRESHOLD);
        }
        finally {
            this.unlockForRescale();
        }
    }

    @Override
    public int size() {
        return (int)Math.min((long)this.reservoirSize, this.count.get());
    }

    @Override
    public void update(long value) {
        this.update(value, this.currentTimeInSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value, long timestamp) {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            double priority = this.weight(timestamp - this.startTime) / this.random.nextDouble();
            long newCount = this.count.incrementAndGet();
            if (newCount <= (long)this.reservoirSize) {
                this.values.put(priority, value);
            } else {
                Double first = this.values.firstKey();
                if (first < priority && this.values.putIfAbsent(priority, value) == null) {
                    while (this.values.remove(first) == null) {
                        first = this.values.firstKey();
                    }
                }
            }
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private void rescaleIfNeeded() {
        long next;
        long now = this.clock.getTick();
        if (now >= (next = this.nextScaleTime.get())) {
            this.rescale(now, next);
        }
    }

    @Override
    public Snapshot getSnapshot() {
        this.lockForRegularUsage();
        try {
            Snapshot snapshot = new Snapshot(this.values.values());
            return snapshot;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private long currentTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime());
    }

    private double weight(long t) {
        return Math.exp(this.alpha * (double)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now, long next) {
        if (this.nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lockForRescale();
            try {
                long oldStartTime = this.startTime;
                this.startTime = this.currentTimeInSeconds();
                ArrayList keys = new ArrayList(this.values.keySet());
                for (Double key : keys) {
                    Long value = this.values.remove(key);
                    this.values.put(key * Math.exp(-this.alpha * (double)(this.startTime - oldStartTime)), value);
                }
                this.count.set(this.values.size());
            }
            finally {
                this.unlockForRescale();
            }
        }
    }

    private void unlockForRescale() {
        this.lock.writeLock().unlock();
    }

    private void lockForRescale() {
        this.lock.writeLock().lock();
    }

    private void lockForRegularUsage() {
        this.lock.readLock().lock();
    }

    private void unlockForRegularUsage() {
        this.lock.readLock().unlock();
    }
}

