/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFingerprint {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private long maxVersionSpecified;
    private long maxVersionEncountered;
    private long maxInHash;
    private long versionsHash;
    private long numVersions;
    private long numDocs;
    private long maxDoc;

    public long getMaxVersionSpecified() {
        return this.maxVersionSpecified;
    }

    public long getMaxVersionEncountered() {
        return this.maxVersionEncountered;
    }

    public long getMaxInHash() {
        return this.maxInHash;
    }

    public long getVersionsHash() {
        return this.versionsHash;
    }

    public long getNumVersions() {
        return this.numVersions;
    }

    public long getNumDocs() {
        return this.numDocs;
    }

    public long getMaxDoc() {
        return this.maxDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexFingerprint getFingerprint(SolrCore core, long maxVersion) throws IOException {
        core.getUpdateHandler().getUpdateLog().openRealtimeSearcher();
        RefCounted<SolrIndexSearcher> newestSearcher = core.getUpdateHandler().getUpdateLog().uhandler.core.getRealtimeSearcher();
        try {
            IndexFingerprint indexFingerprint = newestSearcher.get().getIndexFingerprint(maxVersion);
            return indexFingerprint;
        }
        finally {
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }

    public static IndexFingerprint getFingerprint(SolrIndexSearcher searcher, long maxVersion) throws IOException {
        RTimer timer = new RTimer();
        SchemaField versionField = VersionInfo.getAndCheckVersionField(searcher.getSchema());
        IndexFingerprint f = new IndexFingerprint();
        f.maxVersionSpecified = maxVersion;
        f.maxDoc = searcher.maxDoc();
        ValueSource vs = versionField.getType().getValueSource(versionField, null);
        Map funcContext = ValueSource.newContext((IndexSearcher)searcher);
        vs.createWeight(funcContext, (IndexSearcher)searcher);
        for (LeafReaderContext ctx : searcher.getTopReaderContext().leaves()) {
            int maxDoc = ctx.reader().maxDoc();
            f.numDocs += (long)ctx.reader().numDocs();
            Bits liveDocs = ctx.reader().getLiveDocs();
            FunctionValues fv = vs.getValues(funcContext, ctx);
            for (int doc = 0; doc < maxDoc; ++doc) {
                if (liveDocs != null && !liveDocs.get(doc)) continue;
                long v = fv.longVal(doc);
                f.maxVersionEncountered = Math.max(v, f.maxVersionEncountered);
                if (v > f.maxVersionSpecified) continue;
                f.maxInHash = Math.max(v, f.maxInHash);
                f.versionsHash += Hash.fmix64((long)v);
                ++f.numVersions;
            }
        }
        double duration = timer.stop();
        log.info("IndexFingerprint millis:" + duration + " result:" + f);
        return f;
    }

    public static int compare(IndexFingerprint f1, IndexFingerprint f2) {
        int cmp;
        if (f1.maxVersionSpecified == Long.MAX_VALUE && (cmp = Long.compare(f1.maxVersionEncountered, f2.maxVersionEncountered)) != 0) {
            return cmp;
        }
        cmp = Long.compare(f1.maxInHash, f2.maxInHash);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(f1.numVersions, f2.numVersions);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(f1.versionsHash, f2.versionsHash);
        return cmp;
    }

    public Object toObject() {
        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
        map.put("maxVersionSpecified", this.maxVersionSpecified);
        map.put("maxVersionEncountered", this.maxVersionEncountered);
        map.put("maxInHash", this.maxInHash);
        map.put("versionsHash", this.versionsHash);
        map.put("numVersions", this.numVersions);
        map.put("numDocs", this.numDocs);
        map.put("maxDoc", this.maxDoc);
        return map;
    }

    private static long getLong(Object o, String key, long def) {
        long v = def;
        Object oval = null;
        if (o instanceof Map) {
            oval = ((Map)o).get(key);
        } else if (o instanceof NamedList) {
            oval = ((NamedList)o).get(key);
        }
        return oval != null ? ((Number)oval).longValue() : def;
    }

    public static IndexFingerprint fromObject(Object o) {
        IndexFingerprint f = new IndexFingerprint();
        f.maxVersionSpecified = IndexFingerprint.getLong(o, "maxVersionSpecified", Long.MAX_VALUE);
        f.maxVersionEncountered = IndexFingerprint.getLong(o, "maxVersionEncountered", -1L);
        f.maxInHash = IndexFingerprint.getLong(o, "maxInHash", -1L);
        f.versionsHash = IndexFingerprint.getLong(o, "versionsHash", -1L);
        f.numVersions = IndexFingerprint.getLong(o, "numVersions", -1L);
        f.numDocs = IndexFingerprint.getLong(o, "numDocs", -1L);
        f.maxDoc = IndexFingerprint.getLong(o, "maxDoc", -1L);
        return f;
    }

    public String toString() {
        return this.toObject().toString();
    }
}

