/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;
import org.apache.solr.util.RTimerTree;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSolrCall {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Random random;
    protected final SolrDispatchFilter solrDispatchFilter;
    protected final CoreContainer cores;
    protected final HttpServletRequest req;
    protected final HttpServletResponse response;
    protected final boolean retry;
    protected SolrCore core = null;
    protected SolrQueryRequest solrReq = null;
    protected SolrRequestHandler handler = null;
    protected final SolrParams queryParams;
    protected String path;
    protected SolrDispatchFilter.Action action;
    protected String coreUrl;
    protected SolrConfig config;
    protected Map<String, Integer> invalidStates;
    protected AuthorizationContext.RequestType requestType;
    protected List<String> collectionsList;
    static final String CONNECTION_HEADER = "Connection";
    static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    static final String CONTENT_LENGTH_HEADER = "Content-Length";

    public AuthorizationContext.RequestType getRequestType() {
        return this.requestType;
    }

    public List<String> getCollectionsList() {
        return this.collectionsList;
    }

    public HttpSolrCall(SolrDispatchFilter solrDispatchFilter, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
        this.solrDispatchFilter = solrDispatchFilter;
        this.cores = cores;
        this.req = request;
        this.response = response;
        this.retry = retry;
        this.requestType = AuthorizationContext.RequestType.UNKNOWN;
        this.queryParams = SolrRequestParsers.parseQueryString(this.req.getQueryString());
    }

    public String getPath() {
        return this.path;
    }

    public HttpServletRequest getReq() {
        return this.req;
    }

    public SolrCore getCore() {
        return this.core;
    }

    public SolrParams getQueryParams() {
        return this.queryParams;
    }

    private void init() throws Exception {
        int idx;
        String alternate;
        Aliases aliases = null;
        String corename = "";
        String origCorename = null;
        this.req.setAttribute("org.apache.solr.RequestTimer", (Object)new RTimerTree());
        this.req.setAttribute("org.apache.solr.CoreContainer", (Object)this.cores);
        this.path = this.req.getServletPath();
        if (this.req.getPathInfo() != null) {
            this.path = this.path + this.req.getPathInfo();
        }
        if ((alternate = this.cores.getManagementPath()) != null && this.path.startsWith(alternate)) {
            this.path = this.path.substring(0, alternate.length());
        }
        if ((idx = this.path.indexOf(58)) > 0) {
            this.path = this.path.substring(0, idx);
        }
        boolean usingAliases = false;
        this.handler = this.cores.getRequestHandler(this.path);
        if (this.handler != null) {
            this.solrReq = SolrRequestParsers.DEFAULT.parse(null, this.path, this.req);
            this.solrReq.getContext().put(CoreContainer.class.getName(), this.cores);
            this.requestType = AuthorizationContext.RequestType.ADMIN;
            this.action = SolrDispatchFilter.Action.ADMIN;
            return;
        }
        idx = this.path.indexOf("/", 1);
        if (idx > 1) {
            corename = this.path.substring(1, idx);
            if (this.cores.isZooKeeperAware()) {
                origCorename = corename;
                ZkStateReader reader = this.cores.getZkController().getZkStateReader();
                aliases = reader.getAliases();
                if (aliases != null && aliases.collectionAliasSize() > 0) {
                    usingAliases = true;
                    String alias = aliases.getCollectionAlias(corename);
                    if (alias != null) {
                        this.collectionsList = StrUtils.splitSmart((String)alias, (String)",", (boolean)true);
                        corename = this.collectionsList.get(0);
                    }
                }
            }
            this.core = this.cores.getCore(corename);
            if (this.core != null) {
                this.path = this.path.substring(idx);
            } else {
                if (this.cores.isCoreLoading(corename)) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "SolrCore is loading");
                }
                this.core = this.cores.getCore(corename);
                if (this.core != null) {
                    this.path = this.path.substring(idx);
                }
            }
        }
        if (this.core == null && !this.cores.isZooKeeperAware()) {
            this.core = this.cores.getCore("");
        }
        if (this.core == null && this.cores.isZooKeeperAware()) {
            this.core = this.getCoreByCollection(corename);
            if (this.core != null) {
                this.path = this.path.substring(idx);
                if (this.collectionsList == null) {
                    this.collectionsList = new ArrayList<String>();
                }
                this.collectionsList.add(corename);
            }
            this.extractRemotePath(corename, origCorename, idx);
            if (this.action != null) {
                return;
            }
        }
        if (this.core != null) {
            MDCLoggingContext.setCore(this.core);
            this.config = this.core.getSolrConfig();
            SolrRequestParsers parser = this.config.getRequestParsers();
            this.extractHandlerFromURLPath(parser);
            if (this.action != null) {
                return;
            }
            if (this.handler != null) {
                if (this.solrReq == null) {
                    this.solrReq = parser.parse(this.core, this.path, this.req);
                }
                if (usingAliases) {
                    this.processAliases(aliases, this.collectionsList);
                }
                this.action = SolrDispatchFilter.Action.PROCESS;
                return;
            }
        }
        log.debug("no handler or core retrieved for " + this.path + ", follow through...");
        this.action = SolrDispatchFilter.Action.PASSTHROUGH;
    }

    private void extractHandlerFromURLPath(SolrRequestParsers parser) throws Exception {
        if (this.handler == null && this.path.length() > 1) {
            this.handler = this.core.getRequestHandler(this.path);
            if (this.handler == null && (this.path.equals("/schema") || this.path.startsWith("/schema/"))) {
                this.solrReq = parser.parse(this.core, this.path, this.req);
                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.solrReq, new SolrQueryResponse()));
                if (this.path.equals(this.req.getServletPath())) {
                    this.action = SolrDispatchFilter.Action.PASSTHROUGH;
                    return;
                }
                this.action = SolrDispatchFilter.Action.FORWARD;
                return;
            }
            if (this.handler == null && parser.isHandleSelect() && ("/select".equals(this.path) || "/select/".equals(this.path))) {
                this.solrReq = parser.parse(this.core, this.path, this.req);
                this.invalidStates = this.checkStateIsValid(this.solrReq.getParams().get("_stateVer_"));
                String qt = this.solrReq.getParams().get("qt");
                this.handler = this.core.getRequestHandler(qt);
                if (this.handler == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                }
                if (qt != null && qt.startsWith("/") && this.handler instanceof ContentStreamHandlerBase) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Request Handler ('qt').  Do not use /select to access: " + qt);
                }
            }
        }
    }

    private void extractRemotePath(String corename, String origCorename, int idx) throws UnsupportedEncodingException, KeeperException, InterruptedException {
        if (this.core == null && idx > 0) {
            this.coreUrl = this.getRemotCoreUrl(corename, origCorename);
            this.invalidStates = this.checkStateIsValid(this.queryParams.get("_stateVer_"));
            if (this.coreUrl != null && this.queryParams.get("update.distrib") == null) {
                this.path = this.path.substring(idx);
                if (this.invalidStates != null) {
                    throw new SolrException(SolrException.ErrorCode.INVALID_STATE, new String(Utils.toJSON(this.invalidStates), IOUtils.UTF_8));
                }
                this.action = SolrDispatchFilter.Action.REMOTEQUERY;
            } else if (!this.retry) {
                ZkStateReader reader = this.cores.getZkController().getZkStateReader();
                reader.updateAliases();
                this.action = SolrDispatchFilter.Action.RETRY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrDispatchFilter.Action call() throws IOException {
        SolrDispatchFilter.Action action;
        MDCLoggingContext.reset();
        MDCLoggingContext.setNode(this.cores);
        if (this.cores == null) {
            this.sendError(503, "Server is shutting down or failed to initialize");
            return SolrDispatchFilter.Action.RETURN;
        }
        if (this.solrDispatchFilter.abortErrorMessage != null) {
            this.sendError(500, this.solrDispatchFilter.abortErrorMessage);
            return SolrDispatchFilter.Action.RETURN;
        }
        try {
            Object authResponse;
            this.init();
            if (this.cores.getAuthorizationPlugin() != null && this.shouldAuthorize()) {
                Object headers;
                AuthorizationContext context = this.getAuthCtx();
                log.debug("AuthorizationContext : {}", (Object)context);
                authResponse = this.cores.getAuthorizationPlugin().authorize(context);
                if (((AuthorizationResponse)authResponse).statusCode == AuthorizationResponse.PROMPT.statusCode) {
                    headers = (Map)this.getReq().getAttribute(AuthenticationPlugin.class.getName());
                    if (headers != null) {
                        for (Map.Entry e : headers.entrySet()) {
                            this.response.setHeader((String)e.getKey(), (String)e.getValue());
                        }
                    }
                    log.debug("USER_REQUIRED " + this.req.getHeader("Authorization") + " " + this.req.getUserPrincipal());
                }
                if (((AuthorizationResponse)authResponse).statusCode != 202 && ((AuthorizationResponse)authResponse).statusCode != 200) {
                    log.info("USER_REQUIRED auth header {} context : {} ", (Object)this.req.getHeader("Authorization"), (Object)context);
                    this.sendError(((AuthorizationResponse)authResponse).statusCode, "Unauthorized request, Response code: " + ((AuthorizationResponse)authResponse).statusCode);
                    headers = SolrDispatchFilter.Action.RETURN;
                    return headers;
                }
            }
            HttpServletResponse resp = this.response;
            switch (this.action) {
                case ADMIN: {
                    this.handleAdminRequest();
                    authResponse = SolrDispatchFilter.Action.RETURN;
                    return authResponse;
                }
                case REMOTEQUERY: {
                    this.remoteQuery(this.coreUrl + this.path, resp);
                    authResponse = SolrDispatchFilter.Action.RETURN;
                    return authResponse;
                }
                case PROCESS: {
                    Method reqMethod = Method.getMethod(this.req.getMethod());
                    HttpCacheHeaderUtil.setCacheControlHeader(this.config, resp, reqMethod);
                    if (this.config.getHttpCachingConfig().isNever304() || !HttpCacheHeaderUtil.doCacheHeaderValidation(this.solrReq, this.req, reqMethod, resp)) {
                        SolrQueryResponse solrRsp = new SolrQueryResponse();
                        SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.solrReq, solrRsp));
                        this.execute(solrRsp);
                        HttpCacheHeaderUtil.checkHttpCachingVeto(solrRsp, resp, reqMethod);
                        Iterator<Map.Entry<String, String>> headers = solrRsp.httpHeaders();
                        while (headers.hasNext()) {
                            Map.Entry<String, String> entry = headers.next();
                            resp.addHeader(entry.getKey(), entry.getValue());
                        }
                        QueryResponseWriter responseWriter = this.core.getQueryResponseWriter(this.solrReq);
                        if (this.invalidStates != null) {
                            this.solrReq.getContext().put("_stateVer_", this.invalidStates);
                        }
                        this.writeResponse(solrRsp, responseWriter, reqMethod);
                    }
                    action = SolrDispatchFilter.Action.RETURN;
                    return action;
                }
            }
            action = this.action;
            return action;
        }
        catch (Throwable ex) {
            this.sendError(ex);
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (!(t instanceof Error)) continue;
                if (t != ex) {
                    log.error("An Error was wrapped in another exception - please report complete stacktrace on SOLR-6161", ex);
                }
                throw (Error)t;
            }
            action = SolrDispatchFilter.Action.RETURN;
            return action;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    private boolean shouldAuthorize() {
        if ("/admin/info/key".equals(this.path)) {
            return false;
        }
        if (this.cores.getPkiAuthenticationPlugin() != null && this.req.getUserPrincipal() != null) {
            boolean b = this.cores.getPkiAuthenticationPlugin().needsAuthorization(this.req);
            log.debug("PkiAuthenticationPlugin says authorization required : {} ", (Object)b);
            return b;
        }
        return true;
    }

    void destroy() {
        try {
            if (this.solrReq != null) {
                log.debug("Closing out SolrRequest: {}", (Object)this.solrReq);
                this.solrReq.close();
            }
        }
        finally {
            try {
                if (this.core != null) {
                    this.core.close();
                }
            }
            finally {
                SolrRequestInfo.clearRequestInfo();
            }
            AuthenticationPlugin authcPlugin = this.cores.getAuthenticationPlugin();
            if (authcPlugin != null) {
                authcPlugin.closeRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteQuery(String coreUrl, HttpServletResponse resp) throws IOException {
        HttpGet method = null;
        HttpEntity httpEntity = null;
        try {
            boolean isPostOrPutRequest;
            String urlstr = coreUrl + this.queryParams.toQueryString();
            boolean bl = isPostOrPutRequest = "POST".equals(this.req.getMethod()) || "PUT".equals(this.req.getMethod());
            if ("GET".equals(this.req.getMethod())) {
                method = new HttpGet(urlstr);
            } else if ("HEAD".equals(this.req.getMethod())) {
                method = new HttpHead(urlstr);
            } else if (isPostOrPutRequest) {
                HttpPost entityRequest = "POST".equals(this.req.getMethod()) ? new HttpPost(urlstr) : new HttpPut(urlstr);
                InputStreamEntity entity = new InputStreamEntity((InputStream)this.req.getInputStream(), (long)this.req.getContentLength());
                entityRequest.setEntity((HttpEntity)entity);
                method = entityRequest;
            } else if ("DELETE".equals(this.req.getMethod())) {
                method = new HttpDelete(urlstr);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected method type: " + this.req.getMethod());
            }
            Enumeration e = this.req.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                if ("host".equalsIgnoreCase(headerName) || "authorization".equalsIgnoreCase(headerName) || "accept".equalsIgnoreCase(headerName)) continue;
                method.addHeader(headerName, this.req.getHeader(headerName));
            }
            if (method instanceof HttpEntityEnclosingRequest) {
                method.removeHeaders(TRANSFER_ENCODING_HEADER);
                method.removeHeaders(CONTENT_LENGTH_HEADER);
            }
            HttpResponse response = this.solrDispatchFilter.httpClient.execute((HttpUriRequest)method);
            int httpStatus = response.getStatusLine().getStatusCode();
            httpEntity = response.getEntity();
            resp.setStatus(httpStatus);
            HeaderIterator responseHeaders = response.headerIterator();
            while (responseHeaders.hasNext()) {
                Header header = responseHeaders.nextHeader();
                if (header == null || header.getName().equalsIgnoreCase(TRANSFER_ENCODING_HEADER) || header.getName().equalsIgnoreCase(CONNECTION_HEADER)) continue;
                resp.addHeader(header.getName(), header.getValue());
            }
            if (httpEntity != null) {
                if (httpEntity.getContentEncoding() != null) {
                    resp.setCharacterEncoding(httpEntity.getContentEncoding().getValue());
                }
                if (httpEntity.getContentType() != null) {
                    resp.setContentType(httpEntity.getContentType().getValue());
                }
                InputStream is = httpEntity.getContent();
                ServletOutputStream os = resp.getOutputStream();
                org.apache.commons.io.IOUtils.copyLarge((InputStream)is, (OutputStream)os);
            }
            Utils.consumeFully((HttpEntity)httpEntity);
        }
        catch (IOException e) {
            this.sendError(new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error trying to proxy request for url: " + coreUrl, (Throwable)e));
        }
        finally {
            Utils.consumeFully(httpEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(Throwable ex) throws IOException {
        Exception exp = null;
        SolrCore localCore = null;
        try {
            SolrQueryResponse solrResp = new SolrQueryResponse();
            if (ex instanceof Exception) {
                solrResp.setException((Exception)ex);
            } else {
                solrResp.setException(new RuntimeException(ex));
            }
            localCore = this.core;
            if (this.solrReq == null) {
                Object solrParams = this.req != null ? SolrRequestParsers.parseQueryString(this.req.getQueryString()) : new MapSolrParams(Collections.emptyMap());
                this.solrReq = new SolrQueryRequestBase(this.core, (SolrParams)solrParams){};
            }
            QueryResponseWriter writer = this.core.getQueryResponseWriter(this.solrReq);
            this.writeResponse(solrResp, writer, Method.GET);
        }
        catch (Exception e) {
            exp = e;
        }
        finally {
            try {
                if (exp != null) {
                    SimpleOrderedMap info = new SimpleOrderedMap();
                    int code = ResponseUtils.getErrorInfo(ex, (NamedList)info, log);
                    this.sendError(code, info.toString());
                }
            }
            finally {
                if (this.core == null && localCore != null) {
                    localCore.close();
                }
            }
        }
    }

    protected void sendError(int code, String message) throws IOException {
        try {
            this.response.sendError(code, message);
        }
        catch (EOFException e) {
            log.info("Unable to write error response, client closed connection or we are shutting down", (Throwable)e);
        }
    }

    protected void execute(SolrQueryResponse rsp) {
        this.solrReq.getContext().put("webapp", this.req.getContextPath());
        this.solrReq.getCore().execute(this.handler, this.solrReq, rsp);
    }

    private void handleAdminRequest() throws IOException {
        QueryResponseWriter respWriter;
        SolrQueryResponse solrResp = new SolrQueryResponse();
        SolrCore.preDecorateResponse(this.solrReq, solrResp);
        this.handler.handleRequest(this.solrReq, solrResp);
        SolrCore.postDecorateResponse(this.handler, this.solrReq, solrResp);
        if (log.isInfoEnabled() && solrResp.getToLog().size() > 0) {
            log.info(solrResp.getToLogAsString("[admin]"));
        }
        if ((respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get(this.solrReq.getParams().get("wt"))) == null) {
            respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard");
        }
        this.writeResponse(solrResp, respWriter, Method.getMethod(this.req.getMethod()));
    }

    private void processAliases(Aliases aliases, List<String> collectionsList) {
        String collection = this.solrReq.getParams().get("collection");
        if (collection != null) {
            collectionsList = StrUtils.splitSmart((String)collection, (String)",", (boolean)true);
        }
        if (collectionsList != null) {
            HashSet<String> newCollectionsList = new HashSet<String>(collectionsList.size());
            for (String col : collectionsList) {
                String al = aliases.getCollectionAlias(col);
                if (al != null) {
                    List aliasList = StrUtils.splitSmart((String)al, (String)",", (boolean)true);
                    newCollectionsList.addAll(aliasList);
                    continue;
                }
                newCollectionsList.add(col);
            }
            if (newCollectionsList.size() > 0) {
                StringBuilder collectionString = new StringBuilder();
                Iterator it = newCollectionsList.iterator();
                int sz = newCollectionsList.size();
                for (int i = 0; i < sz; ++i) {
                    collectionString.append((String)it.next());
                    if (i >= newCollectionsList.size() - 1) continue;
                    collectionString.append(",");
                }
                ModifiableSolrParams params = new ModifiableSolrParams(this.solrReq.getParams());
                params.set("collection", new String[]{collectionString.toString()});
                this.solrReq.setParams((SolrParams)params);
            }
        }
    }

    private void writeResponse(SolrQueryResponse solrRsp, QueryResponseWriter responseWriter, Method reqMethod) throws IOException {
        try {
            String ct;
            Object invalidStates = this.solrReq.getContext().get("_stateVer_");
            if (invalidStates != null) {
                solrRsp.add("_stateVer_", invalidStates);
            }
            if (null != (ct = responseWriter.getContentType(this.solrReq, solrRsp))) {
                this.response.setContentType(ct);
            }
            if (solrRsp.getException() != null) {
                SimpleOrderedMap info = new SimpleOrderedMap();
                int code = ResponseUtils.getErrorInfo(solrRsp.getException(), (NamedList)info, log);
                solrRsp.add("error", info);
                this.response.setStatus(code);
            }
            if (Method.HEAD != reqMethod) {
                QueryResponseWriterUtil.writeQueryResponse((OutputStream)this.response.getOutputStream(), responseWriter, this.solrReq, solrRsp, ct);
            }
        }
        catch (EOFException e) {
            log.info("Unable to write response, client closed connection or we are shutting down", (Throwable)e);
        }
    }

    private Map<String, Integer> checkStateIsValid(String stateVer) {
        HashMap<String, Integer> result = null;
        if (stateVer != null && !stateVer.isEmpty() && this.cores.isZooKeeperAware()) {
            String[] pairs;
            for (String pair : pairs = StringUtils.split((String)stateVer, (char)'|')) {
                Integer status;
                String[] pcs = StringUtils.split((String)pair, (char)':');
                if (pcs.length != 2 || pcs[0].isEmpty() || pcs[1].isEmpty() || (status = this.cores.getZkController().getZkStateReader().compareStateVersions(pcs[0], Integer.parseInt(pcs[1]))) == null) continue;
                if (result == null) {
                    result = new HashMap<String, Integer>();
                }
                result.put(pcs[0], status);
            }
        }
        return result;
    }

    private SolrCore getCoreByCollection(String collection) {
        ZkStateReader zkStateReader = this.cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Map slices = clusterState.getActiveSlicesMap(collection);
        if (slices == null) {
            return null;
        }
        Set liveNodes = clusterState.getLiveNodes();
        Set entries = slices.entrySet();
        SolrCore core = null;
        for (Map.Entry entry : entries) {
            Replica leaderProps = clusterState.getLeader(collection, (String)entry.getKey());
            if (leaderProps != null && liveNodes.contains(leaderProps.getNodeName()) && leaderProps.getState() == Replica.State.ACTIVE && (core = this.checkProps((ZkNodeProps)leaderProps)) != null) {
                return core;
            }
            Map shards = ((Slice)entry.getValue()).getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                Replica zkProps = (Replica)shardEntry.getValue();
                if (!liveNodes.contains(zkProps.getNodeName()) || zkProps.getState() != Replica.State.ACTIVE || (core = this.checkProps((ZkNodeProps)zkProps)) == null) continue;
                return core;
            }
        }
        return null;
    }

    private SolrCore checkProps(ZkNodeProps zkProps) {
        SolrCore core = null;
        if (this.cores.getZkController().getNodeName().equals(zkProps.getStr("node_name"))) {
            String corename = zkProps.getStr("core");
            core = this.cores.getCore(corename);
        }
        return core;
    }

    private void getSlicesForCollections(ClusterState clusterState, Collection<Slice> slices, boolean activeSlices) {
        if (activeSlices) {
            for (String collection : clusterState.getCollections()) {
                Collection activeCollectionSlices = clusterState.getActiveSlices(collection);
                if (activeCollectionSlices == null) continue;
                slices.addAll(activeCollectionSlices);
            }
        } else {
            for (String collection : clusterState.getCollections()) {
                Collection collectionSlices = clusterState.getSlices(collection);
                if (collectionSlices == null) continue;
                slices.addAll(collectionSlices);
            }
        }
    }

    private String getRemotCoreUrl(String collectionName, String origCorename) {
        ClusterState clusterState = this.cores.getZkController().getClusterState();
        ArrayList<Slice> slices = clusterState.getActiveSlices(collectionName);
        boolean byCoreName = false;
        if (slices == null) {
            slices = new ArrayList<Slice>();
            byCoreName = true;
            this.getSlicesForCollections(clusterState, slices, true);
            if (slices.isEmpty()) {
                this.getSlicesForCollections(clusterState, slices, false);
            }
        }
        if (slices.isEmpty()) {
            return null;
        }
        if (this.collectionsList == null) {
            this.collectionsList = new ArrayList<String>();
        }
        this.collectionsList.add(collectionName);
        String coreUrl = this.getCoreUrl(collectionName, origCorename, clusterState, slices, byCoreName, true);
        if (coreUrl == null) {
            coreUrl = this.getCoreUrl(collectionName, origCorename, clusterState, slices, byCoreName, false);
        }
        return coreUrl;
    }

    private String getCoreUrl(String collectionName, String origCorename, ClusterState clusterState, Collection<Slice> slices, boolean byCoreName, boolean activeReplicas) {
        Set liveNodes = clusterState.getLiveNodes();
        ArrayList<Slice> randomizedSlices = new ArrayList<Slice>(slices.size());
        randomizedSlices.addAll(slices);
        Collections.shuffle(randomizedSlices, random);
        for (Slice slice : randomizedSlices) {
            ArrayList randomizedReplicas = new ArrayList();
            randomizedReplicas.addAll(slice.getReplicas());
            Collections.shuffle(randomizedReplicas, random);
            for (Replica replica : randomizedReplicas) {
                String coreUrl;
                if (activeReplicas && (!liveNodes.contains(replica.getNodeName()) || replica.getState() != Replica.State.ACTIVE) || byCoreName && !collectionName.equals(replica.getStr("core")) || replica.getStr("base_url").equals(this.cores.getZkController().getBaseUrl())) continue;
                if (origCorename != null) {
                    coreUrl = replica.getStr("base_url") + "/" + origCorename;
                } else {
                    coreUrl = replica.getCoreUrl();
                    if (coreUrl.endsWith("/")) {
                        coreUrl = coreUrl.substring(0, coreUrl.length() - 1);
                    }
                }
                return coreUrl;
            }
        }
        return null;
    }

    private AuthorizationContext getAuthCtx() {
        final String resource = this.getPath();
        SolrParams params = this.getQueryParams();
        final ArrayList<AuthorizationContext.CollectionRequest> collectionRequests = new ArrayList<AuthorizationContext.CollectionRequest>();
        if (this.getCollectionsList() != null) {
            for (String collection : this.getCollectionsList()) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(collection));
            }
        }
        if (this.getPath().equals("/admin/collections")) {
            if (CollectionParams.CollectionAction.CREATE.isEqual(params.get("action")) || CollectionParams.CollectionAction.RELOAD.isEqual(params.get("action")) || CollectionParams.CollectionAction.DELETE.isEqual(params.get("action"))) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(params.get("name")));
            } else if (params.get("collection") != null) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(params.get("collection")));
            }
        }
        if (resource.equals("/select") && params.get("collection") != null) {
            collectionRequests.clear();
            for (String collection : params.get("collection").split(",")) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(collection));
            }
        }
        if (this.requestType == AuthorizationContext.RequestType.UNKNOWN) {
            if (resource.startsWith("/select") || resource.startsWith("/get")) {
                this.requestType = AuthorizationContext.RequestType.READ;
            }
            if (resource.startsWith("/update")) {
                this.requestType = AuthorizationContext.RequestType.WRITE;
            }
        }
        if (this.getCore() != null && (this.getCollectionsList() == null || this.getCollectionsList().size() == 0)) {
            collectionRequests.add(new AuthorizationContext.CollectionRequest(this.getCore().getCoreDescriptor().getCollectionName()));
        }
        if (this.getQueryParams().get("collection") != null) {
            collectionRequests.add(new AuthorizationContext.CollectionRequest(this.getQueryParams().get("collection")));
        }
        return new AuthorizationContext(){

            @Override
            public SolrParams getParams() {
                return HttpSolrCall.this.solrReq.getParams();
            }

            @Override
            public Principal getUserPrincipal() {
                return HttpSolrCall.this.getReq().getUserPrincipal();
            }

            @Override
            public String getHttpHeader(String s) {
                return HttpSolrCall.this.getReq().getHeader(s);
            }

            @Override
            public Enumeration getHeaderNames() {
                return HttpSolrCall.this.getReq().getHeaderNames();
            }

            @Override
            public List<AuthorizationContext.CollectionRequest> getCollectionRequests() {
                return collectionRequests;
            }

            @Override
            public AuthorizationContext.RequestType getRequestType() {
                return HttpSolrCall.this.requestType;
            }

            @Override
            public String getResource() {
                return HttpSolrCall.this.path;
            }

            @Override
            public String getHttpMethod() {
                return HttpSolrCall.this.getReq().getMethod();
            }

            public String toString() {
                StringBuilder response = new StringBuilder("userPrincipal: [").append(this.getUserPrincipal()).append("]").append(" type: [").append(HttpSolrCall.this.requestType.toString()).append("], collections: [");
                for (AuthorizationContext.CollectionRequest collectionRequest : collectionRequests) {
                    response.append(collectionRequest.collectionName).append(", ");
                }
                if (collectionRequests.size() > 0) {
                    response.delete(response.length() - 1, response.length());
                }
                response.append("], Path: [").append(resource).append("]");
                response.append(" path : ").append(HttpSolrCall.this.path).append(" params :").append(HttpSolrCall.this.solrReq.getParams());
                return response.toString();
            }

            @Override
            public String getRemoteAddr() {
                return HttpSolrCall.this.getReq().getRemoteAddr();
            }

            @Override
            public String getRemoteHost() {
                return HttpSolrCall.this.getReq().getRemoteHost();
            }
        };
    }

    static {
        String seed = System.getProperty("tests.seed");
        random = seed == null ? new Random() : new Random(seed.hashCode());
    }
}

