/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.util.CommandOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedAuthorizationPlugin
implements AuthorizationPlugin,
ConfigEditablePlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Set<String>> usersVsRoles = new HashMap<String, Set<String>>();
    private final Map<String, WildCardSupportMap> mapping = new HashMap<String, WildCardSupportMap>();
    private final List<Permission> permissions = new ArrayList<Permission>();
    public static final Set<String> HTTP_METHODS = ImmutableSet.of((Object)"GET", (Object)"POST", (Object)"DELETE", (Object)"PUT", (Object)"HEAD");
    private static final Map<String, Map<String, Object>> well_known_permissions = (Map)Utils.fromJSONResource((String)"WellKnownPermissions.json");

    @Override
    public AuthorizationResponse authorize(AuthorizationContext context) {
        List<AuthorizationContext.CollectionRequest> collectionRequests = context.getCollectionRequests();
        if (context.getRequestType() == AuthorizationContext.RequestType.ADMIN) {
            MatchStatus flag = this.checkCollPerm(this.mapping.get(null), context);
            return flag.rsp;
        }
        for (AuthorizationContext.CollectionRequest collreq : collectionRequests) {
            MatchStatus flag = this.checkCollPerm(this.mapping.get(collreq.collectionName), context);
            if (flag == MatchStatus.NO_PERMISSIONS_FOUND) continue;
            return flag.rsp;
        }
        Object flag = this.checkCollPerm(this.mapping.get("*"), context);
        return ((MatchStatus)((Object)flag)).rsp;
    }

    private MatchStatus checkCollPerm(Map<String, List<Permission>> pathVsPerms, AuthorizationContext context) {
        if (pathVsPerms == null) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        String path = context.getResource();
        MatchStatus flag = this.checkPathPerm(pathVsPerms.get(path), context);
        if (flag != MatchStatus.NO_PERMISSIONS_FOUND) {
            return flag;
        }
        return this.checkPathPerm(pathVsPerms.get(null), context);
    }

    private MatchStatus checkPathPerm(List<Permission> permissions, AuthorizationContext context) {
        if (permissions == null || permissions.isEmpty()) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        Principal principal = context.getUserPrincipal();
        block0: for (int i = 0; i < permissions.size(); ++i) {
            Permission permission = permissions.get(i);
            if (permission.method != null && !permission.method.contains(context.getHttpMethod()) || permission.predicate != null && !permission.predicate.test(context)) continue;
            if (permission.params != null) {
                for (Map.Entry<String, Object> e : permission.params.entrySet()) {
                    String paramVal = context.getParams().get(e.getKey());
                    Object val = e.getValue();
                    if (!(val instanceof List ? !((List)val).contains(paramVal) : !Objects.equals(val, paramVal))) continue;
                    continue block0;
                }
            }
            if (permission.role == null) {
                return MatchStatus.PERMITTED;
            }
            if (principal == null) {
                log.info("request has come without principal. failed permission {} ", (Object)permission);
                return MatchStatus.USER_REQUIRED;
            }
            if (permission.role.contains("*")) {
                return MatchStatus.PERMITTED;
            }
            for (String role : permission.role) {
                Set<String> userRoles = this.usersVsRoles.get(principal.getName());
                if (userRoles == null || !userRoles.contains(role)) continue;
                return MatchStatus.PERMITTED;
            }
            log.info("This resource is configured to have a permission {}, The principal {} does not have the right role ", (Object)permission, (Object)principal);
            return MatchStatus.FORBIDDEN;
        }
        log.debug("No permissions configured for the resource {} . So allowed to access", (Object)context.getResource());
        return MatchStatus.NO_PERMISSIONS_FOUND;
    }

    @Override
    public void init(Map<String, Object> initInfo) {
        this.mapping.put(null, new WildCardSupportMap());
        Map<String, Object> map = SecurityConfHandler.getMapValue(initInfo, "user-role");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> o;
            Map.Entry<String, Object> e = o = iterator.next();
            String roleName = e.getKey();
            this.usersVsRoles.put(roleName, RuleBasedAuthorizationPlugin.readValueAsSet(map, roleName));
        }
        List perms = SecurityConfHandler.getListValue(initInfo, "permissions");
        for (Map o : perms) {
            Permission p;
            try {
                p = Permission.load(o);
            }
            catch (Exception exp) {
                log.error("Invalid permission ", (Throwable)exp);
                continue;
            }
            this.permissions.add(p);
            this.add2Mapping(p);
        }
    }

    private void add2Mapping(Permission permission) {
        for (String c : permission.collections) {
            WildCardSupportMap m = this.mapping.get(c);
            if (m == null) {
                m = new WildCardSupportMap();
                this.mapping.put(c, m);
            }
            for (String path : permission.path) {
                ArrayList<Permission> perms = m.get(path);
                if (perms == null) {
                    perms = new ArrayList<Permission>();
                    m.put(path, (List<Permission>)perms);
                }
                perms.add(permission);
            }
        }
    }

    static Set<String> readValueAsSet(Map m, String key) {
        HashSet<String> result = new HashSet<String>();
        Object val = m.get(key);
        if (val == null) {
            if ("collection".equals(key)) {
                return m.containsKey(key) ? Collections.singleton(null) : Collections.singleton("*");
            }
            return null;
        }
        if (val instanceof Collection) {
            Collection list = (Collection)val;
            for (Object o : list) {
                result.add(String.valueOf(o));
            }
        } else if (val instanceof String) {
            result.add((String)val);
        } else {
            throw new RuntimeException("Bad value for : " + key);
        }
        return result.isEmpty() ? null : Collections.unmodifiableSet(result);
    }

    @Override
    public void close() throws IOException {
    }

    private static Set<String> readSetSmart(String permissionName, Map m, String key) {
        Set<String> set = RuleBasedAuthorizationPlugin.readValueAsSet(m, key);
        if (set == null && well_known_permissions.containsKey(permissionName)) {
            set = RuleBasedAuthorizationPlugin.readValueAsSet(well_known_permissions.get(permissionName), key);
        }
        if ("method".equals(key)) {
            if (set != null) {
                for (String s : set) {
                    if (HTTP_METHODS.contains(s)) continue;
                    return null;
                }
            }
            return set;
        }
        return set == null ? Collections.singleton(null) : set;
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation op : commands) {
            OPERATION operation = null;
            for (OPERATION o : OPERATION.values()) {
                if (!o.name.equals(op.name)) continue;
                operation = o;
                break;
            }
            if (operation == null) {
                op.unknownOperation();
                return null;
            }
            if ((latestConf = operation.edit(latestConf, op)) != null) continue;
            return null;
        }
        return latestConf;
    }

    private static Predicate<AuthorizationContext> getCollectionActionPredicate(final boolean isEdit) {
        return new Predicate<AuthorizationContext>(){

            @Override
            public boolean test(AuthorizationContext context) {
                String action = context.getParams().get("action");
                if (action == null) {
                    return false;
                }
                CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)action);
                if (collectionAction == null) {
                    return false;
                }
                return isEdit ? collectionAction.isWrite : !collectionAction.isWrite;
            }
        };
    }

    public static void main(String[] args) {
        System.out.println(Utils.toJSONString(well_known_permissions));
    }

    static {
        well_known_permissions.get("collection-admin-edit").put(Predicate.class.getName(), RuleBasedAuthorizationPlugin.getCollectionActionPredicate(true));
        well_known_permissions.get("collection-admin-read").put(Predicate.class.getName(), RuleBasedAuthorizationPlugin.getCollectionActionPredicate(false));
    }

    static enum OPERATION {
        SET_USER_ROLE("set-user-role"){

            @Override
            public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
                Map<String, Object> roleMap = SecurityConfHandler.getMapValue(latestConf, "user-role");
                Map<String, Object> map = op.getDataMap();
                if (op.hasError()) {
                    return null;
                }
                for (Map.Entry<String, Object> e : map.entrySet()) {
                    if (e.getValue() == null) {
                        roleMap.remove(e.getKey());
                        continue;
                    }
                    if (e.getValue() instanceof String || e.getValue() instanceof List) {
                        roleMap.put(e.getKey(), e.getValue());
                        continue;
                    }
                    op.addError("Unexpected value ");
                    return null;
                }
                return latestConf;
            }
        }
        ,
        SET_PERMISSION("set-permission"){

            @Override
            public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
                String name = op.getStr("name");
                Map dataMap = op.getDataMap();
                if (op.hasError()) {
                    return null;
                }
                dataMap = Utils.getDeepCopy(dataMap, (int)3);
                String before = (String)dataMap.remove("before");
                for (String key : dataMap.keySet()) {
                    if (Permission.knownKeys.contains(key)) continue;
                    op.addError("Unknown key, " + key);
                }
                try {
                    Permission.load(dataMap);
                }
                catch (Exception e) {
                    op.addError(e.getMessage());
                    return null;
                }
                List permissions = SecurityConfHandler.getListValue(latestConf, "permissions");
                ArrayList<Map> permissionsCopy = new ArrayList<Map>();
                boolean added = false;
                for (Map e : permissions) {
                    Object n = e.get("name");
                    if (n.equals(before) || n.equals(name)) {
                        added = true;
                        permissionsCopy.add(dataMap);
                    }
                    if (n.equals(name)) continue;
                    permissionsCopy.add(e);
                }
                if (!added && before != null) {
                    op.addError("Invalid 'before' :" + before);
                    return null;
                }
                if (!added) {
                    permissionsCopy.add(dataMap);
                }
                latestConf.put("permissions", permissionsCopy);
                return latestConf;
            }
        }
        ,
        UPDATE_PERMISSION("update-permission"){

            @Override
            public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
                String name = op.getStr("name");
                if (op.hasError()) {
                    return null;
                }
                for (Map permission : SecurityConfHandler.getListValue(latestConf, "permissions")) {
                    if (!name.equals(permission.get("name"))) continue;
                    LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(permission);
                    copy.putAll(op.getDataMap());
                    op.setCommandData(copy);
                    return SET_PERMISSION.edit(latestConf, op);
                }
                op.addError("No such permission " + name);
                return null;
            }
        }
        ,
        DELETE_PERMISSION("delete-permission"){

            @Override
            public Map<String, Object> edit(Map<String, Object> latestConf, CommandOperation op) {
                List<String> names = op.getStrs("");
                if (names == null || names.isEmpty()) {
                    op.addError("Invalid command");
                    return null;
                }
                names = new ArrayList<String>(names);
                ArrayList<Map> copy = new ArrayList<Map>();
                List p = SecurityConfHandler.getListValue(latestConf, "permissions");
                for (Map map : p) {
                    Object n = map.get("name");
                    if (names.contains(n)) {
                        names.remove(n);
                        continue;
                    }
                    copy.add(map);
                }
                if (!names.isEmpty()) {
                    op.addError("Unknown permission name(s) " + names);
                    return null;
                }
                latestConf.put("permissions", copy);
                return latestConf;
            }
        };

        public final String name;

        public abstract Map<String, Object> edit(Map<String, Object> var1, CommandOperation var2);

        private OPERATION(String s) {
            this.name = s;
        }

        public static OPERATION get(String name) {
            for (OPERATION o : OPERATION.values()) {
                if (!o.name.equals(name)) continue;
                return o;
            }
            return null;
        }
    }

    static enum MatchStatus {
        USER_REQUIRED(AuthorizationResponse.PROMPT),
        NO_PERMISSIONS_FOUND(AuthorizationResponse.OK),
        PERMITTED(AuthorizationResponse.OK),
        FORBIDDEN(AuthorizationResponse.FORBIDDEN);

        final AuthorizationResponse rsp;

        private MatchStatus(AuthorizationResponse rsp) {
            this.rsp = rsp;
        }
    }

    static class Permission {
        String name;
        Set<String> path;
        Set<String> role;
        Set<String> collections;
        Set<String> method;
        Map<String, Object> params;
        Predicate<AuthorizationContext> predicate;
        static final Set<String> knownKeys = ImmutableSet.of((Object)"collection", (Object)"role", (Object)"params", (Object)"path", (Object)"method", (Object)"name", (Object[])new String[0]);

        private Permission() {
        }

        static Permission load(Map m) {
            Permission p = new Permission();
            String name = (String)m.get("name");
            if (!m.containsKey("role")) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "role not specified");
            }
            p.role = RuleBasedAuthorizationPlugin.readValueAsSet(m, "role");
            if (well_known_permissions.containsKey(name)) {
                HashSet<String> disAllowed = new HashSet<String>(knownKeys);
                disAllowed.remove("role");
                disAllowed.remove("name");
                for (String s : disAllowed) {
                    if (!m.containsKey(s)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, s + " is not a valid key for the permission : " + name);
                }
                p.predicate = (Predicate)((Map)well_known_permissions.get(name)).get(Predicate.class.getName());
                m = (Map)well_known_permissions.get(name);
            }
            p.name = name;
            p.path = RuleBasedAuthorizationPlugin.readSetSmart(name, m, "path");
            p.collections = RuleBasedAuthorizationPlugin.readSetSmart(name, m, "collection");
            p.method = RuleBasedAuthorizationPlugin.readSetSmart(name, m, "method");
            p.params = (Map)m.get("params");
            return p;
        }
    }

    private static class WildCardSupportMap
    extends HashMap<String, List<Permission>> {
        final Set<String> wildcardPrefixes = new HashSet<String>();

        private WildCardSupportMap() {
        }

        @Override
        public List<Permission> put(String key, List<Permission> value) {
            if (key != null && key.endsWith("/*")) {
                key = key.substring(0, key.length() - 2);
                this.wildcardPrefixes.add(key);
            }
            return super.put(key, value);
        }

        @Override
        public List<Permission> get(Object key) {
            ArrayList result = (ArrayList)super.get(key);
            if (key == null || result != null) {
                return result;
            }
            if (!this.wildcardPrefixes.isEmpty()) {
                for (String s : this.wildcardPrefixes) {
                    List l;
                    if (!key.toString().startsWith(s) || (l = (List)super.get(s)) == null) continue;
                    result = result == null ? new ArrayList() : new ArrayList(result);
                    result.addAll(l);
                }
            }
            return result;
        }
    }
}

