/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.GraphQuery;

public class GraphQueryParser
extends QParser {
    public GraphQueryParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        SolrParams localParams = this.getLocalParams();
        Query rootNodeQuery = this.subQuery(localParams.get("v"), null).getQuery();
        String traversalFilterS = localParams.get("traversalFilter");
        Query traversalFilter = traversalFilterS == null ? null : this.subQuery(traversalFilterS, null).getQuery();
        String fromField = localParams.get("from", "node_id");
        String toField = localParams.get("to", "edge_ids");
        boolean onlyLeafNodes = localParams.getBool("returnOnlyLeaf", false);
        boolean returnRootNodes = localParams.getBool("returnRoot", true);
        int maxDepth = localParams.getInt("maxDepth", -1);
        boolean useAutn = localParams.getBool("useAutn", false);
        GraphQuery gq = new GraphQuery(rootNodeQuery, fromField, toField, traversalFilter);
        gq.setMaxDepth(maxDepth);
        gq.setOnlyLeafNodes(onlyLeafNodes);
        gq.setReturnRoot(returnRootNodes);
        gq.setUseAutn(useAutn);
        return gq;
    }
}

