/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldParser;
import org.apache.solr.search.facet.FacetQuery;
import org.apache.solr.search.facet.FacetQueryParser;
import org.apache.solr.search.facet.FacetRange;
import org.apache.solr.search.facet.FacetRangeParser;
import org.apache.solr.search.facet.FacetRequest;

abstract class FacetParser<FacetRequestT extends FacetRequest> {
    protected FacetRequestT facet;
    protected FacetParser parent;
    protected String key;

    public FacetParser(FacetParser parent, String key) {
        this.parent = parent;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getPathStr() {
        if (this.parent == null) {
            return "/" + this.key;
        }
        return this.parent.getKey() + "/" + this.key;
    }

    protected RuntimeException err(String msg) {
        return new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg + " , path=" + this.getPathStr());
    }

    public abstract FacetRequest parse(Object var1) throws SyntaxError;

    public void parseSubs(Object o) throws SyntaxError {
        if (o == null) {
            return;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            for (Map.Entry entry : m.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("processEmpty".equals(key)) {
                    ((FacetRequest)this.facet).processEmpty = this.getBoolean(m, "processEmpty", false);
                    continue;
                }
                Object parsedValue = this.parseFacetOrStat(key, value);
                if (parsedValue instanceof FacetRequest) {
                    ((FacetRequest)this.facet).addSubFacet(key, (FacetRequest)parsedValue);
                    continue;
                }
                if (parsedValue instanceof AggValueSource) {
                    ((FacetRequest)this.facet).addStat(key, (AggValueSource)((Object)parsedValue));
                    continue;
                }
                throw this.err("Unknown facet type key=" + key + " class=" + (parsedValue == null ? "null" : parsedValue.getClass().getName()));
            }
        } else {
            throw this.err("Expected map for facet/stat");
        }
    }

    public Object parseFacetOrStat(String key, Object o) throws SyntaxError {
        Map args;
        String type;
        if (o instanceof String) {
            return this.parseStringFacetOrStat(key, (String)o);
        }
        if (!(o instanceof Map)) {
            throw this.err("expected Map but got " + o);
        }
        Map m = (Map)o;
        if (m.size() == 1) {
            Map.Entry entry = m.entrySet().iterator().next();
            type = (String)entry.getKey();
            args = entry.getValue();
        } else {
            Object typeObj = m.get("type");
            if (!(typeObj instanceof String)) {
                throw this.err("expected facet/stat type name, like {type:range, field:price, ...} but got " + typeObj);
            }
            type = (String)typeObj;
            args = m;
        }
        return this.parseFacetOrStat(key, type, args);
    }

    public Object parseFacetOrStat(String key, String type, Object args) throws SyntaxError {
        if ("field".equals(type) || "terms".equals(type)) {
            return this.parseFieldFacet(key, args);
        }
        if ("query".equals(type)) {
            return this.parseQueryFacet(key, args);
        }
        if ("range".equals(type)) {
            return this.parseRangeFacet(key, args);
        }
        AggValueSource stat = this.parseStat(key, type, args);
        if (stat == null) {
            throw this.err("Unknown facet or stat. key=" + key + " type=" + type + " args=" + args);
        }
        return stat;
    }

    FacetField parseFieldFacet(String key, Object args) throws SyntaxError {
        FacetFieldParser parser = new FacetFieldParser(this, key);
        return parser.parse(args);
    }

    FacetQuery parseQueryFacet(String key, Object args) throws SyntaxError {
        FacetQueryParser parser = new FacetQueryParser(this, key);
        return parser.parse(args);
    }

    FacetRange parseRangeFacet(String key, Object args) throws SyntaxError {
        FacetRangeParser parser = new FacetRangeParser(this, key);
        return parser.parse(args);
    }

    public Object parseStringFacetOrStat(String key, String s) throws SyntaxError {
        return this.parseStringStat(key, s);
    }

    private AggValueSource parseStringStat(String key, String stat) throws SyntaxError {
        FunctionQParser parser = (FunctionQParser)QParser.getParser(stat, "func", this.getSolrRequest());
        AggValueSource agg = parser.parseAgg(1);
        return agg;
    }

    public AggValueSource parseStat(String key, String type, Object args) throws SyntaxError {
        return null;
    }

    private FacetRequest.Domain getDomain() {
        if (((FacetRequest)this.facet).domain == null) {
            ((FacetRequest)this.facet).domain = new FacetRequest.Domain();
        }
        return ((FacetRequest)this.facet).domain;
    }

    protected void parseCommonParams(Object o) {
        if (o instanceof Map) {
            Map domainMap;
            Map m = (Map)o;
            List<String> excludeTags = this.getStringList(m, "excludeTags");
            if (excludeTags != null) {
                this.getDomain().excludeTags = excludeTags;
            }
            if ((domainMap = (Map)m.get("domain")) != null) {
                excludeTags = this.getStringList(domainMap, "excludeTags");
                if (excludeTags != null) {
                    this.getDomain().excludeTags = excludeTags;
                }
                String blockParent = (String)domainMap.get("blockParent");
                String blockChildren = (String)domainMap.get("blockChildren");
                if (blockParent != null) {
                    this.getDomain().toParent = true;
                    this.getDomain().parents = blockParent;
                } else if (blockChildren != null) {
                    this.getDomain().toChildren = true;
                    this.getDomain().parents = blockChildren;
                }
            }
        }
    }

    public String getField(Map<String, Object> args) {
        Object fieldName = args.get("field");
        if (fieldName == null) {
            fieldName = args.get("f");
        }
        if (fieldName == null) {
            throw this.err("Missing 'field'");
        }
        if (!(fieldName instanceof String)) {
            throw this.err("Expected string for 'field', got" + fieldName);
        }
        return (String)fieldName;
    }

    public Long getLongOrNull(Map<String, Object> args, String paramName, boolean required) {
        Object o = args.get(paramName);
        if (o == null) {
            if (required) {
                throw this.err("Missing required parameter '" + paramName + "'");
            }
            return null;
        }
        if (!(o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte)) {
            throw this.err("Expected integer type for param '" + paramName + "' but got " + o);
        }
        return ((Number)o).longValue();
    }

    public long getLong(Map<String, Object> args, String paramName, long defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte)) {
            throw this.err("Expected integer type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return ((Number)o).longValue();
    }

    public boolean getBoolean(Map<String, Object> args, String paramName, boolean defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof Boolean)) {
            throw this.err("Expected boolean type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return (Boolean)o;
    }

    public String getString(Map<String, Object> args, String paramName, String defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof String)) {
            throw this.err("Expected string type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return (String)o;
    }

    public List<String> getStringList(Map<String, Object> args, String paramName) {
        Object o = args.get(paramName);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return StrUtils.splitSmart((String)((String)o), (String)",", (boolean)true);
        }
        throw this.err("Expected list of string or comma separated string values.");
    }

    public IndexSchema getSchema() {
        return this.parent.getSchema();
    }

    public SolrQueryRequest getSolrRequest() {
        return this.parent.getSolrRequest();
    }
}

