/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.solr.search.BitsFilteredDocIdSet;
import org.apache.solr.search.Filter;

public class QueryWrapperFilter
extends Filter {
    private final Query query;

    public QueryWrapperFilter(Query query) {
        if (query == null) {
            throw new NullPointerException("Query may not be null");
        }
        this.query = query;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return new BoostQuery((Query)new ConstantScoreQuery(this.query), 0.0f);
    }

    public final Query getQuery() {
        return this.query;
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        final LeafReaderContext privateContext = context.reader().getContext();
        final Weight weight = new IndexSearcher((IndexReaderContext)privateContext).createNormalizedWeight(this.query, false);
        DocIdSet set = new DocIdSet(){

            public DocIdSetIterator iterator() throws IOException {
                Scorer scorer = weight.scorer(privateContext);
                return scorer == null ? null : scorer.iterator();
            }

            public long ramBytesUsed() {
                return 0L;
            }
        };
        return BitsFilteredDocIdSet.wrap(set, acceptDocs);
    }

    public String toString(String field) {
        return "QueryWrapperFilter(" + this.query.toString(field) + ")";
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.query.equals((Object)((QueryWrapperFilter)((Object)o)).query);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.query.hashCode();
    }
}

