/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LegacyIntField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.EnumFieldSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocValuesRangeQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.LegacyNumericUtils;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EnumField
extends PrimitiveFieldType {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String PARAM_ENUMS_CONFIG = "enumsConfig";
    protected static final String PARAM_ENUM_NAME = "enumName";
    protected static final Integer DEFAULT_VALUE = -1;
    protected static final int DEFAULT_PRECISION_STEP = Integer.MAX_VALUE;
    protected Map<String, Integer> enumStringToIntMap = new HashMap<String, Integer>();
    protected Map<Integer, String> enumIntToStringMap = new HashMap<Integer, String>();
    protected String enumsConfigFile;
    protected String enumName;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.enumsConfigFile = args.get(PARAM_ENUMS_CONFIG);
        if (this.enumsConfigFile == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No enums config file was configured.");
        }
        this.enumName = args.get(PARAM_ENUM_NAME);
        if (this.enumName == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No enum name was configured.");
        }
        InputStream is = null;
        try {
            is = schema.getResourceLoader().openResource(this.enumsConfigFile);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                Document doc = dbf.newDocumentBuilder().parse(is);
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                String xpathStr = String.format(Locale.ROOT, "/enumsConfig/enum[@name='%s']", this.enumName);
                NodeList nodes = (NodeList)xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
                int nodesLength = nodes.getLength();
                if (nodesLength == 0) {
                    String exceptionMessage = String.format(Locale.ENGLISH, "No enum configuration found for enum '%s' in %s.", this.enumName, this.enumsConfigFile);
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, exceptionMessage);
                }
                if (nodesLength > 1 && log.isWarnEnabled()) {
                    log.warn("More than one enum configuration found for enum '{}' in {}. The last one was taken.", (Object)this.enumName, (Object)this.enumsConfigFile);
                }
                Node enumNode = nodes.item(nodesLength - 1);
                NodeList valueNodes = (NodeList)xpath.evaluate("value", enumNode, XPathConstants.NODESET);
                for (int i = 0; i < valueNodes.getLength(); ++i) {
                    Node valueNode = valueNodes.item(i);
                    String valueStr = valueNode.getTextContent();
                    if (valueStr == null || valueStr.length() == 0) {
                        String exceptionMessage = String.format(Locale.ENGLISH, "A value was defined with an no value in enum '%s' in %s.", this.enumName, this.enumsConfigFile);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, exceptionMessage);
                    }
                    if (this.enumStringToIntMap.containsKey(valueStr)) {
                        String exceptionMessage = String.format(Locale.ENGLISH, "A duplicated definition was found for value '%s' in enum '%s' in %s.", valueStr, this.enumName, this.enumsConfigFile);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, exceptionMessage);
                    }
                    this.enumIntToStringMap.put(i, valueStr);
                    this.enumStringToIntMap.put(valueStr, i);
                }
            }
            catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing enums config.", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error while opening enums config.", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.enumStringToIntMap.size() == 0 || this.enumIntToStringMap.size() == 0) {
            String exceptionMessage = String.format(Locale.ENGLISH, "Invalid configuration was defined for enum '%s' in %s.", this.enumName, this.enumsConfigFile);
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, exceptionMessage);
        }
        args.remove(PARAM_ENUMS_CONFIG);
        args.remove(PARAM_ENUM_NAME);
    }

    public EnumFieldValue toObject(IndexableField f) {
        Integer intValue = null;
        String stringValue = null;
        Number val = f.numericValue();
        if (val != null) {
            intValue = val.intValue();
            stringValue = this.intValueToStringValue(intValue);
        }
        return new EnumFieldValue(intValue, stringValue);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        Integer missingValue = Integer.MIN_VALUE;
        SortField sf = new SortField(field.getName(), SortField.Type.INT, top);
        sf.setMissingValue((Object)missingValue);
        return sf;
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_INTEGER;
        }
        return UninvertingReader.Type.LEGACY_INTEGER;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new EnumFieldSource(field.getName(), this.enumIntToStringMap, this.enumStringToIntMap);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        Number val = f.numericValue();
        if (val == null) {
            writer.writeNull(name);
            return;
        }
        String readableValue = this.intValueToStringValue(val.intValue());
        writer.writeStr(name, readableValue, true);
    }

    @Override
    public boolean isTokenized() {
        return false;
    }

    @Override
    public FieldType.LegacyNumericType getNumericType() {
        return FieldType.LegacyNumericType.INT;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        boolean matchOnly;
        Integer minValue = this.stringValueToIntValue(min);
        Integer maxValue = this.stringValueToIntValue(max);
        if (field.multiValued() && field.hasDocValues() && !field.indexed()) {
            return super.getRangeQuery(parser, field, minValue.toString(), maxValue.toString(), minInclusive, maxInclusive);
        }
        Object query = null;
        boolean bl = matchOnly = field.hasDocValues() && !field.indexed();
        query = matchOnly ? new ConstantScoreQuery(DocValuesRangeQuery.newLongRange((String)field.getName(), (Long)(min == null ? null : Long.valueOf(minValue.longValue())), (Long)(max == null ? null : Long.valueOf(maxValue.longValue())), (boolean)minInclusive, (boolean)maxInclusive)) : LegacyNumericRangeQuery.newIntRange((String)field.getName(), (int)Integer.MAX_VALUE, (Integer)(min == null ? null : minValue), (Integer)(max == null ? null : maxValue), (boolean)minInclusive, (boolean)maxInclusive);
        return query;
    }

    @Override
    public void checkSchemaField(SchemaField field) {
    }

    @Override
    public String readableToIndexed(String val) {
        if (val == null) {
            return null;
        }
        BytesRefBuilder bytes = new BytesRefBuilder();
        this.readableToIndexed(val, bytes);
        return bytes.get().utf8ToString();
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        String s = val.toString();
        if (s == null) {
            return;
        }
        Integer intValue = this.stringValueToIntValue(s);
        LegacyNumericUtils.intToPrefixCoded((int)intValue, (int)0, (BytesRefBuilder)result);
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    @Override
    public String toExternal(IndexableField f) {
        Number val = f.numericValue();
        if (val == null) {
            return null;
        }
        return this.intValueToStringValue(val.intValue());
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        if (indexedForm == null) {
            return null;
        }
        BytesRef bytesRef = new BytesRef((CharSequence)indexedForm);
        Integer intValue = LegacyNumericUtils.prefixCodedToInt((BytesRef)bytesRef);
        return this.intValueToStringValue(intValue);
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRefBuilder output) {
        Integer intValue = LegacyNumericUtils.prefixCodedToInt((BytesRef)input);
        String stringValue = this.intValueToStringValue(intValue);
        output.grow(stringValue.length());
        output.setLength(stringValue.length());
        stringValue.getChars(0, output.length(), output.chars(), 0);
        return output.get();
    }

    public EnumFieldValue toObject(SchemaField sf, BytesRef term) {
        Integer intValue = LegacyNumericUtils.prefixCodedToInt((BytesRef)term);
        String stringValue = this.intValueToStringValue(intValue);
        return new EnumFieldValue(intValue, stringValue);
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        Number val = f.numericValue();
        if (val == null) {
            return null;
        }
        BytesRefBuilder bytes = new BytesRefBuilder();
        LegacyNumericUtils.intToPrefixCoded((int)val.intValue(), (int)0, (BytesRefBuilder)bytes);
        return bytes.get().utf8ToString();
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        boolean docValues = field.hasDocValues();
        if (!(indexed || stored || docValues)) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        Integer intValue = this.stringValueToIntValue(value.toString());
        if (intValue == null || intValue.equals(DEFAULT_VALUE)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value for enum field: " + value.toString());
        }
        String intAsString = intValue.toString();
        FieldType newType = new FieldType();
        newType.setTokenized(field.isTokenized());
        newType.setStored(field.stored());
        newType.setOmitNorms(field.omitNorms());
        newType.setIndexOptions(field.indexed() ? this.getIndexOptions(field, intAsString) : IndexOptions.NONE);
        newType.setStoreTermVectors(field.storeTermVector());
        newType.setStoreTermVectorOffsets(field.storeTermOffsets());
        newType.setStoreTermVectorPositions(field.storeTermPositions());
        newType.setStoreTermVectorPayloads(field.storeTermPayloads());
        newType.setNumericType(FieldType.LegacyNumericType.INT);
        newType.setNumericPrecisionStep(Integer.MAX_VALUE);
        LegacyIntField f = new LegacyIntField(field.getName(), intValue.intValue(), newType);
        f.setBoost(boost);
        return f;
    }

    @Override
    public List<IndexableField> createFields(SchemaField sf, Object value, float boost) {
        if (sf.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            IndexableField field = this.createField(sf, value, boost);
            fields.add(field);
            if (sf.multiValued()) {
                BytesRefBuilder bytes = new BytesRefBuilder();
                this.readableToIndexed(this.stringValueToIntValue(value.toString()).toString(), bytes);
                fields.add((IndexableField)new SortedSetDocValuesField(sf.getName(), bytes.toBytesRef()));
            } else {
                long bits = field.numericValue().intValue();
                fields.add((IndexableField)new NumericDocValuesField(sf.getName(), bits));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(sf, value, boost));
    }

    public String intValueToStringValue(Integer intVal) {
        if (intVal == null) {
            return null;
        }
        String enumString = this.enumIntToStringMap.get(intVal);
        if (enumString != null) {
            return enumString;
        }
        return DEFAULT_VALUE.toString();
    }

    public Integer stringValueToIntValue(String stringVal) {
        String enumString;
        if (stringVal == null) {
            return null;
        }
        Integer enumInt = this.enumStringToIntMap.get(stringVal);
        if (enumInt != null) {
            return enumInt;
        }
        Integer intValue = EnumField.tryParseInt(stringVal);
        if (intValue == null) {
            intValue = DEFAULT_VALUE;
        }
        if ((enumString = this.enumIntToStringMap.get(intValue)) != null) {
            return intValue;
        }
        return DEFAULT_VALUE;
    }

    private static Integer tryParseInt(String valueStr) {
        Integer intValue = null;
        try {
            intValue = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }
}

