/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.BoolFieldSource;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class BoolField
extends PrimitiveFieldType {
    protected static final char[] TRUE_TOKEN = new char[]{'T'};
    protected static final char[] FALSE_TOKEN = new char[]{'F'};
    protected static final Analyzer boolAnalyzer = new SolrAnalyzer(){

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            Tokenizer tokenizer = new Tokenizer(){
                final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                boolean done = false;

                public void reset() throws IOException {
                    super.reset();
                    this.done = false;
                }

                public boolean incrementToken() throws IOException {
                    this.clearAttributes();
                    if (this.done) {
                        return false;
                    }
                    this.done = true;
                    int ch = this.input.read();
                    if (ch == -1) {
                        return false;
                    }
                    this.termAtt.copyBuffer(ch == 116 || ch == 84 || ch == 49 ? TRUE_TOKEN : FALSE_TOKEN, 0, 1);
                    return true;
                }
            };
            return new Analyzer.TokenStreamComponents(tokenizer);
        }
    };
    private static final CharsRef TRUE = new CharsRef("true");
    private static final CharsRef FALSE = new CharsRef("false");

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        field.checkSortability();
        return this.getStringSort(field, reverse);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_BINARY;
        }
        return UninvertingReader.Type.SORTED;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new BoolFieldSource(field.name);
    }

    @Override
    public Analyzer getIndexAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public String toInternal(String val) {
        int ch = val != null && val.length() > 0 ? (int)val.charAt(0) : 0;
        return ch == 49 || ch == 116 || ch == 84 ? "T" : "F";
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public Boolean toObject(IndexableField f) {
        return Boolean.valueOf(this.toExternal(f));
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return term.bytes[term.offset] == 84;
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        char ch = indexedForm.charAt(0);
        return ch == 'T' ? "true" : "false";
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRefBuilder charsRef) {
        if (input.length > 0 && input.bytes[input.offset] == 84) {
            charsRef.copyChars(TRUE);
        } else {
            charsRef.copyChars(FALSE);
        }
        return charsRef.get();
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeBool(name, f.stringValue().charAt(0) == 'T');
    }

    @Override
    public Object marshalSortValue(Object value) {
        return BoolField.marshalStringSortValue(value);
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        return BoolField.unmarshalStringSortValue(value);
    }
}

