/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SortingMergePolicy;
import org.apache.lucene.search.Sort;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.index.MergePolicyFactoryArgs;
import org.apache.solr.index.WrapperMergePolicyFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SortSpecParsing;

public class SortingMergePolicyFactory
extends WrapperMergePolicyFactory {
    static final String SORT = "sort";
    protected final Sort mergeSort;

    public SortingMergePolicyFactory(SolrResourceLoader resourceLoader, MergePolicyFactoryArgs args, IndexSchema schema) {
        super(resourceLoader, args, schema);
        String sortArg = (String)args.remove(SORT);
        if (sortArg == null) {
            throw new IllegalArgumentException(SortingMergePolicyFactory.class.getSimpleName() + " requires a '" + SORT + "' argument.");
        }
        this.mergeSort = SortSpecParsing.parseSortSpec(sortArg, schema).getSort();
    }

    @Override
    protected MergePolicy getMergePolicyInstance(MergePolicy wrappedMP) {
        SortingMergePolicy mp = new SortingMergePolicy(wrappedMP, this.mergeSort);
        return mp;
    }
}

