/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.LucenePackage;
import org.apache.lucene.util.Constants;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String hostname = null;
    private CoreContainer cc;
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    public SystemInfoHandler() {
        this.init();
    }

    public SystemInfoHandler(CoreContainer cc) {
        this.cc = cc;
        this.init();
    }

    private void init() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        boolean solrCloudMode;
        SolrCore core = req.getCore();
        if (core != null) {
            rsp.add("core", this.getCoreInfo(core, req.getSchema()));
        }
        rsp.add("mode", (solrCloudMode = this.getCoreContainer(req, core).isZooKeeperAware()) ? "solrcloud" : "std");
        if (solrCloudMode) {
            rsp.add("zkHost", this.getCoreContainer(req, core).getZkController().getZkServerAddress());
        }
        if (this.cc != null) {
            rsp.add("solr_home", this.cc.getSolrHome());
        }
        rsp.add("lucene", SystemInfoHandler.getLuceneInfo());
        rsp.add("jvm", SystemInfoHandler.getJvmInfo());
        rsp.add("system", SystemInfoHandler.getSystemInfo());
        rsp.setHttpCaching(false);
    }

    private CoreContainer getCoreContainer(SolrQueryRequest req, SolrCore core) {
        CoreContainer coreContainer = core != null ? req.getCore().getCoreDescriptor().getCoreContainer() : this.cc;
        return coreContainer;
    }

    private SimpleOrderedMap<Object> getCoreInfo(SolrCore core, IndexSchema schema) {
        SimpleOrderedMap info = new SimpleOrderedMap();
        info.add("schema", (Object)(schema != null ? schema.getSchemaName() : "no schema!"));
        info.add("host", (Object)this.hostname);
        info.add("now", (Object)new Date());
        info.add("start", (Object)core.getStartTimeStamp());
        SimpleOrderedMap dirs = new SimpleOrderedMap();
        dirs.add("cwd", (Object)new File(System.getProperty("user.dir")).getAbsolutePath());
        dirs.add("instance", (Object)core.getResourceLoader().getInstancePath().toString());
        try {
            dirs.add("data", (Object)core.getDirectoryFactory().normalize(core.getDataDir()));
        }
        catch (IOException e) {
            log.warn("Problem getting the normalized data directory path", (Throwable)e);
            dirs.add("data", (Object)"N/A");
        }
        dirs.add("dirimpl", (Object)core.getDirectoryFactory().getClass().getName());
        try {
            dirs.add("index", (Object)core.getDirectoryFactory().normalize(core.getIndexDir()));
        }
        catch (IOException e) {
            log.warn("Problem getting the normalized index directory path", (Throwable)e);
            dirs.add("index", (Object)"N/A");
        }
        info.add("directory", (Object)dirs);
        return info;
    }

    public static SimpleOrderedMap<Object> getSystemInfo() {
        SimpleOrderedMap info = new SimpleOrderedMap();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        info.add("name", (Object)os.getName());
        try {
            SystemInfoHandler.addMXBeanProperties(os, OperatingSystemMXBean.class, (NamedList<Object>)info);
        }
        catch (IntrospectionException | ReflectiveOperationException e) {
            log.warn("Unable to fetch properties of OperatingSystemMXBean.", (Throwable)e);
        }
        for (String clazz : Arrays.asList("com.sun.management.OperatingSystemMXBean", "com.sun.management.UnixOperatingSystemMXBean", "com.ibm.lang.management.OperatingSystemMXBean")) {
            try {
                Class<PlatformManagedObject> intf = Class.forName(clazz).asSubclass(PlatformManagedObject.class);
                SystemInfoHandler.addMXBeanProperties(os, intf, (NamedList<Object>)info);
            }
            catch (ClassNotFoundException intf) {
            }
            catch (IntrospectionException | ReflectiveOperationException e) {
                log.warn("Unable to fetch properties of JVM-specific OperatingSystemMXBean.", (Throwable)e);
            }
        }
        try {
            if (!Constants.WINDOWS) {
                info.add("uname", (Object)SystemInfoHandler.execute("uname -a"));
                info.add("uptime", (Object)SystemInfoHandler.execute("uptime"));
            }
        }
        catch (Exception ex) {
            log.warn("Unable to execute command line tools to get operating system properties.", (Throwable)ex);
        }
        return info;
    }

    static <T extends PlatformManagedObject> void addMXBeanProperties(T obj, Class<? extends T> intf, NamedList<Object> info) throws IntrospectionException, ReflectiveOperationException {
        if (intf.isInstance(obj)) {
            BeanInfo beanInfo = Introspector.getBeanInfo(intf, intf.getSuperclass(), 3);
            for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
                String name = desc.getName();
                if (info.get(name) != null) continue;
                try {
                    Object v = desc.getReadMethod().invoke(obj, new Object[0]);
                    if (v == null) continue;
                    info.add(name, v);
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private static String execute(String cmd) {
        InputStream in = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            in = process.getInputStream();
            String string = IOUtils.toString((Reader)new InputStreamReader(in, Charset.defaultCharset()));
            return string;
        }
        catch (Exception ex) {
            String string = "(error executing: " + cmd + ")";
            return string;
        }
        catch (Error err) {
            if (err.getMessage() != null && (err.getMessage().contains("posix_spawn") || err.getMessage().contains("UNIXProcess"))) {
                log.warn("Error forking command due to JVM locale bug (see https://issues.apache.org/jira/browse/SOLR-6387): " + err.getMessage());
                String string = "(error executing: " + cmd + ")";
                return string;
            }
            throw err;
        }
        finally {
            if (process != null) {
                IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                IOUtils.closeQuietly((InputStream)process.getInputStream());
                IOUtils.closeQuietly((InputStream)process.getErrorStream());
            }
        }
    }

    public static SimpleOrderedMap<Object> getJvmInfo() {
        SimpleOrderedMap jvm = new SimpleOrderedMap();
        String javaVersion = System.getProperty("java.specification.version", "unknown");
        String javaVendor = System.getProperty("java.specification.vendor", "unknown");
        String javaName = System.getProperty("java.specification.name", "unknown");
        String jreVersion = System.getProperty("java.version", "unknown");
        String jreVendor = System.getProperty("java.vendor", "unknown");
        String vmVersion = System.getProperty("java.vm.version", "unknown");
        String vmVendor = System.getProperty("java.vm.vendor", "unknown");
        String vmName = System.getProperty("java.vm.name", "unknown");
        jvm.add("version", (Object)(jreVersion + " " + vmVersion));
        jvm.add("name", (Object)(jreVendor + " " + vmName));
        SimpleOrderedMap java = new SimpleOrderedMap();
        java.add("vendor", (Object)javaVendor);
        java.add("name", (Object)javaName);
        java.add("version", (Object)javaVersion);
        jvm.add("spec", (Object)java);
        SimpleOrderedMap jre = new SimpleOrderedMap();
        jre.add("vendor", (Object)jreVendor);
        jre.add("version", (Object)jreVersion);
        jvm.add("jre", (Object)jre);
        SimpleOrderedMap vm = new SimpleOrderedMap();
        vm.add("vendor", (Object)vmVendor);
        vm.add("name", (Object)vmName);
        vm.add("version", (Object)vmVersion);
        jvm.add("vm", (Object)vm);
        Runtime runtime = Runtime.getRuntime();
        jvm.add("processors", (Object)runtime.availableProcessors());
        DecimalFormat df = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ROOT));
        SimpleOrderedMap mem = new SimpleOrderedMap();
        SimpleOrderedMap raw = new SimpleOrderedMap();
        long free = runtime.freeMemory();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        double percentUsed = (double)used / (double)max * 100.0;
        raw.add("free", (Object)free);
        mem.add("free", (Object)SystemInfoHandler.humanReadableUnits(free, df));
        raw.add("total", (Object)total);
        mem.add("total", (Object)SystemInfoHandler.humanReadableUnits(total, df));
        raw.add("max", (Object)max);
        mem.add("max", (Object)SystemInfoHandler.humanReadableUnits(max, df));
        raw.add("used", (Object)used);
        mem.add("used", (Object)(SystemInfoHandler.humanReadableUnits(used, df) + " (%" + df.format(percentUsed) + ")"));
        raw.add("used%", (Object)percentUsed);
        mem.add("raw", (Object)raw);
        jvm.add("memory", (Object)mem);
        SimpleOrderedMap jmx = new SimpleOrderedMap();
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            if (mx.isBootClassPathSupported()) {
                jmx.add("bootclasspath", (Object)mx.getBootClassPath());
            }
            jmx.add("classpath", (Object)mx.getClassPath());
            jmx.add("commandLineArgs", mx.getInputArguments());
            jmx.add("startTime", (Object)new Date(mx.getStartTime()));
            jmx.add("upTimeMS", (Object)mx.getUptime());
        }
        catch (Exception e) {
            log.warn("Error getting JMX properties", (Throwable)e);
        }
        jvm.add("jmx", (Object)jmx);
        return jvm;
    }

    private static SimpleOrderedMap<Object> getLuceneInfo() {
        SimpleOrderedMap info = new SimpleOrderedMap();
        Package p = SolrCore.class.getPackage();
        info.add("solr-spec-version", (Object)p.getSpecificationVersion());
        info.add("solr-impl-version", (Object)p.getImplementationVersion());
        p = LucenePackage.class.getPackage();
        info.add("lucene-spec-version", (Object)p.getSpecificationVersion());
        info.add("lucene-impl-version", (Object)p.getImplementationVersion());
        return info;
    }

    @Override
    public String getDescription() {
        return "Get System Info";
    }

    private static String humanReadableUnits(long bytes, DecimalFormat df) {
        String newSizeAndUnits = bytes / 0x40000000L > 0L ? String.valueOf(df.format((float)bytes / 1.0737418E9f)) + " GB" : (bytes / 0x100000L > 0L ? String.valueOf(df.format((float)bytes / 1048576.0f)) + " MB" : (bytes / 1024L > 0L ? String.valueOf(df.format((float)bytes / 1024.0f)) + " KB" : String.valueOf(bytes) + " bytes"));
        return newSizeAndUnits;
    }
}

