/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CoreAdminHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    protected final Map<String, Map<String, TaskObject>> requestStatusMap;
    protected final ExecutorService parallelExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)50, (ThreadFactory)new DefaultSolrThreadFactory("parallelCoreAdminExecutor"));
    protected static int MAX_TRACKED_REQUESTS = 100;
    public static String RUNNING = "running";
    public static String COMPLETED = "completed";
    public static String FAILED = "failed";
    public static String RESPONSE = "Response";
    public static String RESPONSE_STATUS = "STATUS";
    public static String RESPONSE_MESSAGE = "msg";
    public static ImmutableMap<String, String> paramToProp = ImmutableMap.builder().put((Object)"config", (Object)"config").put((Object)"schema", (Object)"schema").put((Object)"dataDir", (Object)"dataDir").put((Object)"ulogDir", (Object)"ulogDir").put((Object)"configSet", (Object)"configSet").put((Object)"loadOnStartup", (Object)"loadOnStartup").put((Object)"transient", (Object)"transient").put((Object)"shard", (Object)"shard").put((Object)"collection", (Object)"collection").put((Object)"roles", (Object)"roles").put((Object)"coreNodeName", (Object)"coreNodeName").put((Object)"numShards", (Object)"numShards").build();
    private static final Map<String, CoreAdminOperation> opMap = new HashMap<String, CoreAdminOperation>();

    public CoreAdminHandler() {
        this.coreContainer = null;
        HashMap map = new HashMap(3, 1.0f);
        map.put(RUNNING, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(COMPLETED, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(FAILED, Collections.synchronizedMap(new LinkedHashMap()));
        this.requestStatusMap = Collections.unmodifiableMap(map);
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        HashMap map = new HashMap(3, 1.0f);
        map.put(RUNNING, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(COMPLETED, Collections.synchronizedMap(new LinkedHashMap()));
        map.put(FAILED, Collections.synchronizedMap(new LinkedHashMap()));
        this.requestStatusMap = Collections.unmodifiableMap(map);
    }

    @Override
    public final void init(NamedList args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        block12: {
            try {
                CoreAdminOperation op;
                CoreContainer cores = this.getCoreContainer();
                if (cores == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
                }
                String taskId = req.getParams().get("async");
                TaskObject taskObject = new TaskObject(taskId);
                if (taskId != null) {
                    if (this.getRequestStatusMap(RUNNING).containsKey(taskId) || this.getRequestStatusMap(COMPLETED).containsKey(taskId) || this.getRequestStatusMap(FAILED).containsKey(taskId)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Duplicate request with the same requestid found.");
                    }
                    this.addTask(RUNNING, taskObject);
                }
                if ((op = opMap.get(req.getParams().get("action", CoreAdminParams.CoreAdminAction.STATUS.toString()).toLowerCase(Locale.ROOT))) == null) {
                    this.handleCustomAction(req, rsp);
                    return;
                }
                CallInfo callInfo = new CallInfo(this, req, rsp, op);
                if (taskId == null) {
                    callInfo.call();
                    break block12;
                }
                try {
                    MDC.put((String)"CoreAdminHandler.asyncId", (String)taskId);
                    MDC.put((String)"CoreAdminHandler.action", (String)op.action.toString());
                    this.parallelExecutor.execute(() -> {
                        boolean exceptionCaught = false;
                        try {
                            callInfo.call();
                            taskObject.setRspObject(callInfo.rsp);
                        }
                        catch (Exception e) {
                            exceptionCaught = true;
                            taskObject.setRspObjectFromException(e);
                        }
                        finally {
                            this.removeTask("running", taskObject.taskId);
                            if (exceptionCaught) {
                                this.addTask("failed", taskObject, true);
                            } else {
                                this.addTask("completed", taskObject, true);
                            }
                        }
                    });
                }
                finally {
                    MDC.remove((String)"CoreAdminHandler.asyncId");
                    MDC.remove((String)"CoreAdminHandler.action");
                }
            }
            finally {
                rsp.setHttpCaching(false);
            }
        }
    }

    protected void handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    protected static Map<String, String> buildCoreParams(SolrParams params) {
        HashMap<String, String> coreParams = new HashMap<String, String>();
        for (String param : paramToProp.keySet()) {
            String value = params.get(param, null);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            coreParams.put((String)paramToProp.get((Object)param), value);
        }
        Iterator paramsIt = params.getParameterNamesIterator();
        while (paramsIt.hasNext()) {
            String param;
            param = (String)paramsIt.next();
            if (param.startsWith("property.")) {
                String propName = param.substring("property.".length());
                String propValue = params.get(param);
                coreParams.put(propName, propValue);
            }
            if (!param.startsWith("collection.")) continue;
            coreParams.put(param, params.get(param));
        }
        return coreParams;
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTask(String type, TaskObject o, boolean limit) {
        Map<String, TaskObject> map = this.getRequestStatusMap(type);
        synchronized (map) {
            if (limit && this.getRequestStatusMap(type).size() == MAX_TRACKED_REQUESTS) {
                String key = this.getRequestStatusMap(type).entrySet().iterator().next().getKey();
                this.getRequestStatusMap(type).remove(key);
            }
            this.addTask(type, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(String type, TaskObject o) {
        Map<String, TaskObject> map = this.getRequestStatusMap(type);
        synchronized (map) {
            this.getRequestStatusMap(type).put(o.taskId, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(String map, String taskId) {
        Map<String, TaskObject> map2 = this.getRequestStatusMap(map);
        synchronized (map2) {
            this.getRequestStatusMap(map).remove(taskId);
        }
    }

    Map<String, TaskObject> getRequestStatusMap(String key) {
        return this.requestStatusMap.get(key);
    }

    public void shutdown() {
        if (this.parallelExecutor != null && !this.parallelExecutor.isShutdown()) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.parallelExecutor);
        }
    }

    static {
        for (CoreAdminOperation op : CoreAdminOperation.values()) {
            opMap.put(op.action.toString().toLowerCase(Locale.ROOT), op);
        }
    }

    public static interface Invocable {
        public Map<String, Object> invoke(SolrQueryRequest var1);
    }

    static class CallInfo {
        final CoreAdminHandler handler;
        final SolrQueryRequest req;
        final SolrQueryResponse rsp;
        final CoreAdminOperation op;

        CallInfo(CoreAdminHandler handler, SolrQueryRequest req, SolrQueryResponse rsp, CoreAdminOperation op) {
            this.handler = handler;
            this.req = req;
            this.rsp = rsp;
            this.op = op;
        }

        void call() throws Exception {
            this.op.call(this);
        }
    }

    static class TaskObject {
        String taskId;
        String rspInfo;

        public TaskObject(String taskId) {
            this.taskId = taskId;
        }

        public String getRspObject() {
            return this.rspInfo;
        }

        public void setRspObject(SolrQueryResponse rspObject) {
            this.rspInfo = rspObject.getToLogAsString("TaskId: " + this.taskId);
        }

        public void setRspObjectFromException(Exception e) {
            this.rspInfo = e.getMessage();
        }
    }
}

