/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ClusterStatus;
import org.apache.solr.handler.admin.RebalanceLeaders;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    static final Set<String> KNOWN_ROLES = ImmutableSet.of((Object)"overseer");
    public static long DEFAULT_COLLECTION_OP_TIMEOUT = 180000L;
    public static final String SYSTEM_COLL = ".system";
    public static final List<String> MODIFIABLE_COLL_PROPS = ImmutableList.of((Object)"rule", (Object)"snitch", (Object)"replicationFactor", (Object)"maxShardsPerNode", (Object)"autoAddReplicas");

    public CollectionsHandler() {
        this.coreContainer = null;
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            CollectionOperation operation = CollectionOperation.get(action);
            log.info("Invoked Collection Action :{} with params {} and sendToOCPQueue={}", new Object[]{action.toLower(), req.getParamString(), operation.sendToOCPQueue});
            SolrResponse response = null;
            Map<String, Object> props = operation.call(req, rsp, this);
            String asyncId = req.getParams().get("async");
            if (props != null) {
                if (asyncId != null) {
                    props.put("async", asyncId);
                }
                props.put("operation", operation.action.toLower());
                ZkNodeProps zkProps = new ZkNodeProps(props);
                if (operation.sendToOCPQueue) {
                    response = this.handleResponse(operation.action.toLower(), zkProps, rsp, operation.timeOut);
                } else {
                    Overseer.getStateUpdateQueue(this.coreContainer.getZkController().getZkClient()).offer(Utils.toJSON(props));
                }
                String collectionName = zkProps.getStr("name");
                if (action.equals((Object)CollectionParams.CollectionAction.CREATE) && asyncId == null && rsp.getException() == null) {
                    CollectionsHandler.waitForActiveCollection(collectionName, zkProps, cores, response);
                }
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        rsp.setHttpCaching(false);
    }

    void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        this.handleResponse(operation, m, rsp, DEFAULT_COLLECTION_OP_TIMEOUT);
    }

    private SolrResponse handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        if (m.containsKey("async") && m.get("async") != null) {
            String asyncId = m.getStr("async");
            if (asyncId.equals("-1")) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "requestid can not be -1. It is reserved for cleanup purposes.");
            }
            NamedList r = new NamedList();
            if (this.coreContainer.getZkController().getOverseerCompletedMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerFailureMap().contains(asyncId) || this.coreContainer.getZkController().getOverseerRunningMap().contains(asyncId) || this.overseerCollectionQueueContains(asyncId)) {
                r.add("error", (Object)"Task with the same requestid already exists.");
            } else {
                this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m));
            }
            r.add("requestid", (Object)((String)m.get("async")));
            OverseerSolrResponse response = new OverseerSolrResponse(r);
            rsp.getValues().addAll(response.getResponse());
            return response;
        }
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerCollectionQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize((byte[])event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
            return response;
        }
        if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
        }
        if (event.getWatchedEvent() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unknown case");
    }

    private boolean overseerCollectionQueueContains(String asyncId) throws KeeperException, InterruptedException {
        OverseerTaskQueue collectionQueue = this.coreContainer.getZkController().getOverseerCollectionQueue();
        return collectionQueue.containsTaskWithRequestId("async", asyncId);
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        return props;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    private static void forceLeaderElection(SolrQueryRequest req, CollectionsHandler handler) {
        ClusterState clusterState = handler.coreContainer.getZkController().getClusterState();
        String collection = req.getParams().required().get("collection");
        String sliceId = req.getParams().required().get("shard");
        log.info("Force leader invoked, state: {}", (Object)clusterState);
        Slice slice = clusterState.getSlice(collection, sliceId);
        if (slice == null) {
            if (clusterState.hasCollection(collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + sliceId + " exists for collection " + collection);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collection);
        }
        try {
            Replica leader = slice.getLeader();
            if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard already has an active leader. Force leader is not applicable. State: " + slice);
            }
            String lirPath = handler.coreContainer.getZkController().getLeaderInitiatedRecoveryZnodePath(collection, sliceId);
            if (handler.coreContainer.getZkController().getZkClient().exists(lirPath, true).booleanValue()) {
                StringBuilder sb = new StringBuilder();
                handler.coreContainer.getZkController().getZkClient().printLayout(lirPath, 4, sb);
                log.info("Cleaning out LIR data, which was: {}", (Object)sb);
                handler.coreContainer.getZkController().getZkClient().clean(lirPath);
            }
            for (Replica rep : slice.getReplicas()) {
                if (!clusterState.getLiveNodes().contains(rep.getNodeName())) continue;
                ShardHandler shardHandler = handler.coreContainer.getShardHandlerFactory().getShardHandler();
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.FORCEPREPAREFORLEADERSHIP.toString()});
                params.set("core", new String[]{rep.getStr("core")});
                String nodeName = rep.getNodeName();
                OverseerCollectionMessageHandler.sendShardRequest(nodeName, params, shardHandler, null, null, "/admin/cores", handler.coreContainer.getZkController().getZkStateReader());
            }
            boolean success = false;
            for (int i = 0; i < 9; ++i) {
                Thread.sleep(5000L);
                clusterState = handler.coreContainer.getZkController().getClusterState();
                slice = clusterState.getSlice(collection, sliceId);
                if (slice.getLeader() != null && slice.getLeader().getState() == Replica.State.ACTIVE) {
                    success = true;
                    break;
                }
                log.warn("Force leader attempt {}. Waiting 5 secs for an active leader. State of the slice: {}", (Object)(i + 1), (Object)slice);
            }
            if (success) {
                log.info("Successfully issued FORCELEADER command for collection: {}, shard: {}", (Object)collection, (Object)sliceId);
            } else {
                log.info("Couldn't successfully force leader, collection: {}, shard: {}. Cluster state: {}", new Object[]{collection, sliceId, clusterState});
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing FORCELEADER operation for collection: " + collection + " shard: " + sliceId, (Throwable)e);
        }
    }

    private static void waitForActiveCollection(String collectionName, ZkNodeProps message, CoreContainer cc, SolrResponse response) throws KeeperException, InterruptedException {
        if (response.getResponse().get("exception") != null) {
            log.info("Not waiting for active collection due to exception: " + response.getResponse().get("exception"));
            return;
        }
        if (response.getResponse().get("failure") != null) {
            // empty if block
        }
        String replicaNotAlive = null;
        String replicaState = null;
        String nodeNotLive = null;
        CloudConfig ccfg = cc.getConfig().getCloudConfig();
        Integer numRetries = ccfg.getCreateCollectionWaitTimeTillActive();
        Boolean checkLeaderOnly = ccfg.isCreateCollectionCheckLeaderActive();
        log.info("Wait for new collection to be active for at most " + numRetries + " seconds. Check all shard " + (checkLeaderOnly != false ? "leaders" : "replicas"));
        ZkStateReader zkStateReader = cc.getZkController().getZkStateReader();
        for (int i = 0; i < numRetries; ++i) {
            zkStateReader.updateClusterState();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection shards = clusterState.getSlices(collectionName);
            if (shards != null) {
                replicaNotAlive = null;
                for (Slice shard : shards) {
                    ArrayList<Replica> replicas;
                    if (!checkLeaderOnly.booleanValue()) {
                        replicas = shard.getReplicas();
                    } else {
                        replicas = new ArrayList<Replica>();
                        replicas.add(shard.getLeader());
                    }
                    for (Replica replica : replicas) {
                        String state = replica.getStr("state");
                        log.debug("Checking replica status, collection={} replica={} state={}", new Object[]{collectionName, replica.getCoreUrl(), state});
                        if (clusterState.liveNodesContain(replica.getNodeName()) && state.equals(Replica.State.ACTIVE.toString())) continue;
                        replicaNotAlive = replica.getCoreUrl();
                        nodeNotLive = replica.getNodeName();
                        replicaState = state;
                        break;
                    }
                    if (replicaNotAlive == null) continue;
                    break;
                }
                if (replicaNotAlive == null) {
                    return;
                }
            }
            Thread.sleep(1000L);
        }
        if (nodeNotLive != null && replicaState != null) {
            log.error("Timed out waiting for new collection's replicas to become ACTIVE " + (replicaState.equals(Replica.State.ACTIVE.toString()) ? "node " + nodeNotLive + " is not live" : "replica " + replicaNotAlive + " is in state of " + replicaState.toString()) + " with timeout=" + numRetries);
        } else {
            log.error("Timed out waiting for new collection's replicas to become ACTIVE with timeout=" + numRetries);
        }
    }

    public static void verifyRuleParams(CoreContainer cc, Map<String, Object> m) {
        List l = (List)m.get("rule");
        if (l != null) {
            for (Object o : l) {
                Map map = (Map)o;
                try {
                    new Rule(map);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error in rule " + m, (Throwable)e);
                }
            }
        }
        ReplicaAssigner.verifySnitchConf(cc, (List)m.get("snitch"));
    }

    private static Map<String, Object> addMapObject(Map<String, Object> props, String key) {
        Object v = props.get(key);
        if (v == null) {
            return props;
        }
        ArrayList<String> val = new ArrayList<String>();
        if (v instanceof String[]) {
            val.addAll(Arrays.asList((String[])v));
        } else {
            val.add(v.toString());
        }
        if (val.size() > 0) {
            ArrayList<Map> l = new ArrayList<Map>();
            for (String rule : val) {
                l.add(Rule.parseRule(rule));
            }
            props.put(key, l);
        }
        return props;
    }

    private static void verifyShardsParam(String shardsParam) {
        for (String shard : shardsParam.split(",")) {
            if (SolrIdentifierValidator.validateShardName((String)shard)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, SolrIdentifierValidator.getIdentifierMessage((SolrIdentifierValidator.IdentifierType)SolrIdentifierValidator.IdentifierType.SHARD, (String)shard));
        }
    }

    static enum CollectionOperation {
        CREATE_OP(CollectionParams.CollectionAction.CREATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws KeeperException, InterruptedException {
                Map props = req.getParams().required().getAll(null, new String[]{"name"});
                props.put("fromApi", "true");
                req.getParams().getAll(props, new String[]{"replicationFactor", "collection.configName", "numShards", "maxShardsPerNode", "createNodeSet", "createNodeSet.shuffle", "shards", "stateFormat", "autoAddReplicas", "rule", "snitch"});
                if (props.get("stateFormat") == null) {
                    props.put("stateFormat", "2");
                }
                CollectionsHandler.addMapObject(props, "rule");
                CollectionsHandler.addMapObject(props, "snitch");
                CollectionsHandler.verifyRuleParams(h.coreContainer, props);
                String collectionName = (String)props.get("name");
                if (!SolrIdentifierValidator.validateCollectionName((String)collectionName)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, SolrIdentifierValidator.getIdentifierMessage((SolrIdentifierValidator.IdentifierType)SolrIdentifierValidator.IdentifierType.COLLECTION, (String)collectionName));
                }
                String shardsParam = (String)props.get("shards");
                if (StringUtils.isNotEmpty((String)shardsParam)) {
                    CollectionsHandler.verifyShardsParam(shardsParam);
                }
                if (CollectionsHandler.SYSTEM_COLL.equals(collectionName)) {
                    props.put("numShards", 1);
                    props.remove("shards");
                    this.createSysConfigSet(h.coreContainer);
                }
                CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "router.");
            }

            private void createSysConfigSet(CoreContainer coreContainer) throws KeeperException, InterruptedException {
                SolrZkClient zk = coreContainer.getZkController().getZkStateReader().getZkClient();
                ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zk.getZkClientTimeout());
                cmdExecutor.ensureExists("/configs", zk);
                cmdExecutor.ensureExists("/configs/.system", zk);
                try {
                    String path = "/configs/.system/schema.xml";
                    byte[] data = IOUtils.toByteArray((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("SystemCollectionSchema.xml"));
                    cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
                    path = "/configs/.system/solrconfig.xml";
                    data = IOUtils.toByteArray((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("SystemCollectionSolrConfig.xml"));
                    cmdExecutor.ensureExists(path, data, CreateMode.PERSISTENT, zk);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
        ,
        DELETE_OP(CollectionParams.CollectionAction.DELETE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        RELOAD_OP(CollectionParams.CollectionAction.RELOAD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        SYNCSHARD_OP(CollectionParams.CollectionAction.SYNCSHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String collection = req.getParams().required().get("collection");
                String shard = req.getParams().required().get("shard");
                ClusterState clusterState = h.coreContainer.getZkController().getClusterState();
                Replica leaderProps = clusterState.getLeader(collection, shard);
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
                try (HttpSolrClient client = new HttpSolrClient(nodeProps.getBaseUrl());){
                    client.setConnectionTimeout(15000);
                    client.setSoTimeout(60000);
                    CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
                    reqSyncShard.setCollection(collection);
                    reqSyncShard.setShard(shard);
                    reqSyncShard.setCoreName(nodeProps.getCoreName());
                    client.request((SolrRequest)reqSyncShard);
                }
                return null;
            }
        }
        ,
        CREATEALIAS_OP(CollectionParams.CollectionAction.CREATEALIAS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                String aliasName = req.getParams().get("name");
                if (!SolrIdentifierValidator.validateCollectionName((String)aliasName)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, SolrIdentifierValidator.getIdentifierMessage((SolrIdentifierValidator.IdentifierType)SolrIdentifierValidator.IdentifierType.ALIAS, (String)aliasName));
                }
                return req.getParams().required().getAll(null, new String[]{"name", "collections"});
            }
        }
        ,
        DELETEALIAS_OP(CollectionParams.CollectionAction.DELETEALIAS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        SPLITSHARD_OP(CollectionParams.CollectionAction.SPLITSHARD, DEFAULT_COLLECTION_OP_TIMEOUT * 5L, true){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String name = req.getParams().required().get("collection");
                String shard = req.getParams().get("shard");
                String rangesStr = req.getParams().get("ranges");
                String splitKey = req.getParams().get("split.key");
                if (splitKey == null && shard == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: shard");
                }
                if (splitKey != null && shard != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'shard' or 'split.key' should be specified");
                }
                if (splitKey != null && rangesStr != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one of 'ranges' or 'split.key' should be specified");
                }
                Map map = req.getParams().getAll(null, new String[]{"collection", "shard", "split.key", "ranges"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
            }
        }
        ,
        DELETESHARD_OP(CollectionParams.CollectionAction.DELETESHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard"});
                req.getParams().getAll(map, new String[]{"deleteIndex", "deleteDataDir", "deleteInstanceDir"});
                return map;
            }
        }
        ,
        FORCELEADER_OP(CollectionParams.CollectionAction.FORCELEADER){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                CollectionsHandler.forceLeaderElection(req, handler);
                return null;
            }
        }
        ,
        CREATESHARD_OP(CollectionParams.CollectionAction.CREATESHARD){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard"});
                ClusterState clusterState = handler.coreContainer.getZkController().getClusterState();
                String newShardName = req.getParams().get("shard");
                if (!SolrIdentifierValidator.validateShardName((String)newShardName)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, SolrIdentifierValidator.getIdentifierMessage((SolrIdentifierValidator.IdentifierType)SolrIdentifierValidator.IdentifierType.SHARD, (String)newShardName));
                }
                if (!"implicit".equals(((Map)clusterState.getCollection(req.getParams().get("collection")).get("router")).get("name"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
                }
                req.getParams().getAll(map, new String[]{"replicationFactor", "createNodeSet"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), map, "property.");
            }
        }
        ,
        DELETEREPLICA_OP(CollectionParams.CollectionAction.DELETEREPLICA){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "shard", "replica"});
                req.getParams().getAll(map, new String[]{"deleteIndex", "deleteDataDir", "deleteInstanceDir"});
                return req.getParams().getAll(map, new String[]{"onlyIfDown"});
            }
        }
        ,
        MIGRATE_OP(CollectionParams.CollectionAction.MIGRATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "split.key", "target.collection"});
                return req.getParams().getAll(map, new String[]{"forward.timeout"});
            }
        }
        ,
        ADDROLE_OP(CollectionParams.CollectionAction.ADDROLE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
                if (!KNOWN_ROLES.contains(map.get("role"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
                }
                return map;
            }
        }
        ,
        REMOVEROLE_OP(CollectionParams.CollectionAction.REMOVEROLE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"role", "node"});
                if (!KNOWN_ROLES.contains(map.get("role"))) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown role. Supported roles are ," + KNOWN_ROLES);
                }
                return map;
            }
        }
        ,
        CLUSTERPROP_OP(CollectionParams.CollectionAction.CLUSTERPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                String name = req.getParams().required().get("name");
                String val = req.getParams().get("val");
                h.coreContainer.getZkController().getZkStateReader().setClusterProperty(name, val);
                return null;
            }
        }
        ,
        REQUESTSTATUS_OP(CollectionParams.CollectionAction.REQUESTSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                byte[] mapEntry;
                req.getParams().required().check(new String[]{"requestid"});
                CoreContainer coreContainer = h.coreContainer;
                String requestId = req.getParams().get("requestid");
                ZkController zkController = coreContainer.getZkController();
                NamedList results = new NamedList();
                if (zkController.getOverseerCompletedMap().contains(requestId)) {
                    mapEntry = zkController.getOverseerCompletedMap().get(requestId);
                    rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEntry).getResponse());
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.COMPLETED, "found [" + requestId + "] in completed tasks");
                } else if (zkController.getOverseerFailureMap().contains(requestId)) {
                    mapEntry = zkController.getOverseerFailureMap().get(requestId);
                    rsp.getValues().addAll(SolrResponse.deserialize((byte[])mapEntry).getResponse());
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.FAILED, "found [" + requestId + "] in failed tasks");
                } else if (zkController.getOverseerRunningMap().contains(requestId)) {
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.RUNNING, "found [" + requestId + "] in running tasks");
                } else if (h.overseerCollectionQueueContains(requestId)) {
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.SUBMITTED, "found [" + requestId + "] in submitted tasks");
                } else {
                    this.addStatusToResponse((NamedList<Object>)results, RequestStatusState.NOT_FOUND, "Did not find [" + requestId + "] in any tasks queue");
                }
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }

            private void addStatusToResponse(NamedList<Object> results, RequestStatusState state, String msg) {
                SimpleOrderedMap status = new SimpleOrderedMap();
                status.add("state", (Object)state.getKey());
                status.add("msg", (Object)msg);
                results.add("status", (Object)status);
            }
        }
        ,
        DELETESTATUS_OP(CollectionParams.CollectionAction.DELETESTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                CoreContainer coreContainer = h.coreContainer;
                String requestId = req.getParams().get("requestid");
                ZkController zkController = coreContainer.getZkController();
                Boolean flush = req.getParams().getBool("flush", false);
                if (requestId == null && !flush.booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either requestid or flush parameter must be specified.");
                }
                if (requestId != null && flush.booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both requestid and flush parameters can not be specified together.");
                }
                if (flush.booleanValue()) {
                    zkController.getOverseerCompletedMap().clear();
                    zkController.getOverseerFailureMap().clear();
                    rsp.getValues().add("status", (Object)"successfully cleared stored collection api responses");
                    return null;
                }
                if (zkController.getOverseerCompletedMap().remove(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else if (zkController.getOverseerFailureMap().remove(requestId)) {
                    rsp.getValues().add("status", (Object)("successfully removed stored response for [" + requestId + "]"));
                } else {
                    rsp.getValues().add("status", (Object)("[" + requestId + "] not found in stored responses"));
                }
                return null;
            }
        }
        ,
        ADDREPLICA_OP(CollectionParams.CollectionAction.ADDREPLICA){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map props = req.getParams().getAll(null, new String[]{"collection", "node", "shard", "_route_", "name", "instanceDir", "dataDir"});
                return CollectionsHandler.copyPropertiesWithPrefix(req.getParams(), props, "property.");
            }
        }
        ,
        OVERSEERSTATUS_OP(CollectionParams.CollectionAction.OVERSEERSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                return new LinkedHashMap<String, Object>();
            }
        }
        ,
        LIST_OP(CollectionParams.CollectionAction.LIST){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                NamedList results = new NamedList();
                Set collections = handler.coreContainer.getZkController().getZkStateReader().getClusterState().getCollections();
                ArrayList<String> collectionList = new ArrayList<String>();
                for (String collection : collections) {
                    collectionList.add(collection);
                }
                results.add("collections", collectionList);
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }
        }
        ,
        CLUSTERSTATUS_OP(CollectionParams.CollectionAction.CLUSTERSTATUS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws KeeperException, InterruptedException {
                Map all = req.getParams().getAll(null, new String[]{"collection", "shard", "_route_"});
                new ClusterStatus(handler.coreContainer.getZkController().getZkStateReader(), new ZkNodeProps(all)).getClusterStatus(rsp.getValues());
                return null;
            }
        }
        ,
        ADDREPLICAPROP_OP(CollectionParams.CollectionAction.ADDREPLICAPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica", "property.value"});
                req.getParams().getAll(map, new String[]{"shardUnique"});
                String property = (String)map.get("property");
                if (!property.startsWith("property.")) {
                    property = "property." + property;
                }
                boolean uniquePerSlice = Boolean.parseBoolean((String)map.get("shardUnique"));
                if (StringUtils.isNotBlank((String)((String)map.get("shardUnique"))) && SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(property.toLowerCase(Locale.ROOT)) && !uniquePerSlice) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer replica property command received for property " + property + " with the " + "shardUnique" + " parameter set to something other than 'true'. No action taken.");
                }
                return map;
            }
        }
        ,
        DELETEREPLICAPROP_OP(CollectionParams.CollectionAction.DELETEREPLICAPROP){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property", "shard", "replica"});
                return req.getParams().getAll(map, new String[]{"property"});
            }
        }
        ,
        BALANCESHARDUNIQUE_OP(CollectionParams.CollectionAction.BALANCESHARDUNIQUE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map map = req.getParams().required().getAll(null, new String[]{"collection", "property"});
                Boolean shardUnique = Boolean.parseBoolean(req.getParams().get("shardUnique"));
                String prop = req.getParams().get("property").toLowerCase(Locale.ROOT);
                if (!StringUtils.startsWith((String)prop, (String)"property.")) {
                    prop = "property." + prop;
                }
                if (!shardUnique.booleanValue() && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(prop)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be pre-defined as a unique property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'.  Property: " + prop + " shardUnique: " + Boolean.toString(shardUnique));
                }
                return req.getParams().getAll(map, new String[]{"onlyactivenodes", "shardUnique"});
            }
        }
        ,
        REBALANCELEADERS_OP(CollectionParams.CollectionAction.REBALANCELEADERS){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                new RebalanceLeaders(req, rsp, h).execute();
                return null;
            }
        }
        ,
        MODIFYCOLLECTION_OP(CollectionParams.CollectionAction.MODIFYCOLLECTION, DEFAULT_COLLECTION_OP_TIMEOUT, false){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler h) throws Exception {
                Map m = req.getParams().getAll(null, MODIFIABLE_COLL_PROPS.toArray(new String[0]));
                if (m.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)"no supported values provided rule, snitch, masShardsPerNode, replicationFactor", (Object[])new Object[0]));
                }
                req.getParams().required().getAll(m, new String[]{"collection"});
                CollectionsHandler.addMapObject(m, "rule");
                CollectionsHandler.addMapObject(m, "snitch");
                for (String prop : MODIFIABLE_COLL_PROPS) {
                    DocCollection.verifyProp((Map)m, (String)prop);
                }
                CollectionsHandler.verifyRuleParams(h.coreContainer, m);
                return m;
            }
        }
        ,
        MIGRATESTATEFORMAT_OP(CollectionParams.CollectionAction.MIGRATESTATEFORMAT){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, CollectionsHandler handler) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"collection"});
            }
        };

        CollectionParams.CollectionAction action;
        long timeOut;
        boolean sendToOCPQueue;

        private CollectionOperation(CollectionParams.CollectionAction action) {
            this(action, DEFAULT_COLLECTION_OP_TIMEOUT, true);
        }

        private CollectionOperation(CollectionParams.CollectionAction action, long timeOut, boolean sendToOCPQueue) {
            this.action = action;
            this.timeOut = timeOut;
            this.sendToOCPQueue = sendToOCPQueue;
        }

        abstract Map<String, Object> call(SolrQueryRequest var1, SolrQueryResponse var2, CollectionsHandler var3) throws Exception;

        public static CollectionOperation get(CollectionParams.CollectionAction action) {
            for (CollectionOperation op : CollectionOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action" + action);
        }
    }
}

