/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;

public class ClusterStatus {
    private final ZkStateReader zkStateReader;
    private final String collection;
    private ZkNodeProps message;

    public ClusterStatus(ZkStateReader zkStateReader, ZkNodeProps props) {
        this.zkStateReader = zkStateReader;
        this.message = props;
        this.collection = props.getStr("collection");
    }

    public void getClusterStatus(NamedList results) throws KeeperException, InterruptedException {
        this.zkStateReader.updateClusterState();
        Aliases aliases = this.zkStateReader.getAliases();
        HashMap<String, ArrayList<String>> collectionVsAliases = new HashMap<String, ArrayList<String>>();
        Map aliasVsCollections = aliases.getCollectionAliasMap();
        if (aliasVsCollections != null) {
            for (Map.Entry entry : aliasVsCollections.entrySet()) {
                List colls = StrUtils.splitSmart((String)((String)entry.getValue()), (char)',');
                String alias = (String)entry.getKey();
                for (String coll : colls) {
                    if (this.collection != null && !this.collection.equals(coll)) continue;
                    ArrayList<String> list = (ArrayList<String>)collectionVsAliases.get(coll);
                    if (list == null) {
                        list = new ArrayList<String>();
                        collectionVsAliases.put(coll, list);
                    }
                    list.add(alias);
                }
            }
        }
        Map roles = null;
        if (this.zkStateReader.getZkClient().exists("/roles.json", true).booleanValue()) {
            roles = (Map)Utils.fromJSON((byte[])this.zkStateReader.getZkClient().getData("/roles.json", null, null, true));
        }
        ClusterState clusterState = this.zkStateReader.getClusterState();
        byte[] bytes = Utils.toJSON((Object)clusterState);
        Map stateMap = (Map)Utils.fromJSON((byte[])bytes);
        String routeKey = this.message.getStr("_route_");
        String shard = this.message.getStr("shard");
        Set<String> collections = this.collection == null ? new HashSet<String>(clusterState.getCollections()) : Collections.singleton(this.collection);
        SimpleOrderedMap collectionProps = new SimpleOrderedMap();
        for (String name : collections) {
            Map<String, Object> collectionStatus;
            DocCollection clusterStateCollection = clusterState.getCollectionOrNull(name);
            if (clusterStateCollection == null) {
                if (this.collection == null) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
            }
            HashSet<String> requestedShards = new HashSet<String>();
            if (routeKey != null) {
                DocRouter router = clusterStateCollection.getRouter();
                Collection slices = router.getSearchSlices(routeKey, null, clusterStateCollection);
                for (Slice slice : slices) {
                    requestedShards.add(slice.getName());
                }
            }
            if (shard != null) {
                requestedShards.add(shard);
            }
            if (clusterStateCollection.getStateFormat() > 1) {
                bytes = Utils.toJSON((Object)clusterStateCollection);
                Map docCollection = (Map)Utils.fromJSON((byte[])bytes);
                collectionStatus = this.getCollectionStatus(docCollection, name, requestedShards);
            } else {
                collectionStatus = this.getCollectionStatus((Map)stateMap.get(name), name, requestedShards);
            }
            collectionStatus.put("znodeVersion", clusterStateCollection.getZNodeVersion());
            if (collectionVsAliases.containsKey(name) && !((List)collectionVsAliases.get(name)).isEmpty()) {
                collectionStatus.put("aliases", collectionVsAliases.get(name));
            }
            String configName = this.zkStateReader.readConfigName(name);
            collectionStatus.put("configName", configName);
            collectionProps.add(name, collectionStatus);
        }
        List liveNodes = this.zkStateReader.getZkClient().getChildren("/live_nodes", null, true);
        this.crossCheckReplicaStateWithLiveNodes(liveNodes, (NamedList<Object>)collectionProps);
        SimpleOrderedMap clusterStatus = new SimpleOrderedMap();
        clusterStatus.add("collections", (Object)collectionProps);
        Map clusterProps = this.zkStateReader.getClusterProps();
        if (clusterProps != null && !clusterProps.isEmpty()) {
            clusterStatus.add("properties", (Object)clusterProps);
        }
        if (aliasVsCollections != null && !aliasVsCollections.isEmpty()) {
            clusterStatus.add("aliases", (Object)aliasVsCollections);
        }
        if (roles != null) {
            clusterStatus.add("roles", (Object)roles);
        }
        clusterStatus.add("live_nodes", (Object)liveNodes);
        results.add("cluster", (Object)clusterStatus);
    }

    private Map<String, Object> getCollectionStatus(Map<String, Object> collection, String name, Set<String> requestedShards) {
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
        }
        if (requestedShards == null || requestedShards.isEmpty()) {
            return collection;
        }
        Map shards = (Map)collection.get("shards");
        HashMap selected = new HashMap();
        for (String selectedShard : requestedShards) {
            if (!shards.containsKey(selectedShard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " shard: " + selectedShard + " not found");
            }
            selected.put(selectedShard, shards.get(selectedShard));
            collection.put("shards", selected);
        }
        return collection;
    }

    protected void crossCheckReplicaStateWithLiveNodes(List<String> liveNodes, NamedList<Object> collectionProps) {
        for (Map.Entry next : collectionProps) {
            Map collMap = (Map)next.getValue();
            Map shards = (Map)collMap.get("shards");
            for (Object nextShard : shards.values()) {
                Map shardMap = (Map)nextShard;
                Map replicas = (Map)shardMap.get("replicas");
                for (Object nextReplica : replicas.values()) {
                    String node_name;
                    Map replicaMap = (Map)nextReplica;
                    if (Replica.State.getState((String)((String)replicaMap.get("state"))) == Replica.State.DOWN || liveNodes.contains(node_name = (String)replicaMap.get("node_name"))) continue;
                    replicaMap.put("state", Replica.State.DOWN.toString());
                }
            }
        }
    }
}

