/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.IndexFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCore
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String backupName;
    private final String backupLocation;
    private final SolrCore core;

    public RestoreCore(SolrCore core, String location, String name) {
        this.core = core;
        this.backupLocation = location;
        this.backupName = name;
    }

    @Override
    public Boolean call() throws Exception {
        return this.doRestore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doRestore() throws Exception {
        block43: {
            backupPath = Paths.get(this.backupLocation, new String[0]).resolve(this.backupName);
            dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT);
            restoreIndexName = "restore." + dateFormat.format(new Date());
            restoreIndexPath = this.core.getDataDir() + restoreIndexName;
            restoreIndexDir = null;
            indexDir = null;
            backupDir = FSDirectory.open((Path)backupPath);
            var8_8 = null;
            restoreIndexDir = this.core.getDirectoryFactory().get(restoreIndexPath, DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
            indexDir = this.core.getDirectoryFactory().get(this.core.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
            for (String filename : backupDir.listAll()) {
                this.checkInterrupted();
                RestoreCore.log.info("Copying file {} to restore directory ", (Object)filename);
                try {
                    indexInput = backupDir.openInput(filename, IOContext.READONCE);
                    var14_20 = null;
                    try {
                        checksum = null;
                        try {
                            checksum = CodecUtil.retrieveChecksum((IndexInput)indexInput);
                        }
                        catch (Exception e) {
                            RestoreCore.log.warn("Could not read checksum from index file: " + filename, (Throwable)e);
                        }
                        length = indexInput.length();
                        compareResult = IndexFetcher.compareFile(indexDir, filename, length, checksum);
                        if (!compareResult.equal || !compareResult.checkSummed && (filename.endsWith(".si") || filename.endsWith(".liv") || filename.startsWith("segments_"))) {
                            restoreIndexDir.copyFrom((Directory)backupDir, filename, filename, IOContext.READONCE);
                            continue;
                        }
                        restoreIndexDir.copyFrom(indexDir, filename, filename, IOContext.READONCE);
                    }
                    catch (Throwable var15_23) {
                        var14_20 = var15_23;
                        throw var15_23;
                    }
                    finally {
                        if (indexInput != null) {
                            if (var14_20 != null) {
                                try {
                                    indexInput.close();
                                }
                                catch (Throwable var15_22) {
                                    var14_20.addSuppressed(var15_22);
                                }
                            } else {
                                indexInput.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Exception while restoring the backup index", (Throwable)e);
                }
            }
            RestoreCore.log.debug("Switching directories");
            IndexFetcher.modifyIndexProps(this.core, restoreIndexName);
            try {
                this.core.getUpdateHandler().newIndexWriter(false);
                this.openNewSearcher();
                success = true;
                RestoreCore.log.info("Successfully restored to the backup index");
            }
            catch (Exception e) {
                RestoreCore.log.warn("Could not switch to restored index. Rolling back to the current index");
                dir = null;
                try {
                    dir = this.core.getDirectoryFactory().get(this.core.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.core.getSolrConfig().indexConfig.lockType);
                    dir.deleteFile("index.properties");
                    ** if (dir == null) goto lbl-1000
                }
                catch (Throwable var21_29) {
                    if (dir != null) {
                        this.core.getDirectoryFactory().release(dir);
                    }
                    throw var21_29;
                }
lbl-1000:
                // 1 sources

                {
                    this.core.getDirectoryFactory().release(dir);
                }
lbl-1000:
                // 2 sources

                {
                }
                this.core.getDirectoryFactory().doneWithDirectory(restoreIndexDir);
                this.core.getDirectoryFactory().remove(restoreIndexDir);
                this.core.getUpdateHandler().newIndexWriter(false);
                this.openNewSearcher();
                throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Exception while restoring the backup index", (Throwable)e);
            }
            if (success) {
                this.core.getDirectoryFactory().doneWithDirectory(indexDir);
                this.core.getDirectoryFactory().remove(indexDir);
            }
            var10_12 = 1;
            if (restoreIndexDir == null) break block43;
            this.core.getDirectoryFactory().release(restoreIndexDir);
        }
        if (indexDir != null) {
            this.core.getDirectoryFactory().release(indexDir);
        }
        return (boolean)var10_12;
        {
            catch (Throwable var9_11) {
                var8_8 = var9_11;
                throw var9_11;
            }
            finally {
                if (backupDir != null) {
                    if (var8_8 != null) {
                        try {
                            backupDir.close();
                        }
                        catch (Throwable var11_16) {
                            var8_8.addSuppressed(var11_16);
                        }
                    } else {
                        backupDir.close();
                    }
                }
            }
            {
                catch (Throwable var24_32) {
                    if (restoreIndexDir != null) {
                        this.core.getDirectoryFactory().release(restoreIndexDir);
                    }
                    if (indexDir != null) {
                        this.core.getDirectoryFactory().release(indexDir);
                    }
                    throw var24_32;
                }
            }
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Stopping restore process. Thread was interrupted.");
        }
    }

    private void openNewSearcher() throws Exception {
        Future[] waitSearcher = new Future[1];
        this.core.getSearcher(true, false, waitSearcher, true);
        if (waitSearcher[0] != null) {
            waitSearcher[0].get();
        }
    }
}

