/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.MoreLikeThisParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrQueryTimeoutImpl;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreLikeThisHandler
extends RequestHandlerBase {
    private static final Pattern splitList = Pattern.compile(",| ");
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void init(NamedList args) {
        super.init(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        block43: {
            SolrParams params = req.getParams();
            long timeAllowed = params.getInt("timeAllowed", -1);
            if (timeAllowed > 0L) {
                SolrQueryTimeoutImpl.set(timeAllowed);
            }
            try {
                DocListAndSet mltDocs;
                ArrayList<InterestingTerm> interesting;
                MoreLikeThisParams.TermStyle termStyle;
                MoreLikeThisHelper mlt;
                ArrayList<Query> filters;
                String q;
                block42: {
                    SolrReturnFields returnFields = new SolrReturnFields(req);
                    rsp.setReturnFields(returnFields);
                    int flags = 0;
                    if (((ReturnFields)returnFields).wantsScore()) {
                        flags |= 1;
                    }
                    String defType = params.get("defType", "lucene");
                    q = params.get("q");
                    Query query = null;
                    SortSpec sortSpec = null;
                    filters = null;
                    try {
                        String[] fqs;
                        if (q != null) {
                            QParser parser = QParser.getParser(q, defType, req);
                            query = parser.getQuery();
                            sortSpec = parser.getSort(true);
                        }
                        if ((fqs = req.getParams().getParams("fq")) != null && fqs.length != 0) {
                            filters = new ArrayList<Query>();
                            for (String fq : fqs) {
                                if (fq == null || fq.trim().length() == 0) continue;
                                QParser fqp = QParser.getParser(fq, null, req);
                                filters.add(fqp.getQuery());
                            }
                        }
                    }
                    catch (SyntaxError e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                    SolrIndexSearcher searcher = req.getSearcher();
                    mlt = new MoreLikeThisHelper(params, searcher);
                    termStyle = MoreLikeThisParams.TermStyle.get((String)params.get("mlt.interestingTerms"));
                    interesting = termStyle == MoreLikeThisParams.TermStyle.NONE ? null : new ArrayList<InterestingTerm>(mlt.mlt.getMaxQueryTerms());
                    mltDocs = null;
                    try (Reader reader = null;){
                        Iterable<ContentStream> streams;
                        if ((q == null || q.trim().length() < 1) && (streams = req.getContentStreams()) != null) {
                            Iterator<ContentStream> iter = streams.iterator();
                            if (iter.hasNext()) {
                                reader = iter.next().getReader();
                            }
                            if (iter.hasNext()) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis does not support multiple ContentStreams");
                            }
                        }
                        int start = params.getInt("start", 0);
                        int rows = params.getInt("rows", 10);
                        if (reader != null) {
                            mltDocs = mlt.getMoreLikeThis(reader, start, rows, filters, interesting, flags);
                            break block42;
                        }
                        if (q != null) {
                            DocIterator iterator;
                            boolean includeMatch = params.getBool("mlt.match.include", true);
                            int matchOffset = params.getInt("mlt.match.offset", 0);
                            String[] match = searcher.getDocList(query, null, null, matchOffset, 1, flags);
                            if (includeMatch) {
                                rsp.add("match", match);
                            }
                            if ((iterator = match.iterator()).hasNext()) {
                                int id = iterator.nextDoc();
                                mltDocs = mlt.getMoreLikeThis(id, start, rows, filters, interesting, flags);
                            }
                            break block42;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires either a query (?q=) or text to find similar documents.");
                    }
                }
                if (mltDocs == null) {
                    mltDocs = new DocListAndSet();
                }
                rsp.addResponse(mltDocs.docList);
                if (interesting != null) {
                    if (termStyle == MoreLikeThisParams.TermStyle.DETAILS) {
                        NamedList it = new NamedList();
                        for (InterestingTerm t : interesting) {
                            it.add(t.term.toString(), (Object)Float.valueOf(t.boost));
                        }
                        rsp.add("interestingTerms", it);
                    } else {
                        ArrayList<String> it = new ArrayList<String>(interesting.size());
                        for (InterestingTerm t : interesting) {
                            it.add(t.term.text());
                        }
                        rsp.add("interestingTerms", it);
                    }
                }
                if (params.getBool("facet", false)) {
                    if (mltDocs.docSet == null) {
                        rsp.add("facet_counts", null);
                    } else {
                        SimpleFacets f = new SimpleFacets(req, mltDocs.docSet, params);
                        rsp.add("facet_counts", FacetComponent.getFacetCounts(f));
                    }
                }
                boolean dbg = req.getParams().getBool("debugQuery", false);
                boolean dbgQuery = false;
                boolean dbgResults = false;
                if (!dbg) {
                    String[] dbgParams = req.getParams().getParams("debug");
                    if (dbgParams != null) {
                        for (String dbgParam : dbgParams) {
                            if (dbgParam.equals("query")) {
                                dbgQuery = true;
                                continue;
                            }
                            if (!dbgParam.equals("results")) continue;
                            dbgResults = true;
                        }
                    }
                } else {
                    dbgQuery = true;
                    dbgResults = true;
                }
                if (!dbg) break block43;
                try {
                    NamedList dbgInfo = SolrPluginUtils.doStandardDebug(req, q, mlt.getRawMLTQuery(), mltDocs.docList, dbgQuery, dbgResults);
                    if (null != dbgInfo) {
                        if (null != filters) {
                            dbgInfo.add("filter_queries", (Object)req.getParams().getParams("fq"));
                            ArrayList<String> fqs = new ArrayList<String>(filters.size());
                            for (Query fq : filters) {
                                fqs.add(QueryParsing.toString(fq, req.getSchema()));
                            }
                            dbgInfo.add("parsed_filter_queries", fqs);
                        }
                        rsp.add("debug", dbgInfo);
                    }
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"Exception during debug", (Throwable)e);
                    rsp.add("exception_during_debug", SolrException.toStr((Throwable)e));
                }
            }
            catch (ExitableDirectoryReader.ExitingReaderException ex) {
                log.warn("Query: " + req.getParamString() + "; " + ex.getMessage());
            }
            finally {
                SolrQueryTimeoutImpl.reset();
            }
        }
    }

    @Override
    public String getDescription() {
        return "Solr MoreLikeThis";
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/MoreLikeThis")};
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static class MoreLikeThisHelper {
        final SolrIndexSearcher searcher;
        final MoreLikeThis mlt;
        final IndexReader reader;
        final SchemaField uniqueKeyField;
        final boolean needDocSet;
        Map<String, Float> boostFields;
        private Query rawMLTQuery;
        private Query boostedMLTQuery;
        private BooleanQuery realMLTQuery;

        public MoreLikeThisHelper(SolrParams params, SolrIndexSearcher searcher) {
            this.searcher = searcher;
            this.reader = searcher.getIndexReader();
            this.uniqueKeyField = searcher.getSchema().getUniqueKeyField();
            this.needDocSet = params.getBool("facet", false);
            RequiredSolrParams required = params.required();
            String[] fl = required.getParams("mlt.fl");
            ArrayList<String> list = new ArrayList<String>();
            for (String f : fl) {
                String[] strings;
                if (StringUtils.isEmpty((String)f)) continue;
                for (String string : strings = splitList.split(f)) {
                    if (StringUtils.isEmpty((String)string)) continue;
                    list.add(string);
                }
            }
            String[] fields = list.toArray(new String[list.size()]);
            if (fields.length < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: mlt.fl");
            }
            this.mlt = new MoreLikeThis(this.reader);
            this.mlt.setFieldNames(fields);
            this.mlt.setAnalyzer(searcher.getSchema().getIndexAnalyzer());
            this.mlt.setMinTermFreq(params.getInt("mlt.mintf", 2));
            this.mlt.setMinDocFreq(params.getInt("mlt.mindf", 5));
            this.mlt.setMaxDocFreq(params.getInt("mlt.maxdf", Integer.MAX_VALUE));
            this.mlt.setMinWordLen(params.getInt("mlt.minwl", 0));
            this.mlt.setMaxWordLen(params.getInt("mlt.maxwl", 0));
            this.mlt.setMaxQueryTerms(params.getInt("mlt.maxqt", 25));
            this.mlt.setMaxNumTokensParsed(params.getInt("mlt.maxntp", 5000));
            this.mlt.setBoost(params.getBool("mlt.boost", false));
            this.boostFields = SolrPluginUtils.parseFieldBoosts(params.getParams("mlt.qf"));
        }

        public Query getRawMLTQuery() {
            return this.rawMLTQuery;
        }

        public Query getBoostedMLTQuery() {
            return this.boostedMLTQuery;
        }

        public Query getRealMLTQuery() {
            return this.realMLTQuery;
        }

        private Query getBoostedQuery(Query mltquery) {
            BooleanQuery boostedQuery = (BooleanQuery)mltquery;
            if (this.boostFields.size() > 0) {
                BooleanQuery.Builder newQ = new BooleanQuery.Builder();
                newQ.setDisableCoord(boostedQuery.isCoordDisabled());
                newQ.setMinimumNumberShouldMatch(boostedQuery.getMinimumNumberShouldMatch());
                for (BooleanClause clause : boostedQuery) {
                    Float fieldBoost;
                    Query q = clause.getQuery();
                    float originalBoost = 1.0f;
                    if (q instanceof BoostQuery) {
                        BoostQuery bq = (BoostQuery)q;
                        q = bq.getQuery();
                        originalBoost = bq.getBoost();
                    }
                    q = (fieldBoost = this.boostFields.get(((TermQuery)q).getTerm().field())) != null ? new BoostQuery(q, fieldBoost.floatValue() * originalBoost) : clause.getQuery();
                    newQ.add(q, clause.getOccur());
                }
                boostedQuery = newQ.build();
            }
            return boostedQuery;
        }

        public DocListAndSet getMoreLikeThis(int id, int start, int rows, List<Query> filters, List<InterestingTerm> terms, int flags) throws IOException {
            Document doc = this.reader.document(id);
            this.rawMLTQuery = this.mlt.like(id);
            this.boostedMLTQuery = this.getBoostedQuery(this.rawMLTQuery);
            if (terms != null) {
                this.fillInterestingTermsFromMLTQuery(this.rawMLTQuery, terms);
            }
            BooleanQuery.Builder realMLTQuery = new BooleanQuery.Builder();
            realMLTQuery.add(this.boostedMLTQuery, BooleanClause.Occur.MUST);
            realMLTQuery.add((Query)new TermQuery(new Term(this.uniqueKeyField.getName(), this.uniqueKeyField.getType().storedToIndexed(doc.getField(this.uniqueKeyField.getName())))), BooleanClause.Occur.MUST_NOT);
            this.realMLTQuery = realMLTQuery.build();
            DocListAndSet results = new DocListAndSet();
            if (this.needDocSet) {
                results = this.searcher.getDocListAndSet((Query)this.realMLTQuery, filters, null, start, rows, flags);
            } else {
                results.docList = this.searcher.getDocList((Query)this.realMLTQuery, filters, null, start, rows, flags);
            }
            return results;
        }

        public DocListAndSet getMoreLikeThis(Reader reader, int start, int rows, List<Query> filters, List<InterestingTerm> terms, int flags) throws IOException {
            this.rawMLTQuery = this.mlt.like(this.mlt.getFieldNames()[0], new Reader[]{reader});
            this.boostedMLTQuery = this.getBoostedQuery(this.rawMLTQuery);
            if (terms != null) {
                this.fillInterestingTermsFromMLTQuery(this.boostedMLTQuery, terms);
            }
            DocListAndSet results = new DocListAndSet();
            if (this.needDocSet) {
                results = this.searcher.getDocListAndSet(this.boostedMLTQuery, filters, null, start, rows, flags);
            } else {
                results.docList = this.searcher.getDocList(this.boostedMLTQuery, filters, null, start, rows, flags);
            }
            return results;
        }

        public NamedList<BooleanQuery> getMoreLikeTheseQuery(DocList docs) throws IOException {
            IndexSchema schema = this.searcher.getSchema();
            NamedList result = new NamedList();
            DocIterator iterator = docs.iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextDoc();
                String uniqueId = schema.printableUniqueKey(this.reader.document(id));
                BooleanQuery mltquery = (BooleanQuery)this.mlt.like(id);
                if (mltquery.clauses().size() == 0) {
                    return result;
                }
                mltquery = (BooleanQuery)this.getBoostedQuery((Query)mltquery);
                BooleanQuery.Builder mltQuery = new BooleanQuery.Builder();
                mltQuery.add((Query)mltquery, BooleanClause.Occur.MUST);
                mltQuery.add((Query)new TermQuery(new Term(this.uniqueKeyField.getName(), uniqueId)), BooleanClause.Occur.MUST_NOT);
                result.add(uniqueId, (Object)mltQuery.build());
            }
            return result;
        }

        private void fillInterestingTermsFromMLTQuery(Query query, List<InterestingTerm> terms) {
            List clauses = ((BooleanQuery)query).clauses();
            for (BooleanClause o : clauses) {
                Query q = o.getQuery();
                float boost = 1.0f;
                if (q instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)q;
                    q = bq.getQuery();
                    boost = bq.getBoost();
                }
                InterestingTerm it = new InterestingTerm();
                it.boost = boost;
                it.term = ((TermQuery)q).getTerm();
                terms.add(it);
            }
        }

        public MoreLikeThis getMoreLikeThis() {
            return this.mlt;
        }
    }

    public static class InterestingTerm {
        public Term term;
        public float boost;
        public static Comparator<InterestingTerm> BOOST_ORDER = new Comparator<InterestingTerm>(){

            @Override
            public int compare(InterestingTerm t1, InterestingTerm t2) {
                float d = t1.boost - t2.boost;
                if (d == 0.0f) {
                    return 0;
                }
                return d > 0.0f ? 1 : -1;
            }
        };
    }
}

