/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.request.DocumentAnalysisRequest;
import org.apache.solr.common.EmptyEntityResolver;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.handler.AnalysisRequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentAnalysisRequestHandler
extends AnalysisRequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    private static final float DEFAULT_BOOST = 1.0f;
    private XMLInputFactory inputFactory;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = XMLInputFactory.newInstance();
        EmptyEntityResolver.configureXMLInputFactory((XMLInputFactory)this.inputFactory);
        this.inputFactory.setXMLReporter((XMLReporter)xmllog);
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input factory: " + this.inputFactory);
        }
    }

    @Override
    protected NamedList doAnalysis(SolrQueryRequest req) throws Exception {
        DocumentAnalysisRequest analysisRequest = this.resolveAnalysisRequest(req);
        return this.handleAnalysisRequest(analysisRequest, req.getSchema());
    }

    @Override
    public String getDescription() {
        return "Provides a breakdown of the analysis process of provided documents";
    }

    DocumentAnalysisRequest resolveAnalysisRequest(SolrQueryRequest req) throws IOException, XMLStreamException {
        DocumentAnalysisRequest request = new DocumentAnalysisRequest();
        SolrParams params = req.getParams();
        String query = params.get("analysis.query", params.get("q", null));
        request.setQuery(query);
        boolean showMatch = params.getBool("analysis.showmatch", false);
        request.setShowMatch(showMatch);
        ContentStream stream = this.extractSingleContentStream(req);
        InputStream is = null;
        XMLStreamReader parser = null;
        try {
            is = stream.getStream();
            String charset = ContentStreamBase.getCharsetFromContentType((String)stream.getContentType());
            parser = charset == null ? this.inputFactory.createXMLStreamReader(is) : this.inputFactory.createXMLStreamReader(is, charset);
            while (true) {
                int event = parser.next();
                switch (event) {
                    case 8: {
                        parser.close();
                        DocumentAnalysisRequest documentAnalysisRequest = request;
                        return documentAnalysisRequest;
                    }
                    case 1: {
                        String currTag = parser.getLocalName();
                        if (!"doc".equals(currTag)) break;
                        log.trace("Reading doc...");
                        SolrInputDocument document = this.readDocument(parser, req.getSchema());
                        request.addDocument(document);
                        break;
                    }
                }
            }
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    NamedList<Object> handleAnalysisRequest(DocumentAnalysisRequest request, IndexSchema schema) {
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        SimpleOrderedMap result = new SimpleOrderedMap();
        for (SolrInputDocument document : request.getDocuments()) {
            SimpleOrderedMap theTokens = new SimpleOrderedMap();
            result.add(document.getFieldValue(uniqueKeyField.getName()).toString(), (Object)theTokens);
            for (String name : document.getFieldNames()) {
                Set<BytesRef> termsToMatch;
                SchemaField field = schema.getField(name);
                if (!field.indexed()) continue;
                SimpleOrderedMap fieldTokens = new SimpleOrderedMap();
                theTokens.add(name, (Object)fieldTokens);
                FieldType fieldType = schema.getFieldType(name);
                String queryValue = request.getQuery();
                try {
                    termsToMatch = queryValue != null && request.isShowMatch() ? this.getQueryTokenSet(queryValue, fieldType.getQueryAnalyzer()) : EMPTY_BYTES_SET;
                }
                catch (Exception e) {
                    termsToMatch = EMPTY_BYTES_SET;
                }
                if (request.getQuery() != null) {
                    try {
                        AnalysisRequestHandlerBase.AnalysisContext analysisContext = new AnalysisRequestHandlerBase.AnalysisContext(fieldType, fieldType.getQueryAnalyzer(), EMPTY_BYTES_SET);
                        fieldTokens.add("query", this.analyzeValue(request.getQuery(), analysisContext));
                    }
                    catch (Exception analysisContext) {
                        // empty catch block
                    }
                }
                Analyzer analyzer = fieldType.getIndexAnalyzer();
                AnalysisRequestHandlerBase.AnalysisContext analysisContext = new AnalysisRequestHandlerBase.AnalysisContext(fieldType, analyzer, termsToMatch);
                Collection fieldValues = document.getFieldValues(name);
                SimpleOrderedMap indexTokens = new SimpleOrderedMap();
                for (Object fieldValue : fieldValues) {
                    indexTokens.add(String.valueOf(fieldValue), this.analyzeValue(fieldValue.toString(), analysisContext));
                }
                fieldTokens.add("index", (Object)indexTokens);
            }
        }
        return result;
    }

    SolrInputDocument readDocument(XMLStreamReader reader, IndexSchema schema) throws XMLStreamException {
        SolrInputDocument doc = new SolrInputDocument();
        String uniqueKeyField = schema.getUniqueKeyField().getName();
        StringBuilder text = new StringBuilder();
        String fieldName = null;
        boolean hasId = false;
        block5: while (true) {
            int event = reader.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(reader.getText());
                    break;
                }
                case 2: {
                    if ("doc".equals(reader.getLocalName())) {
                        if (!hasId) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "All documents must contain a unique key value: '" + doc.toString() + "'");
                        }
                        return doc;
                    }
                    if (!"field".equals(reader.getLocalName())) break;
                    doc.addField(fieldName, (Object)text.toString(), 1.0f);
                    if (!uniqueKeyField.equals(fieldName)) break;
                    hasId = true;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = reader.getLocalName();
                    if (!"field".equals(localName)) {
                        log.warn("unexpected XML tag doc/" + localName);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag doc/" + localName);
                    }
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String attrName = reader.getAttributeLocalName(i);
                        if (!"name".equals(attrName)) continue;
                        fieldName = reader.getAttributeValue(i);
                    }
                    continue block5;
                }
            }
        }
    }

    private ContentStream extractSingleContentStream(SolrQueryRequest req) {
        Iterable<ContentStream> streams = req.getContentStreams();
        String exceptionMsg = "DocumentAnalysisRequestHandler expects a single content stream with documents to analyze";
        if (streams == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, exceptionMsg);
        }
        Iterator<ContentStream> iter = streams.iterator();
        if (!iter.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, exceptionMsg);
        }
        ContentStream stream = iter.next();
        if (iter.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, exceptionMsg);
        }
        return stream;
    }
}

