/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CdcrBufferManager;
import org.apache.solr.handler.CdcrBufferStateManager;
import org.apache.solr.handler.CdcrLeaderStateManager;
import org.apache.solr.handler.CdcrParams;
import org.apache.solr.handler.CdcrProcessStateManager;
import org.apache.solr.handler.CdcrReplicatorManager;
import org.apache.solr.handler.CdcrReplicatorState;
import org.apache.solr.handler.CdcrUpdateLogSynchronizer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.CdcrUpdateLog;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcrRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrCore core;
    private String collection;
    private String path;
    private SolrParams updateLogSynchronizerConfiguration;
    private SolrParams replicatorConfiguration;
    private SolrParams bufferConfiguration;
    private Map<String, List<SolrParams>> replicasConfiguration;
    private CdcrProcessStateManager processStateManager;
    private CdcrBufferStateManager bufferStateManager;
    private CdcrReplicatorManager replicatorManager;
    private CdcrLeaderStateManager leaderStateManager;
    private CdcrUpdateLogSynchronizer updateLogSynchronizer;
    private CdcrBufferManager bufferManager;

    @Override
    public void init(NamedList args) {
        super.init(args);
        if (args != null) {
            Object bufferParam;
            Object replicatorParam;
            Object updateLogSynchonizerParam = args.get("updateLogSynchronizer");
            if (updateLogSynchonizerParam != null && updateLogSynchonizerParam instanceof NamedList) {
                this.updateLogSynchronizerConfiguration = SolrParams.toSolrParams((NamedList)((NamedList)updateLogSynchonizerParam));
            }
            if ((replicatorParam = args.get("replicator")) != null && replicatorParam instanceof NamedList) {
                this.replicatorConfiguration = SolrParams.toSolrParams((NamedList)((NamedList)replicatorParam));
            }
            if ((bufferParam = args.get("buffer")) != null && bufferParam instanceof NamedList) {
                this.bufferConfiguration = SolrParams.toSolrParams((NamedList)((NamedList)bufferParam));
            }
            this.replicasConfiguration = new HashMap<String, List<SolrParams>>();
            List replicas = args.getAll("replica");
            for (Object replica : replicas) {
                if (replica == null || !(replica instanceof NamedList)) continue;
                SolrParams params = SolrParams.toSolrParams((NamedList)((NamedList)replica));
                if (!this.replicasConfiguration.containsKey(params.get("source"))) {
                    this.replicasConfiguration.put(params.get("source"), new ArrayList());
                }
                this.replicasConfiguration.get(params.get("source")).add(params);
            }
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        CdcrParams.CdcrAction action = null;
        String a = params.get("action");
        if (a != null) {
            action = CdcrParams.CdcrAction.get(a);
        }
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
        }
        switch (action) {
            case START: {
                this.handleStartAction(req, rsp);
                break;
            }
            case STOP: {
                this.handleStopAction(req, rsp);
                break;
            }
            case STATUS: {
                this.handleStatusAction(req, rsp);
                break;
            }
            case COLLECTIONCHECKPOINT: {
                this.handleCollectionCheckpointAction(req, rsp);
                break;
            }
            case SHARDCHECKPOINT: {
                this.handleShardCheckpointAction(req, rsp);
                break;
            }
            case ENABLEBUFFER: {
                this.handleEnableBufferAction(req, rsp);
                break;
            }
            case DISABLEBUFFER: {
                this.handleDisableBufferAction(req, rsp);
                break;
            }
            case LASTPROCESSEDVERSION: {
                this.handleLastProcessedVersionAction(req, rsp);
                break;
            }
            case QUEUES: {
                this.handleQueuesAction(req, rsp);
                break;
            }
            case OPS: {
                this.handleOpsAction(req, rsp);
                break;
            }
            case ERRORS: {
                this.handleErrorsAction(req, rsp);
                break;
            }
            default: {
                throw new RuntimeException("Unknown action: " + (Object)((Object)action));
            }
        }
        rsp.setHttpCaching(false);
    }

    @Override
    public void inform(SolrCore core) {
        this.core = core;
        this.collection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        if (!core.getCoreDescriptor().getCoreContainer().isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Solr instance is not running in SolrCloud mode.");
        }
        if (!(core.getUpdateHandler().getUpdateLog() instanceof CdcrUpdateLog)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Solr instance is not configured with the cdcr update log.");
        }
        this.path = null;
        for (Map.Entry<String, PluginBag.PluginHolder<SolrRequestHandler>> entry : core.getRequestHandlers().getRegistry().entrySet()) {
            if (!core.getRequestHandlers().isLoaded(entry.getKey()) || entry.getValue().get() != this) continue;
            this.path = entry.getKey();
            break;
        }
        if (this.path == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The CdcrRequestHandler is not registered with the current core.");
        }
        if (!this.path.startsWith("/")) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The CdcrRequestHandler needs to be registered to a path. Typically this is '/cdcr'");
        }
        this.bufferStateManager = new CdcrBufferStateManager(core, this.bufferConfiguration);
        this.processStateManager = new CdcrProcessStateManager(core);
        this.leaderStateManager = new CdcrLeaderStateManager(core);
        this.replicatorManager = new CdcrReplicatorManager(core, this.path, this.replicatorConfiguration, this.replicasConfiguration);
        this.replicatorManager.setProcessStateManager(this.processStateManager);
        this.replicatorManager.setLeaderStateManager(this.leaderStateManager);
        this.replicatorManager.stateUpdate();
        this.updateLogSynchronizer = new CdcrUpdateLogSynchronizer(core, this.path, this.updateLogSynchronizerConfiguration);
        this.updateLogSynchronizer.setLeaderStateManager(this.leaderStateManager);
        this.updateLogSynchronizer.stateUpdate();
        this.bufferManager = new CdcrBufferManager(core);
        this.bufferManager.setLeaderStateManager(this.leaderStateManager);
        this.bufferManager.setBufferStateManager(this.bufferStateManager);
        this.bufferManager.stateUpdate();
        this.registerCloseHook(core);
    }

    private void registerCloseHook(SolrCore core) {
        core.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
                String collectionName = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
                String shard = core.getCoreDescriptor().getCloudDescriptor().getShardId();
                log.info("Solr core is being closed - shutting down CDCR handler @ {}:{}", (Object)collectionName, (Object)shard);
                CdcrRequestHandler.this.updateLogSynchronizer.shutdown();
                CdcrRequestHandler.this.replicatorManager.shutdown();
                CdcrRequestHandler.this.bufferStateManager.shutdown();
                CdcrRequestHandler.this.processStateManager.shutdown();
                CdcrRequestHandler.this.leaderStateManager.shutdown();
            }

            @Override
            public void postClose(SolrCore core) {
            }
        });
    }

    private void handleStartAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.processStateManager.getState() == CdcrParams.ProcessState.STOPPED) {
            this.processStateManager.setState(CdcrParams.ProcessState.STARTED);
            this.processStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleStopAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.processStateManager.getState() == CdcrParams.ProcessState.STARTED) {
            this.processStateManager.setState(CdcrParams.ProcessState.STOPPED);
            this.processStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleStatusAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private NamedList getStatus() {
        NamedList status = new NamedList();
        status.add(CdcrParams.ProcessState.getParam(), (Object)this.processStateManager.getState().toLower());
        status.add(CdcrParams.BufferState.getParam(), (Object)this.bufferStateManager.getState().toLower());
        return status;
    }

    private void handleCollectionCheckpointAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        ZkController zkController = this.core.getCoreDescriptor().getCoreContainer().getZkController();
        try {
            zkController.getZkStateReader().updateClusterState();
        }
        catch (Exception e) {
            log.warn("Error when updating cluster state", (Throwable)e);
        }
        ClusterState cstate = zkController.getClusterState();
        Collection shards = cstate.getActiveSlices(this.collection);
        ExecutorService parallelExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new DefaultSolrThreadFactory("parallelCdcrExecutor"));
        long checkpoint = Long.MAX_VALUE;
        try {
            ArrayList<SliceCheckpointCallable> callables = new ArrayList<SliceCheckpointCallable>();
            for (Slice slice : shards) {
                Replica leaderProps = zkController.getZkStateReader().getLeaderRetry(this.collection, slice.getName());
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
                callables.add(new SliceCheckpointCallable(nodeProps.getCoreUrl(), this.path));
            }
            for (Future future : parallelExecutor.invokeAll(callables)) {
                long version = (Long)future.get();
                if (version >= checkpoint) continue;
                checkpoint = version;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while requesting shard's checkpoints", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while requesting shard's checkpoints", (Throwable)e);
        }
        finally {
            parallelExecutor.shutdown();
        }
        rsp.add("checkpoint", checkpoint);
    }

    private void handleShardCheckpointAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (!this.leaderStateManager.amILeader()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Action '" + (Object)((Object)CdcrParams.CdcrAction.SHARDCHECKPOINT) + "' sent to non-leader replica");
        }
        UpdateLog ulog = this.core.getUpdateHandler().getUpdateLog();
        try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
            List<Long> versions = recentUpdates.getVersions(1);
            long lastVersion = versions.isEmpty() ? -1L : Math.abs(versions.get(0));
            rsp.add("checkpoint", lastVersion);
        }
    }

    private void handleEnableBufferAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.bufferStateManager.getState() == CdcrParams.BufferState.DISABLED) {
            this.bufferStateManager.setState(CdcrParams.BufferState.ENABLED);
            this.bufferStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleDisableBufferAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.bufferStateManager.getState() == CdcrParams.BufferState.ENABLED) {
            this.bufferStateManager.setState(CdcrParams.BufferState.DISABLED);
            this.bufferStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleLastProcessedVersionAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        String collectionName = this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        String shard = this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
        if (!this.leaderStateManager.amILeader()) {
            log.warn("Action {} sent to non-leader replica @ {}:{}", new Object[]{CdcrParams.CdcrAction.LASTPROCESSEDVERSION, collectionName, shard});
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Action " + (Object)((Object)CdcrParams.CdcrAction.LASTPROCESSEDVERSION) + " sent to non-leader replica");
        }
        long lastProcessedVersion = Long.MAX_VALUE;
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            long version = Long.MAX_VALUE;
            if (state.getLogReader() != null) {
                version = state.getLogReader().getLastVersion();
            }
            lastProcessedVersion = Math.min(lastProcessedVersion, version);
        }
        CdcrUpdateLog.CdcrLogReader bufferLogReader = ((CdcrUpdateLog)this.core.getUpdateHandler().getUpdateLog()).getBufferToggle();
        if (bufferLogReader != null) {
            lastProcessedVersion = Math.min(lastProcessedVersion, bufferLogReader.getLastVersion());
        }
        if (this.processStateManager.getState().equals((Object)CdcrParams.ProcessState.STOPPED) && this.bufferStateManager.getState().equals((Object)CdcrParams.BufferState.DISABLED)) {
            try (CdcrUpdateLog.CdcrLogReader logReader = ((CdcrUpdateLog)this.core.getUpdateHandler().getUpdateLog()).newLogReader();){
                logReader.next();
                lastProcessedVersion = Math.min(lastProcessedVersion, logReader.getLastVersion());
            }
        }
        log.debug("Returning the lowest last processed version {}  @ {}:{}", new Object[]{lastProcessedVersion, collectionName, shard});
        rsp.add("lastProcessedVersion", lastProcessedVersion);
    }

    private void handleQueuesAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        NamedList hosts = new NamedList();
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            NamedList queueStats = new NamedList();
            CdcrUpdateLog.CdcrLogReader logReader = state.getLogReader();
            if (logReader == null) {
                String collectionName = req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
                String shard = req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                log.warn("The log reader for target collection {} is not initialised @ {}:{}", new Object[]{state.getTargetCollection(), collectionName, shard});
                queueStats.add("queueSize", (Object)-1L);
            } else {
                queueStats.add("queueSize", (Object)logReader.getNumberOfRemainingRecords());
            }
            queueStats.add("lastTimestamp", (Object)state.getTimestampOfLastProcessedOperation());
            if (hosts.get(state.getZkHost()) == null) {
                hosts.add(state.getZkHost(), (Object)new NamedList());
            }
            ((NamedList)hosts.get(state.getZkHost())).add(state.getTargetCollection(), (Object)queueStats);
        }
        rsp.add("queues", hosts);
        UpdateLog updateLog = this.core.getUpdateHandler().getUpdateLog();
        rsp.add("tlogTotalSize", updateLog.getTotalLogsSize());
        rsp.add("tlogTotalCount", updateLog.getTotalLogsNumber());
        rsp.add("updateLogSynchronizer", this.updateLogSynchronizer.isStarted() ? CdcrParams.ProcessState.STARTED.toLower() : CdcrParams.ProcessState.STOPPED.toLower());
    }

    private void handleOpsAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        NamedList hosts = new NamedList();
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            NamedList ops = new NamedList();
            ops.add("all", (Object)state.getBenchmarkTimer().getOperationsPerSecond());
            ops.add("adds", (Object)state.getBenchmarkTimer().getAddsPerSecond());
            ops.add("deletes", (Object)state.getBenchmarkTimer().getDeletesPerSecond());
            if (hosts.get(state.getZkHost()) == null) {
                hosts.add(state.getZkHost(), (Object)new NamedList());
            }
            ((NamedList)hosts.get(state.getZkHost())).add(state.getTargetCollection(), (Object)ops);
        }
        rsp.add("operationsPerSecond", hosts);
    }

    private void handleErrorsAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        NamedList hosts = new NamedList();
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            NamedList errors = new NamedList();
            errors.add("consecutiveErrors", (Object)state.getConsecutiveErrors());
            errors.add(CdcrReplicatorState.ErrorType.BAD_REQUEST.toLower(), (Object)state.getErrorCount(CdcrReplicatorState.ErrorType.BAD_REQUEST));
            errors.add(CdcrReplicatorState.ErrorType.INTERNAL.toLower(), (Object)state.getErrorCount(CdcrReplicatorState.ErrorType.INTERNAL));
            NamedList lastErrors = new NamedList();
            for (String[] lastError : state.getLastErrors()) {
                lastErrors.add(lastError[0], (Object)lastError[1]);
            }
            errors.add("last", (Object)lastErrors);
            if (hosts.get(state.getZkHost()) == null) {
                hosts.add(state.getZkHost(), (Object)new NamedList());
            }
            ((NamedList)hosts.get(state.getZkHost())).add(state.getTargetCollection(), (Object)errors);
        }
        rsp.add("errors", hosts);
    }

    @Override
    public String getDescription() {
        return "Manage Cross Data Center Replication";
    }

    private static final class SliceCheckpointCallable
    implements Callable<Long> {
        final String baseUrl;
        final String cdcrPath;

        SliceCheckpointCallable(String baseUrl, String cdcrPath) {
            this.baseUrl = baseUrl;
            this.cdcrPath = cdcrPath;
        }

        @Override
        public Long call() throws Exception {
            try (HttpSolrClient server = new HttpSolrClient(this.baseUrl);){
                server.setConnectionTimeout(15000);
                server.setSoTimeout(60000);
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CdcrParams.CdcrAction.SHARDCHECKPOINT.toString()});
                QueryRequest request = new QueryRequest((SolrParams)params);
                request.setPath(this.cdcrPath);
                NamedList response = server.request((SolrRequest)request);
                Long l = (Long)response.get("checkpoint");
                return l;
            }
        }
    }
}

