/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.handler.CdcrReplicator;
import org.apache.solr.handler.CdcrReplicatorManager;
import org.apache.solr.handler.CdcrReplicatorState;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdcrReplicatorScheduler {
    private boolean isStarted = false;
    private ScheduledExecutorService scheduler;
    private ExecutorService replicatorsPool;
    private final CdcrReplicatorManager replicatorManager;
    private final ConcurrentLinkedQueue<CdcrReplicatorState> statesQueue;
    private int poolSize = 2;
    private int timeSchedule = 10;
    private int batchSize = 128;
    private static final int DEFAULT_POOL_SIZE = 2;
    private static final int DEFAULT_TIME_SCHEDULE = 10;
    private static final int DEFAULT_BATCH_SIZE = 128;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    CdcrReplicatorScheduler(CdcrReplicatorManager replicatorStatesManager, SolrParams replicatorConfiguration) {
        this.replicatorManager = replicatorStatesManager;
        this.statesQueue = new ConcurrentLinkedQueue<CdcrReplicatorState>(this.replicatorManager.getReplicatorStates());
        if (replicatorConfiguration != null) {
            this.poolSize = replicatorConfiguration.getInt("threadPoolSize", 2);
            this.timeSchedule = replicatorConfiguration.getInt("schedule", 10);
            this.batchSize = replicatorConfiguration.getInt("batchSize", 128);
        }
    }

    void start() {
        if (!this.isStarted) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new DefaultSolrThreadFactory("cdcr-scheduler"));
            this.replicatorsPool = ExecutorUtil.newMDCAwareFixedThreadPool((int)this.poolSize, (ThreadFactory)new DefaultSolrThreadFactory("cdcr-replicator"));
            this.scheduler.scheduleWithFixedDelay(() -> {
                int nCandidates = this.statesQueue.size();
                for (int i = 0; i < nCandidates; ++i) {
                    this.replicatorsPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            CdcrReplicatorState state = (CdcrReplicatorState)CdcrReplicatorScheduler.this.statesQueue.poll();
                            assert (state != null);
                            try {
                                new CdcrReplicator(state, CdcrReplicatorScheduler.this.batchSize).run();
                            }
                            finally {
                                CdcrReplicatorScheduler.this.statesQueue.offer(state);
                            }
                        }
                    });
                }
            }, 0L, this.timeSchedule, TimeUnit.MILLISECONDS);
            this.isStarted = true;
        }
    }

    void shutdown() {
        if (this.isStarted) {
            this.replicatorsPool.shutdown();
            try {
                this.replicatorsPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Thread interrupted while waiting for CDCR replicator threadpool close.");
                Thread.currentThread().interrupt();
            }
            finally {
                this.scheduler.shutdownNow();
                this.isStarted = false;
            }
        }
    }
}

