/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CdcrLeaderStateManager;
import org.apache.solr.handler.CdcrParams;
import org.apache.solr.handler.CdcrProcessStateManager;
import org.apache.solr.handler.CdcrReplicatorScheduler;
import org.apache.solr.handler.CdcrReplicatorState;
import org.apache.solr.handler.CdcrStateManager;
import org.apache.solr.update.CdcrUpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdcrReplicatorManager
implements CdcrStateManager.CdcrStateObserver {
    private List<CdcrReplicatorState> replicatorStates;
    private final CdcrReplicatorScheduler scheduler;
    private CdcrProcessStateManager processStateManager;
    private CdcrLeaderStateManager leaderStateManager;
    private SolrCore core;
    private String path;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    CdcrReplicatorManager(SolrCore core, String path, SolrParams replicatorConfiguration, Map<String, List<SolrParams>> replicasConfiguration) {
        this.core = core;
        this.path = path;
        this.replicatorStates = new ArrayList<CdcrReplicatorState>();
        String myCollection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        List<SolrParams> targets = replicasConfiguration.get(myCollection);
        if (targets != null) {
            for (SolrParams params : targets) {
                String zkHost = params.get("zkHost");
                String targetCollection = params.get("target");
                CloudSolrClient client = new CloudSolrClient(zkHost, true);
                client.setDefaultCollection(targetCollection);
                this.replicatorStates.add(new CdcrReplicatorState(targetCollection, zkHost, client));
            }
        }
        this.scheduler = new CdcrReplicatorScheduler(this, replicatorConfiguration);
    }

    void setProcessStateManager(CdcrProcessStateManager processStateManager) {
        this.processStateManager = processStateManager;
        this.processStateManager.register(this);
    }

    void setLeaderStateManager(CdcrLeaderStateManager leaderStateManager) {
        this.leaderStateManager = leaderStateManager;
        this.leaderStateManager.register(this);
    }

    @Override
    public synchronized void stateUpdate() {
        if (this.leaderStateManager.amILeader() && this.processStateManager.getState().equals((Object)CdcrParams.ProcessState.STARTED)) {
            this.initLogReaders();
            this.scheduler.start();
            return;
        }
        this.scheduler.shutdown();
        this.closeLogReaders();
    }

    List<CdcrReplicatorState> getReplicatorStates() {
        return this.replicatorStates;
    }

    void initLogReaders() {
        String collectionName = this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        String shard = this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
        CdcrUpdateLog ulog = (CdcrUpdateLog)this.core.getUpdateHandler().getUpdateLog();
        for (CdcrReplicatorState state : this.replicatorStates) {
            state.closeLogReader();
            try {
                long checkpoint = this.getCheckpoint(state);
                log.info("Create new update log reader for target {} with checkpoint {} @ {}:{}", new Object[]{state.getTargetCollection(), checkpoint, collectionName, shard});
                CdcrUpdateLog.CdcrLogReader reader = ulog.newLogReader();
                reader.seek(checkpoint);
                state.init(reader);
            }
            catch (IOException | SolrServerException | SolrException e) {
                log.warn("Unable to instantiate the log reader for target collection " + state.getTargetCollection(), e);
            }
            catch (InterruptedException e) {
                log.warn("Thread interrupted while instantiate the log reader for target collection " + state.getTargetCollection(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private long getCheckpoint(CdcrReplicatorState state) throws IOException, SolrServerException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CdcrParams.CdcrAction.COLLECTIONCHECKPOINT.toString()});
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath(this.path);
        NamedList response = state.getClient().request((SolrRequest)request);
        return (Long)response.get("checkpoint");
    }

    void closeLogReaders() {
        for (CdcrReplicatorState state : this.replicatorStates) {
            state.closeLogReader();
        }
    }

    void shutdown() {
        this.scheduler.shutdown();
        for (CdcrReplicatorState state : this.replicatorStates) {
            state.shutdown();
        }
        this.replicatorStates.clear();
    }
}

