/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.handler.CdcrReplicatorState;
import org.apache.solr.update.CdcrUpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcrReplicator
implements Runnable {
    private final CdcrReplicatorState state;
    private final int batchSize;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public CdcrReplicator(CdcrReplicatorState state, int batchSize) {
        this.state = state;
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CdcrUpdateLog.CdcrLogReader logReader = this.state.getLogReader();
        CdcrUpdateLog.CdcrLogReader subReader = null;
        if (logReader == null) {
            log.warn("Log reader for target {} is not initialised, it will be ignored.", (Object)this.state.getTargetCollection());
            return;
        }
        try {
            Object o;
            UpdateRequest req = new UpdateRequest();
            req.setParam("cdcr.update", "");
            this.state.getBenchmarkTimer().start();
            long counter = 0L;
            subReader = logReader.getSubReader();
            for (int i = 0; i < this.batchSize && (o = subReader.next()) != null; ++i) {
                if (this.isDelete(o)) {
                    List docs = req.getDocuments();
                    if (docs != null && docs.size() > 0) {
                        subReader.resetToLastPosition();
                        this.sendRequest(req);
                        logReader.forwardSeek(subReader);
                        o = subReader.next();
                        counter += (long)docs.size();
                        req.clear();
                    }
                    this.processUpdate(o, req);
                    this.sendRequest(req);
                    logReader.forwardSeek(subReader);
                    ++counter;
                    req.clear();
                    continue;
                }
                this.processUpdate(o, req);
            }
            List docs = req.getDocuments();
            if (docs != null && docs.size() > 0) {
                this.sendRequest(req);
                counter += (long)docs.size();
            }
            logReader.forwardSeek(subReader);
            log.debug("Forwarded {} updates to target {}", (Object)counter, (Object)this.state.getTargetCollection());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.state.getBenchmarkTimer().stop();
            if (subReader != null) {
                subReader.close();
            }
        }
    }

    private void sendRequest(UpdateRequest req) throws IOException, SolrServerException, CdcrReplicatorException {
        UpdateResponse rsp = (UpdateResponse)req.process((SolrClient)this.state.getClient());
        if (rsp.getStatus() != 0) {
            throw new CdcrReplicatorException(req, rsp);
        }
        this.state.resetConsecutiveErrors();
    }

    private boolean isDelete(Object o) {
        List entry = (List)o;
        int operationAndFlags = (Integer)entry.get(0);
        int oper = operationAndFlags & 0xF;
        return oper == 3 || oper == 2;
    }

    private void handleException(Exception e) {
        if (e instanceof CdcrReplicatorException) {
            UpdateRequest req = ((CdcrReplicatorException)e).req;
            UpdateResponse rsp = ((CdcrReplicatorException)e).rsp;
            log.warn("Failed to forward update request {}. Got response {}", (Object)req, (Object)rsp);
            this.state.reportError(CdcrReplicatorState.ErrorType.BAD_REQUEST);
        } else if (e instanceof CloudSolrClient.RouteException) {
            log.warn("Failed to forward update request", (Throwable)e);
            this.state.reportError(CdcrReplicatorState.ErrorType.BAD_REQUEST);
        } else {
            log.warn("Failed to forward update request", (Throwable)e);
            this.state.reportError(CdcrReplicatorState.ErrorType.INTERNAL);
        }
    }

    private UpdateRequest processUpdate(Object o, UpdateRequest req) {
        List entry = (List)o;
        int operationAndFlags = (Integer)entry.get(0);
        int oper = operationAndFlags & 0xF;
        long version = (Long)entry.get(1);
        this.state.getBenchmarkTimer().incrementCounter(oper);
        switch (oper) {
            case 1: {
                SolrInputDocument sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
                req.add(sdoc);
                return req;
            }
            case 2: {
                byte[] idBytes = (byte[])entry.get(2);
                req.deleteById(new String(idBytes, Charset.forName("UTF-8")));
                req.setParam("_version_", Long.toString(version));
                return req;
            }
            case 3: {
                String query = (String)entry.get(2);
                req.deleteByQuery(query);
                req.setParam("_version_", Long.toString(version));
                return req;
            }
            case 4: {
                return null;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
    }

    public class CdcrReplicatorException
    extends Exception {
        private final UpdateRequest req;
        private final UpdateResponse rsp;

        public CdcrReplicatorException(UpdateRequest req, UpdateResponse rsp) {
            this.req = req;
            this.rsp = rsp;
        }
    }
}

