/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.nio.charset.Charset;
import java.util.Locale;

public class CdcrParams {
    public static final String REPLICA_PARAM = "replica";
    public static final String SOURCE_COLLECTION_PARAM = "source";
    public static final String TARGET_COLLECTION_PARAM = "target";
    public static final String ZK_HOST_PARAM = "zkHost";
    public static final String REPLICATOR_PARAM = "replicator";
    public static final String THREAD_POOL_SIZE_PARAM = "threadPoolSize";
    public static final String SCHEDULE_PARAM = "schedule";
    public static final String BATCH_SIZE_PARAM = "batchSize";
    public static final String UPDATE_LOG_SYNCHRONIZER_PARAM = "updateLogSynchronizer";
    public static final String BUFFER_PARAM = "buffer";
    public static final String DEFAULT_STATE_PARAM = "defaultState";
    public static final String CHECKPOINT = "checkpoint";
    public static final String LAST_PROCESSED_VERSION = "lastProcessedVersion";
    public static final String QUEUES = "queues";
    public static final String QUEUE_SIZE = "queueSize";
    public static final String LAST_TIMESTAMP = "lastTimestamp";
    public static final String OPERATIONS_PER_SECOND = "operationsPerSecond";
    public static final String COUNTER_ALL = "all";
    public static final String COUNTER_ADDS = "adds";
    public static final String COUNTER_DELETES = "deletes";
    public static final String ERRORS = "errors";
    public static final String CONSECUTIVE_ERRORS = "consecutiveErrors";
    public static final String LAST = "last";
    public static final String TLOG_TOTAL_SIZE = "tlogTotalSize";
    public static final String TLOG_TOTAL_COUNT = "tlogTotalCount";
    public static final String UPDATE_LOG_SYNCHRONIZER = "updateLogSynchronizer";

    public static enum BufferState {
        ENABLED,
        DISABLED;


        public static BufferState get(byte[] state) {
            if (state != null) {
                try {
                    return BufferState.valueOf(new String(state, Charset.forName("UTF-8")).toUpperCase(Locale.ROOT));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public byte[] getBytes() {
            return this.toLower().getBytes(Charset.forName("UTF-8"));
        }

        public static String getParam() {
            return CdcrParams.BUFFER_PARAM;
        }
    }

    public static enum ProcessState {
        STARTED,
        STOPPED;


        public static ProcessState get(byte[] state) {
            if (state != null) {
                try {
                    return ProcessState.valueOf(new String(state, Charset.forName("UTF-8")).toUpperCase(Locale.ROOT));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public byte[] getBytes() {
            return this.toLower().getBytes(Charset.forName("UTF-8"));
        }

        public static String getParam() {
            return "process";
        }
    }

    public static enum CdcrAction {
        START,
        STOP,
        STATUS,
        COLLECTIONCHECKPOINT,
        SHARDCHECKPOINT,
        ENABLEBUFFER,
        DISABLEBUFFER,
        LASTPROCESSEDVERSION,
        QUEUES,
        OPS,
        ERRORS;


        public static CdcrAction get(String p) {
            if (p != null) {
                try {
                    return CdcrAction.valueOf(p.toUpperCase(Locale.ROOT));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

