/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunExecutableListener
extends AbstractSolrEventListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String[] cmd;
    protected File dir;
    protected String[] envp;
    protected boolean wait = true;
    private static int INVALID_PROCESS_RETURN_CODE = -1;

    public RunExecutableListener(SolrCore core) {
        super(core);
    }

    @Override
    public void init(NamedList args) {
        String str;
        super.init(args);
        ArrayList<Object> cmdlist = new ArrayList<Object>();
        cmdlist.add(args.get("exe"));
        List lst = (List)args.get("args");
        if (lst != null) {
            cmdlist.addAll(lst);
        }
        this.cmd = cmdlist.toArray(new String[cmdlist.size()]);
        lst = (List)args.get("env");
        if (lst != null) {
            this.envp = lst.toArray(new String[lst.size()]);
        }
        this.dir = (str = (String)args.get("dir")) == null || str.equals("") || str.equals(".") || str.equals("./") ? null : new File(str);
        if ("false".equals(args.get("wait")) || Boolean.FALSE.equals(args.get("wait"))) {
            this.wait = false;
        }
    }

    protected int exec(String callback) {
        int ret = 0;
        try {
            Process proc;
            boolean doLog = log.isDebugEnabled();
            if (doLog) {
                log.debug("About to exec " + this.cmd[0]);
            }
            try {
                proc = Runtime.getRuntime().exec(this.cmd, this.envp, this.dir);
            }
            catch (Error err) {
                if (err.getMessage() != null && (err.getMessage().contains("posix_spawn") || err.getMessage().contains("UNIXProcess"))) {
                    Error newErr = new Error("Error forking command due to JVM locale bug (see https://issues.apache.org/jira/browse/SOLR-6387): " + err.getMessage());
                    newErr.setStackTrace(err.getStackTrace());
                    err = newErr;
                }
                throw err;
            }
            if (this.wait) {
                try {
                    ret = proc.waitFor();
                }
                catch (InterruptedException e) {
                    SolrException.log((Logger)log, (Throwable)e);
                    ret = INVALID_PROCESS_RETURN_CODE;
                }
            }
            if (this.wait && doLog) {
                log.debug("Executable " + this.cmd[0] + " returned " + ret);
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (Throwable)e);
            ret = INVALID_PROCESS_RETURN_CODE;
        }
        return ret;
    }

    @Override
    public void postCommit() {
        this.exec("postCommit");
    }

    @Override
    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        this.exec("newSearcher");
    }
}

