/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.MapSerializable;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParams
implements MapSerializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map data;
    private final Map<String, ParamSet> paramsets = new LinkedHashMap<String, ParamSet>();
    private final int znodeVersion;
    public static final String USEPARAM = "useParams";
    public static final String NAME = "params";
    public static final String RESOURCE = "params.json";
    public static final String APPENDS = "_appends_";
    public static final String INVARIANTS = "_invariants_";

    public RequestParams(Map data, int znodeVersion) {
        if (data == null) {
            data = Collections.EMPTY_MAP;
        }
        this.data = data;
        Map paramsets = (Map)data.get(NAME);
        if (paramsets != null) {
            for (Map.Entry o : paramsets.entrySet()) {
                Map.Entry e = o;
                if (!(e.getValue() instanceof Map)) continue;
                Map value = (Map)e.getValue();
                this.paramsets.put((String)e.getKey(), RequestParams.createParamSet(value, 0L));
            }
        }
        this.znodeVersion = znodeVersion;
    }

    public static ParamSet createParamSet(Map map, Long version) {
        Map copy = Utils.getDeepCopy((Map)map, (int)3);
        Map<String, Long> meta = (Map<String, Long>)copy.remove("");
        if (meta == null && version != null) {
            meta = Collections.singletonMap("v", version);
        }
        Map invariants = (Map)copy.remove(INVARIANTS);
        Map appends = (Map)copy.remove(APPENDS);
        return new ParamSet(copy, invariants, appends, meta);
    }

    private static Map getMapCopy(Map value) {
        LinkedHashMap copy = new LinkedHashMap();
        for (Map.Entry o1 : value.entrySet()) {
            Map.Entry entry = o1;
            if ("".equals(entry.getKey())) {
                copy.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() != null) {
                if (entry.getValue() instanceof List) {
                    List l = (List)entry.getValue();
                    String[] sarr = new String[l.size()];
                    for (int i = 0; i < l.size(); ++i) {
                        if (l.get(i) == null) continue;
                        sarr[i] = String.valueOf(l.get(i));
                    }
                    copy.put(entry.getKey(), sarr);
                    continue;
                }
                copy.put(entry.getKey(), String.valueOf(entry.getValue()));
                continue;
            }
            copy.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public ParamSet getParams(String name) {
        return this.paramsets.get(name);
    }

    public VersionedParams getParams(String name, String type) {
        ParamSet paramSet = this.paramsets.get(name);
        return paramSet == null ? null : paramSet.getParams(type);
    }

    public int getZnodeVersion() {
        return this.znodeVersion;
    }

    @Override
    public Map<String, Object> toMap() {
        return RequestParams.getMapWithVersion(this.data, this.znodeVersion);
    }

    public static Map<String, Object> getMapWithVersion(Map<String, Object> data, int znodeVersion) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("znodeVersion", znodeVersion);
        result.putAll(data);
        return result;
    }

    public RequestParams setParams(String name, ParamSet paramSet) {
        Map deepCopy = Utils.getDeepCopy((Map)this.data, (int)3);
        LinkedHashMap<String, Map<String, Object>> p = (LinkedHashMap<String, Map<String, Object>>)deepCopy.get(NAME);
        if (p == null) {
            p = new LinkedHashMap<String, Map<String, Object>>();
            deepCopy.put(NAME, p);
        }
        if (paramSet == null) {
            p.remove(name);
        } else {
            p.put(name, paramSet.toMap());
        }
        return new RequestParams(deepCopy, this.znodeVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestParams getFreshRequestParams(SolrResourceLoader loader, RequestParams requestParams) {
        if (loader instanceof ZkSolrResourceLoader) {
            ZkSolrResourceLoader resourceLoader = (ZkSolrResourceLoader)loader;
            try {
                Stat stat = resourceLoader.getZkController().getZkClient().exists(resourceLoader.getConfigSetZkPath() + "/" + RESOURCE, null, true);
                log.debug("latest version of {} in ZK  is : {}", (Object)(resourceLoader.getConfigSetZkPath() + "/" + RESOURCE), stat == null ? "" : Integer.valueOf(stat.getVersion()));
                if (stat == null) {
                    return new RequestParams(Collections.EMPTY_MAP, -1);
                }
                if (requestParams != null) {
                    if (stat.getVersion() <= requestParams.getZnodeVersion()) return requestParams;
                }
                Object[] o = RequestParams.getMapAndVersion(loader, RESOURCE);
                requestParams = new RequestParams((Map)o[0], (Integer)o[1]);
                log.info("request params refreshed to version {}", (Object)requestParams.getZnodeVersion());
                return requestParams;
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        } else {
            Object[] o = RequestParams.getMapAndVersion(loader, RESOURCE);
            return new RequestParams((Map)o[0], (Integer)o[1]);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Object[] getMapAndVersion(SolrResourceLoader loader, String name) {
        try {
            Throwable throwable = null;
            try (InputStream in = loader.openResource(name);){
                int version = 0;
                if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                    version = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                    log.info("conf resource {} loaded . version : {} ", (Object)name, (Object)version);
                }
                try {
                    Map m = (Map)ObjectBuilder.getVal((JSONParser)new JSONParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)));
                    Object[] objectArray = new Object[]{m, version};
                    return objectArray;
                }
                catch (IOException e) {
                    try {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing conf resource " + name, (Throwable)e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (IOException e) {
            return new Object[]{Collections.EMPTY_MAP, -1};
        }
    }

    public byte[] toByteArray() {
        return Utils.toJSON((Object)this.data);
    }

    public static class VersionedParams
    extends MapSolrParams {
        final ParamSet paramSet;

        public VersionedParams(Map map, ParamSet paramSet) {
            super(RequestParams.getMapCopy(map));
            this.paramSet = paramSet;
        }
    }

    public static class ParamSet
    implements MapSerializable {
        private final Map defaults;
        private final Map appends;
        private final Map invariants;
        Map<String, VersionedParams> paramsMap;
        public final Map meta;

        ParamSet(Map defaults, Map invariants, Map appends, Map meta) {
            this.defaults = defaults;
            this.invariants = invariants;
            this.appends = appends;
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"defaults", (Object)new VersionedParams(defaults, this));
            if (appends != null) {
                builder.put((Object)"appends", (Object)new VersionedParams(appends, this));
            }
            if (invariants != null) {
                builder.put((Object)"invariants", (Object)new VersionedParams(invariants, this));
            }
            this.paramsMap = builder.build();
            this.meta = meta;
        }

        public Long getVersion() {
            return this.meta == null ? 0L : (Long)this.meta.get("v");
        }

        @Override
        public Map<String, Object> toMap() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.putAll(this.defaults);
            if (this.appends != null) {
                result.put(RequestParams.APPENDS, this.appends);
            }
            if (this.invariants != null) {
                result.put(RequestParams.INVARIANTS, this.invariants);
            }
            if (this.meta != null) {
                result.put("", this.meta);
            }
            return result;
        }

        public ParamSet update(Map map) {
            ParamSet p = RequestParams.createParamSet(map, null);
            return new ParamSet(ParamSet.mergeMaps(Utils.getDeepCopy((Map)this.defaults, (int)2), p.defaults), ParamSet.mergeMaps(Utils.getDeepCopy((Map)this.invariants, (int)2), p.invariants), ParamSet.mergeMaps(Utils.getDeepCopy((Map)this.appends, (int)2), p.appends), ParamSet.mergeMaps(Utils.getDeepCopy((Map)this.meta, (int)2), Collections.singletonMap("v", this.getVersion() + 1L)));
        }

        private static Map mergeMaps(Map m1, Map m2) {
            if (m1 == null && m2 == null) {
                return null;
            }
            if (m1 == null) {
                return m2;
            }
            if (m2 == null) {
                return m1;
            }
            m1.putAll(m2);
            return m1;
        }

        public VersionedParams getParams(String type) {
            return this.paramsMap.get(type);
        }
    }
}

