/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.MemClassLoader;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.util.CryptoKeys;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBag<T>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, PluginHolder<T>> registry;
    private final Map<String, PluginHolder<T>> immutableRegistry;
    private String def;
    private final Class klass;
    private SolrCore core;
    private final SolrConfig.SolrPluginInfo meta;

    public PluginBag(Class<T> klass, SolrCore core, boolean needThreadSafety) {
        this.core = core;
        this.klass = klass;
        this.registry = needThreadSafety ? new ConcurrentHashMap() : new HashMap();
        this.immutableRegistry = Collections.unmodifiableMap(this.registry);
        this.meta = SolrConfig.classVsSolrPluginInfo.get(klass.getName());
        if (this.meta == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Plugin : " + klass.getName());
        }
    }

    public PluginBag(Class<T> klass, SolrCore core) {
        this(klass, core, false);
    }

    static void initInstance(Object inst, PluginInfo info) {
        if (inst instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)inst).init(info);
        } else if (inst instanceof NamedListInitializedPlugin) {
            ((NamedListInitializedPlugin)inst).init(info.initArgs);
        } else if (inst instanceof SolrRequestHandler) {
            ((SolrRequestHandler)inst).init(info.initArgs);
        }
        if (inst instanceof SearchComponent) {
            ((SearchComponent)inst).setName(info.name);
        }
        if (inst instanceof RequestHandlerBase) {
            ((RequestHandlerBase)inst).setPluginInfo(info);
        }
    }

    public Set<String> checkContains(Collection<String> names) {
        if (names == null || names.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : names) {
            if (this.registry.containsKey(s)) continue;
            result.add(s);
        }
        return result;
    }

    PluginHolder<T> createPlugin(PluginInfo info) {
        if ("true".equals(String.valueOf(info.attributes.get("runtimeLib")))) {
            log.info(" {} : '{}'  created with runtimeLib=true ", (Object)this.meta.getCleanTag(), (Object)info.name);
            return new LazyPluginHolder(this.meta, info, this.core, this.core.getMemClassLoader());
        }
        if ("lazy".equals(info.attributes.get("startup")) && this.meta.options.contains((Object)SolrConfig.PluginOpts.LAZY)) {
            log.info("{} : '{}' created with startup=lazy ", (Object)this.meta.getCleanTag(), (Object)info.name);
            return new LazyPluginHolder(this.meta, info, this.core, this.core.getResourceLoader());
        }
        Object inst = SolrCore.createInstance(info.className, this.meta.clazz, this.meta.getCleanTag(), null, this.core.getResourceLoader());
        PluginBag.initInstance(inst, info);
        return new PluginHolder(info, inst);
    }

    boolean alias(String src, String target) {
        if (src == null) {
            return false;
        }
        PluginHolder<T> a = this.registry.get(src);
        if (a == null) {
            return false;
        }
        PluginHolder<T> b = this.registry.get(target);
        if (b != null) {
            return false;
        }
        this.registry.put(target, a);
        return true;
    }

    public T get(String name) {
        PluginHolder<T> result = this.registry.get(name);
        return result == null ? null : (T)result.get();
    }

    public T get(String name, boolean useDefault) {
        T result = this.get(name);
        if (useDefault && result == null) {
            return this.get(this.def);
        }
        return result;
    }

    public Set<String> keySet() {
        return this.immutableRegistry.keySet();
    }

    public T put(String name, T plugin) {
        if (plugin == null) {
            return null;
        }
        PluginHolder<T> old = this.put(name, new PluginHolder<T>(null, plugin));
        return old == null ? null : (T)old.get();
    }

    PluginHolder<T> put(String name, PluginHolder<T> plugin) {
        PluginHolder<T> old = this.registry.put(name, plugin);
        if (plugin.pluginInfo != null && plugin.pluginInfo.isDefault()) {
            this.setDefault(name);
        }
        if (plugin.isLoaded()) {
            PluginBag.registerMBean(plugin.get(), this.core, name);
        }
        return old;
    }

    void setDefault(String def) {
        if (!this.registry.containsKey(def)) {
            return;
        }
        if (this.def != null) {
            log.warn("Multiple defaults for : " + this.meta.getCleanTag());
        }
        this.def = def;
    }

    public Map<String, PluginHolder<T>> getRegistry() {
        return this.immutableRegistry;
    }

    public boolean contains(String name) {
        return this.registry.containsKey(name);
    }

    String getDefault() {
        return this.def;
    }

    T remove(String name) {
        PluginHolder<T> removed = this.registry.remove(name);
        return removed == null ? null : (T)removed.get();
    }

    void init(Map<String, T> defaults, SolrCore solrCore) {
        this.init(defaults, solrCore, solrCore.getSolrConfig().getPluginInfos(this.klass.getName()));
    }

    void init(Map<String, T> defaults, SolrCore solrCore, List<PluginInfo> infos) {
        this.core = solrCore;
        for (PluginInfo pluginInfo : infos) {
            PluginHolder<T> old;
            PluginHolder<T> o = this.createPlugin(pluginInfo);
            String name = pluginInfo.name;
            if (this.meta.clazz.equals(SolrRequestHandler.class)) {
                name = RequestHandlers.normalize(pluginInfo.name);
            }
            if ((old = this.put(name, o)) == null) continue;
            log.warn("Multiple entries of {} with name {}", (Object)this.meta.getCleanTag(), (Object)name);
        }
        for (Map.Entry entry : defaults.entrySet()) {
            if (this.contains((String)entry.getKey())) continue;
            this.put((String)entry.getKey(), new PluginHolder(null, entry.getValue()));
        }
    }

    public boolean isLoaded(String name) {
        PluginHolder<T> result = this.registry.get(name);
        if (result == null) {
            return false;
        }
        return result.isLoaded();
    }

    private static void registerMBean(Object inst, SolrCore core, String pluginKey) {
        if (core == null) {
            return;
        }
        if (inst instanceof SolrInfoMBean) {
            SolrInfoMBean mBean = (SolrInfoMBean)inst;
            String name = inst instanceof SolrRequestHandler ? pluginKey : mBean.getName();
            core.registerInfoBean(name, mBean);
        }
    }

    @Override
    public void close() {
        for (Map.Entry<String, PluginHolder<T>> e : this.registry.entrySet()) {
            try {
                e.getValue().close();
            }
            catch (Exception exp) {
                log.error("Error closing plugin " + e.getKey() + " of type : " + this.meta.getCleanTag(), (Throwable)exp);
            }
        }
    }

    public static class RuntimeLib
    implements PluginInfoInitialized,
    AutoCloseable {
        private String name;
        private String version;
        private String sig;
        private BlobRepository.BlobContentRef jarContent;
        private final CoreContainer coreContainer;
        private boolean verified = false;

        @Override
        public void init(PluginInfo info) {
            this.name = info.attributes.get("name");
            String v = info.attributes.get("version");
            if (this.name == null || v == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "runtimeLib must have name and version");
            }
            this.version = String.valueOf(v);
            this.sig = info.attributes.get("sig");
        }

        public RuntimeLib(SolrCore core) {
            this.coreContainer = core.getCoreDescriptor().getCoreContainer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadJar() {
            if (this.jarContent != null) {
                return;
            }
            RuntimeLib runtimeLib = this;
            synchronized (runtimeLib) {
                if (this.jarContent != null) {
                    return;
                }
                this.jarContent = this.coreContainer.getBlobRepository().getBlobIncRef(this.name + "/" + this.version);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSig() {
            return this.sig;
        }

        public ByteBuffer getFileContent(String entryName) throws IOException {
            if (this.jarContent == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "jar not available: " + this.name + "/" + this.version);
            }
            return BlobRepository.getFileContent(this.jarContent.blob, entryName);
        }

        @Override
        public void close() throws Exception {
            if (this.jarContent != null) {
                this.coreContainer.getBlobRepository().decrementBlobRefCount(this.jarContent);
            }
        }

        public static List<RuntimeLib> getLibObjects(SolrCore core, List<PluginInfo> libs) {
            ArrayList<RuntimeLib> l = new ArrayList<RuntimeLib>(libs.size());
            for (PluginInfo lib : libs) {
                RuntimeLib rtl = new RuntimeLib(core);
                rtl.init(lib);
                l.add(rtl);
            }
            return l;
        }

        public void verify() throws Exception {
            if (this.verified) {
                return;
            }
            if (this.jarContent == null) {
                log.error("Calling verify before loading the jar");
                return;
            }
            if (!this.coreContainer.isZooKeeperAware()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Signing jar is possible only in cloud");
            }
            Map<String, byte[]> keys = CloudUtil.getTrustedKeys(this.coreContainer.getZkController().getZkClient(), "exe");
            if (keys.isEmpty()) {
                if (this.sig == null) {
                    this.verified = true;
                    log.info("A run time lib {} is loaded  without verification ", (Object)this.name);
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No public keys are available in ZK to verify signature for runtime lib  " + this.name);
            }
            if (this.sig == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, StrUtils.formatString((String)"runtimelib {0} should be signed with one of the keys in ZK /keys/exe ", (Object[])new Object[]{this.name}));
            }
            try {
                String matchedKey = this.jarContent.blob.checkSignature(this.sig, new CryptoKeys(keys));
                if (matchedKey == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No key matched signature for jar : " + this.name + " version: " + this.version);
                }
                log.info("Jar {} signed with {} successfully verified", (Object)this.name, (Object)matchedKey);
            }
            catch (Exception e) {
                if (e instanceof SolrException) {
                    throw e;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error verifying key ", (Throwable)e);
            }
        }
    }

    public static class LazyPluginHolder<T>
    extends PluginHolder<T> {
        private volatile T lazyInst;
        private final SolrConfig.SolrPluginInfo pluginMeta;
        protected SolrException solrException;
        private final SolrCore core;
        protected ResourceLoader resourceLoader;

        LazyPluginHolder(SolrConfig.SolrPluginInfo pluginMeta, PluginInfo pluginInfo, SolrCore core, ResourceLoader loader) {
            super(pluginInfo);
            this.pluginMeta = pluginMeta;
            this.core = core;
            this.resourceLoader = loader;
            if (loader instanceof MemClassLoader && !"true".equals(System.getProperty("enable.runtime.lib"))) {
                String s = "runtime library loading is not enabled, start Solr with -Denable.runtime.lib=true";
                log.warn(s);
                this.solrException = new SolrException(SolrException.ErrorCode.SERVER_ERROR, s);
            }
        }

        @Override
        public boolean isLoaded() {
            return this.lazyInst != null;
        }

        @Override
        public T get() {
            if (this.lazyInst != null) {
                return this.lazyInst;
            }
            if (this.solrException != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecoverable error", (Throwable)this.solrException);
            }
            if (this.createInst()) {
                PluginBag.registerMBean(this.lazyInst, this.core, this.pluginInfo.name);
            }
            return this.lazyInst;
        }

        private synchronized boolean createInst() {
            if (this.lazyInst != null) {
                return false;
            }
            log.info("Going to create a new {} with {} ", (Object)this.pluginMeta.getCleanTag(), (Object)this.pluginInfo.toString());
            if (this.resourceLoader instanceof MemClassLoader) {
                MemClassLoader loader = (MemClassLoader)this.resourceLoader;
                loader.loadJars();
            }
            Class clazz = this.pluginMeta.clazz;
            Object localInst = SolrCore.createInstance(this.pluginInfo.className, clazz, this.pluginMeta.getCleanTag(), null, this.resourceLoader);
            PluginBag.initInstance(localInst, this.pluginInfo);
            if (localInst instanceof SolrCoreAware) {
                SolrResourceLoader.assertAwareCompatibility(SolrCoreAware.class, localInst);
                ((SolrCoreAware)localInst).inform(this.core);
            }
            if (localInst instanceof ResourceLoaderAware) {
                SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, localInst);
                try {
                    ((ResourceLoaderAware)localInst).inform((ResourceLoader)this.core.getResourceLoader());
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error initializing component", (Throwable)e);
                }
            }
            this.lazyInst = localInst;
            return true;
        }
    }

    public static class PluginHolder<T>
    implements AutoCloseable {
        private T inst;
        protected final PluginInfo pluginInfo;

        public PluginHolder(PluginInfo info) {
            this.pluginInfo = info;
        }

        public PluginHolder(PluginInfo info, T inst) {
            this.inst = inst;
            this.pluginInfo = info;
        }

        public T get() {
            return this.inst;
        }

        public boolean isLoaded() {
            return this.inst != null;
        }

        @Override
        public void close() throws Exception {
            T myInst;
            if (this.isLoaded() && (myInst = this.get()) != null && myInst instanceof AutoCloseable) {
                ((AutoCloseable)myInst).close();
            }
        }

        public String getClassName() {
            if (this.isLoaded()) {
                return this.inst.getClass().getName();
            }
            if (this.pluginInfo != null) {
                return this.pluginInfo.className;
            }
            return null;
        }
    }
}

