/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrInfoMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMonitoredMap<K, V>
extends ConcurrentHashMap<String, SolrInfoMBean> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean useCachedStatsBetweenGetMBeanInfoCalls = Boolean.getBoolean("useCachedStatsBetweenGetMBeanInfoCalls");
    private MBeanServer server = null;
    private String jmxRootName;
    private String coreHashCode;

    public JmxMonitoredMap(String coreName, String coreHashCode, SolrConfig.JmxConfiguration jmxConfig) {
        this.coreHashCode = coreHashCode;
        String string = null != jmxConfig.rootName ? jmxConfig.rootName : (this.jmxRootName = "solr" + (null != coreName ? "/" + coreName : ""));
        if (jmxConfig.serviceUrl == null) {
            ArrayList<MBeanServer> servers = null;
            if (jmxConfig.agentId == null) {
                servers = MBeanServerFactory.findMBeanServer(null);
            } else if (jmxConfig.agentId != null && ((servers = MBeanServerFactory.findMBeanServer(jmxConfig.agentId)) == null || servers.isEmpty())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No JMX Servers found with agentId: " + jmxConfig.agentId);
            }
            if (servers == null || servers.isEmpty()) {
                LOG.info("No JMX servers found, not exposing Solr information with JMX.");
                return;
            }
            this.server = (MBeanServer)servers.get(0);
            LOG.info("JMX monitoring is enabled. Adding Solr mbeans to JMX Server: " + this.server);
        } else {
            try {
                this.server = MBeanServerFactory.newMBeanServer();
                JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(jmxConfig.serviceUrl), null, this.server);
                connector.start();
                LOG.info("JMX monitoring is enabled at " + jmxConfig.serviceUrl);
            }
            catch (Exception e) {
                this.server = null;
                throw new RuntimeException("Could not start JMX monitoring ", e);
            }
        }
    }

    @Override
    public void clear() {
        if (this.server != null) {
            QueryExp exp = Query.eq(Query.attr("coreHashCode"), Query.value(this.coreHashCode));
            Set<ObjectName> objectNames = null;
            try {
                ObjectName instance = new ObjectName(this.jmxRootName + ":*");
                objectNames = this.server.queryNames(instance, exp);
            }
            catch (Exception e) {
                LOG.warn("Exception querying for mbeans", (Throwable)e);
            }
            if (objectNames != null) {
                for (ObjectName name : objectNames) {
                    try {
                        this.server.unregisterMBean(name);
                    }
                    catch (Exception e) {
                        LOG.warn("Exception un-registering mbean {}", (Object)name, (Object)e);
                    }
                }
            }
        }
        super.clear();
    }

    @Override
    public SolrInfoMBean put(String key, SolrInfoMBean infoBean) {
        if (this.server != null && infoBean != null) {
            try {
                ObjectName name = this.getObjectName(key, infoBean);
                if (this.server.isRegistered(name)) {
                    this.server.unregisterMBean(name);
                }
                SolrDynamicMBean mbean = new SolrDynamicMBean(this.coreHashCode, infoBean, this.useCachedStatsBetweenGetMBeanInfoCalls);
                this.server.registerMBean(mbean, name);
            }
            catch (Exception e) {
                LOG.warn("Failed to register info bean: " + key, (Throwable)e);
            }
        }
        return super.put(key, infoBean);
    }

    @Override
    public SolrInfoMBean remove(Object key) {
        SolrInfoMBean infoBean = (SolrInfoMBean)this.get(key);
        if (infoBean != null) {
            try {
                this.unregister((String)key, infoBean);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to unregister info bean: " + key, (Throwable)e);
            }
        }
        return (SolrInfoMBean)super.remove(key);
    }

    private void unregister(String key, SolrInfoMBean infoBean) {
        if (this.server == null) {
            return;
        }
        try {
            ObjectName name = this.getObjectName(key, infoBean);
            if (this.server.isRegistered(name) && this.coreHashCode.equals(this.server.getAttribute(name, "coreHashCode"))) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to unregister info bean: " + key, (Throwable)e);
        }
    }

    private ObjectName getObjectName(String key, SolrInfoMBean infoBean) throws MalformedObjectNameException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("type", key);
        if (infoBean.getName() != null && !"".equals(infoBean.getName())) {
            map.put("id", infoBean.getName());
        }
        return ObjectName.getInstance(this.jmxRootName, map);
    }

    public MBeanServer getServer() {
        return this.server;
    }

    static class SolrDynamicMBean
    implements DynamicMBean {
        private SolrInfoMBean infoBean;
        private HashSet<String> staticStats;
        private String coreHashCode;
        private volatile NamedList cachedDynamicStats;
        private boolean useCachedStatsBetweenGetMBeanInfoCalls;

        public SolrDynamicMBean(String coreHashCode, SolrInfoMBean managedResource) {
            this(coreHashCode, managedResource, false);
        }

        public SolrDynamicMBean(String coreHashCode, SolrInfoMBean managedResource, boolean useCachedStatsBetweenGetMBeanInfoCalls) {
            this.useCachedStatsBetweenGetMBeanInfoCalls = useCachedStatsBetweenGetMBeanInfoCalls;
            this.infoBean = managedResource;
            this.staticStats = new HashSet();
            this.staticStats.add("name");
            this.staticStats.add("version");
            this.staticStats.add("description");
            this.staticStats.add("category");
            this.staticStats.add("source");
            this.coreHashCode = coreHashCode;
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            ArrayList<MBeanAttributeInfo> attrInfoList;
            block7: {
                attrInfoList = new ArrayList<MBeanAttributeInfo>();
                for (String stat : this.staticStats) {
                    attrInfoList.add(new MBeanAttributeInfo(stat, String.class.getName(), null, true, false, false));
                }
                attrInfoList.add(new MBeanAttributeInfo("coreHashCode", String.class.getName(), null, true, false, false));
                try {
                    NamedList dynamicStats = this.infoBean.getStatistics();
                    if (this.useCachedStatsBetweenGetMBeanInfoCalls) {
                        this.cachedDynamicStats = dynamicStats;
                    }
                    if (dynamicStats != null) {
                        for (int i = 0; i < dynamicStats.size(); ++i) {
                            String name = dynamicStats.getName(i);
                            if (this.staticStats.contains(name)) continue;
                            Class<?> type = dynamicStats.get(name).getClass();
                            OpenType typeBox = this.determineType(type);
                            if (type.equals(String.class) || typeBox == null) {
                                attrInfoList.add(new MBeanAttributeInfo(dynamicStats.getName(i), String.class.getName(), null, true, false, false));
                                continue;
                            }
                            attrInfoList.add(new OpenMBeanAttributeInfoSupport(dynamicStats.getName(i), dynamicStats.getName(i), typeBox, true, false, false));
                        }
                    }
                }
                catch (Exception e) {
                    if (SolrException.getRootCause((Throwable)e) instanceof AlreadyClosedException) break block7;
                    LOG.warn("Could not getStatistics on info bean {}", (Object)this.infoBean.getName(), (Object)e);
                }
            }
            MBeanAttributeInfo[] attrInfoArr = attrInfoList.toArray(new MBeanAttributeInfo[attrInfoList.size()]);
            return new MBeanInfo(this.getClass().getName(), this.infoBean.getDescription(), attrInfoArr, null, null, null);
        }

        private OpenType determineType(Class type) {
            try {
                for (Field field : SimpleType.class.getFields()) {
                    SimpleType candidate;
                    if (!field.getType().equals(SimpleType.class) || !(candidate = (SimpleType)field.get(SimpleType.class)).getTypeName().equals(type.getName())) continue;
                    return candidate;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            Object val;
            if ("coreHashCode".equals(attribute)) {
                val = this.coreHashCode;
            } else if (this.staticStats.contains(attribute) && attribute != null && attribute.length() > 0) {
                try {
                    String getter = "get" + attribute.substring(0, 1).toUpperCase(Locale.ROOT) + attribute.substring(1);
                    Method meth = this.infoBean.getClass().getMethod(getter, new Class[0]);
                    val = meth.invoke((Object)this.infoBean, new Object[0]);
                }
                catch (Exception e) {
                    throw new AttributeNotFoundException(attribute);
                }
            } else {
                NamedList cachedStats;
                NamedList stats = null;
                if (this.useCachedStatsBetweenGetMBeanInfoCalls && (cachedStats = this.cachedDynamicStats) != null) {
                    stats = cachedStats;
                }
                if (stats == null) {
                    stats = this.infoBean.getStatistics();
                }
                val = stats.get(attribute);
            }
            if (val != null) {
                for (String simpleTypeName : SimpleType.ALLOWED_CLASSNAMES_LIST) {
                    if (!val.getClass().getName().equals(simpleTypeName)) continue;
                    return val;
                }
                return val.toString();
            }
            return null;
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            AttributeList list = new AttributeList();
            for (String attribute : attributes) {
                try {
                    list.add(new Attribute(attribute, this.getAttribute(attribute)));
                }
                catch (Exception e) {
                    LOG.warn("Could not get attribute " + attribute);
                }
            }
            return list;
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new UnsupportedOperationException("Operation not Supported");
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            throw new UnsupportedOperationException("Operation not Supported");
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            throw new UnsupportedOperationException("Operation not Supported");
        }
    }
}

