/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.util.CryptoKeys;
import org.apache.solr.util.SimplePostTool;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobRepository {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Random RANDOM;
    private final CoreContainer coreContainer;
    private Map<String, BlobContent> blobs = new ConcurrentHashMap<String, BlobContent>();

    public BlobRepository(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getFileContent(BlobContent blobContent, String entryName) throws IOException {
        ByteArrayInputStream zipContents = new ByteArrayInputStream(blobContent.buffer.array(), blobContent.buffer.arrayOffset(), blobContent.buffer.limit());
        ZipInputStream zis = new ZipInputStream(zipContents);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int size;
                if (entryName != null && !entryName.equals(entry.getName())) continue;
                SimplePostTool.BAOS out = new SimplePostTool.BAOS();
                byte[] buffer = new byte[2048];
                while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, size);
                }
                out.close();
                ByteBuffer byteBuffer = out.getByteBuffer();
                return byteBuffer;
            }
        }
        finally {
            zis.closeEntry();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobContentRef getBlobIncRef(String key) {
        BlobContent aBlob = this.blobs.get(key);
        if (aBlob == null) {
            if (this.coreContainer.isZooKeeperAware()) {
                ByteBuffer b;
                Replica replica = this.getSystemCollReplica();
                String url = replica.getStr("base_url") + "/.system/blob/" + key + "?wt=filestream";
                HttpClient httpClient = this.coreContainer.getUpdateShardHandler().getHttpClient();
                HttpGet httpGet = new HttpGet(url);
                try {
                    HttpResponse entity = httpClient.execute((HttpUriRequest)httpGet);
                    int statusCode = entity.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "no such blob or version available: " + key);
                    }
                    b = SimplePostTool.inputStreamToByteArray(entity.getEntity().getContent());
                }
                catch (Exception e) {
                    if (e instanceof SolrException) {
                        throw (SolrException)((Object)e);
                    }
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "could not load : " + key, (Throwable)e);
                }
                finally {
                    httpGet.releaseConnection();
                }
                aBlob = new BlobContent(key, b);
                this.blobs.put(key, aBlob);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Jar loading is not supported in non-cloud mode");
            }
        }
        BlobContentRef ref = new BlobContentRef(aBlob);
        Set set = aBlob.references;
        synchronized (set) {
            aBlob.references.add(ref);
        }
        return ref;
    }

    private Replica getSystemCollReplica() {
        ZkStateReader zkStateReader = this.coreContainer.getZkController().getZkStateReader();
        ClusterState cs = zkStateReader.getClusterState();
        DocCollection coll = cs.getCollectionOrNull(".system");
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, ".system collection not available");
        }
        ArrayList slices = new ArrayList(coll.getActiveSlices());
        if (slices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No active slices for .system collection");
        }
        Collections.shuffle(slices, RANDOM);
        Replica replica = null;
        block0: for (Slice slice : slices) {
            ArrayList replicas = new ArrayList(slice.getReplicasMap().values());
            Collections.shuffle(replicas, RANDOM);
            for (Replica r : replicas) {
                if (r.getState() != Replica.State.ACTIVE) continue;
                if (zkStateReader.getClusterState().getLiveNodes().contains(r.get("node_name"))) {
                    replica = r;
                    continue block0;
                }
                log.info("replica {} says it is active but not a member of live nodes", r.get("node_name"));
            }
        }
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, ".no active replica available for .system collection");
        }
        return replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementBlobRefCount(BlobContentRef ref) {
        if (ref == null) {
            return;
        }
        Set set = ref.blob.references;
        synchronized (set) {
            if (!ref.blob.references.remove(ref)) {
                log.error("Multiple releases for the same reference");
            }
            if (ref.blob.references.isEmpty()) {
                this.blobs.remove(ref.blob.key);
            }
        }
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
    }

    public static class BlobContentRef {
        public final BlobContent blob;

        private BlobContentRef(BlobContent blob) {
            this.blob = blob;
        }
    }

    public static interface Decoder<T> {
        public T decode(InputStream var1);
    }

    public static class BlobContent {
        private final String key;
        private Map<String, Object> decodedObjects = null;
        private final ByteBuffer buffer;
        private final Set<BlobContentRef> references = new HashSet<BlobContentRef>();

        public BlobContent(String key, ByteBuffer buffer) {
            this.key = key;
            this.buffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T decodeAndCache(String key, Decoder<T> decoder) {
            Object t;
            if (this.decodedObjects == null) {
                BlobContent blobContent = this;
                synchronized (blobContent) {
                    if (this.decodedObjects == null) {
                        this.decodedObjects = new ConcurrentHashMap<String, Object>();
                    }
                }
            }
            if ((t = this.decodedObjects.get(key)) != null) {
                return (T)t;
            }
            t = decoder.decode((InputStream)new ByteBufferInputStream(this.buffer));
            this.decodedObjects.put(key, t);
            return (T)t;
        }

        public String checkSignature(String base64Sig, CryptoKeys keys) {
            return keys.verify(base64Sig, this.buffer);
        }
    }
}

