/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.cloud.rule.Snitch;
import org.apache.solr.cloud.rule.SnitchContext;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitSnitch
extends Snitch
implements CoreAdminHandler.Invocable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Pattern hostAndPortPattern = Pattern.compile("(?:https?://)?([^:]+):(\\d+)");
    public static final String NODE = "node";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String CORES = "cores";
    public static final String DISK = "freedisk";
    public static final String SYSPROP = "sysprop.";
    public static final List<String> IP_SNITCHES = ImmutableList.of((Object)"ip_1", (Object)"ip_2", (Object)"ip_3", (Object)"ip_4");
    public static final Set<String> tags = ImmutableSet.builder().add((Object[])new String[]{"node", "port", "host", "cores", "freedisk"}).addAll(IP_SNITCHES).build();
    private static final String HOST_FRAG_SEPARATOR_REGEX = "\\.";

    @Override
    public void getTags(String solrNode, Set<String> requestedTags, SnitchContext ctx) {
        Matcher hostAndPortMatcher;
        if (requestedTags.contains(NODE)) {
            ctx.getTags().put(NODE, solrNode);
        }
        if (requestedTags.contains(HOST) && (hostAndPortMatcher = hostAndPortPattern.matcher(solrNode)).find()) {
            ctx.getTags().put(HOST, hostAndPortMatcher.group(1));
        }
        if (requestedTags.contains(PORT) && (hostAndPortMatcher = hostAndPortPattern.matcher(solrNode)).find()) {
            ctx.getTags().put(PORT, hostAndPortMatcher.group(2));
        }
        this.addIpTags(solrNode, requestedTags, ctx);
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (requestedTags.contains(CORES)) {
            params.add(CORES, new String[]{"1"});
        }
        if (requestedTags.contains(DISK)) {
            params.add(DISK, new String[]{"1"});
        }
        for (String tag : requestedTags) {
            if (!tag.startsWith(SYSPROP)) continue;
            params.add(SYSPROP, new String[]{tag.substring(SYSPROP.length())});
        }
        if (params.size() > 0) {
            ctx.invokeRemote(solrNode, params, ImplicitSnitch.class.getName(), null);
        }
    }

    static long getUsableSpaceInGB() throws IOException {
        long space = Files.getFileStore(Paths.get("/", new String[0])).getUsableSpace();
        long spaceInGB = space / 1024L / 1024L / 1024L;
        return spaceInGB;
    }

    @Override
    public Map<String, Object> invoke(SolrQueryRequest req) {
        String[] sysProps;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (req.getParams().getInt(CORES, -1) == 1) {
            CoreContainer cc = (CoreContainer)req.getContext().get(CoreContainer.class.getName());
            result.put(CORES, cc.getCoreNames().size());
        }
        if (req.getParams().getInt(DISK, -1) == 1) {
            try {
                long spaceInGB = ImplicitSnitch.getUsableSpaceInGB();
                result.put(DISK, spaceInGB);
            }
            catch (IOException spaceInGB) {
                // empty catch block
            }
        }
        if ((sysProps = req.getParams().getParams(SYSPROP)) != null && sysProps.length > 0) {
            for (String prop : sysProps) {
                result.put(SYSPROP + prop, System.getProperty(prop));
            }
        }
        return result;
    }

    @Override
    public boolean isKnownTag(String tag) {
        return tags.contains(tag) || tag.startsWith(SYSPROP);
    }

    private void addIpTags(String solrNode, Set<String> requestedTags, SnitchContext context) {
        ArrayList<String> requestedHostTags = new ArrayList<String>();
        for (String tag : requestedTags) {
            if (!IP_SNITCHES.contains(tag)) continue;
            requestedHostTags.add(tag);
        }
        if (requestedHostTags.isEmpty()) {
            return;
        }
        String[] ipFragments = this.getIpFragments(solrNode);
        if (ipFragments == null) {
            return;
        }
        int ipSnitchCount = IP_SNITCHES.size();
        for (int i = 0; i < ipSnitchCount; ++i) {
            String currentTagValue = ipFragments[i];
            String currentTagKey = IP_SNITCHES.get(ipSnitchCount - i - 1);
            if (!requestedHostTags.contains(currentTagKey)) continue;
            context.getTags().put(currentTagKey, currentTagValue);
        }
    }

    private String[] getIpFragments(String solrNode) {
        String ip;
        String host;
        Matcher hostAndPortMatcher = hostAndPortPattern.matcher(solrNode);
        if (hostAndPortMatcher.find() && (host = hostAndPortMatcher.group(1)) != null && (ip = this.getHostIp(host)) != null) {
            return ip.split(HOST_FRAG_SEPARATOR_REGEX);
        }
        log.warn("Failed to match host IP address from node URL [{}] using regex [{}]", (Object)solrNode, (Object)hostAndPortPattern.pattern());
        return null;
    }

    protected String getHostIp(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.getHostAddress();
        }
        catch (Exception e) {
            log.warn("Failed to get IP address from host [{}], with exception [{}] ", (Object)host, (Object)e);
            return null;
        }
    }
}

