/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ZkStateReader zkStateReader;

    public ReplicaMutator(ZkStateReader reader) {
        this.zkStateReader = reader;
    }

    protected Replica setProperty(Replica replica, String key, String value) {
        assert (key != null);
        assert (value != null);
        if (StringUtils.equalsIgnoreCase((String)replica.getStr(key), (String)value)) {
            return replica;
        }
        LinkedHashMap<String, String> replicaProps = new LinkedHashMap<String, String>(replica.getProperties());
        replicaProps.put(key, value);
        return new Replica(replica.getName(), replicaProps);
    }

    protected Replica unsetProperty(Replica replica, String key) {
        assert (key != null);
        if (!replica.containsKey(key)) {
            return replica;
        }
        LinkedHashMap replicaProps = new LinkedHashMap(replica.getProperties());
        replicaProps.remove(key);
        return new Replica(replica.getName(), replicaProps);
    }

    protected Replica setLeader(Replica replica) {
        return this.setProperty(replica, "leader", "true");
    }

    protected Replica unsetLeader(Replica replica) {
        return this.unsetProperty(replica, "leader");
    }

    protected Replica setState(Replica replica, String state) {
        assert (state != null);
        return this.setProperty(replica, "state", state);
    }

    public ZkWriteCommand addReplicaProperty(ClusterState clusterState, ZkNodeProps message) {
        if (!(CollectionMutator.checkKeyExistence(message, "collection") && CollectionMutator.checkKeyExistence(message, "shard") && CollectionMutator.checkKeyExistence(message, "replica") && CollectionMutator.checkKeyExistence(message, "property") && CollectionMutator.checkKeyExistence(message, "property.value"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer ADDREPLICAPROP requires collection and shard and replica and property and property.value no action taken.");
        }
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        String replicaName = message.getStr("replica");
        String property = message.getStr("property").toLowerCase(Locale.ROOT);
        if (!StringUtils.startsWith((String)property, (String)"property.")) {
            property = "property." + property;
        }
        property = property.toLowerCase(Locale.ROOT);
        String propVal = message.getStr("property.value");
        String shardUnique = message.getStr("shardUnique");
        boolean isUnique = false;
        if (SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(property)) {
            if (StringUtils.isNotBlank((String)shardUnique) && !Boolean.parseBoolean(shardUnique)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer ADDREPLICAPROP for " + property + " cannot have " + "shardUnique" + " set to anything other than" + "'true'. No action taken");
            }
            isUnique = true;
        } else {
            isUnique = Boolean.parseBoolean(shardUnique);
        }
        Replica replica = clusterState.getReplica(collectionName, replicaName);
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection/slice/replica " + collectionName + "/" + sliceName + "/" + replicaName + " no action taken.");
        }
        log.info("Setting property " + property + " with value: " + propVal + " for collection: " + collectionName + ". Full message: " + message);
        if (StringUtils.equalsIgnoreCase((String)replica.getStr(property), (String)propVal)) {
            return ZkStateWriter.NO_OP;
        }
        Map replicas = clusterState.getSlice(collectionName, sliceName).getReplicasCopy();
        if (!isUnique) {
            ((Replica)replicas.get(replicaName)).getProperties().put(property, propVal);
        } else {
            for (Replica rep : replicas.values()) {
                if (rep.getName().equalsIgnoreCase(replicaName)) {
                    rep.getProperties().put(property, propVal);
                    continue;
                }
                rep.getProperties().remove(property);
            }
        }
        Slice newSlice = new Slice(sliceName, replicas, clusterState.getSlice(collectionName, sliceName).shallowCopy());
        DocCollection newCollection = CollectionMutator.updateSlice(collectionName, clusterState.getCollection(collectionName), newSlice);
        return new ZkWriteCommand(collectionName, newCollection);
    }

    public ZkWriteCommand deleteReplicaProperty(ClusterState clusterState, ZkNodeProps message) {
        Replica replica;
        if (!(CollectionMutator.checkKeyExistence(message, "collection") && CollectionMutator.checkKeyExistence(message, "shard") && CollectionMutator.checkKeyExistence(message, "replica") && CollectionMutator.checkKeyExistence(message, "property"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer DELETEREPLICAPROP requires collection and shard and replica and property no action taken.");
        }
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        String replicaName = message.getStr("replica");
        String property = message.getStr("property").toLowerCase(Locale.ROOT);
        if (!StringUtils.startsWith((String)property, (String)"property.")) {
            property = "property." + property;
        }
        if ((replica = clusterState.getReplica(collectionName, replicaName)) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection/slice/replica " + collectionName + "/" + sliceName + "/" + replicaName + " no action taken.");
        }
        log.info("Deleting property " + property + " for collection: " + collectionName + " slice " + sliceName + " replica " + replicaName + ". Full message: " + message);
        String curProp = replica.getStr(property);
        if (curProp == null) {
            return ZkStateWriter.NO_OP;
        }
        log.info("Deleting property " + property + " for collection: " + collectionName + " slice " + sliceName + " replica " + replicaName + ". Full message: " + message);
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(sliceName);
        DocCollection newCollection = SliceMutator.updateReplica(collection, slice, replicaName, this.unsetProperty(replica, property));
        return new ZkWriteCommand(collectionName, newCollection);
    }

    public ZkWriteCommand setState(ClusterState clusterState, ZkNodeProps message) {
        if (Overseer.isLegacy(this.zkStateReader.getClusterProps())) {
            return this.updateState(clusterState, message);
        }
        return this.updateStateNew(clusterState, message);
    }

    protected ZkWriteCommand updateState(ClusterState prevState, ZkNodeProps message) {
        String cName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        Integer numShards = message.getInt("numShards", null);
        log.info("Update state numShards={} message={}", (Object)numShards, (Object)message);
        ArrayList<String> shardNames = new ArrayList<String>();
        ZkWriteCommand writeCommand = null;
        ClusterState newState = null;
        boolean collectionExists = prevState.hasCollection(cName);
        if (!collectionExists && numShards != null) {
            ClusterStateMutator.getShardNames(numShards, shardNames);
            Map createMsg = Utils.makeMap((Object[])new Object[]{"name", cName});
            createMsg.putAll(message.getProperties());
            writeCommand = new ClusterStateMutator(this.zkStateReader).createCollection(prevState, new ZkNodeProps(createMsg));
            DocCollection collection = writeCommand.collection;
            newState = ClusterStateMutator.newState(prevState, cName, collection);
        }
        return this.updateState(newState != null ? newState : prevState, message, cName, numShards, collectionExists);
    }

    private ZkWriteCommand updateState(ClusterState prevState, ZkNodeProps message, String collectionName, Integer numShards, boolean collectionExists) {
        Map<String, Replica> replicas;
        Replica oldReplica;
        String sliceName = message.getStr("shard");
        String coreNodeName = message.getStr("core_node_name");
        if (coreNodeName == null) {
            coreNodeName = ClusterStateMutator.getAssignedCoreNodeName(prevState, message);
            if (coreNodeName != null) {
                log.info("node=" + coreNodeName + " is already registered");
            } else {
                coreNodeName = Assign.assignNode(collectionName, prevState);
            }
            message.getProperties().put("core_node_name", coreNodeName);
        }
        if (sliceName == null && (sliceName = ClusterStateMutator.getAssignedId(prevState, coreNodeName, message)) != null) {
            log.info("shard=" + sliceName + " is already registered");
        }
        if (sliceName == null) {
            if (collectionExists) {
                numShards = prevState.getCollection(collectionName).getSlices().size();
                log.info("Collection already exists with numShards=" + numShards);
            }
            sliceName = Assign.assignShard(collectionName, prevState, numShards);
            log.info("Assigning new node to shard shard=" + sliceName);
        }
        Slice slice = prevState.getSlice(collectionName, sliceName);
        LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>();
        replicaProps.putAll(message.getProperties());
        if (slice != null && (oldReplica = (Replica)slice.getReplicasMap().get(coreNodeName)) != null) {
            if (oldReplica.containsKey("leader")) {
                replicaProps.put("leader", oldReplica.get("leader"));
            }
            for (Map.Entry entry : oldReplica.getProperties().entrySet()) {
                if (!((String)entry.getKey()).startsWith("property.")) continue;
                replicaProps.put((String)entry.getKey(), entry.getValue());
            }
        }
        replicaProps.remove("numShards");
        replicaProps.remove("core_node_name");
        replicaProps.remove("shard");
        replicaProps.remove("collection");
        replicaProps.remove("operation");
        Set entrySet = replicaProps.entrySet();
        ArrayList removeKeys = new ArrayList();
        for (Map.Entry entry : entrySet) {
            if (entry.getValue() != null) continue;
            removeKeys.add(entry.getKey());
        }
        for (String string : removeKeys) {
            replicaProps.remove(string);
        }
        replicaProps.remove("core_node_name");
        String string = (String)replicaProps.remove("shard_range");
        String string2 = (String)replicaProps.remove("shard_state");
        String shardParent = (String)replicaProps.remove("shard_parent");
        Replica replica = new Replica(coreNodeName, replicaProps);
        Map<String, String> sliceProps = null;
        DocCollection collection = prevState.getCollectionOrNull(collectionName);
        if (slice != null) {
            collection = prevState.getCollection(collectionName);
            collection = this.checkAndCompleteShardSplit(prevState, collection, coreNodeName, sliceName, replica);
            slice = collection.getSlice(sliceName);
            sliceProps = slice.getProperties();
            replicas = slice.getReplicasCopy();
        } else {
            replicas = new HashMap(1);
            sliceProps = new HashMap<String, String>();
            sliceProps.put("range", string);
            sliceProps.put("state", string2);
            sliceProps.put("parent", shardParent);
        }
        replicas.put(replica.getName(), replica);
        slice = new Slice(sliceName, replicas, sliceProps);
        DocCollection newCollection = CollectionMutator.updateSlice(collectionName, collection, slice);
        return new ZkWriteCommand(collectionName, newCollection);
    }

    protected ZkWriteCommand updateStateNew(ClusterState clusterState, ZkNodeProps message) {
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String sliceName = message.getStr("shard");
        if (collection == null || sliceName == null) {
            log.error("Invalid collection and slice {}", (Object)message);
            return ZkStateWriter.NO_OP;
        }
        Slice slice = clusterState.getSlice(collection, sliceName);
        if (slice == null) {
            log.error("No such slice exists {}", (Object)message);
            return ZkStateWriter.NO_OP;
        }
        return this.updateState(clusterState, message);
    }

    private DocCollection checkAndCompleteShardSplit(ClusterState prevState, DocCollection collection, String coreNodeName, String sliceName, Replica replica) {
        Slice slice = collection.getSlice(sliceName);
        Map sliceProps = slice.getProperties();
        if (slice.getState() == Slice.State.RECOVERY) {
            log.info("Shard: {} is in recovery state", (Object)sliceName);
            if (replica.getState() == Replica.State.ACTIVE) {
                log.info("Shard: {} is in recovery state and coreNodeName: {} is active", (Object)sliceName, (Object)coreNodeName);
                boolean allActive = true;
                for (Map.Entry entry : slice.getReplicasMap().entrySet()) {
                    if (coreNodeName.equals(entry.getKey()) || ((Replica)entry.getValue()).getState() == Replica.State.ACTIVE) continue;
                    allActive = false;
                    break;
                }
                if (allActive) {
                    log.info("Shard: {} - all replicas are active. Finding status of fellow sub-shards", (Object)sliceName);
                    HashMap allSlicesCopy = new HashMap(collection.getSlicesMap());
                    ArrayList<Object> subShardSlices = new ArrayList<Object>();
                    block1: for (Map.Entry entry : allSlicesCopy.entrySet()) {
                        Object otherSlice;
                        if (sliceName.equals(entry.getKey()) || (otherSlice = (Slice)entry.getValue()).getState() != Slice.State.RECOVERY || slice.getParent() == null || !slice.getParent().equals(otherSlice.getParent())) continue;
                        log.info("Shard: {} - Fellow sub-shard: {} found", (Object)sliceName, (Object)otherSlice.getName());
                        for (Map.Entry sliceEntry : otherSlice.getReplicasMap().entrySet()) {
                            if (((Replica)sliceEntry.getValue()).getState() == Replica.State.ACTIVE) continue;
                            allActive = false;
                            break block1;
                        }
                        log.info("Shard: {} - Fellow sub-shard: {} has all replicas active", (Object)sliceName, (Object)otherSlice.getName());
                        subShardSlices.add(otherSlice);
                    }
                    if (allActive) {
                        log.info("Shard: {} - All replicas across all fellow sub-shards are now ACTIVE. Preparing to switch shard states.", (Object)sliceName);
                        String parentSliceName = (String)sliceProps.remove("parent");
                        HashMap<String, String> propMap = new HashMap<String, String>();
                        propMap.put("operation", "updateshardstate");
                        propMap.put(parentSliceName, Slice.State.INACTIVE.toString());
                        propMap.put(sliceName, Slice.State.ACTIVE.toString());
                        for (Slice slice2 : subShardSlices) {
                            propMap.put(slice2.getName(), Slice.State.ACTIVE.toString());
                        }
                        propMap.put("collection", collection.getName());
                        ZkNodeProps m = new ZkNodeProps(propMap);
                        return new SliceMutator((ZkStateReader)this.zkStateReader).updateShardState((ClusterState)prevState, (ZkNodeProps)m).collection;
                    }
                }
            }
        }
        return collection;
    }
}

