/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.xml.sax.SAXException;

public class ZkCLI {
    private static final String MAKEPATH = "makepath";
    private static final String PUT = "put";
    private static final String PUT_FILE = "putfile";
    private static final String GET = "get";
    private static final String GET_FILE = "getfile";
    private static final String DOWNCONFIG = "downconfig";
    private static final String ZK_CLI_NAME = "ZkCLI";
    private static final String HELP = "help";
    private static final String LINKCONFIG = "linkconfig";
    private static final String CONFDIR = "confdir";
    private static final String CONFNAME = "confname";
    private static final String ZKHOST = "zkhost";
    private static final String RUNZK = "runzk";
    private static final String SOLRHOME = "solrhome";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String UPCONFIG = "upconfig";
    private static final String COLLECTION = "collection";
    private static final String CLEAR = "clear";
    private static final String LIST = "list";
    private static final String CMD = "cmd";
    private static final String CLUSTERPROP = "clusterprop";
    private static final String UPDATEACLS = "updateacls";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, TimeoutException, IOException, ParserConfigurationException, SAXException, KeeperException {
        block55: {
            PosixParser parser = new PosixParser();
            Options options = new Options();
            OptionBuilder.hasArg((boolean)true);
            OptionBuilder.withDescription((String)"cmd to run: bootstrap, upconfig, downconfig, linkconfig, makepath, put, putfile,get,getfile, list, clear, updateacls");
            options.addOption(OptionBuilder.create((String)CMD));
            Option zkHostOption = new Option("z", ZKHOST, true, "ZooKeeper host address");
            options.addOption(zkHostOption);
            Option solrHomeOption = new Option("s", SOLRHOME, true, "for bootstrap, runzk: solrhome location");
            options.addOption(zkHostOption);
            options.addOption(solrHomeOption);
            options.addOption("d", CONFDIR, true, "for upconfig: a directory of configuration files");
            options.addOption("n", CONFNAME, true, "for upconfig, linkconfig: name of the config set");
            options.addOption("c", COLLECTION, true, "for linkconfig: name of the collection");
            options.addOption("r", RUNZK, true, "run zk internally by passing the solr run port - only for clusters on one machine (tests, dev)");
            options.addOption("h", HELP, false, "bring up this help page");
            options.addOption("name", true, "name of the cluster property to set");
            options.addOption("val", true, "value of the cluster to set");
            try {
                CommandLine line = parser.parse(options, args);
                if (line.hasOption(HELP) || !line.hasOption(ZKHOST) || !line.hasOption(CMD)) {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp(ZK_CLI_NAME, options);
                    System.out.println("Examples:");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd bootstrap -solrhome /opt/solr");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd upconfig -confdir /opt/solr/collection1/conf -confname myconf");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd downconfig -confdir /opt/solr/collection1/conf -confname myconf");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd linkconfig -collection collection1 -confname myconf");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd makepath /apache/solr");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd put /solr.conf 'conf data'");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd putfile /solr.xml /User/myuser/solr/solr.xml");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd get /solr.xml");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd getfile /solr.xml solr.xml.file");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd clear /solr");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd list");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd clusterprop -name urlScheme -val https");
                    System.out.println("zkcli.sh -zkhost localhost:9983 -cmd updateacls /solr");
                    return;
                }
                String zkServerAddress = line.getOptionValue(ZKHOST);
                String solrHome = line.getOptionValue(SOLRHOME);
                String solrPort = null;
                if (line.hasOption(RUNZK)) {
                    if (!line.hasOption(SOLRHOME)) {
                        System.out.println("-solrhome is required for runzk");
                        System.exit(1);
                    }
                    solrPort = line.getOptionValue(RUNZK);
                }
                SolrZkServer zkServer = null;
                if (solrPort != null) {
                    zkServer = new SolrZkServer("true", null, solrHome + "/zoo_data", solrHome, Integer.parseInt(solrPort));
                    zkServer.parseConfig();
                    zkServer.start();
                }
                SolrZkClient zkClient = null;
                zkClient = new SolrZkClient(zkServerAddress, 30000, 30000, () -> {});
                if (line.getOptionValue(CMD).equalsIgnoreCase(BOOTSTRAP)) {
                    if (!line.hasOption(SOLRHOME)) {
                        System.out.println("-solrhome is required for bootstrap");
                        System.exit(1);
                    }
                    CoreContainer cc = new CoreContainer(solrHome);
                    if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                        System.out.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                        System.exit(1);
                    }
                    ZkController.bootstrapConf(zkClient, cc, solrHome);
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(UPCONFIG)) {
                    if (!line.hasOption(CONFDIR) || !line.hasOption(CONFNAME)) {
                        System.out.println("-confdir and -confname are required for upconfig");
                        System.exit(1);
                    }
                    String confDir = line.getOptionValue(CONFDIR);
                    String confName = line.getOptionValue(CONFNAME);
                    if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                        System.out.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                        System.exit(1);
                    }
                    ZkConfigManager configManager = new ZkConfigManager(zkClient);
                    configManager.uploadConfigDir(Paths.get(confDir, new String[0]), confName);
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(DOWNCONFIG)) {
                    if (!line.hasOption(CONFDIR) || !line.hasOption(CONFNAME)) {
                        System.out.println("-confdir and -confname are required for downconfig");
                        System.exit(1);
                    }
                    String confDir = line.getOptionValue(CONFDIR);
                    String confName = line.getOptionValue(CONFNAME);
                    ZkConfigManager configManager = new ZkConfigManager(zkClient);
                    configManager.downloadConfigDir(confName, Paths.get(confDir, new String[0]));
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(LINKCONFIG)) {
                    if (!line.hasOption(COLLECTION) || !line.hasOption(CONFNAME)) {
                        System.out.println("-collection and -confname are required for linkconfig");
                        System.exit(1);
                    }
                    String collection = line.getOptionValue(COLLECTION);
                    String confName = line.getOptionValue(CONFNAME);
                    ZkController.linkConfSet(zkClient, collection, confName);
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(LIST)) {
                    zkClient.printLayoutToStdOut();
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(CLEAR)) {
                    List arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        System.out.println("-clear requires one arg - the path to clear");
                        System.exit(1);
                    }
                    zkClient.clean(arglist.get(0).toString());
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(MAKEPATH)) {
                    List arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        System.out.println("-makepath requires one arg - the path to make");
                        System.exit(1);
                    }
                    zkClient.makePath(arglist.get(0).toString(), true);
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(PUT)) {
                    String path;
                    List arglist = line.getArgList();
                    if (arglist.size() != 2) {
                        System.out.println("-put requires two args - the path to create and the data string");
                        System.exit(1);
                    }
                    if (zkClient.exists(path = arglist.get(0).toString(), true).booleanValue()) {
                        zkClient.setData(path, arglist.get(1).toString().getBytes(StandardCharsets.UTF_8), true);
                    } else {
                        zkClient.create(path, arglist.get(1).toString().getBytes(StandardCharsets.UTF_8), CreateMode.PERSISTENT, true);
                    }
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(PUT_FILE)) {
                    List arglist = line.getArgList();
                    if (arglist.size() != 2) {
                        System.out.println("-putfile requires two args - the path to create in ZK and the path to the local file");
                        System.exit(1);
                    }
                    String path = arglist.get(0).toString();
                    FileInputStream is = new FileInputStream(arglist.get(1).toString());
                    try {
                        if (zkClient.exists(path, true).booleanValue()) {
                            zkClient.setData(path, IOUtils.toByteArray((InputStream)is), true);
                        } else {
                            zkClient.create(path, IOUtils.toByteArray((InputStream)is), CreateMode.PERSISTENT, true);
                        }
                        break block55;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(GET)) {
                    List arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        System.out.println("-get requires one arg - the path to get");
                        System.exit(1);
                    }
                    byte[] data = zkClient.getData(arglist.get(0).toString(), null, null, true);
                    System.out.println(new String(data, StandardCharsets.UTF_8));
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(GET_FILE)) {
                    List arglist = line.getArgList();
                    if (arglist.size() != 2) {
                        System.out.println("-getfilerequires two args - the path to get and the file to save it to");
                        System.exit(1);
                    }
                    byte[] data = zkClient.getData(arglist.get(0).toString(), null, null, true);
                    FileUtils.writeByteArrayToFile((File)new File(arglist.get(1).toString()), (byte[])data);
                    break block55;
                }
                if (line.getOptionValue(CMD).equals(UPDATEACLS)) {
                    List arglist = line.getArgList();
                    if (arglist.size() != 1) {
                        System.out.println("-updateacls requires one arg - the path to update");
                        System.exit(1);
                    }
                    zkClient.updateACLs(arglist.get(0).toString());
                    break block55;
                }
                if (line.getOptionValue(CMD).equalsIgnoreCase(CLUSTERPROP)) {
                    if (!line.hasOption("name")) {
                        System.out.println("-name is required for clusterprop");
                    }
                    String propertyName = line.getOptionValue("name");
                    String propertyValue = line.getOptionValue("val");
                    try (ZkStateReader reader = new ZkStateReader(zkClient);){
                        reader.setClusterProperty(propertyName, propertyValue);
                        break block55;
                    }
                }
                System.out.println("Unknown command " + line.getOptionValue(CMD) + ". Use -h to get help.");
                System.exit(1);
                break block55;
                finally {
                    if (solrPort != null) {
                        zkServer.stop();
                    }
                    if (zkClient != null) {
                        zkClient.close();
                    }
                }
            }
            catch (ParseException exp) {
                System.out.println("Unexpected exception:" + exp.getMessage());
            }
        }
    }
}

