/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.util.stats.TimerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerTaskQueue
extends DistributedQueue {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String response_prefix = "qnr-";

    public OverseerTaskQueue(SolrZkClient zookeeper, String dir) {
        this(zookeeper, dir, new Overseer.Stats());
    }

    public OverseerTaskQueue(SolrZkClient zookeeper, String dir, Overseer.Stats stats) {
        super(zookeeper, dir, stats);
    }

    public boolean containsTaskWithRequestId(String requestIdKey, String requestId) throws KeeperException, InterruptedException {
        List childNames = this.zookeeper.getChildren(this.dir, null, true);
        this.stats.setQueueLength(childNames.size());
        for (String childName : childNames) {
            if (childName == null) continue;
            try {
                ZkNodeProps message;
                byte[] data = this.zookeeper.getData(this.dir + "/" + childName, null, null, true);
                if (data == null || !(message = ZkNodeProps.load((byte[])data)).containsKey(requestIdKey)) continue;
                LOG.debug(">>>> {}", message.get(requestIdKey));
                if (!message.get(requestIdKey).equals(requestId)) continue;
                return true;
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] remove(QueueEvent event) throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_remove_event");
        try {
            String path = event.getId();
            String responsePath = this.dir + "/" + "qnr-" + path.substring(path.lastIndexOf("-") + 1);
            if (this.zookeeper.exists(responsePath, true).booleanValue()) {
                this.zookeeper.setData(responsePath, event.getBytes(), true);
            } else {
                LOG.info("Response ZK path: " + responsePath + " doesn't exist." + "  Requestor may have disconnected from ZooKeeper");
            }
            byte[] data = this.zookeeper.getData(path, null, null, true);
            this.zookeeper.delete(path, -1, true);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    private String createData(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.create(path, data, mode, true);
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(this.dir, new byte[0], CreateMode.PERSISTENT, true);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueEvent offer(byte[] data, long timeout) throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_offer");
        try {
            String watchID = this.createData(this.dir + "/" + "qnr-", null, CreateMode.EPHEMERAL_SEQUENTIAL);
            Object lock = new Object();
            LatchWatcher watcher = new LatchWatcher(lock);
            Stat stat = this.zookeeper.exists(watchID, (Watcher)watcher, true);
            this.createData(this.dir + "/" + "qn-" + watchID.substring(watchID.lastIndexOf("-") + 1), data, CreateMode.PERSISTENT);
            Object object = lock;
            synchronized (object) {
                if (stat != null && watcher.getWatchedEvent() == null) {
                    watcher.await(timeout);
                }
            }
            byte[] bytes = this.zookeeper.getData(watchID, null, null, true);
            QueueEvent event = new QueueEvent(watchID, bytes, watcher.getWatchedEvent());
            this.zookeeper.delete(watchID, -1, true);
            QueueEvent queueEvent = event;
            return queueEvent;
        }
        finally {
            time.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueueEvent> peekTopN(int n, Set<String> excludeSet, long waitMillis) throws KeeperException, InterruptedException {
        ArrayList<QueueEvent> topN = new ArrayList<QueueEvent>();
        LOG.debug("Peeking for top {} elements. ExcludeSet: {}", (Object)n, excludeSet);
        TimerContext time = null;
        time = waitMillis == Long.MAX_VALUE ? this.stats.time(this.dir + "_peekTopN_wait_forever") : this.stats.time(this.dir + "_peekTopN_wait" + waitMillis);
        try {
            Object object;
            for (String headNode : this.getChildren(waitMillis)) {
                if (topN.size() < n) {
                    try {
                        String id = this.dir + "/" + headNode;
                        if (excludeSet.contains(id)) continue;
                        QueueEvent queueEvent = new QueueEvent(id, this.zookeeper.getData(this.dir + "/" + headNode, null, null, true), null);
                        topN.add(queueEvent);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                    continue;
                }
                if (topN.size() < 1) continue;
                OverseerTaskQueue.printQueueEventsListElementIds(topN);
                ArrayList<QueueEvent> arrayList = topN;
                return arrayList;
            }
            if (topN.size() > 0) {
                OverseerTaskQueue.printQueueEventsListElementIds(topN);
                object = topN;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            time.stop();
        }
    }

    private static void printQueueEventsListElementIds(ArrayList<QueueEvent> topN) {
        if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("[");
            for (QueueEvent queueEvent : topN) {
                sb.append(queueEvent.getId()).append(", ");
            }
            sb.append("]");
            LOG.debug("Returning topN elements: {}", (Object)sb.toString());
        }
    }

    public String getTailId() throws KeeperException, InterruptedException {
        TreeSet<String> orderedChildren = this.fetchZkChildren(null);
        for (String headNode : orderedChildren.descendingSet()) {
            if (headNode == null) continue;
            try {
                QueueEvent queueEvent = new QueueEvent(this.dir + "/" + headNode, this.zookeeper.getData(this.dir + "/" + headNode, null, null, true), null);
                return queueEvent.getId();
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
        }
        return null;
    }

    public static class QueueEvent {
        private WatchedEvent event = null;
        private String id;
        private byte[] bytes;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueEvent other = (QueueEvent)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        QueueEvent(String id, byte[] bytes, WatchedEvent event) {
            this.id = id;
            this.bytes = bytes;
            this.event = event;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }

    private final class LatchWatcher
    implements Watcher {
        private final Object lock;
        private WatchedEvent event;
        private Watcher.Event.EventType latchEventType;

        LatchWatcher(Object lock) {
            this(lock, null);
        }

        LatchWatcher(Watcher.Event.EventType eventType) {
            this(new Object(), eventType);
        }

        LatchWatcher(Object lock, Watcher.Event.EventType eventType) {
            this.lock = lock;
            this.latchEventType = eventType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            LOG.info("{} fired on path {} state {} latchEventType {}", new Object[]{event.getType(), event.getPath(), event.getState(), this.latchEventType});
            if (this.latchEventType == null || event.getType() == this.latchEventType) {
                Object object = this.lock;
                synchronized (object) {
                    this.event = event;
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(long timeout) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                if (this.event != null) {
                    return;
                }
                this.lock.wait(timeout);
            }
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }
}

