/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.OverseerAutoReplicaFailoverThread;
import org.apache.solr.cloud.OverseerCollectionConfigSetProcessor;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.SizeLimitedDistributedMap;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.NodeMutator;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.overseer.ReplicaMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.stats.Clock;
import org.apache.solr.util.stats.Timer;
import org.apache.solr.util.stats.TimerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer
implements Closeable {
    public static final String QUEUE_OPERATION = "operation";
    public static final int STATE_UPDATE_DELAY = 1500;
    public static final int NUM_RESPONSES_TO_STORE = 10000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OverseerThread ccThread;
    private OverseerThread updaterThread;
    private OverseerThread arfoThread;
    private final ZkStateReader reader;
    private final ShardHandler shardHandler;
    private final UpdateShardHandler updateShardHandler;
    private final String adminPath;
    private OverseerCollectionConfigSetProcessor overseerCollectionConfigSetProcessor;
    private ZkController zkController;
    private Stats stats;
    private String id;
    private boolean closed;
    private CloudConfig config;

    public Overseer(ShardHandler shardHandler, UpdateShardHandler updateShardHandler, String adminPath, ZkStateReader reader, ZkController zkController, CloudConfig config) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.updateShardHandler = updateShardHandler;
        this.adminPath = adminPath;
        this.zkController = zkController;
        this.stats = new Stats();
        this.config = config;
    }

    public synchronized void start(String id) {
        this.id = id;
        this.closed = false;
        this.doClose();
        this.stats = new Stats();
        log.info("Overseer (id=" + id + ") starting");
        Overseer.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        this.updaterThread = new OverseerThread(tg, new ClusterStateUpdater(this.reader, id, this.stats), "OverseerStateUpdate-" + id);
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        OverseerNodePrioritizer overseerPrioritizer = new OverseerNodePrioritizer(this.reader, this.adminPath, this.shardHandler.getShardHandlerFactory());
        this.overseerCollectionConfigSetProcessor = new OverseerCollectionConfigSetProcessor(this.reader, id, this.shardHandler, this.adminPath, this.stats, this, overseerPrioritizer);
        this.ccThread = new OverseerThread(ccTg, this.overseerCollectionConfigSetProcessor, "OverseerCollectionConfigSetProcessor-" + id);
        this.ccThread.setDaemon(true);
        ThreadGroup ohcfTg = new ThreadGroup("Overseer Hdfs SolrCore Failover Thread.");
        OverseerAutoReplicaFailoverThread autoReplicaFailoverThread = new OverseerAutoReplicaFailoverThread(this.config, this.reader, this.updateShardHandler);
        this.arfoThread = new OverseerThread(ohcfTg, autoReplicaFailoverThread, "OverseerHdfsCoreFailoverThread-" + id);
        this.arfoThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
        this.arfoThread.start();
    }

    public Stats getStats() {
        return this.stats;
    }

    ZkController getZkController() {
        return this.zkController;
    }

    public synchronized OverseerThread getUpdaterThread() {
        return this.updaterThread;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        log.info("Overseer (id=" + this.id + ") closing");
        this.doClose();
        this.closed = true;
    }

    private void doClose() {
        if (this.updaterThread != null) {
            IOUtils.closeQuietly((Closeable)this.updaterThread);
            this.updaterThread.interrupt();
        }
        if (this.ccThread != null) {
            IOUtils.closeQuietly((Closeable)this.ccThread);
            this.ccThread.interrupt();
        }
        if (this.arfoThread != null) {
            IOUtils.closeQuietly((Closeable)this.arfoThread);
            this.arfoThread.interrupt();
        }
        this.updaterThread = null;
        this.ccThread = null;
        this.arfoThread = null;
    }

    public static DistributedQueue getStateUpdateQueue(SolrZkClient zkClient) {
        return Overseer.getStateUpdateQueue(zkClient, new Stats());
    }

    static DistributedQueue getStateUpdateQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue", zkStats);
    }

    static DistributedQueue getInternalWorkQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue-work", zkStats);
    }

    static DistributedMap getRunningMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedMap(zkClient, "/overseer/collection-map-running");
    }

    static DistributedMap getCompletedMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new SizeLimitedDistributedMap(zkClient, "/overseer/collection-map-completed", 10000);
    }

    static DistributedMap getFailureMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new SizeLimitedDistributedMap(zkClient, "/overseer/collection-map-failure", 10000);
    }

    static OverseerTaskQueue getCollectionQueue(SolrZkClient zkClient) {
        return Overseer.getCollectionQueue(zkClient, new Stats());
    }

    static OverseerTaskQueue getCollectionQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new OverseerTaskQueue(zkClient, "/overseer/collection-queue-work", zkStats);
    }

    static OverseerTaskQueue getConfigSetQueue(SolrZkClient zkClient) {
        return Overseer.getConfigSetQueue(zkClient, new Stats());
    }

    static OverseerTaskQueue getConfigSetQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return Overseer.getCollectionQueue(zkClient, zkStats);
    }

    private static void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isLegacy(Map clusterProps) {
        return !"false".equals(clusterProps.get("legacyCloud"));
    }

    public ZkStateReader getZkStateReader() {
        return this.reader;
    }

    public static class FailedOp {
        public final ZkNodeProps req;
        public final SolrResponse resp;

        public FailedOp(ZkNodeProps req, SolrResponse resp) {
            this.req = req;
            this.resp = resp;
        }
    }

    public static class Stat {
        public final AtomicInteger success = new AtomicInteger();
        public final AtomicInteger errors = new AtomicInteger();
        public final Timer requestTime = new Timer(TimeUnit.MILLISECONDS, TimeUnit.MINUTES, Clock.defaultClock());
        public final LinkedList<FailedOp> failureDetails = new LinkedList();
    }

    public static class Stats {
        static final int MAX_STORED_FAILURES = 10;
        final Map<String, Stat> stats = new ConcurrentHashMap<String, Stat>();
        private volatile int queueLength;

        public Map<String, Stat> getStats() {
            return this.stats;
        }

        public int getSuccessCount(String operation) {
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            return stat == null ? 0 : stat.success.get();
        }

        public int getErrorCount(String operation) {
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            return stat == null ? 0 : stat.errors.get();
        }

        public void success(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            stat.success.incrementAndGet();
        }

        public void error(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            stat.errors.incrementAndGet();
        }

        public TimerContext time(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            return stat.requestTime.time();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeFailureDetails(String operation, ZkNodeProps request, SolrResponse resp) {
            LinkedList<FailedOp> failedOps;
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
            synchronized (linkedList) {
                if (failedOps.size() >= 10) {
                    failedOps.removeFirst();
                }
                failedOps.addLast(new FailedOp(request, resp));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FailedOp> getFailureDetails(String operation) {
            LinkedList<FailedOp> failedOps;
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            if (stat == null || stat.failureDetails.isEmpty()) {
                return null;
            }
            LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
            synchronized (linkedList) {
                ArrayList<FailedOp> ret = new ArrayList<FailedOp>(failedOps);
                return ret;
            }
        }

        public int getQueueLength() {
            return this.queueLength;
        }

        public void setQueueLength(int queueLength) {
            this.queueLength = queueLength;
        }

        public void clear() {
            this.stats.clear();
        }
    }

    class OverseerThread
    extends Thread
    implements Closeable {
        protected volatile boolean isClosed;
        private Closeable thread;

        public OverseerThread(ThreadGroup tg, Closeable thread) {
            super(tg, (Runnable)((Object)thread));
            this.thread = thread;
        }

        public OverseerThread(ThreadGroup ccTg, Closeable thread, String name) {
            super(ccTg, (Runnable)((Object)thread), name);
            this.thread = thread;
        }

        @Override
        public void close() throws IOException {
            this.thread.close();
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }

    private class SliceReplica {
        private Slice slice;
        private Replica replica;

        SliceReplica(Slice slice, Replica replica) {
            this.slice = slice;
            this.replica = replica;
        }
    }

    private class ExclusiveSliceProperty {
        private ClusterState clusterState;
        private final boolean onlyActiveNodes;
        private final String property;
        private final DocCollection collection;
        private final String collectionName;
        private final Map<String, List<SliceReplica>> nodesHostingReplicas = new HashMap<String, List<SliceReplica>>();
        private final Map<String, List<SliceReplica>> nodesHostingProp = new HashMap<String, List<SliceReplica>>();
        Set<String> shardsNeedingHosts = new HashSet<String>();
        Map<String, Slice> changedSlices = new HashMap<String, Slice>();
        private int origMaxPropPerNode = 0;
        private int origModulo = 0;
        private int tmpMaxPropPerNode = 0;
        private int tmpModulo = 0;
        Random rand = new Random();
        private int assigned = 0;

        ExclusiveSliceProperty(ClusterState clusterState, ZkNodeProps message) {
            this.clusterState = clusterState;
            String tmp = message.getStr("property");
            if (!StringUtils.startsWith((String)tmp, (String)"property.")) {
                tmp = "property." + tmp;
            }
            this.property = tmp.toLowerCase(Locale.ROOT);
            this.collectionName = message.getStr("collection");
            if (StringUtils.isBlank((String)this.collectionName) || StringUtils.isBlank((String)this.property)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer '" + message.getStr(Overseer.QUEUE_OPERATION) + "'  requires both the '" + "collection" + "' and '" + "property" + "' parameters. No action taken ");
            }
            Boolean shardUnique = Boolean.parseBoolean(message.getStr("shardUnique"));
            if (!shardUnique.booleanValue() && !SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(this.property)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Balancing properties amongst replicas in a slice requires that the property be a pre-defined property (e.g. 'preferredLeader') or that 'shardUnique' be set to 'true'  Property: " + this.property + " shardUnique: " + Boolean.toString(shardUnique));
            }
            this.collection = clusterState.getCollection(this.collectionName);
            if (this.collection == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection ' " + this.collectionName + "' for overseer operation '" + message.getStr(Overseer.QUEUE_OPERATION) + "'. No action taken.");
            }
            this.onlyActiveNodes = Boolean.parseBoolean(message.getStr("onlyactivenodes", "true"));
        }

        private DocCollection getDocCollection() {
            return this.collection;
        }

        private boolean isActive(Replica replica) {
            return replica.getState() == Replica.State.ACTIVE;
        }

        private boolean collectCurrentPropStats() {
            int maxAssigned = 0;
            HashSet<String> allHosts = new HashSet<String>();
            for (Slice slice : this.collection.getSlices()) {
                boolean sliceHasProp = false;
                for (Replica replica : slice.getReplicas()) {
                    if (this.onlyActiveNodes && !this.isActive(replica)) {
                        if (!StringUtils.isNotBlank((String)replica.getStr(this.property))) continue;
                        this.removeProp(slice, replica.getName());
                        continue;
                    }
                    allHosts.add(replica.getNodeName());
                    String nodeName = replica.getNodeName();
                    if (StringUtils.isNotBlank((String)replica.getStr(this.property))) {
                        if (sliceHasProp) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'" + CollectionParams.CollectionAction.BALANCESHARDUNIQUE + "' should only be called for properties that have at most one member " + "in any slice with the property set. No action taken.");
                        }
                        if (!this.nodesHostingProp.containsKey(nodeName)) {
                            this.nodesHostingProp.put(nodeName, new ArrayList());
                        }
                        this.nodesHostingProp.get(nodeName).add(new SliceReplica(slice, replica));
                        ++this.assigned;
                        maxAssigned = Math.max(maxAssigned, this.nodesHostingProp.get(nodeName).size());
                        sliceHasProp = true;
                    }
                    if (!this.nodesHostingReplicas.containsKey(nodeName)) {
                        this.nodesHostingReplicas.put(nodeName, new ArrayList());
                    }
                    this.nodesHostingReplicas.get(nodeName).add(new SliceReplica(slice, replica));
                }
            }
            this.origMaxPropPerNode = this.collection.getSlices().size() / allHosts.size();
            this.origModulo = this.collection.getSlices().size() % allHosts.size();
            if (this.origModulo > 0) {
                ++this.origMaxPropPerNode;
            }
            if (this.assigned != this.collection.getSlices().size()) {
                return true;
            }
            int counter = this.origModulo;
            for (List<SliceReplica> list : this.nodesHostingProp.values()) {
                if (list.size() != this.origMaxPropPerNode) continue;
                --counter;
            }
            return counter != 0;
        }

        private void removeSliceAlreadyHostedFromPossibles(String sliceName) {
            for (Map.Entry<String, List<SliceReplica>> entReplica : this.nodesHostingReplicas.entrySet()) {
                ListIterator<SliceReplica> iter = entReplica.getValue().listIterator();
                while (iter.hasNext()) {
                    SliceReplica sr = iter.next();
                    if (!sr.slice.getName().equals(sliceName)) continue;
                    iter.remove();
                }
            }
        }

        private void balanceUnassignedReplicas() {
            this.tmpMaxPropPerNode = this.origMaxPropPerNode;
            this.tmpModulo = this.origModulo;
            while (this.shardsNeedingHosts.size() > 0) {
                String nodeName = "";
                int minSize = Integer.MAX_VALUE;
                SliceReplica srToChange = null;
                for (String slice : this.shardsNeedingHosts) {
                    for (Map.Entry<String, List<SliceReplica>> ent : this.nodesHostingReplicas.entrySet()) {
                        if (srToChange == null && ent.getValue().size() > 0) {
                            srToChange = ent.getValue().get(0);
                        }
                        ListIterator<SliceReplica> iter = ent.getValue().listIterator();
                        while (iter.hasNext()) {
                            SliceReplica sr = iter.next();
                            if (!StringUtils.equals((String)slice, (String)sr.slice.getName())) continue;
                            if (!this.nodesHostingProp.containsKey(ent.getKey())) {
                                this.nodesHostingProp.put(ent.getKey(), new ArrayList());
                            }
                            if (minSize <= this.nodesHostingReplicas.get(ent.getKey()).size() || this.nodesHostingProp.get(ent.getKey()).size() >= this.tmpMaxPropPerNode) continue;
                            minSize = this.nodesHostingReplicas.get(ent.getKey()).size();
                            srToChange = sr;
                            nodeName = ent.getKey();
                        }
                    }
                }
                this.shardsNeedingHosts.remove(srToChange.slice.getName());
                if (!this.nodesHostingProp.containsKey(nodeName)) {
                    this.nodesHostingProp.put(nodeName, new ArrayList());
                }
                this.nodesHostingProp.get(nodeName).add(srToChange);
                this.adjustLimits(this.nodesHostingProp.get(nodeName));
                this.removeSliceAlreadyHostedFromPossibles(srToChange.slice.getName());
                this.addProp(srToChange.slice, srToChange.replica.getName());
            }
        }

        private void adjustLimits(List<SliceReplica> changeList) {
            if (changeList.size() == this.tmpMaxPropPerNode) {
                if (this.tmpModulo < 0) {
                    return;
                }
                --this.tmpModulo;
                if (this.tmpModulo == 0) {
                    --this.tmpMaxPropPerNode;
                    --this.tmpModulo;
                }
            }
        }

        private void removeOverallocatedReplicas() {
            this.tmpMaxPropPerNode = this.origMaxPropPerNode;
            this.tmpModulo = this.origModulo;
            for (Map.Entry<String, List<SliceReplica>> ent : this.nodesHostingProp.entrySet()) {
                while (ent.getValue().size() > this.tmpMaxPropPerNode) {
                    ent.getValue().remove(this.rand.nextInt(ent.getValue().size()));
                }
                this.adjustLimits(ent.getValue());
            }
        }

        private void removeProp(Slice origSlice, String replicaName) {
            this.getReplicaFromChanged(origSlice, replicaName).getProperties().remove(this.property);
        }

        private void addProp(Slice origSlice, String replicaName) {
            this.getReplicaFromChanged(origSlice, replicaName).getProperties().put(this.property, "true");
        }

        private Replica getReplicaFromChanged(Slice origSlice, String replicaName) {
            Replica replica;
            Slice newSlice = this.changedSlices.get(origSlice.getName());
            if (newSlice != null) {
                replica = newSlice.getReplica(replicaName);
            } else {
                newSlice = new Slice(origSlice.getName(), origSlice.getReplicasCopy(), origSlice.shallowCopy());
                this.changedSlices.put(origSlice.getName(), newSlice);
                replica = newSlice.getReplica(replicaName);
            }
            if (replica == null) {
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Should have been able to find replica '" + replicaName + "' in slice '" + origSlice.getName() + "'. No action taken");
            }
            return replica;
        }

        private boolean balanceProperty() {
            if (!this.collectCurrentPropStats()) {
                return false;
            }
            this.removeOverallocatedReplicas();
            for (Map.Entry<String, List<SliceReplica>> entProp : this.nodesHostingProp.entrySet()) {
                for (SliceReplica srHosting : entProp.getValue()) {
                    this.removeSliceAlreadyHostedFromPossibles(srHosting.slice.getName());
                }
            }
            for (Map.Entry<String, List<SliceReplica>> ent : this.nodesHostingReplicas.entrySet()) {
                ListIterator<SliceReplica> iter = ent.getValue().listIterator();
                while (iter.hasNext()) {
                    SliceReplica sr = iter.next();
                    this.shardsNeedingHosts.add(sr.slice.getName());
                }
            }
            this.balanceUnassignedReplicas();
            for (Slice newSlice : this.changedSlices.values()) {
                DocCollection docCollection = CollectionMutator.updateSlice(this.collectionName, this.clusterState.getCollection(this.collectionName), newSlice);
                this.clusterState = ClusterStateMutator.newState(this.clusterState, this.collectionName, docCollection);
            }
            return true;
        }
    }

    private class ClusterStateUpdater
    implements Runnable,
    Closeable {
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final DistributedQueue stateUpdateQueue;
        private final DistributedQueue workQueue;
        private final DistributedMap runningMap;
        private final DistributedMap completedMap;
        private final DistributedMap failureMap;
        private final Stats zkStats;
        private boolean isClosed = false;

        public ClusterStateUpdater(ZkStateReader reader, String myId, Stats zkStats) {
            this.zkClient = reader.getZkClient();
            this.zkStats = zkStats;
            this.stateUpdateQueue = Overseer.getStateUpdateQueue(this.zkClient, zkStats);
            this.workQueue = Overseer.getInternalWorkQueue(this.zkClient, zkStats);
            this.failureMap = Overseer.getFailureMap(this.zkClient);
            this.runningMap = Overseer.getRunningMap(this.zkClient);
            this.completedMap = Overseer.getCompletedMap(this.zkClient);
            this.myId = myId;
            this.reader = reader;
        }

        public Stats getStateUpdateQueueStats() {
            return this.stateUpdateQueue.getStats();
        }

        public Stats getWorkQueueStats() {
            return this.workQueue.getStats();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClusterState processQueueItem(ZkNodeProps message, ClusterState clusterState, ZkStateWriter zkStateWriter, boolean enableBatching, ZkStateWriter.ZkWriteCallback callback) throws Exception {
            String operation = message.getStr(Overseer.QUEUE_OPERATION);
            List<ZkWriteCommand> zkWriteCommands = null;
            TimerContext timerContext = Overseer.this.stats.time(operation);
            try {
                zkWriteCommands = this.processMessage(clusterState, message, operation);
                Overseer.this.stats.success(operation);
            }
            catch (Exception e) {
                log.error("Overseer could not process the current clusterstate state update message, skipping the message.", (Throwable)e);
                Overseer.this.stats.error(operation);
            }
            finally {
                timerContext.stop();
            }
            if (zkWriteCommands != null) {
                for (ZkWriteCommand zkWriteCommand : zkWriteCommands) {
                    clusterState = zkStateWriter.enqueueUpdate(clusterState, zkWriteCommand, callback);
                }
                if (!enableBatching) {
                    clusterState = zkStateWriter.writePendingUpdates();
                }
            }
            return clusterState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIfIamStillLeader() {
            byte[] data;
            if (Overseer.this.zkController != null && Overseer.this.zkController.getCoreContainer().isShutDown()) {
                return;
            }
            org.apache.zookeeper.data.Stat stat = new org.apache.zookeeper.data.Stat();
            String path = "/overseer_elect/leader";
            try {
                data = this.zkClient.getData(path, null, stat, true);
            }
            catch (Exception e) {
                log.error("could not read the data", (Throwable)e);
                return;
            }
            try {
                Map m = (Map)Utils.fromJSON((byte[])data);
                String id = (String)m.get("id");
                if (Overseer.this.overseerCollectionConfigSetProcessor.getId().equals(id)) {
                    try {
                        log.info("I'm exiting , but I'm still the leader");
                        this.zkClient.delete(path, stat.getVersion(), true);
                    }
                    catch (KeeperException.BadVersionException badVersionException) {
                    }
                    catch (Exception e) {
                        log.error("Could not delete my leader node ", (Throwable)e);
                    }
                } else {
                    log.info("somebody else has already taken up the overseer position");
                }
            }
            finally {
                try {
                    if (Overseer.this.zkController != null && !Overseer.this.zkController.getCoreContainer().isShutDown()) {
                        Overseer.this.zkController.rejoinOverseerElection(null, false);
                    }
                }
                catch (Exception e) {
                    log.warn("Unable to rejoinElection ", (Throwable)e);
                }
            }
        }

        private List<ZkWriteCommand> processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            block26: {
                block25: {
                    CollectionParams.CollectionAction collectionAction = CollectionParams.CollectionAction.get((String)operation);
                    if (collectionAction == null) break block25;
                    switch (collectionAction) {
                        case CREATE: {
                            return Collections.singletonList(new ClusterStateMutator(Overseer.this.getZkStateReader()).createCollection(clusterState, message));
                        }
                        case DELETE: {
                            return Collections.singletonList(new ClusterStateMutator(Overseer.this.getZkStateReader()).deleteCollection(clusterState, message));
                        }
                        case CREATESHARD: {
                            return Collections.singletonList(new CollectionMutator(Overseer.this.getZkStateReader()).createShard(clusterState, message));
                        }
                        case DELETESHARD: {
                            return Collections.singletonList(new CollectionMutator(Overseer.this.getZkStateReader()).deleteShard(clusterState, message));
                        }
                        case ADDREPLICA: {
                            return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).addReplica(clusterState, message));
                        }
                        case ADDREPLICAPROP: {
                            return Collections.singletonList(new ReplicaMutator(Overseer.this.getZkStateReader()).addReplicaProperty(clusterState, message));
                        }
                        case DELETEREPLICAPROP: {
                            return Collections.singletonList(new ReplicaMutator(Overseer.this.getZkStateReader()).deleteReplicaProperty(clusterState, message));
                        }
                        case BALANCESHARDUNIQUE: {
                            ExclusiveSliceProperty dProp = new ExclusiveSliceProperty(clusterState, message);
                            if (dProp.balanceProperty()) {
                                String collName = message.getStr("collection");
                                return Collections.singletonList(new ZkWriteCommand(collName, dProp.getDocCollection()));
                            }
                            break block26;
                        }
                        case MODIFYCOLLECTION: {
                            CollectionsHandler.verifyRuleParams(Overseer.this.zkController.getCoreContainer(), message.getProperties());
                            return Collections.singletonList(new CollectionMutator(this.reader).modifyCollection(clusterState, message));
                        }
                        case MIGRATESTATEFORMAT: {
                            return Collections.singletonList(new ClusterStateMutator(this.reader).migrateStateFormat(clusterState, message));
                        }
                        default: {
                            throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                        }
                    }
                }
                OverseerAction overseerAction = OverseerAction.get(operation);
                if (overseerAction == null) {
                    throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                }
                switch (overseerAction) {
                    case STATE: {
                        return Collections.singletonList(new ReplicaMutator(Overseer.this.getZkStateReader()).setState(clusterState, message));
                    }
                    case LEADER: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).setShardLeader(clusterState, message));
                    }
                    case DELETECORE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).removeReplica(clusterState, message));
                    }
                    case ADDROUTINGRULE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).addRoutingRule(clusterState, message));
                    }
                    case REMOVEROUTINGRULE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).removeRoutingRule(clusterState, message));
                    }
                    case UPDATESHARDSTATE: {
                        return Collections.singletonList(new SliceMutator(Overseer.this.getZkStateReader()).updateShardState(clusterState, message));
                    }
                    case QUIT: {
                        if (this.myId.equals(message.get("id"))) {
                            log.info("Quit command received {}", (Object)LeaderElector.getNodeName(this.myId));
                            Overseer.this.overseerCollectionConfigSetProcessor.close();
                            this.close();
                            break;
                        }
                        log.warn("Overseer received wrong QUIT message {}", (Object)message);
                        break;
                    }
                    case DOWNNODE: {
                        return new NodeMutator(Overseer.this.getZkStateReader()).downNode(clusterState, message);
                    }
                    default: {
                        throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
                    }
                }
            }
            return Collections.singletonList(ZkStateWriter.NO_OP);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeaderStatus amILeader() {
            TimerContext timerContext = Overseer.this.stats.time("am_i_leader");
            boolean success = true;
            try {
                ZkNodeProps props = ZkNodeProps.load((byte[])this.zkClient.getData("/overseer_elect/leader", null, null, true));
                if (this.myId.equals(props.getStr("id"))) {
                    LeaderStatus leaderStatus = LeaderStatus.YES;
                    return leaderStatus;
                }
            }
            catch (KeeperException e) {
                success = false;
                if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.error("", (Throwable)e);
                    LeaderStatus leaderStatus = LeaderStatus.DONT_KNOW;
                    return leaderStatus;
                }
                if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                    log.info("", (Throwable)e);
                } else {
                    log.warn("", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                success = false;
                Thread.currentThread().interrupt();
            }
            finally {
                timerContext.stop();
                if (success) {
                    Overseer.this.stats.success("am_i_leader");
                } else {
                    Overseer.this.stats.error("am_i_leader");
                }
            }
            log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
            return LeaderStatus.NO;
        }

        @Override
        public void close() {
            this.isClosed = true;
        }
    }

    static enum LeaderStatus {
        DONT_KNOW,
        NO,
        YES;

    }
}

