/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.util.RefCounted;

class JoinQuery
extends Query {
    String fromField;
    String toField;
    String fromIndex;
    Query q;
    long fromCoreOpenTime;

    public JoinQuery(String fromField, String toField, String fromIndex, Query subQuery) {
        this.fromField = fromField;
        this.toField = toField;
        this.fromIndex = fromIndex;
        this.q = subQuery;
    }

    public Query getQuery() {
        return this.q;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new JoinQueryWeight((SolrIndexSearcher)searcher);
    }

    public String toString(String field) {
        return "{!join from=" + this.fromField + " to=" + this.toField + (this.fromIndex != null ? " fromIndex=" + this.fromIndex : "") + "}" + this.q.toString();
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JoinQuery other = (JoinQuery)((Object)o);
        return this.fromField.equals(other.fromField) && this.toField.equals(other.toField) && this.getBoost() == other.getBoost() && this.q.equals((Object)other.q) && (this.fromIndex == other.fromIndex || this.fromIndex != null && this.fromIndex.equals(other.fromIndex)) && this.fromCoreOpenTime == other.fromCoreOpenTime;
    }

    public int hashCode() {
        int h = super.hashCode();
        h = h * 31 + this.q.hashCode();
        h = h * 31 + (int)this.fromCoreOpenTime;
        h = h * 31 + this.fromField.hashCode();
        h = h * 31 + this.toField.hashCode();
        return h;
    }

    protected static class JoinScorer
    extends Scorer {
        final DocIdSetIterator iter;
        final float score;
        int doc = -1;

        public JoinScorer(Weight w, DocIdSetIterator iter, float score) throws IOException {
            super(w);
            this.score = score;
            this.iter = iter == null ? DocIdSetIterator.empty() : iter;
        }

        public int nextDoc() throws IOException {
            return this.iter.nextDoc();
        }

        public int docID() {
            return this.iter.docID();
        }

        public float score() throws IOException {
            return this.score;
        }

        public int freq() throws IOException {
            return 1;
        }

        public int advance(int target) throws IOException {
            return this.iter.advance(target);
        }

        public long cost() {
            return this.iter.cost();
        }
    }

    private class JoinQueryWeight
    extends Weight {
        SolrIndexSearcher fromSearcher;
        RefCounted<SolrIndexSearcher> fromRef;
        SolrIndexSearcher toSearcher;
        private Similarity similarity;
        private float queryNorm;
        private float queryWeight;
        ResponseBuilder rb;
        DocSet resultSet;
        Filter filter;
        int fromSetSize;
        long resultListDocs;
        int fromTermCount;
        long fromTermTotalDf;
        int fromTermDirectCount;
        int fromTermHits;
        long fromTermHitsTotalDf;
        int toTermHits;
        long toTermHitsTotalDf;
        int toTermDirectCount;
        int smallSetsDeferred;

        public JoinQueryWeight(SolrIndexSearcher searcher) {
            this.fromSearcher = searcher;
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            if (info != null) {
                this.rb = info.getResponseBuilder();
            }
            if (JoinQuery.this.fromIndex == null) {
                this.fromSearcher = searcher;
            } else {
                if (info == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join must have SolrRequestInfo");
                }
                CoreContainer container = searcher.getCore().getCoreDescriptor().getCoreContainer();
                final SolrCore fromCore = container.getCore(JoinQuery.this.fromIndex);
                if (fromCore == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + JoinQuery.this.fromIndex);
                }
                if (info.getReq().getCore() == fromCore) {
                    this.fromSearcher = searcher;
                } else {
                    this.fromRef = fromCore.getSearcher(false, true, null);
                    this.fromSearcher = this.fromRef.get();
                }
                if (this.fromRef != null) {
                    final RefCounted<SolrIndexSearcher> ref = this.fromRef;
                    info.addCloseHook(new Closeable(){

                        @Override
                        public void close() {
                            ref.decref();
                        }
                    });
                }
                info.addCloseHook(new Closeable(){

                    @Override
                    public void close() {
                        fromCore.close();
                    }
                });
            }
            this.toSearcher = searcher;
        }

        public Query getQuery() {
            return JoinQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = JoinQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSet readerSet;
            if (this.filter == null) {
                long end;
                boolean debug = this.rb != null && this.rb.isDebug();
                long start = debug ? System.currentTimeMillis() : 0L;
                this.resultSet = this.getDocSet();
                long l = end = debug ? System.currentTimeMillis() : 0L;
                if (debug) {
                    SimpleOrderedMap dbg = new SimpleOrderedMap();
                    dbg.add("time", (Object)(end - start));
                    dbg.add("fromSetSize", (Object)this.fromSetSize);
                    dbg.add("toSetSize", (Object)this.resultSet.size());
                    dbg.add("fromTermCount", (Object)this.fromTermCount);
                    dbg.add("fromTermTotalDf", (Object)this.fromTermTotalDf);
                    dbg.add("fromTermDirectCount", (Object)this.fromTermDirectCount);
                    dbg.add("fromTermHits", (Object)this.fromTermHits);
                    dbg.add("fromTermHitsTotalDf", (Object)this.fromTermHitsTotalDf);
                    dbg.add("toTermHits", (Object)this.toTermHits);
                    dbg.add("toTermHitsTotalDf", (Object)this.toTermHitsTotalDf);
                    dbg.add("toTermDirectCount", (Object)this.toTermDirectCount);
                    dbg.add("smallSetsDeferred", (Object)this.smallSetsDeferred);
                    dbg.add("toSetDocsAdded", (Object)this.resultListDocs);
                    this.rb.addDebug(dbg, "join", JoinQuery.this.toString());
                }
                this.filter = this.resultSet.getTopFilter();
            }
            return new JoinScorer(this, (readerSet = this.filter.getDocIdSet(context, acceptDocs)) == null ? DocIdSetIterator.empty() : readerSet.iterator(), JoinQuery.this.getBoost());
        }

        public DocSet getDocSet() throws IOException {
            Fields toFields;
            FixedBitSet resultBits = null;
            int minDocFreqFrom = Math.max(5, this.fromSearcher.maxDoc() >> 13);
            int minDocFreqTo = Math.max(5, this.toSearcher.maxDoc() >> 13);
            int maxSortedIntSize = Math.max(10, this.toSearcher.maxDoc() >> 10);
            DocSet fromSet = this.fromSearcher.getDocSet(JoinQuery.this.q);
            this.fromSetSize = fromSet.size();
            ArrayList<DocSet> resultList = new ArrayList<DocSet>(10);
            DocSet fastForRandomSet = fromSet;
            if (minDocFreqFrom > 0 && fromSet instanceof SortedIntDocSet) {
                SortedIntDocSet sset = (SortedIntDocSet)fromSet;
                fastForRandomSet = new HashDocSet(sset.getDocs(), 0, sset.size());
            }
            Fields fromFields = this.fromSearcher.getAtomicReader().fields();
            Fields fields = toFields = this.fromSearcher == this.toSearcher ? fromFields : this.toSearcher.getAtomicReader().fields();
            if (fromFields == null) {
                return DocSet.EMPTY;
            }
            Terms terms = fromFields.terms(JoinQuery.this.fromField);
            Terms toTerms = toFields.terms(JoinQuery.this.toField);
            if (terms == null || toTerms == null) {
                return DocSet.EMPTY;
            }
            String prefixStr = TrieField.getMainValuePrefix(this.fromSearcher.getSchema().getFieldType(JoinQuery.this.fromField));
            BytesRef prefix = prefixStr == null ? null : new BytesRef((CharSequence)prefixStr);
            BytesRef term = null;
            TermsEnum termsEnum = terms.iterator(null);
            TermsEnum toTermsEnum = toTerms.iterator(null);
            SolrIndexSearcher.DocsEnumState fromDeState = null;
            SolrIndexSearcher.DocsEnumState toDeState = null;
            if (prefix == null) {
                term = termsEnum.next();
            } else if (termsEnum.seekCeil(prefix) != TermsEnum.SeekStatus.END) {
                term = termsEnum.term();
            }
            Bits fromLiveDocs = this.fromSearcher.getAtomicReader().getLiveDocs();
            Bits toLiveDocs = this.fromSearcher == this.toSearcher ? fromLiveDocs : this.toSearcher.getAtomicReader().getLiveDocs();
            fromDeState = new SolrIndexSearcher.DocsEnumState();
            fromDeState.fieldName = JoinQuery.this.fromField;
            fromDeState.liveDocs = fromLiveDocs;
            fromDeState.termsEnum = termsEnum;
            fromDeState.docsEnum = null;
            fromDeState.minSetSizeCached = minDocFreqFrom;
            toDeState = new SolrIndexSearcher.DocsEnumState();
            toDeState.fieldName = JoinQuery.this.toField;
            toDeState.liveDocs = toLiveDocs;
            toDeState.termsEnum = toTermsEnum;
            toDeState.docsEnum = null;
            toDeState.minSetSizeCached = minDocFreqTo;
            while (term != null && (prefix == null || StringHelper.startsWith((BytesRef)term, (BytesRef)prefix))) {
                boolean intersects;
                block37: {
                    ++this.fromTermCount;
                    intersects = false;
                    int freq = termsEnum.docFreq();
                    ++this.fromTermTotalDf;
                    if (freq < minDocFreqFrom) {
                        ++this.fromTermDirectCount;
                        fromDeState.docsEnum = fromDeState.termsEnum.docs(null, fromDeState.docsEnum, 0);
                        DocsEnum docsEnum = fromDeState.docsEnum;
                        if (docsEnum instanceof MultiDocsEnum) {
                            MultiDocsEnum.EnumWithSlice[] subs = ((MultiDocsEnum)docsEnum).getSubs();
                            int numSubs = ((MultiDocsEnum)docsEnum).getNumSubs();
                            for (int subindex = 0; subindex < numSubs; ++subindex) {
                                int docid;
                                MultiDocsEnum.EnumWithSlice sub = subs[subindex];
                                if (sub.docsEnum == null) continue;
                                int base = sub.slice.start;
                                while ((docid = sub.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    if (!fastForRandomSet.exists(docid + base)) continue;
                                    intersects = true;
                                    break block37;
                                }
                            }
                        } else {
                            int docid;
                            while ((docid = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                if (!fastForRandomSet.exists(docid)) continue;
                                intersects = true;
                                break;
                            }
                        }
                    } else {
                        DocSet fromTermSet = this.fromSearcher.getDocSet(fromDeState);
                        intersects = fromSet.intersects(fromTermSet);
                    }
                }
                if (intersects) {
                    ++this.fromTermHits;
                    ++this.fromTermHitsTotalDf;
                    TermsEnum.SeekStatus status = toTermsEnum.seekCeil(term);
                    if (status == TermsEnum.SeekStatus.END) break;
                    if (status == TermsEnum.SeekStatus.FOUND) {
                        ++this.toTermHits;
                        int df = toTermsEnum.docFreq();
                        this.toTermHitsTotalDf += (long)df;
                        if (resultBits == null && (long)df + this.resultListDocs > (long)maxSortedIntSize && resultList.size() > 0) {
                            resultBits = new FixedBitSet(this.toSearcher.maxDoc());
                        }
                        if (toTermsEnum.docFreq() >= minDocFreqTo || resultBits == null) {
                            DocSet toTermSet = this.toSearcher.getDocSet(toDeState);
                            this.resultListDocs += (long)toTermSet.size();
                            if (resultBits != null) {
                                toTermSet.addAllTo(new BitDocSet(resultBits));
                            } else if (toTermSet instanceof BitDocSet) {
                                resultBits = ((BitDocSet)toTermSet).bits.clone();
                            } else {
                                resultList.add(toTermSet);
                            }
                        } else {
                            ++this.toTermDirectCount;
                            toDeState.docsEnum = toDeState.termsEnum.docs(toDeState.liveDocs, toDeState.docsEnum, 0);
                            DocsEnum docsEnum = toDeState.docsEnum;
                            if (docsEnum instanceof MultiDocsEnum) {
                                MultiDocsEnum.EnumWithSlice[] subs = ((MultiDocsEnum)docsEnum).getSubs();
                                int numSubs = ((MultiDocsEnum)docsEnum).getNumSubs();
                                for (int subindex = 0; subindex < numSubs; ++subindex) {
                                    int docid;
                                    MultiDocsEnum.EnumWithSlice sub = subs[subindex];
                                    if (sub.docsEnum == null) continue;
                                    int base = sub.slice.start;
                                    while ((docid = sub.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                        ++this.resultListDocs;
                                        resultBits.set(docid + base);
                                    }
                                }
                            } else {
                                int docid;
                                while ((docid = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    ++this.resultListDocs;
                                    resultBits.set(docid);
                                }
                            }
                        }
                    }
                }
                term = termsEnum.next();
            }
            this.smallSetsDeferred = resultList.size();
            if (resultBits != null) {
                BitDocSet bitSet = new BitDocSet(resultBits);
                for (DocSet set : resultList) {
                    set.addAllTo(bitSet);
                }
                return bitSet;
            }
            if (resultList.size() == 0) {
                return DocSet.EMPTY;
            }
            if (resultList.size() == 1) {
                return (DocSet)resultList.get(0);
            }
            int sz = 0;
            for (DocSet set : resultList) {
                sz += set.size();
            }
            int[] docs = new int[sz];
            int pos = 0;
            for (DocSet set : resultList) {
                System.arraycopy(((SortedIntDocSet)set).getDocs(), 0, docs, pos, set.size());
                pos += set.size();
            }
            Arrays.sort(docs);
            int[] dedup = new int[sz];
            pos = 0;
            int last = -1;
            for (int doc : docs) {
                if (doc != last) {
                    dedup[pos++] = doc;
                }
                last = doc;
            }
            if (pos != dedup.length) {
                dedup = Arrays.copyOf(dedup, pos);
            }
            return new SortedIntDocSet(dedup, dedup.length);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Scorer scorer = this.scorer(context, true, false, context.reader().getLiveDocs());
            boolean exists = scorer.advance(doc) == doc;
            ComplexExplanation result = new ComplexExplanation();
            if (exists) {
                result.setDescription(((Object)((Object)this)).toString() + " , product of:");
                result.setValue(this.queryWeight);
                result.setMatch(Boolean.TRUE);
                result.addDetail(new Explanation(JoinQuery.this.getBoost(), "boost"));
                result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result.setDescription(((Object)((Object)this)).toString() + " doesn't match id " + doc);
                result.setValue(0.0f);
                result.setMatch(Boolean.FALSE);
            }
            return result;
        }
    }
}

