/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableDoubleFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.util.NumberUtils;

@Deprecated
public class SortableDoubleField
extends PrimitiveFieldType
implements DoubleValueFieldType {
    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new SortableDoubleFieldSource(field.name);
    }

    @Override
    public String toInternal(String val) {
        return NumberUtils.double2sortableStr(val);
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public Double toObject(IndexableField f) {
        return NumberUtils.SortableStr2double(f.stringValue());
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return NumberUtils.SortableStr2doubleStr(indexedForm);
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRef charsRef) {
        UnicodeUtil.UTF8toUTF16((BytesRef)input, (CharsRef)charsRef);
        char[] indexedToReadable = this.indexedToReadable(charsRef.toString()).toCharArray();
        charsRef.copyChars(indexedToReadable, 0, indexedToReadable.length);
        return charsRef;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        String sval = f.stringValue();
        writer.writeDouble(name, NumberUtils.SortableStr2double(sval));
    }

    @Override
    public Object marshalSortValue(Object value) {
        if (null == value) {
            return null;
        }
        CharsRef chars = new CharsRef();
        UnicodeUtil.UTF8toUTF16((BytesRef)((BytesRef)value), (CharsRef)chars);
        return NumberUtils.SortableStr2double(chars.toString());
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        if (null == value) {
            return null;
        }
        String sortableString = NumberUtils.double2sortableStr(value.toString());
        BytesRef bytes = new BytesRef();
        UnicodeUtil.UTF16toUTF8((CharSequence)sortableString, (int)0, (int)sortableString.length(), (BytesRef)bytes);
        return bytes;
    }
}

