/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.InflaterInputStream;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.PropertiesInputStream;
import org.apache.solr.util.PropertiesOutputStream;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapPuller {
    public static final String INDEX_PROPERTIES = "index.properties";
    private static final Logger LOG = LoggerFactory.getLogger((String)SnapPuller.class.getName());
    private final String masterUrl;
    private final ReplicationHandler replicationHandler;
    private final Integer pollInterval;
    private String pollIntervalStr;
    private ScheduledExecutorService executorService;
    private volatile long executorStartTime;
    private volatile long replicationStartTime;
    private final SolrCore solrCore;
    private volatile List<Map<String, Object>> filesToDownload;
    private volatile List<Map<String, Object>> confFilesToDownload;
    private volatile List<Map<String, Object>> filesDownloaded;
    private volatile List<Map<String, Object>> confFilesDownloaded;
    private volatile Map<String, Object> currentFile;
    private volatile DirectoryFileFetcher dirFileFetcher;
    private volatile LocalFsFileFetcher localFileFetcher;
    private volatile ExecutorService fsyncService;
    private volatile boolean stop = false;
    private boolean useInternal = false;
    private boolean useExternal = false;
    private AtomicBoolean pollDisabled = new AtomicBoolean(false);
    private final HttpClient myHttpClient;
    private boolean successfulInstall = false;
    private volatile Exception fsyncException;
    private final Map<String, ReplicationHandler.FileInfo> confFileInfoCache = new HashMap<String, ReplicationHandler.FileInfo>();
    private static final int MAX_RETRIES = 5;
    private static final int NO_CONTENT = 1;
    private static final int ERR = 2;
    public static final String REPLICATION_PROPERTIES = "replication.properties";
    public static final String POLL_INTERVAL = "pollInterval";
    public static final String INTERVAL_ERR_MSG = "The pollInterval must be in this format 'HH:mm:ss'";
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("(\\d*?):(\\d*?):(\\d*)");
    static final String INDEX_REPLICATED_AT = "indexReplicatedAt";
    static final String TIMES_INDEX_REPLICATED = "timesIndexReplicated";
    static final String CONF_FILES_REPLICATED = "confFilesReplicated";
    static final String CONF_FILES_REPLICATED_AT = "confFilesReplicatedAt";
    static final String TIMES_CONFIG_REPLICATED = "timesConfigReplicated";
    static final String LAST_CYCLE_BYTES_DOWNLOADED = "lastCycleBytesDownloaded";
    static final String TIMES_FAILED = "timesFailed";
    static final String REPLICATION_FAILED_AT = "replicationFailedAt";
    static final String PREVIOUS_CYCLE_TIME_TAKEN = "previousCycleTimeInSeconds";
    static final String INDEX_REPLICATED_AT_LIST = "indexReplicatedAtList";
    static final String REPLICATION_FAILED_AT_LIST = "replicationFailedAtList";

    private static HttpClient createHttpClient(SolrCore core, String connTimeout, String readTimeout, String httpBasicAuthUser, String httpBasicAuthPassword, boolean useCompression) {
        ModifiableSolrParams httpClientParams = new ModifiableSolrParams();
        httpClientParams.set("connTimeout", new String[]{connTimeout != null ? connTimeout : "5000"});
        httpClientParams.set("socketTimeout", new String[]{readTimeout != null ? readTimeout : "20000"});
        httpClientParams.set("httpBasicAuthUser", new String[]{httpBasicAuthUser});
        httpClientParams.set("httpBasicAuthPassword", new String[]{httpBasicAuthPassword});
        httpClientParams.set("allowCompression", useCompression);
        HttpClient httpClient = HttpClientUtil.createClient((SolrParams)httpClientParams, (ClientConnectionManager)core.getCoreDescriptor().getCoreContainer().getUpdateShardHandler().getConnectionManager());
        return httpClient;
    }

    public SnapPuller(NamedList initArgs, ReplicationHandler handler, SolrCore sc) {
        this.solrCore = sc;
        SolrParams params = SolrParams.toSolrParams((NamedList)initArgs);
        String masterUrl = (String)initArgs.get("masterUrl");
        if (masterUrl == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'masterUrl' is required for a slave");
        }
        if (masterUrl.endsWith("/replication")) {
            masterUrl = masterUrl.substring(0, masterUrl.length() - 12);
            LOG.warn("'masterUrl' must be specified without the /replication suffix");
        }
        this.masterUrl = masterUrl;
        this.replicationHandler = handler;
        this.pollIntervalStr = (String)initArgs.get(POLL_INTERVAL);
        this.pollInterval = SnapPuller.readInterval(this.pollIntervalStr);
        String compress = (String)initArgs.get("compression");
        this.useInternal = "internal".equals(compress);
        this.useExternal = "external".equals(compress);
        String connTimeout = (String)initArgs.get("connTimeout");
        String readTimeout = (String)initArgs.get("socketTimeout");
        String httpBasicAuthUser = (String)initArgs.get("httpBasicAuthUser");
        String httpBasicAuthPassword = (String)initArgs.get("httpBasicAuthPassword");
        this.myHttpClient = SnapPuller.createHttpClient(this.solrCore, connTimeout, readTimeout, httpBasicAuthUser, httpBasicAuthPassword, this.useExternal);
        if (this.pollInterval != null && this.pollInterval > 0) {
            this.startExecutorService();
        } else {
            LOG.info(" No value set for 'pollInterval'. Timer Task not started.");
        }
    }

    private void startExecutorService() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (SnapPuller.this.pollDisabled.get()) {
                    LOG.info("Poll disabled");
                    return;
                }
                try {
                    LOG.debug("Polling for index modifications");
                    SnapPuller.this.executorStartTime = System.currentTimeMillis();
                    SnapPuller.this.replicationHandler.doFetch(null, false);
                }
                catch (Exception e) {
                    LOG.error("Exception in fetching index", (Throwable)e);
                }
            }
        };
        this.executorService = Executors.newSingleThreadScheduledExecutor(new DefaultSolrThreadFactory("snapPuller"));
        long initialDelay = (long)this.pollInterval.intValue() - System.currentTimeMillis() % (long)this.pollInterval.intValue();
        this.executorService.scheduleAtFixedRate(task, initialDelay, this.pollInterval.intValue(), TimeUnit.MILLISECONDS);
        LOG.info("Poll Scheduled at an interval of " + this.pollInterval + "ms");
    }

    NamedList getLatestVersion() throws IOException {
        NamedList rsp;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"indexversion"});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/replication"});
        QueryRequest req = new QueryRequest((SolrParams)params);
        HttpSolrServer server = new HttpSolrServer(this.masterUrl, this.myHttpClient);
        try {
            server.setSoTimeout(60000);
            server.setConnectionTimeout(15000);
            rsp = server.request((SolrRequest)req);
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage());
        }
        finally {
            server.shutdown();
        }
        return rsp;
    }

    private void fetchFileList(long gen) throws IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"filelist"});
        params.set("generation", new String[]{String.valueOf(gen)});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/replication"});
        QueryRequest req = new QueryRequest((SolrParams)params);
        HttpSolrServer server = new HttpSolrServer(this.masterUrl, this.myHttpClient);
        try {
            server.setSoTimeout(60000);
            server.setConnectionTimeout(15000);
            NamedList response = server.request((SolrRequest)req);
            List files = (List)response.get("filelist");
            if (files != null) {
                this.filesToDownload = Collections.synchronizedList(files);
            } else {
                this.filesToDownload = Collections.emptyList();
                LOG.error("No files to download for index generation: " + gen);
            }
            files = (List)response.get("confFiles");
            if (files != null) {
                this.confFilesToDownload = Collections.synchronizedList(files);
            }
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    boolean fetchLatestIndex(SolrCore core, boolean forceReplication) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void terminateAndWaitFsyncService() throws Exception {
        if (this.fsyncService.isTerminated()) {
            return;
        }
        this.fsyncService.shutdown();
        this.fsyncService.awaitTermination(3600L, TimeUnit.SECONDS);
        Exception fsyncExceptionCopy = this.fsyncException;
        if (fsyncExceptionCopy != null) {
            throw fsyncExceptionCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logReplicationTimeAndConfFiles(Collection<Map<String, Object>> modifiedConfFiles, boolean successfulInstall) throws IOException {
        ArrayList<String> confFiles = new ArrayList<String>();
        if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
            for (Map<String, Object> map1 : modifiedConfFiles) {
                confFiles.add((String)map1.get("name"));
            }
        }
        Properties props = this.replicationHandler.loadReplicationProperties();
        long replicationTime = System.currentTimeMillis();
        long replicationTimeTaken = (replicationTime - this.getReplicationStartTime()) / 1000L;
        Directory dir = null;
        try {
            dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.solrCore.getSolrConfig().indexConfig.lockType);
            int indexCount = 1;
            int confFilesCount = 1;
            if (props.containsKey(TIMES_INDEX_REPLICATED)) {
                indexCount = Integer.valueOf(props.getProperty(TIMES_INDEX_REPLICATED)) + 1;
            }
            StringBuilder sb = this.readToStringBuilder(replicationTime, props.getProperty(INDEX_REPLICATED_AT_LIST));
            props.setProperty(INDEX_REPLICATED_AT_LIST, sb.toString());
            props.setProperty(INDEX_REPLICATED_AT, String.valueOf(replicationTime));
            props.setProperty(PREVIOUS_CYCLE_TIME_TAKEN, String.valueOf(replicationTimeTaken));
            props.setProperty(TIMES_INDEX_REPLICATED, String.valueOf(indexCount));
            if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
                props.setProperty(CONF_FILES_REPLICATED, ((Object)confFiles).toString());
                props.setProperty(CONF_FILES_REPLICATED_AT, String.valueOf(replicationTime));
                if (props.containsKey(TIMES_CONFIG_REPLICATED)) {
                    confFilesCount = Integer.valueOf(props.getProperty(TIMES_CONFIG_REPLICATED)) + 1;
                }
                props.setProperty(TIMES_CONFIG_REPLICATED, String.valueOf(confFilesCount));
            }
            props.setProperty(LAST_CYCLE_BYTES_DOWNLOADED, String.valueOf(SnapPuller.getTotalBytesDownloaded(this)));
            if (!successfulInstall) {
                int numFailures = 1;
                if (props.containsKey(TIMES_FAILED)) {
                    numFailures = Integer.valueOf(props.getProperty(TIMES_FAILED)) + 1;
                }
                props.setProperty(TIMES_FAILED, String.valueOf(numFailures));
                props.setProperty(REPLICATION_FAILED_AT, String.valueOf(replicationTime));
                sb = this.readToStringBuilder(replicationTime, props.getProperty(REPLICATION_FAILED_AT_LIST));
                props.setProperty(REPLICATION_FAILED_AT_LIST, sb.toString());
            }
            IndexOutput out = dir.createOutput(REPLICATION_PROPERTIES, DirectoryFactory.IOCONTEXT_NO_CACHE);
            OutputStreamWriter outFile = new OutputStreamWriter((OutputStream)new PropertiesOutputStream(out), IOUtils.CHARSET_UTF_8);
            try {
                props.store(outFile, "Replication details");
                dir.sync(Collections.singleton(REPLICATION_PROPERTIES));
            }
            finally {
                org.apache.commons.io.IOUtils.closeQuietly((Writer)outFile);
            }
            if (dir == null) return;
        }
        catch (Exception e) {
            try {
                LOG.warn("Exception while updating statistics", (Throwable)e);
                if (dir == null) return;
            }
            catch (Throwable throwable) {
                if (dir == null) throw throwable;
                this.solrCore.getDirectoryFactory().release(dir);
                throw throwable;
            }
            this.solrCore.getDirectoryFactory().release(dir);
            return;
        }
        this.solrCore.getDirectoryFactory().release(dir);
        return;
    }

    static long getTotalBytesDownloaded(SnapPuller snappuller) {
        long bytesDownloaded = 0L;
        for (Map<String, Object> file : snappuller.getFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        for (Map<String, Object> file : snappuller.getConfFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        Map<String, Object> currentFile = snappuller.getCurrentFile();
        if (currentFile != null && currentFile.containsKey("bytesDownloaded")) {
            bytesDownloaded += ((Long)currentFile.get("bytesDownloaded")).longValue();
        }
        return bytesDownloaded;
    }

    private StringBuilder readToStringBuilder(long replicationTime, String str) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> l = new ArrayList<String>();
        if (str != null && str.length() != 0) {
            String[] ss = str.split(",");
            for (int i = 0; i < ss.length; ++i) {
                l.add(ss[i]);
            }
        }
        sb.append(replicationTime);
        if (!l.isEmpty()) {
            for (int i = 0; (i < l.size() || i < 9) && i != l.size() && i != 9; ++i) {
                String s = (String)l.get(i);
                sb.append(",").append(s);
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewSearcherAndUpdateCommitPoint(boolean isFullCopyNeeded) throws IOException {
        IndexCommit commitPoint;
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.solrCore, (SolrParams)new ModifiableSolrParams());
        RefCounted<SolrIndexSearcher> searcher = null;
        try {
            Future[] waitSearcher = new Future[1];
            searcher = this.solrCore.getSearcher(true, true, waitSearcher, true);
            if (waitSearcher[0] != null) {
                try {
                    waitSearcher[0].get();
                }
                catch (InterruptedException e) {
                    SolrException.log((Logger)LOG, (Throwable)e);
                }
                catch (ExecutionException e) {
                    SolrException.log((Logger)LOG, (Throwable)e);
                }
            }
            commitPoint = searcher.get().getIndexReader().getIndexCommit();
        }
        finally {
            req.close();
            if (searcher != null) {
                searcher.decref();
            }
        }
        this.replicationHandler.indexCommitPoint = commitPoint;
    }

    private String createTempindexDir(SolrCore core, String tmpIdxDirName) {
        String tmpIdxDir = core.getDataDir() + tmpIdxDirName;
        return tmpIdxDir;
    }

    private void reloadCore() {
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SnapPuller.this.solrCore.getCoreDescriptor().getCoreContainer().reload(SnapPuller.this.solrCore.getName());
                }
                catch (Exception e) {
                    LOG.error("Could not reload core ", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            }
        }.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for core reload to finish", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadConfFiles(List<Map<String, Object>> confFilesToDownload, long latestGeneration) throws Exception {
        LOG.info("Starting download of configuration files from master: " + confFilesToDownload);
        this.confFilesDownloaded = Collections.synchronizedList(new ArrayList());
        File tmpconfDir = new File(this.solrCore.getResourceLoader().getConfigDir(), "conf." + this.getDateAsStr(new Date()));
        try {
            boolean status = tmpconfDir.mkdirs();
            if (!status) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create temporary config folder: " + tmpconfDir.getName());
            }
            for (Map<String, Object> file : confFilesToDownload) {
                String saveAs = (String)(file.get("alias") == null ? file.get("name") : file.get("alias"));
                this.localFileFetcher = new LocalFsFileFetcher(tmpconfDir, file, saveAs, true, latestGeneration);
                this.currentFile = file;
                this.localFileFetcher.fetchFile();
                this.confFilesDownloaded.add(new HashMap<String, Object>(file));
            }
            this.terminateAndWaitFsyncService();
            this.copyTmpConfFiles2Conf(tmpconfDir);
        }
        finally {
            SnapPuller.delTree(tmpconfDir);
        }
    }

    private void downloadIndexFiles(boolean downloadCompleteIndex, Directory indexDir, Directory tmpIndexDir, long latestGeneration) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Download files to dir: " + Arrays.asList(indexDir.listAll()));
        }
        for (Map<String, Object> file : this.filesToDownload) {
            if (!indexDir.fileExists((String)file.get("name")) || downloadCompleteIndex) {
                this.dirFileFetcher = new DirectoryFileFetcher(tmpIndexDir, file, (String)file.get("name"), false, latestGeneration);
                this.currentFile = file;
                this.dirFileFetcher.fetchFile();
                this.filesDownloaded.add(new HashMap<String, Object>(file));
                continue;
            }
            LOG.info("Skipping download for " + file.get("name") + " because it already exists");
        }
    }

    private boolean isIndexStale(Directory dir) throws IOException {
        for (Map<String, Object> file : this.filesToDownload) {
            if (!dir.fileExists((String)file.get("name")) || dir.fileLength((String)file.get("name")) == ((Long)file.get("size")).longValue()) continue;
            LOG.warn("File " + file.get("name") + " expected to be " + file.get("size") + " while it is " + dir.fileLength((String)file.get("name")));
            return true;
        }
        return false;
    }

    private boolean moveAFile(Directory tmpIdxDir, Directory indexDir, String fname, List<String> copiedfiles) {
        LOG.debug("Moving file: {}", (Object)fname);
        boolean success = false;
        try {
            if (indexDir.fileExists(fname)) {
                LOG.info("Skipping move file - it already exists:" + fname);
                return true;
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)LOG, (String)"could not check if a file exists", (Throwable)e);
            return false;
        }
        try {
            this.solrCore.getDirectoryFactory().move(tmpIdxDir, indexDir, fname, DirectoryFactory.IOCONTEXT_NO_CACHE);
            success = true;
        }
        catch (IOException e) {
            SolrException.log((Logger)LOG, (String)"Could not move file", (Throwable)e);
        }
        return success;
    }

    private boolean moveIndexFiles(Directory tmpIdxDir, Directory indexDir) {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.info("From dir files:" + Arrays.asList(tmpIdxDir.listAll()));
                LOG.info("To dir files:" + Arrays.asList(indexDir.listAll()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String segmentsFile = null;
        ArrayList<String> movedfiles = new ArrayList<String>();
        for (Map<String, Object> f : this.filesDownloaded) {
            String fname = (String)f.get("name");
            if (fname.startsWith("segments_")) {
                segmentsFile = fname;
                continue;
            }
            if (!this.moveAFile(tmpIdxDir, indexDir, fname, movedfiles)) {
                return false;
            }
            movedfiles.add(fname);
        }
        return segmentsFile == null || this.moveAFile(tmpIdxDir, indexDir, segmentsFile, movedfiles);
    }

    private List<File> makeTmpConfDirFileList(File dir, List<File> fileList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                fileList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            fileList = this.makeTmpConfDirFileList(file, fileList);
        }
        return fileList;
    }

    private void copyTmpConfFiles2Conf(File tmpconfDir) {
        boolean status = false;
        File confDir = new File(this.solrCore.getResourceLoader().getConfigDir());
        for (File file : this.makeTmpConfDirFileList(tmpconfDir, new ArrayList<File>())) {
            File oldFile = new File(confDir, file.getPath().substring(tmpconfDir.getPath().length(), file.getPath().length()));
            if (!oldFile.getParentFile().exists() && !(status = oldFile.getParentFile().mkdirs())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to mkdirs: " + oldFile.getParentFile());
            }
            if (oldFile.exists()) {
                File backupFile = new File(oldFile.getPath() + "." + this.getDateAsStr(new Date(oldFile.lastModified())));
                if (!backupFile.getParentFile().exists() && !(status = backupFile.getParentFile().mkdirs())) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to mkdirs: " + backupFile.getParentFile());
                }
                status = oldFile.renameTo(backupFile);
                if (!status) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + oldFile + " to: " + backupFile);
                }
            }
            if (status = file.renameTo(oldFile)) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + file + " to: " + oldFile);
        }
    }

    private String getDateAsStr(Date d) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).format(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean modifyIndexProps(String tmpIdxDirName) {
        boolean bl;
        LOG.info("New index installed. Updating index properties... index=" + tmpIdxDirName);
        Properties p = new Properties();
        Directory dir = null;
        try {
            dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.solrCore.getSolrConfig().indexConfig.lockType);
            if (dir.fileExists(INDEX_PROPERTIES)) {
                IndexInput input = dir.openInput(INDEX_PROPERTIES, DirectoryFactory.IOCONTEXT_NO_CACHE);
                PropertiesInputStream is = new PropertiesInputStream(input);
                try {
                    p.load(new InputStreamReader((InputStream)is, IOUtils.CHARSET_UTF_8));
                }
                catch (Exception e) {
                    LOG.error("Unable to load index.properties", (Throwable)e);
                }
                finally {
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                }
            }
            try {
                dir.deleteFile(INDEX_PROPERTIES);
            }
            catch (IOException e) {
                // empty catch block
            }
            IndexOutput out = dir.createOutput(INDEX_PROPERTIES, DirectoryFactory.IOCONTEXT_NO_CACHE);
            p.put("index", tmpIdxDirName);
            OutputStreamWriter os = null;
            try {
                os = new OutputStreamWriter((OutputStream)new PropertiesOutputStream(out), IOUtils.CHARSET_UTF_8);
                p.store(os, INDEX_PROPERTIES);
                dir.sync(Collections.singleton(INDEX_PROPERTIES));
            }
            catch (Exception e) {
                try {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to write index.properties", (Throwable)e);
                }
                catch (Throwable throwable) {
                    org.apache.commons.io.IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            org.apache.commons.io.IOUtils.closeQuietly((Writer)os);
            bl = true;
            if (dir == null) return bl;
        }
        catch (IOException e1) {
            try {
                throw new RuntimeException(e1);
            }
            catch (Throwable throwable) {
                if (dir == null) throw throwable;
                try {
                    this.solrCore.getDirectoryFactory().release(dir);
                    throw throwable;
                }
                catch (IOException e) {
                    SolrException.log((Logger)LOG, (String)"", (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            this.solrCore.getDirectoryFactory().release(dir);
            return bl;
        }
        catch (IOException e) {
            SolrException.log((Logger)LOG, (String)"", (Throwable)e);
        }
        return bl;
    }

    private Collection<Map<String, Object>> getModifiedConfFiles(List<Map<String, Object>> confFilesToDownload) {
        if (confFilesToDownload == null || confFilesToDownload.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, Map<String, Object>> nameVsFile = new HashMap<String, Map<String, Object>>();
        NamedList names = new NamedList();
        for (Map<String, Object> map : confFilesToDownload) {
            String name = (String)(map.get("alias") == null ? map.get("name") : map.get("alias"));
            nameVsFile.put(name, map);
            names.add(name, null);
        }
        List<Map<String, Object>> localFilesInfo = this.replicationHandler.getConfFileInfoFromCache((NamedList<String>)names, this.confFileInfoCache);
        for (Map<String, Object> fileInfo : localFilesInfo) {
            String name = (String)fileInfo.get("name");
            Map m = (Map)nameVsFile.get(name);
            if (m == null || !m.get("checksum").equals(fileInfo.get("checksum"))) continue;
            nameVsFile.remove(name);
        }
        return nameVsFile.isEmpty() ? Collections.EMPTY_LIST : nameVsFile.values();
    }

    static boolean delTree(File dir) {
        boolean isSuccess = true;
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                boolean success;
                if (file.isDirectory()) {
                    success = SnapPuller.delTree(file);
                    if (success) continue;
                    LOG.warn("Unable to delete directory : " + file);
                    isSuccess = false;
                    continue;
                }
                success = file.delete();
                if (success) continue;
                LOG.warn("Unable to delete file : " + file);
                isSuccess = false;
                return false;
            }
        }
        return isSuccess && dir.delete();
    }

    void disablePoll() {
        this.pollDisabled.set(true);
        LOG.info("inside disable poll, value of pollDisabled = " + this.pollDisabled);
    }

    void enablePoll() {
        this.pollDisabled.set(false);
        LOG.info("inside enable poll, value of pollDisabled = " + this.pollDisabled);
    }

    void abortPull() {
        this.stop = true;
    }

    long getReplicationStartTime() {
        return this.replicationStartTime;
    }

    List<Map<String, Object>> getConfFilesToDownload() {
        List<Map<String, Object>> tmp = this.confFilesToDownload;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getConfFilesDownloaded() {
        List<Map<String, Object>> tmp = this.confFilesDownloaded;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesToDownload() {
        List<Map<String, Object>> tmp = this.filesToDownload;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesDownloaded() {
        List<Map<String, Object>> tmp = this.filesDownloaded;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    Map<String, Object> getCurrentFile() {
        Map<String, Object> tmp = this.currentFile;
        DirectoryFileFetcher tmpFileFetcher = this.dirFileFetcher;
        if (tmp == null) {
            return null;
        }
        tmp = new HashMap<String, Object>(tmp);
        if (tmpFileFetcher != null) {
            tmp.put("bytesDownloaded", tmpFileFetcher.bytesDownloaded);
        }
        return tmp;
    }

    boolean isPollingDisabled() {
        return this.pollDisabled.get();
    }

    Long getNextScheduledExecTime() {
        Long nextTime = null;
        if (this.executorStartTime > 0L) {
            nextTime = this.executorStartTime + (long)this.pollInterval.intValue();
        }
        return nextTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamedList getDetails() throws IOException, SolrServerException {
        NamedList rsp;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"details"});
        params.set("slave", false);
        params.set("qt", new String[]{"/replication"});
        HttpSolrServer server = new HttpSolrServer(this.masterUrl, this.myHttpClient);
        try {
            server.setSoTimeout(60000);
            server.setConnectionTimeout(15000);
            QueryRequest request = new QueryRequest((SolrParams)params);
            rsp = server.request((SolrRequest)request);
        }
        finally {
            server.shutdown();
        }
        return rsp;
    }

    static Integer readInterval(String interval) {
        if (interval == null) {
            return null;
        }
        int result = 0;
        if (interval != null) {
            Matcher m = INTERVAL_PATTERN.matcher(interval.trim());
            if (m.find()) {
                String hr = m.group(1);
                String min = m.group(2);
                String sec = m.group(3);
                result = 0;
                try {
                    if (sec != null && sec.length() > 0) {
                        result += Integer.parseInt(sec);
                    }
                    if (min != null && min.length() > 0) {
                        result += 60 * Integer.parseInt(min);
                    }
                    if (hr != null && hr.length() > 0) {
                        result += 3600 * Integer.parseInt(hr);
                    }
                    result *= 1000;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, INTERVAL_ERR_MSG);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, INTERVAL_ERR_MSG);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
        }
        finally {
            try {
                this.abortPull();
            }
            finally {
                if (this.executorService != null) {
                    ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)this.executorService);
                }
            }
        }
    }

    String getMasterUrl() {
        return this.masterUrl;
    }

    String getPollInterval() {
        return this.pollIntervalStr;
    }

    private class LocalFsFileFetcher {
        boolean includeChecksum = true;
        private File copy2Dir;
        String fileName;
        String saveAs;
        long size;
        long bytesDownloaded = 0L;
        FileChannel fileChannel;
        private FileOutputStream fileOutputStream;
        byte[] buf = new byte[0x100000];
        Checksum checksum;
        File file;
        int errorCount = 0;
        private boolean isConf;
        private boolean aborted = false;
        private Long indexGen;

        LocalFsFileFetcher(File dir, Map<String, Object> fileDetails, String saveAs, boolean isConf, long latestGen) throws IOException {
            this.copy2Dir = dir;
            this.fileName = (String)fileDetails.get("name");
            this.size = (Long)fileDetails.get("size");
            this.isConf = isConf;
            this.saveAs = saveAs;
            this.indexGen = latestGen;
            this.file = new File(this.copy2Dir, saveAs);
            File parentDir = this.file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create (sub)directory for file: " + saveAs);
            }
            this.fileOutputStream = new FileOutputStream(this.file);
            this.fileChannel = this.fileOutputStream.getChannel();
            if (this.includeChecksum) {
                this.checksum = new Adler32();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void fetchFile() throws Exception {
            try {
                FastInputStream is;
                while (true) {
                    is = this.getStream();
                    int result = this.fetchPackets(is);
                    if (result != 0 && result != 1) break block6;
                    break;
                }
                {
                    catch (Throwable throwable) {
                        org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                }
                {
                    block6: {
                        org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                        this.cleanup();
                        SnapPuller.this.fsyncService.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FileUtils.sync(LocalFsFileFetcher.this.file);
                                }
                                catch (IOException e) {
                                    SnapPuller.this.fsyncException = e;
                                }
                            }
                        });
                        return;
                    }
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.cleanup();
                SnapPuller.this.fsyncService.submit(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private int fetchPackets(FastInputStream fis) throws Exception {
            byte[] intbytes = new byte[4];
            byte[] longbytes = new byte[8];
            try {
                while (true) {
                    if (SnapPuller.this.stop) {
                        SnapPuller.this.stop = false;
                        this.aborted = true;
                        throw new ReplicationHandlerException("User aborted replication");
                    }
                    long checkSumServer = -1L;
                    fis.readFully(intbytes);
                    int packetSize = this.readInt(intbytes);
                    if (packetSize <= 0) {
                        LOG.warn("No content recieved for file: " + SnapPuller.this.currentFile);
                        return 1;
                    }
                    if (this.buf.length < packetSize) {
                        this.buf = new byte[packetSize];
                    }
                    if (this.checksum != null) {
                        fis.readFully(longbytes);
                        checkSumServer = this.readLong(longbytes);
                    }
                    fis.readFully(this.buf, 0, packetSize);
                    if (this.includeChecksum) {
                        this.checksum.reset();
                        this.checksum.update(this.buf, 0, packetSize);
                        long checkSumClient = this.checksum.getValue();
                        if (checkSumClient != checkSumServer) {
                            LOG.error("Checksum not matched between client and server for: " + SnapPuller.this.currentFile);
                            return 1;
                        }
                    }
                    this.fileChannel.write(ByteBuffer.wrap(this.buf, 0, packetSize));
                    this.bytesDownloaded += (long)packetSize;
                    if (this.bytesDownloaded >= this.size) {
                        return 0;
                    }
                    this.errorCount = 0;
                }
            }
            catch (ReplicationHandlerException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Error in fetching packets ", (Throwable)e);
                ++this.errorCount;
                if (this.errorCount > 5) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fetch failed for file:" + this.fileName, (Throwable)e);
                }
                return 2;
            }
        }

        private int readInt(byte[] b) {
            return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }

        private long readLong(byte[] b) {
            return (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)((b[5] & 0xFF) << 16) | (long)((b[6] & 0xFF) << 8) | (long)(b[7] & 0xFF);
        }

        private void cleanup() {
            try {
                this.fileOutputStream.close();
            }
            catch (Exception e) {
                LOG.error("Error closing the file stream: " + this.saveAs, (Throwable)e);
            }
            if (this.bytesDownloaded != this.size) {
                try {
                    this.file.delete();
                }
                catch (Exception e) {
                    LOG.error("Error deleting file in cleanup" + e.getMessage());
                }
                if (!this.aborted) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to download " + this.fileName + " completely. Downloaded " + this.bytesDownloaded + "!=" + this.size);
                }
            }
        }

        FastInputStream getStream() throws IOException {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("command", new String[]{"filecontent"});
            params.set("generation", new String[]{Long.toString(this.indexGen)});
            params.set("qt", new String[]{"/replication"});
            if (this.isConf) {
                params.set("cf", new String[]{this.fileName});
            } else {
                params.set("file", new String[]{this.fileName});
            }
            if (SnapPuller.this.useInternal) {
                params.set("compression", new String[]{"true"});
            }
            if (this.includeChecksum) {
                params.set("checksum", true);
            }
            params.set("wt", new String[]{"filestream"});
            if (this.bytesDownloaded > 0L) {
                params.set("offset", new String[]{Long.toString(this.bytesDownloaded)});
            }
            InputStream is = null;
            HttpSolrServer s = new HttpSolrServer(SnapPuller.this.masterUrl, SnapPuller.this.myHttpClient, null);
            try {
                s.setSoTimeout(60000);
                s.setConnectionTimeout(15000);
                QueryRequest req = new QueryRequest((SolrParams)params);
                NamedList response = s.request((SolrRequest)req);
                is = (InputStream)response.get("stream");
                if (SnapPuller.this.useInternal) {
                    is = new InflaterInputStream(is);
                }
                FastInputStream fastInputStream = new FastInputStream(is);
                return fastInputStream;
            }
            catch (Exception e) {
                org.apache.commons.io.IOUtils.closeQuietly(is);
                throw new IOException("Could not download file '" + this.fileName + "'", e);
            }
            finally {
                s.shutdown();
            }
        }
    }

    private class DirectoryFileFetcher {
        boolean includeChecksum = true;
        Directory copy2Dir;
        String fileName;
        String saveAs;
        long size;
        long bytesDownloaded = 0L;
        byte[] buf = new byte[0x100000];
        Checksum checksum;
        int errorCount = 0;
        private boolean isConf;
        private boolean aborted = false;
        private Long indexGen;
        private IndexOutput outStream;

        DirectoryFileFetcher(Directory tmpIndexDir, Map<String, Object> fileDetails, String saveAs, boolean isConf, long latestGen) throws IOException {
            this.copy2Dir = tmpIndexDir;
            this.fileName = (String)fileDetails.get("name");
            this.size = (Long)fileDetails.get("size");
            this.isConf = isConf;
            this.saveAs = saveAs;
            this.indexGen = latestGen;
            this.outStream = this.copy2Dir.createOutput(saveAs, DirectoryFactory.IOCONTEXT_NO_CACHE);
            if (this.includeChecksum) {
                this.checksum = new Adler32();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void fetchFile() throws Exception {
            try {
                FastInputStream is;
                while (true) {
                    is = this.getStream();
                    int result = this.fetchPackets(is);
                    if (result != 0 && result != 1) break block6;
                    break;
                }
                {
                    catch (Throwable throwable) {
                        org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                }
                {
                    block6: {
                        org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                        this.cleanup();
                        SnapPuller.this.fsyncService.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    DirectoryFileFetcher.this.copy2Dir.sync(Collections.singleton(DirectoryFileFetcher.this.saveAs));
                                }
                                catch (IOException e) {
                                    SnapPuller.this.fsyncException = e;
                                }
                            }
                        });
                        return;
                    }
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.cleanup();
                SnapPuller.this.fsyncService.submit(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private int fetchPackets(FastInputStream fis) throws Exception {
            byte[] intbytes = new byte[4];
            byte[] longbytes = new byte[8];
            try {
                while (true) {
                    if (SnapPuller.this.stop) {
                        SnapPuller.this.stop = false;
                        this.aborted = true;
                        throw new ReplicationHandlerException("User aborted replication");
                    }
                    long checkSumServer = -1L;
                    fis.readFully(intbytes);
                    int packetSize = this.readInt(intbytes);
                    if (packetSize <= 0) {
                        LOG.warn("No content recieved for file: " + SnapPuller.this.currentFile);
                        return 1;
                    }
                    if (this.buf.length < packetSize) {
                        this.buf = new byte[packetSize];
                    }
                    if (this.checksum != null) {
                        fis.readFully(longbytes);
                        checkSumServer = this.readLong(longbytes);
                    }
                    fis.readFully(this.buf, 0, packetSize);
                    if (this.includeChecksum) {
                        this.checksum.reset();
                        this.checksum.update(this.buf, 0, packetSize);
                        long checkSumClient = this.checksum.getValue();
                        if (checkSumClient != checkSumServer) {
                            LOG.error("Checksum not matched between client and server for: " + SnapPuller.this.currentFile);
                            return 1;
                        }
                    }
                    this.writeBytes(packetSize);
                    this.bytesDownloaded += (long)packetSize;
                    if (this.bytesDownloaded >= this.size) {
                        return 0;
                    }
                    this.errorCount = 0;
                }
            }
            catch (ReplicationHandlerException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Error in fetching packets ", (Throwable)e);
                ++this.errorCount;
                if (this.errorCount > 5) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fetch failed for file:" + this.fileName, (Throwable)e);
                }
                return 2;
            }
        }

        protected void writeBytes(int packetSize) throws IOException {
            this.outStream.writeBytes(this.buf, 0, packetSize);
        }

        private int readInt(byte[] b) {
            return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }

        private long readLong(byte[] b) {
            return (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)((b[5] & 0xFF) << 16) | (long)((b[6] & 0xFF) << 8) | (long)(b[7] & 0xFF);
        }

        private void cleanup() {
            try {
                this.outStream.close();
            }
            catch (Exception e) {
                LOG.error("Error closing the file stream: " + this.saveAs, (Throwable)e);
            }
            if (this.bytesDownloaded != this.size) {
                try {
                    this.copy2Dir.deleteFile(this.saveAs);
                }
                catch (Exception e) {
                    LOG.error("Error deleting file in cleanup" + e.getMessage());
                }
                if (!this.aborted) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to download " + this.fileName + " completely. Downloaded " + this.bytesDownloaded + "!=" + this.size);
                }
            }
        }

        FastInputStream getStream() throws IOException {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("command", new String[]{"filecontent"});
            params.set("generation", new String[]{Long.toString(this.indexGen)});
            params.set("qt", new String[]{"/replication"});
            if (this.isConf) {
                params.set("cf", new String[]{this.fileName});
            } else {
                params.set("file", new String[]{this.fileName});
            }
            if (SnapPuller.this.useInternal) {
                params.set("compression", new String[]{"true"});
            }
            if (this.includeChecksum) {
                params.set("checksum", true);
            }
            params.set("wt", new String[]{"filestream"});
            if (this.bytesDownloaded > 0L) {
                params.set("offset", new String[]{Long.toString(this.bytesDownloaded)});
            }
            InputStream is = null;
            HttpSolrServer s = new HttpSolrServer(SnapPuller.this.masterUrl, SnapPuller.this.myHttpClient, null);
            try {
                s.setSoTimeout(60000);
                s.setConnectionTimeout(15000);
                QueryRequest req = new QueryRequest((SolrParams)params);
                NamedList response = s.request((SolrRequest)req);
                is = (InputStream)response.get("stream");
                if (SnapPuller.this.useInternal) {
                    is = new InflaterInputStream(is);
                }
                FastInputStream fastInputStream = new FastInputStream(is);
                return fastInputStream;
            }
            catch (Exception e) {
                org.apache.commons.io.IOUtils.closeQuietly(is);
                throw new IOException("Could not download file '" + this.fileName + "'", e);
            }
            finally {
                s.shutdown();
            }
        }
    }

    private static class ReplicationHandlerException
    extends InterruptedException {
        public ReplicationHandlerException(String message) {
            super(message);
        }
    }
}

