/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolrXml;
import org.apache.solr.core.ConfigSolrXmlOld;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolr.class);
    public static final String SOLR_XML_FILE = "solr.xml";
    private static final int DEFAULT_ZK_CLIENT_TIMEOUT = 15000;
    private static final int DEFAULT_LEADER_VOTE_WAIT = 180000;
    private static final int DEFAULT_LEADER_CONFLICT_RESOLVE_WAIT = 180000;
    private static final int DEFAULT_CORE_LOAD_THREADS = 3;
    protected static final String DEFAULT_CORE_ADMIN_PATH = "/admin/cores";
    protected Config config;
    protected Map<CfgProp, String> propMap = new HashMap<CfgProp, String>();

    public static ConfigSolr fromFile(SolrResourceLoader loader, File configFile) {
        ConfigSolr configSolr;
        log.info("Loading container configuration from {}", (Object)configFile.getAbsolutePath());
        InputStream inputStream = null;
        try {
            if (!configFile.exists()) {
                if (ZkContainer.isZkMode()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.xml does not exist in " + configFile.getAbsolutePath() + " cannot start Solr");
                }
                log.info("{} does not exist, using default configuration", (Object)configFile.getAbsolutePath());
                inputStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:collection1}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>".getBytes(Charsets.UTF_8));
            } else {
                inputStream = new FileInputStream(configFile);
            }
            configSolr = ConfigSolr.fromInputStream(loader, inputStream);
        }
        catch (Exception e) {
            try {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load SOLR configuration", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return configSolr;
    }

    public static ConfigSolr fromString(SolrResourceLoader loader, String xml) {
        return ConfigSolr.fromInputStream(loader, new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8)));
    }

    public static ConfigSolr fromInputStream(SolrResourceLoader loader, InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)is, (OutputStream)baos);
            String originalXml = IOUtils.toString((InputStream)new ByteArrayInputStream(baos.toByteArray()), (String)"UTF-8");
            ByteArrayInputStream dup = new ByteArrayInputStream(baos.toByteArray());
            Config config = new Config(loader, null, new InputSource(dup), null, false);
            return ConfigSolr.fromConfig(config, originalXml);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static ConfigSolr fromSolrHome(SolrResourceLoader loader, String solrHome) {
        return ConfigSolr.fromFile(loader, new File(solrHome, SOLR_XML_FILE));
    }

    public static ConfigSolr fromConfig(Config config, String originalXml) {
        boolean oldStyle = config.getNode("solr/cores", false) != null;
        return oldStyle ? new ConfigSolrXmlOld(config, originalXml) : new ConfigSolrXml(config);
    }

    public abstract CoresLocator getCoresLocator();

    public String getCoreRootDirectory() {
        return this.get(CfgProp.SOLR_COREROOTDIRECTORY, this.config.getResourceLoader().getInstanceDir());
    }

    public PluginInfo getShardHandlerFactoryPluginInfo() {
        Node node = this.config.getNode(this.getShardHandlerFactoryConfigPath(), false);
        return node == null ? null : new PluginInfo(node, "shardHandlerFactory", false, true);
    }

    protected abstract String getShardHandlerFactoryConfigPath();

    public String getZkHost() {
        String sysZkHost = System.getProperty("zkHost");
        if (sysZkHost != null) {
            return sysZkHost;
        }
        return this.get(CfgProp.SOLR_ZKHOST, null);
    }

    public int getZkClientTimeout() {
        String sysProp = System.getProperty("zkClientTimeout");
        if (sysProp != null) {
            return Integer.parseInt(sysProp);
        }
        return this.getInt(CfgProp.SOLR_ZKCLIENTTIMEOUT, 15000);
    }

    public String getZkHostPort() {
        return this.get(CfgProp.SOLR_HOSTPORT, null);
    }

    public String getZkHostContext() {
        return this.get(CfgProp.SOLR_HOSTCONTEXT, null);
    }

    public String getHost() {
        return this.get(CfgProp.SOLR_HOST, null);
    }

    public int getLeaderVoteWait() {
        return this.getInt(CfgProp.SOLR_LEADERVOTEWAIT, 180000);
    }

    public int getLeaderConflictResolveWait() {
        return this.getInt(CfgProp.SOLR_LEADERCONFLICTRESOLVEWAIT, 180000);
    }

    public boolean getGenericCoreNodeNames() {
        return this.getBool(CfgProp.SOLR_GENERICCORENODENAMES, false);
    }

    public int getDistributedConnectionTimeout() {
        return this.getInt(CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, 0);
    }

    public int getDistributedSocketTimeout() {
        return this.getInt(CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, 0);
    }

    public int getMaxUpdateConnections() {
        return this.getInt(CfgProp.SOLR_MAXUPDATECONNECTIONS, 10000);
    }

    public int getMaxUpdateConnectionsPerHost() {
        return this.getInt(CfgProp.SOLR_MAXUPDATECONNECTIONSPERHOST, 100);
    }

    public int getCoreLoadThreadCount() {
        return this.getInt(CfgProp.SOLR_CORELOADTHREADS, 3);
    }

    public String getSharedLibDirectory() {
        return this.get(CfgProp.SOLR_SHAREDLIB, null);
    }

    public String getDefaultCoreName() {
        return this.get(CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, null);
    }

    public abstract boolean isPersistent();

    public String getAdminPath() {
        return this.get(CfgProp.SOLR_ADMINPATH, DEFAULT_CORE_ADMIN_PATH);
    }

    public String getCoreAdminHandlerClass() {
        return this.get(CfgProp.SOLR_ADMINHANDLER, "org.apache.solr.handler.admin.CoreAdminHandler");
    }

    public String getCollectionsHandlerClass() {
        return this.get(CfgProp.SOLR_COLLECTIONSHANDLER, "org.apache.solr.handler.admin.CollectionsHandler");
    }

    public String getInfoHandlerClass() {
        return this.get(CfgProp.SOLR_INFOHANDLER, "org.apache.solr.handler.admin.InfoHandler");
    }

    public boolean hasSchemaCache() {
        return this.getBool(CfgProp.SOLR_SHARESCHEMA, false);
    }

    public String getManagementPath() {
        return this.get(CfgProp.SOLR_MANAGEMENTPATH, null);
    }

    public LogWatcherConfig getLogWatcherConfig() {
        return new LogWatcherConfig(this.getBool(CfgProp.SOLR_LOGGING_ENABLED, true), this.get(CfgProp.SOLR_LOGGING_CLASS, null), this.get(CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, null), this.getInt(CfgProp.SOLR_LOGGING_WATCHER_SIZE, 50));
    }

    public int getTransientCacheSize() {
        return this.getInt(CfgProp.SOLR_TRANSIENTCACHESIZE, Integer.MAX_VALUE);
    }

    public ConfigSolr(Config config) {
        this.config = config;
    }

    protected ConfigSolr() {
    }

    public Config getConfig() {
        return this.config;
    }

    public int getInt(CfgProp prop, int def) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? def : Integer.parseInt(val);
    }

    public boolean getBool(CfgProp prop, boolean defValue) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? defValue : Boolean.parseBoolean(val);
    }

    public String get(CfgProp prop, String def) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? def : val;
    }

    public Properties getSolrProperties(String path) {
        try {
            return this.readProperties(((NodeList)this.config.evaluate(path, XPathConstants.NODESET)).item(0));
        }
        catch (Exception e) {
            SolrException.log((Logger)log, null, (Throwable)e);
            return null;
        }
    }

    protected Properties readProperties(Node node) throws XPathExpressionException {
        XPath xpath = this.config.getXPath();
        NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node prop = props.item(i);
            properties.setProperty(DOMUtil.getAttr(prop, "name"), PropertiesUtil.substituteProperty(DOMUtil.getAttr(prop, "value"), null));
        }
        return properties;
    }

    protected static enum CfgProp {
        SOLR_ADMINHANDLER,
        SOLR_COLLECTIONSHANDLER,
        SOLR_CORELOADTHREADS,
        SOLR_COREROOTDIRECTORY,
        SOLR_DISTRIBUPDATECONNTIMEOUT,
        SOLR_DISTRIBUPDATESOTIMEOUT,
        SOLR_MAXUPDATECONNECTIONS,
        SOLR_MAXUPDATECONNECTIONSPERHOST,
        SOLR_HOST,
        SOLR_HOSTCONTEXT,
        SOLR_HOSTPORT,
        SOLR_INFOHANDLER,
        SOLR_LEADERVOTEWAIT,
        SOLR_LOGGING_CLASS,
        SOLR_LOGGING_ENABLED,
        SOLR_LOGGING_WATCHER_SIZE,
        SOLR_LOGGING_WATCHER_THRESHOLD,
        SOLR_MANAGEMENTPATH,
        SOLR_SHAREDLIB,
        SOLR_SHARESCHEMA,
        SOLR_TRANSIENTCACHESIZE,
        SOLR_GENERICCORENODENAMES,
        SOLR_ZKCLIENTTIMEOUT,
        SOLR_ZKHOST,
        SOLR_LEADERCONFLICTRESOLVEWAIT,
        SOLR_PERSISTENT,
        SOLR_CORES_DEFAULT_CORE_NAME,
        SOLR_ADMINPATH;

    }
}

