/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.solr.store.blockcache.BufferStore;

public abstract class CustomBufferedIndexInput
extends IndexInput {
    public static final int BUFFER_SIZE = 1024;
    private int bufferSize = 1024;
    protected byte[] buffer;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public CustomBufferedIndexInput(String resourceDesc) {
        this(resourceDesc, 1024);
    }

    public CustomBufferedIndexInput(String resourceDesc, int bufferSize) {
        super(resourceDesc);
        this.checkBufferSize(bufferSize);
        this.bufferSize = bufferSize;
    }

    private void checkBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than 0 (got " + bufferSize + ")");
        }
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.readBytes(b, offset, len, true);
    }

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        if (len <= this.bufferLength - this.bufferPosition) {
            if (len > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
            }
            this.bufferPosition += len;
        } else {
            int available = this.bufferLength - this.bufferPosition;
            if (available > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, available);
                offset += available;
                len -= available;
                this.bufferPosition += available;
            }
            if (useBuffer && len < this.bufferSize) {
                this.refill();
                if (this.bufferLength < len) {
                    System.arraycopy(this.buffer, 0, b, offset, this.bufferLength);
                    throw new IOException("read past EOF");
                }
                System.arraycopy(this.buffer, 0, b, offset, len);
                this.bufferPosition = len;
            } else {
                long after = this.bufferStart + (long)this.bufferPosition + (long)len;
                if (after > this.length()) {
                    throw new IOException("read past EOF");
                }
                this.readInternal(b, offset, len);
                this.bufferStart = after;
                this.bufferPosition = 0;
                this.bufferLength = 0;
            }
        }
    }

    public int readInt() throws IOException {
        if (4 <= this.bufferLength - this.bufferPosition) {
            return (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
        }
        return super.readInt();
    }

    public long readLong() throws IOException {
        if (8 <= this.bufferLength - this.bufferPosition) {
            int i1 = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            int i2 = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
        }
        return super.readLong();
    }

    public int readVInt() throws IOException {
        if (5 <= this.bufferLength - this.bufferPosition) {
            byte b = this.buffer[this.bufferPosition++];
            int i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                b = this.buffer[this.bufferPosition++];
                i |= (b & 0x7F) << shift;
                shift += 7;
            }
            return i;
        }
        return super.readVInt();
    }

    public long readVLong() throws IOException {
        if (9 <= this.bufferLength - this.bufferPosition) {
            byte b = this.buffer[this.bufferPosition++];
            long i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                b = this.buffer[this.bufferPosition++];
                i |= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            return i;
        }
        return super.readVLong();
    }

    private void refill() throws IOException {
        int newLength;
        long start = this.bufferStart + (long)this.bufferPosition;
        long end = start + (long)this.bufferSize;
        if (end > this.length()) {
            end = this.length();
        }
        if ((newLength = (int)(end - start)) <= 0) {
            throw new EOFException("read past EOF");
        }
        if (this.buffer == null) {
            this.buffer = BufferStore.takeBuffer(this.bufferSize);
            this.seekInternal(this.bufferStart);
        }
        this.readInternal(this.buffer, 0, newLength);
        this.bufferLength = newLength;
        this.bufferStart = start;
        this.bufferPosition = 0;
    }

    public final void close() throws IOException {
        this.closeInternal();
        BufferStore.putBuffer(this.buffer);
        this.buffer = null;
    }

    protected abstract void closeInternal() throws IOException;

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public IndexInput clone() {
        CustomBufferedIndexInput clone = (CustomBufferedIndexInput)super.clone();
        clone.buffer = null;
        clone.bufferLength = 0;
        clone.bufferPosition = 0;
        clone.bufferStart = this.getFilePointer();
        return clone;
    }

    protected int flushBuffer(IndexOutput out, long numBytes) throws IOException {
        int toCopy = this.bufferLength - this.bufferPosition;
        if ((long)toCopy > numBytes) {
            toCopy = (int)numBytes;
        }
        if (toCopy > 0) {
            out.writeBytes(this.buffer, this.bufferPosition, toCopy);
            this.bufferPosition += toCopy;
        }
        return toCopy;
    }
}

