/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

class SimpleStats {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;

    public SimpleStats(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.docs = docs;
        this.params = params;
    }

    public NamedList<Object> getStatsCounts() throws IOException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        res.add("stats_fields", this.getStatsFields());
        return res;
    }

    public NamedList<Object> getStatsFields() throws IOException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] statsFs = this.params.getParams("stats.field");
        boolean isShard = this.params.getBool("isShard", false);
        if (null != statsFs) {
            IndexSchema schema = this.searcher.getSchema();
            for (String f : statsFs) {
                NamedList<?> stv;
                String[] facets = this.params.getFieldParams(f, "stats.facet");
                if (facets == null) {
                    facets = new String[]{};
                }
                SchemaField sf = schema.getField(f);
                FieldType ft = sf.getType();
                if (sf.multiValued() || ft.multiValuedFieldCache()) {
                    UnInvertedField uif = UnInvertedField.getUnInvertedField(f, this.searcher);
                    stv = uif.getStats(this.searcher, this.docs, facets).getStatsValues();
                } else {
                    stv = this.getFieldCacheStats(f, facets);
                }
                if (isShard || (Long)stv.get("count") > 0L) {
                    res.add(f, stv);
                    continue;
                }
                res.add(f, null);
            }
        }
        return res;
    }

    public NamedList<?> getFieldCacheStats(String fieldName, String[] facet) throws IOException {
        IndexSchema schema = this.searcher.getSchema();
        SchemaField sf = schema.getField(fieldName);
        StatsValues allstats = StatsValuesFactory.createStatsValues(sf);
        ArrayList<FieldFacetStats> facetStats = new ArrayList<FieldFacetStats>();
        for (String facetField : facet) {
            SchemaField fsf = schema.getField(facetField);
            if (fsf.multiValued()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stats can only facet on single-valued fields, not: " + facetField);
            }
            facetStats.add(new FieldFacetStats(this.searcher, facetField, sf, fsf));
        }
        Iterator ctxIt = this.searcher.getIndexReader().leaves().iterator();
        AtomicReaderContext ctx = null;
        DocIterator docsIt = this.docs.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (ctx == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                while ((ctx = (AtomicReaderContext)ctxIt.next()) == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                }
                assert (doc >= ctx.docBase);
                allstats.setNextReader(ctx);
                for (FieldFacetStats f : facetStats) {
                    f.setNextReader(ctx);
                }
            }
            allstats.accumulate(doc - ctx.docBase);
            for (FieldFacetStats f : facetStats) {
                f.facet(doc - ctx.docBase);
            }
        }
        for (FieldFacetStats f : facetStats) {
            allstats.addFacet(f.name, f.facetStatsValues);
        }
        return allstats.getStatsValues();
    }
}

