/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.search.MissingStringLastComparatorSource;

class ShardFieldSortedHitQueue
extends PriorityQueue<ShardDoc> {
    protected Comparator[] comparators;
    protected SortField[] fields;
    protected List<String> fieldNames = new ArrayList<String>();

    public ShardFieldSortedHitQueue(SortField[] fields, int size) {
        super(size);
        int n = fields.length;
        this.comparators = new Comparator[n];
        this.fields = new SortField[n];
        for (int i = 0; i < n; ++i) {
            SortField.Type type = fields[i].getType();
            if (type != SortField.Type.SCORE && type != SortField.Type.DOC) {
                this.fieldNames.add(fields[i].getField());
            }
            String fieldname = fields[i].getField();
            this.comparators[i] = this.getCachedComparator(fieldname, fields[i].getType(), fields[i].getComparatorSource());
            this.fields[i] = fields[i].getType() == SortField.Type.STRING ? new SortField(fieldname, SortField.Type.STRING, fields[i].getReverse()) : new SortField(fieldname, fields[i].getType(), fields[i].getReverse());
        }
    }

    protected boolean lessThan(ShardDoc docA, ShardDoc docB) {
        if (docA.shard == docB.shard) {
            return docA.orderInShard >= docB.orderInShard;
        }
        int n = this.comparators.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            c = this.fields[i].getReverse() ? this.comparators[i].compare(docB, docA) : this.comparators[i].compare(docA, docB);
        }
        if (c == 0) {
            c = -docA.shard.compareTo(docB.shard);
        }
        return c < 0;
    }

    Comparator getCachedComparator(String fieldname, SortField.Type type, FieldComparatorSource factory) {
        Comparator comparator = null;
        switch (type) {
            case SCORE: {
                comparator = ShardFieldSortedHitQueue.comparatorScore(fieldname);
                break;
            }
            case STRING: {
                comparator = this.comparatorNatural(fieldname);
                break;
            }
            case CUSTOM: {
                if (factory instanceof MissingStringLastComparatorSource) {
                    comparator = this.comparatorMissingStringLast(fieldname);
                    break;
                }
                comparator = this.comparatorNatural(fieldname);
                break;
            }
            case DOC: {
                throw new RuntimeException("Doc sort not supported");
            }
            default: {
                comparator = this.comparatorNatural(fieldname);
            }
        }
        return comparator;
    }

    static Comparator comparatorScore(String fieldName) {
        return new Comparator(){

            public final int compare(Object o1, Object o2) {
                float f2;
                ShardDoc e1 = (ShardDoc)((Object)o1);
                ShardDoc e2 = (ShardDoc)((Object)o2);
                float f1 = e1.score.floatValue();
                if (f1 < (f2 = e2.score.floatValue())) {
                    return -1;
                }
                if (f1 > f2) {
                    return 1;
                }
                return 0;
            }
        };
    }

    Comparator comparatorNatural(String fieldName) {
        return new ShardComparator(fieldName){

            @Override
            public final int compare(Object o1, Object o2) {
                Comparable v2;
                ShardDoc sd1 = (ShardDoc)((Object)o1);
                ShardDoc sd2 = (ShardDoc)((Object)o2);
                Comparable v1 = (Comparable)this.sortVal(sd1);
                if (v1 == (v2 = (Comparable)this.sortVal(sd2))) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                if (v2 == null) {
                    return -1;
                }
                return -v1.compareTo(v2);
            }
        };
    }

    Comparator comparatorStringLocale(String fieldName, Locale locale) {
        final Collator collator = Collator.getInstance(locale);
        return new ShardComparator(fieldName){

            @Override
            public final int compare(Object o1, Object o2) {
                Comparable v2;
                ShardDoc sd1 = (ShardDoc)((Object)o1);
                ShardDoc sd2 = (ShardDoc)((Object)o2);
                Comparable v1 = (Comparable)this.sortVal(sd1);
                if (v1 == (v2 = (Comparable)this.sortVal(sd2))) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                if (v2 == null) {
                    return -1;
                }
                return -collator.compare(v1, v2);
            }
        };
    }

    Comparator comparatorMissingStringLast(String fieldName) {
        return new ShardComparator(fieldName){

            @Override
            public final int compare(Object o1, Object o2) {
                Comparable v2;
                ShardDoc sd1 = (ShardDoc)((Object)o1);
                ShardDoc sd2 = (ShardDoc)((Object)o2);
                Comparable v1 = (Comparable)this.sortVal(sd1);
                if (v1 == (v2 = (Comparable)this.sortVal(sd2))) {
                    return 0;
                }
                if (v1 == null) {
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                return -v1.compareTo(v2);
            }
        };
    }

    class ShardComparator
    implements Comparator {
        String fieldName;
        int fieldNum;

        public ShardComparator(String fieldName) {
            this.fieldName = fieldName;
            this.fieldNum = 0;
            for (int i = 0; i < ShardFieldSortedHitQueue.this.fieldNames.size(); ++i) {
                if (!ShardFieldSortedHitQueue.this.fieldNames.get(i).equals(fieldName)) continue;
                this.fieldNum = i;
                break;
            }
        }

        Object sortVal(ShardDoc shardDoc) {
            assert (shardDoc.sortFieldValues.getName(this.fieldNum).equals(this.fieldName));
            List lst = (List)shardDoc.sortFieldValues.getVal(this.fieldNum);
            return lst.get(shardDoc.orderInShard);
        }

        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

