/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigSolrXmlOld
extends ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolrXmlOld.class);
    private NodeList coreNodes = null;
    public static final String DEF_SOLR_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>";

    @Override
    protected String getShardHandlerFactoryConfigPath() {
        return "solr/cores/shardHandlerFactory";
    }

    public ConfigSolrXmlOld(Config config) {
        super(config);
        try {
            this.checkForIllegalConfig();
            this.fillPropMap();
            config.substituteProperties();
            this.initCoreList();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForIllegalConfig() throws IOException {
        this.failIfFound("solr/str[@name='adminHandler']");
        this.failIfFound("solr/int[@name='coreLoadThreads']");
        this.failIfFound("solr/str[@name='coreRootDirectory']");
        this.failIfFound("solr/solrcloud/int[@name='distribUpdateConnTimeout']");
        this.failIfFound("solr/solrcloud/int[@name='distribUpdateSoTimeout']");
        this.failIfFound("solr/solrcloud/str[@name='host']");
        this.failIfFound("solr/solrcloud/str[@name='hostContext']");
        this.failIfFound("solr/solrcloud/int[@name='hostPort']");
        this.failIfFound("solr/solrcloud/int[@name='leaderVoteWait']");
        this.failIfFound("solr/solrcloud/int[@name='genericCoreNodeNames']");
        this.failIfFound("solr/str[@name='managementPath']");
        this.failIfFound("solr/str[@name='sharedLib']");
        this.failIfFound("solr/str[@name='shareSchema']");
        this.failIfFound("solr/int[@name='transientCacheSize']");
        this.failIfFound("solr/solrcloud/int[@name='zkClientTimeout']");
        this.failIfFound("solr/solrcloud/int[@name='zkHost']");
        this.failIfFound("solr/logging/str[@name='class']");
        this.failIfFound("solr/logging/str[@name='enabled']");
        this.failIfFound("solr/logging/watcher/int[@name='size']");
        this.failIfFound("solr/logging/watcher/int[@name='threshold']");
    }

    private void failIfFound(String xPath) {
        if (this.config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + " solr.xml may be a mix of old and new style formats.");
        }
    }

    private void fillPropMap() {
        this.propMap.put(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, this.config.getVal("solr/@coreLoadThreads", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_SHAREDLIB, this.config.getVal("solr/@sharedLib", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKHOST, this.config.getVal("solr/@zkHost", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, this.config.getVal("solr/logging/@class", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, this.config.getVal("solr/logging/@enabled", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, this.config.getVal("solr/logging/watcher/@size", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, this.config.getVal("solr/logging/watcher/@threshold", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, this.config.getVal("solr/cores/@adminHandler", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, this.config.getVal("solr/cores/@distribUpdateConnTimeout", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, this.config.getVal("solr/cores/@distribUpdateSoTimeout", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOST, this.config.getVal("solr/cores/@host", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, this.config.getVal("solr/cores/@hostContext", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTPORT, this.config.getVal("solr/cores/@hostPort", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, this.config.getVal("solr/cores/@leaderVoteWait", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_GENERICCORENODENAMES, this.config.getVal("solr/cores/@genericCoreNodeNames", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, this.config.getVal("solr/cores/@managementPath", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, this.config.getVal("solr/cores/@shareSchema", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, this.config.getVal("solr/cores/@transientCacheSize", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, this.config.getVal("solr/cores/@zkClientTimeout", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, this.config.getVal("solr/cores/@defaultCoreName", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_PERSISTENT, this.config.getVal("solr/@persistent", false));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ADMINPATH, this.config.getVal("solr/cores/@adminPath", false));
    }

    private void initCoreList() throws IOException {
        this.coreNodes = (NodeList)this.config.evaluate("solr/cores/core", XPathConstants.NODESET);
        HashSet<String> names = new HashSet<String>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
            String instDir;
            Node node = this.coreNodes.item(idx);
            String name = DOMUtil.getAttr(node, "name", null);
            String dataDir = DOMUtil.getAttr(node, "dataDir", null);
            if (dataDir != null) {
                dataDir = PropertiesUtil.substituteProperty(dataDir, null);
            }
            if (name != null) {
                if (!names.contains(name)) {
                    names.add(name);
                } else {
                    String msg = String.format(Locale.ROOT, "More than one core defined for core named %s", name);
                    log.error(msg);
                }
            }
            if ((instDir = DOMUtil.getAttr(node, "instanceDir", null)) != null) {
                instDir = PropertiesUtil.substituteProperty(instDir, null);
            }
            if (dataDir == null) continue;
            String absData = null;
            File dataFile = new File(dataDir);
            if (dataFile.isAbsolute()) {
                absData = dataFile.getCanonicalPath();
            } else if (instDir != null) {
                File instFile = new File(instDir);
                absData = new File(instFile, dataDir).getCanonicalPath();
            }
            if (absData == null) continue;
            if (!dirs.containsKey(absData)) {
                dirs.put(absData, name);
                continue;
            }
            String msg = String.format(Locale.ROOT, "More than one core points to data dir %s. They are in %s and %s", absData, dirs.get(absData), name);
            log.warn(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> readCoreAttributes(String coreName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    String val = PropertiesUtil.substituteProperty(attribute.getNodeValue(), null);
                    if (("dataDir".equals(attribute.getNodeName()) || "instanceDir".equals(attribute.getNodeName())) && val.indexOf(36) == -1) {
                        val = val != null && !val.endsWith("/") ? val + '/' : val;
                    }
                    attrs.put(attribute.getNodeName(), val);
                }
                return attrs;
            }
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllCoreNames() {
        ArrayList<String> ret = new ArrayList<String>();
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                ret.add(DOMUtil.getAttr(node, "name", null));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String coreName, String property, String defaultVal) {
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                String propVal = DOMUtil.getAttr(node, property, defaultVal);
                return PropertiesUtil.substituteProperty(propVal, null);
            }
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties readCoreProperties(String coreName) {
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                try {
                    return this.readProperties(node);
                }
                catch (XPathExpressionException e) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void substituteProperties() {
        this.config.substituteProperties();
    }
}

