/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.SystemIdResolver;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ManagedIndexSchemaFactory
extends IndexSchemaFactory {
    private static final Logger log = LoggerFactory.getLogger(ManagedIndexSchemaFactory.class);
    private static final String UPGRADED_SCHEMA_EXTENSION = ".bak";
    private boolean isMutable;
    private String managedSchemaResourceName;
    private SolrConfig config;
    private SolrResourceLoader loader;
    private String resourceName;
    private IndexSchema schema;

    @Override
    public void init(NamedList args) {
        SolrParams params = SolrParams.toSolrParams((NamedList)args);
        this.isMutable = params.getBool("mutable", false);
        args.remove("mutable");
        this.managedSchemaResourceName = params.get("managedSchemaResourceName", "managed-schema");
        args.remove("managedSchemaResourceName");
        if ("schema.xml".equals(this.managedSchemaResourceName)) {
            String msg = "managedSchemaResourceName can't be 'schema.xml'";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        if (args.size() > 0) {
            String msg = "Unexpected arg(s): " + args;
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }

    @Override
    public IndexSchema create(String resourceName, SolrConfig config) {
        SolrResourceLoader loader;
        this.resourceName = resourceName;
        this.config = config;
        this.loader = loader = config.getResourceLoader();
        InputStream schemaInputStream = null;
        boolean shouldUpgrade = false;
        String loadedResource = null;
        if (null == resourceName) {
            resourceName = "schema.xml";
        }
        try {
            schemaInputStream = loader.openSchema(this.managedSchemaResourceName);
            loadedResource = this.managedSchemaResourceName;
            if (!resourceName.equals(this.managedSchemaResourceName) && this.nonManagedSchemaExists()) {
                log.warn("The schema has been upgraded to managed, but the non-managed schema " + resourceName + " is still loadable.  PLEASE REMOVE THIS FILE.");
            }
        }
        catch (IOException e) {
            log.info("SolrConfig.isManagedSchema = true, but managed schema resource " + this.managedSchemaResourceName + " not found - loading non-managed schema " + resourceName + " instead");
        }
        if (null == schemaInputStream) {
            try {
                schemaInputStream = loader.openSchema(resourceName);
                loadedResource = resourceName;
                shouldUpgrade = true;
            }
            catch (Exception e) {
                try {
                    schemaInputStream = loader.openSchema(this.managedSchemaResourceName);
                    loadedResource = this.managedSchemaResourceName;
                }
                catch (IOException e1) {
                    String msg = "Error loading both non-managed schema '" + resourceName + "' and managed schema '" + this.managedSchemaResourceName + "'";
                    log.error(msg, (Throwable)e);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
                }
            }
        }
        InputSource inputSource = new InputSource(schemaInputStream);
        inputSource.setSystemId(SystemIdResolver.createSystemIdFromResourceName(loadedResource));
        this.schema = new ManagedIndexSchema(config, loadedResource, inputSource, this.isMutable);
        if (shouldUpgrade) {
            this.upgradeToManagedSchema();
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean nonManagedSchemaExists() {
        boolean exists;
        block10: {
            InputStream nonManagedSchemaInputStream;
            exists = false;
            SolrResourceLoader loader = this.config.getResourceLoader();
            if (loader instanceof ZkSolrResourceLoader) {
                ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)loader;
                String nonManagedSchemaPath = zkLoader.getCollectionZkPath() + "/" + this.resourceName;
                try {
                    exists = zkLoader.getZkController().pathExists(nonManagedSchemaPath);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("", (Throwable)e);
                }
                catch (KeeperException e) {
                    log.warn("Error checking for the existence of the non-managed schema " + this.resourceName, (Throwable)e);
                }
            } else {
                block9: {
                    nonManagedSchemaInputStream = null;
                    nonManagedSchemaInputStream = loader.openSchema(this.resourceName);
                    if (null == nonManagedSchemaInputStream) break block9;
                    exists = true;
                }
                IOUtils.closeQuietly((InputStream)nonManagedSchemaInputStream);
            }
            break block10;
            catch (IOException e) {
                IOUtils.closeQuietly((InputStream)nonManagedSchemaInputStream);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(nonManagedSchemaInputStream);
                    throw throwable;
                }
            }
        }
        return exists;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeToManagedSchema() {
        SolrResourceLoader loader = this.config.getResourceLoader();
        if (loader instanceof ZkSolrResourceLoader) {
            this.zkUgradeToManagedSchema();
            return;
        }
        File managedSchemaFile = new File(loader.getConfigDir(), this.managedSchemaResourceName);
        OutputStreamWriter writer = null;
        try {
            File parentDir = managedSchemaFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                String msg = "Can't create managed schema directory " + parentDir.getAbsolutePath();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            FileOutputStream out = new FileOutputStream(managedSchemaFile);
            writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            this.schema.persist(writer);
            log.info("Upgraded to managed schema at " + managedSchemaFile.getPath());
        }
        catch (IOException e) {
            try {
                String msg = "Error persisting managed schema " + managedSchemaFile;
                log.error(msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                try {
                    FileUtils.sync(managedSchemaFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    String msg = "Error syncing the managed schema file " + managedSchemaFile;
                    log.error(msg, (Throwable)e2);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        try {
            FileUtils.sync(managedSchemaFile);
        }
        catch (IOException e) {
            String msg = "Error syncing the managed schema file " + managedSchemaFile;
            log.error(msg, (Throwable)e);
        }
        if (this.resourceName.equals(this.managedSchemaResourceName)) {
            log.info("On upgrading to managed schema, did not rename non-managed schema '" + this.resourceName + "' because it's the same as the managed schema's name.");
            return;
        }
        File nonManagedSchemaFile = this.locateConfigFile(this.resourceName);
        if (null == nonManagedSchemaFile) {
            log.warn("On upgrading to managed schema, did not rename non-managed schema " + this.resourceName + " because it's neither an absolute file " + "nor under SolrConfig.getConfigDir() or the current directory." + "  PLEASE REMOVE THIS FILE.");
            return;
        }
        File upgradedSchemaFile = new File(nonManagedSchemaFile.getPath() + UPGRADED_SCHEMA_EXTENSION);
        if (nonManagedSchemaFile.renameTo(upgradedSchemaFile)) {
            this.schema.setResourceName(this.managedSchemaResourceName);
            log.info("After upgrading to managed schema, renamed the non-managed schema " + nonManagedSchemaFile + " to " + upgradedSchemaFile);
            return;
        }
        log.warn("Can't rename " + nonManagedSchemaFile.toString() + " to " + upgradedSchemaFile.toString() + " - PLEASE REMOVE THIS FILE.");
    }

    private File locateConfigFile(String resource) {
        File located = null;
        File file = new File(resource);
        if (file.isAbsolute()) {
            if (file.isFile() && file.canRead()) {
                located = file;
            }
        } else {
            File fileUnderConfigDir = new File(this.config.getResourceLoader().getConfigDir() + resource);
            if (fileUnderConfigDir.isFile() && fileUnderConfigDir.canRead()) {
                located = fileUnderConfigDir;
            } else if (file.isFile() && file.canRead()) {
                located = file;
            }
        }
        return located;
    }

    private void zkUgradeToManagedSchema() {
        ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)this.config.getResourceLoader();
        ZkCmdExecutor zkCmdExecutor = new ZkCmdExecutor(30);
        ZkController zkController = zkLoader.getZkController();
        String managedSchemaPath = zkLoader.getCollectionZkPath() + "/" + this.managedSchemaResourceName;
        try {
            zkCmdExecutor.ensureExists(managedSchemaPath, zkController.getZkClient());
            StringWriter writer = new StringWriter();
            this.schema.persist(writer);
            zkController.getZkClient().setData(managedSchemaPath, writer.toString().getBytes("UTF-8"), true);
            log.info("Upgraded to managed schema at " + managedSchemaPath + "");
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            String msg = "Error persisting managed schema resource " + this.managedSchemaResourceName;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        if (this.resourceName.equals(this.managedSchemaResourceName)) {
            log.info("On upgrading to managed schema, did not rename non-managed schema " + this.resourceName + " because it's the same as the managed schema's name.");
        } else {
            String nonManagedSchemaPath = zkLoader.getCollectionZkPath() + "/" + this.resourceName;
            try {
                if (zkController.pathExists(nonManagedSchemaPath)) {
                    byte[] bytes = zkController.getZkClient().getData(nonManagedSchemaPath, null, null, true);
                    String upgradedSchemaPath = nonManagedSchemaPath + UPGRADED_SCHEMA_EXTENSION;
                    zkCmdExecutor.ensureExists(upgradedSchemaPath, zkController.getZkClient());
                    zkController.getZkClient().setData(upgradedSchemaPath, bytes, true);
                    zkController.getZkClient().delete(nonManagedSchemaPath, -1, true);
                    this.schema.setResourceName(this.managedSchemaResourceName);
                    log.info("After upgrading to managed schema in ZooKeeper, renamed the non-managed schema " + nonManagedSchemaPath + " to " + upgradedSchemaPath);
                } else {
                    log.info("After upgrading to managed schema in ZooKeeper, the non-managed schema " + nonManagedSchemaPath + " no longer exists.");
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    log.warn("", (Throwable)e);
                }
                String msg = "Error persisting managed schema resource " + this.managedSchemaResourceName;
                log.warn(msg, (Throwable)e);
            }
        }
    }
}

