/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.io.UnsupportedEncodingException;
import org.apache.solr.common.SolrException;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.rest.schema.BaseSchemaResource;
import org.apache.solr.schema.SchemaField;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFieldResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(DynamicFieldResource.class);
    private String fieldNamePattern;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.fieldNamePattern = (String)this.getRequestAttributes().get("name");
            try {
                this.fieldNamePattern = null == this.fieldNamePattern ? "" : DynamicFieldResource.urlDecode(this.fieldNamePattern.trim()).trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException((Throwable)e);
            }
        }
    }

    @Override
    public Representation get() {
        try {
            if (this.fieldNamePattern.isEmpty()) {
                String message = "Dynamic field name is missing";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Dynamic field name is missing");
            }
            SchemaField field = null;
            for (SchemaField prototype : this.getSchema().getDynamicFieldPrototypes()) {
                if (!prototype.getName().equals(this.fieldNamePattern)) continue;
                field = prototype;
                break;
            }
            if (null == field) {
                String message = "Dynamic field '" + this.fieldNamePattern + "' not found.";
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, message);
            }
            this.getSolrResponse().add("dynamicField", this.getFieldProperties(field));
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }
}

