/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreAdminHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(CoreAdminHandler.class);
    protected final CoreContainer coreContainer;

    public CoreAdminHandler() {
        this.coreContainer = null;
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        boolean doPersist = false;
        SolrParams params = req.getParams();
        CoreAdminParams.CoreAdminAction action = CoreAdminParams.CoreAdminAction.STATUS;
        String a = params.get("action");
        if (a != null && (action = CoreAdminParams.CoreAdminAction.get((String)a)) == null) {
            doPersist = this.handleCustomAction(req, rsp);
        }
        if (action != null) {
            switch (action) {
                case CREATE: {
                    doPersist = this.handleCreateAction(req, rsp);
                    break;
                }
                case RENAME: {
                    doPersist = this.handleRenameAction(req, rsp);
                    break;
                }
                case UNLOAD: {
                    doPersist = this.handleUnloadAction(req, rsp);
                    break;
                }
                case STATUS: {
                    doPersist = this.handleStatusAction(req, rsp);
                    break;
                }
                case PERSIST: {
                    doPersist = this.handlePersistAction(req, rsp);
                    break;
                }
                case RELOAD: {
                    doPersist = this.handleReloadAction(req, rsp);
                    break;
                }
                case SWAP: {
                    doPersist = this.handleSwapAction(req, rsp);
                    break;
                }
                case MERGEINDEXES: {
                    doPersist = this.handleMergeAction(req, rsp);
                    break;
                }
                case SPLIT: {
                    doPersist = this.handleSplitAction(req, rsp);
                    break;
                }
                case PREPRECOVERY: {
                    this.handleWaitForStateAction(req, rsp);
                    break;
                }
                case REQUESTRECOVERY: {
                    this.handleRequestRecoveryAction(req, rsp);
                    break;
                }
                case REQUESTSYNCSHARD: {
                    this.handleRequestSyncAction(req, rsp);
                    break;
                }
                case REQUESTAPPLYUPDATES: {
                    this.handleRequestApplyUpdatesAction(req, rsp);
                    break;
                }
                default: {
                    doPersist = this.handleCustomAction(req, rsp);
                }
                case LOAD: 
            }
        }
        if (doPersist) {
            cores.persist();
            rsp.add("saved", cores.getConfigFile().getAbsolutePath());
        }
        rsp.setHttpCaching(false);
    }

    protected boolean handleSplitAction(SolrQueryRequest adminReq, SolrQueryResponse rsp) throws IOException {
        SolrParams params = adminReq.getParams();
        List ranges = null;
        String[] pathsArr = params.getParams("path");
        String rangesStr = params.get("ranges");
        String[] newCoreNames = params.getParams("targetCore");
        String cname = params.get("core", "");
        if (!(pathsArr != null && pathsArr.length != 0 || newCoreNames != null && newCoreNames.length != 0)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either path or targetCore param must be specified");
        }
        log.info("Invoked split action for core: " + cname);
        SolrCore core = this.coreContainer.getCore(cname);
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, params);
        ArrayList<SolrCore> newCores = null;
        try {
            List<String> paths = null;
            int partitions = pathsArr != null ? pathsArr.length : newCoreNames.length;
            DocRouter router = null;
            if (this.coreContainer.isZooKeeperAware()) {
                ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
                String collectionName = req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
                DocCollection collection = clusterState.getCollection(collectionName);
                String sliceName = req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                Slice slice = clusterState.getSlice(collectionName, sliceName);
                DocRouter.Range currentRange = slice.getRange();
                router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
                List list = ranges = currentRange != null ? router.partitionRange(partitions, currentRange) : null;
            }
            if (pathsArr == null) {
                newCores = new ArrayList<SolrCore>(partitions);
                for (String newCoreName : newCoreNames) {
                    SolrCore newcore = this.coreContainer.getCore(newCoreName);
                    if (newcore == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name " + newCoreName + " expected but doesn't exist.");
                    }
                    newCores.add(newcore);
                }
            } else {
                paths = Arrays.asList(pathsArr);
            }
            SplitIndexCommand cmd = new SplitIndexCommand(req, paths, newCores, ranges, router);
            core.getUpdateHandler().split(cmd);
        }
        catch (Exception e) {
            log.error("ERROR executing split:", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (req != null) {
                req.close();
            }
            if (core != null) {
                core.close();
            }
            if (newCores != null) {
                for (SolrCore newCore : newCores) {
                    newCore.close();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleMergeAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SolrParams params = req.getParams();
        String cname = params.required().get("core");
        SolrCore core = this.coreContainer.getCore(cname);
        SolrQueryRequest wrappedReq = null;
        Object[] sourceCores = null;
        Object[] searchers = null;
        DirectoryReader[] readersToBeClosed = null;
        Directory[] dirsToBeReleased = null;
        if (core != null) {
            block27: {
                try {
                    int i;
                    String[] stringArray = params.getParams("indexDir");
                    if (stringArray == null || stringArray.length == 0) {
                        String[] sources = params.getParams("srcCore");
                        if (sources == null || sources.length == 0) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one indexDir or srcCore must be specified");
                        }
                        sourceCores = new SolrCore[sources.length];
                        for (i = 0; i < sources.length; ++i) {
                            String source = sources[i];
                            SolrCore srcCore = this.coreContainer.getCore(source);
                            if (srcCore == null) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core: " + source + " does not exist");
                            }
                            sourceCores[i] = srcCore;
                        }
                    } else {
                        readersToBeClosed = new DirectoryReader[stringArray.length];
                        dirsToBeReleased = new Directory[stringArray.length];
                        DirectoryFactory dirFactory = core.getDirectoryFactory();
                        for (i = 0; i < stringArray.length; ++i) {
                            Directory dir;
                            dirsToBeReleased[i] = dir = dirFactory.get(stringArray[i], DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
                            readersToBeClosed[i] = DirectoryReader.open((Directory)dir);
                        }
                    }
                    DirectoryReader[] readers = null;
                    if (readersToBeClosed != null) {
                        readers = readersToBeClosed;
                    } else {
                        readers = new DirectoryReader[sourceCores.length];
                        searchers = new RefCounted[sourceCores.length];
                        for (i = 0; i < sourceCores.length; ++i) {
                            Directory solrCore = sourceCores[i];
                            searchers[i] = solrCore.getSearcher();
                            readers[i] = ((SolrIndexSearcher)searchers[i].get()).getIndexReader();
                        }
                    }
                    UpdateRequestProcessorChain processorChain = core.getUpdateProcessingChain(params.get("update.chain"));
                    wrappedReq = new LocalSolrQueryRequest(core, req.getParams());
                    UpdateRequestProcessor processor = processorChain.createProcessor(wrappedReq, rsp);
                    processor.processMergeIndexes(new MergeIndexesCommand(readers, req));
                    if (searchers == null) break block27;
                }
                catch (Throwable throwable) {
                    if (searchers != null) {
                        for (Directory searcher : searchers) {
                            if (searcher == null) continue;
                            searcher.decref();
                        }
                    }
                    if (sourceCores != null) {
                        for (Directory solrCore : sourceCores) {
                            if (solrCore == null) continue;
                            solrCore.close();
                        }
                    }
                    if (readersToBeClosed != null) {
                        IOUtils.closeWhileHandlingException(readersToBeClosed);
                    }
                    if (dirsToBeReleased != null) {
                        for (Directory dir : dirsToBeReleased) {
                            DirectoryFactory dirFactory = core.getDirectoryFactory();
                            dirFactory.release(dir);
                        }
                    }
                    if (wrappedReq != null) {
                        wrappedReq.close();
                    }
                    core.close();
                    throw throwable;
                }
                for (Directory searcher : searchers) {
                    if (searcher == null) continue;
                    searcher.decref();
                }
            }
            if (sourceCores != null) {
                for (Directory solrCore : sourceCores) {
                    if (solrCore == null) continue;
                    solrCore.close();
                }
            }
            if (readersToBeClosed != null) {
                IOUtils.closeWhileHandlingException((Closeable[])readersToBeClosed);
            }
            if (dirsToBeReleased != null) {
                for (Directory dir : dirsToBeReleased) {
                    DirectoryFactory dirFactory = core.getDirectoryFactory();
                    dirFactory.release(dir);
                }
            }
            if (wrappedReq != null) {
                wrappedReq.close();
            }
            core.close();
        }
        return this.coreContainer.isPersistent();
    }

    protected boolean handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    protected boolean handleCreateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String name = params.get("name");
        if (null == name || "".equals(name)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core name is mandatory to CREATE a SolrCore");
        }
        try {
            CloudDescriptor cd;
            Boolean value;
            if (this.coreContainer.getAllCoreNames().contains(name)) {
                log.warn("Re-creating a core with existing name is not allowed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core with name '" + name + "' already exists.");
            }
            String instanceDir = params.get("instanceDir");
            if (instanceDir == null) {
                instanceDir = name;
            }
            CoreDescriptor dcore = new CoreDescriptor(this.coreContainer, name, instanceDir);
            String opts = params.get("config");
            if (opts != null) {
                dcore.setConfigName(opts);
            }
            if ((opts = params.get("schema")) != null) {
                dcore.setSchemaName(opts);
            }
            if ((opts = params.get("dataDir")) != null) {
                dcore.setDataDir(opts);
            }
            if ((opts = params.get("ulogDir")) != null) {
                dcore.setUlogDir(opts);
            }
            if ((opts = params.get("loadOnStartup")) != null) {
                value = Boolean.valueOf(opts);
                dcore.setLoadOnStartup(value);
            }
            if ((opts = params.get("transient")) != null) {
                value = Boolean.valueOf(opts);
                dcore.setTransient(value);
            }
            if ((cd = dcore.getCloudDescriptor()) != null) {
                Integer numShards;
                cd.setParams(req.getParams());
                opts = params.get("collection");
                if (opts != null) {
                    cd.setCollectionName(opts);
                }
                if ((opts = params.get("shard")) != null) {
                    cd.setShardId(opts);
                }
                if ((opts = params.get("shard.range")) != null) {
                    cd.setShardRange(opts);
                }
                if ((opts = params.get("shard.state")) != null) {
                    cd.setShardState(opts);
                }
                if ((opts = params.get("roles")) != null) {
                    cd.setRoles(opts);
                }
                if ((opts = params.get("coreNodeName")) != null) {
                    cd.setCoreNodeName(opts);
                }
                if ((numShards = params.getInt("numShards")) != null) {
                    cd.setNumShards(numShards);
                }
            }
            Properties coreProperties = new Properties();
            Iterator parameterNamesIterator = params.getParameterNamesIterator();
            while (parameterNamesIterator.hasNext()) {
                String parameterName = (String)parameterNamesIterator.next();
                if (!parameterName.startsWith("property.")) continue;
                String parameterValue = params.get(parameterName);
                String propertyName = parameterName.substring("property.".length());
                coreProperties.put(propertyName, parameterValue);
            }
            dcore.setCoreProperties(coreProperties);
            SolrCore core = this.coreContainer.create(dcore);
            String sameDirCore = this.coreContainer.checkUniqueDataDir(core.getDataDir());
            if (sameDirCore != null) {
                if (core != null) {
                    core.close();
                }
                log.warn("Creating a core that points to the same data dir as core {} is not allowed", (Object)sameDirCore);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core with same data dir '" + sameDirCore + "' already exists.");
            }
            this.coreContainer.register(name, core, false);
            rsp.add("core", core.getName());
            return this.coreContainer.isPersistent();
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error CREATEing SolrCore '" + name + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected boolean handleRenameAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        boolean doPersist = false;
        if (cname.equals(name)) {
            return doPersist;
        }
        doPersist = this.coreContainer.isPersistent();
        this.coreContainer.rename(cname, name);
        return doPersist;
    }

    @Deprecated
    protected boolean handleAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        boolean doPersist = false;
        if (cname.equals(name)) {
            return doPersist;
        }
        SolrCore core = this.coreContainer.getCore(cname);
        if (core != null) {
            doPersist = this.coreContainer.isPersistent();
            this.coreContainer.register(name, core, false);
        }
        return doPersist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleUnloadAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        SolrCore core = this.coreContainer.remove(cname);
        try {
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core exists '" + cname + "'");
            }
            if (this.coreContainer.getZkController() != null) {
                log.info("Unregistering core " + core.getName() + " from cloudstate.");
                try {
                    this.coreContainer.getZkController().unregister(cname, core.getCoreDescriptor());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not unregister core " + cname + " from cloudstate: " + e.getMessage(), (Throwable)e);
                }
                catch (KeeperException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not unregister core " + cname + " from cloudstate: " + e.getMessage(), (Throwable)e);
                }
            }
            if (params.getBool("deleteIndex", false)) {
                try {
                    core.getDirectoryFactory().remove(core.getIndexDir());
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Failed to flag index dir for removal for core:" + core.getName() + " dir:" + core.getIndexDir()));
                }
            }
            if (params.getBool("deleteDataDir", false)) {
                try {
                    core.getDirectoryFactory().remove(core.getDataDir(), true);
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Failed to flag data dir for removal for core:" + core.getName() + " dir:" + core.getDataDir()));
                }
            }
            if (params.getBool("deleteInstanceDir", false)) {
                core.addCloseHook(new CloseHook(){

                    @Override
                    public void preClose(SolrCore core) {
                    }

                    @Override
                    public void postClose(SolrCore core) {
                        CoreDescriptor cd = core.getCoreDescriptor();
                        if (cd != null) {
                            File instanceDir = new File(cd.getInstanceDir());
                            try {
                                FileUtils.deleteDirectory((File)instanceDir);
                            }
                            catch (IOException e) {
                                SolrException.log((Logger)log, (String)("Failed to delete instance dir for core:" + core.getName() + " dir:" + instanceDir.getAbsolutePath()));
                            }
                        }
                    }
                });
            }
        }
        finally {
            if (core != null) {
                if (this.coreContainer.getZkController() != null) {
                    core.getSolrCoreState().cancelRecovery();
                }
                core.close();
            }
        }
        return this.coreContainer.isPersistent();
    }

    protected boolean handleStatusAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        String indexInfo = params.get("indexInfo");
        boolean isIndexInfoNeeded = Boolean.parseBoolean(null == indexInfo ? "true" : indexInfo);
        boolean doPersist = false;
        SimpleOrderedMap status = new SimpleOrderedMap();
        Map<String, Exception> allFailures = this.coreContainer.getCoreInitFailures();
        try {
            if (cname == null) {
                rsp.add("defaultCoreName", this.coreContainer.getDefaultCoreName());
                for (String name : this.coreContainer.getAllCoreNames()) {
                    status.add(name, this.getCoreStatus(this.coreContainer, name, isIndexInfoNeeded));
                }
                rsp.add("initFailures", allFailures);
            } else {
                Map failures = allFailures.containsKey(cname) ? Collections.singletonMap(cname, allFailures.get(cname)) : Collections.emptyMap();
                rsp.add("initFailures", failures);
                status.add(cname, this.getCoreStatus(this.coreContainer, cname, isIndexInfoNeeded));
            }
            rsp.add("status", status);
            doPersist = false;
            return doPersist;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'status' action ", (Throwable)ex);
        }
    }

    protected boolean handlePersistAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        boolean doPersist = false;
        String fileName = params.get("file");
        if (fileName != null) {
            File file = new File(this.coreContainer.getConfigFile().getParentFile(), fileName);
            this.coreContainer.persistFile(file);
            rsp.add("saved", file.getAbsolutePath());
            doPersist = false;
        } else {
            if (!this.coreContainer.isPersistent()) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Persistence is not enabled");
            }
            doPersist = true;
        }
        return doPersist;
    }

    protected boolean handleReloadAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        try {
            this.coreContainer.reload(cname);
            return false;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'reload' action", (Throwable)ex);
        }
    }

    protected boolean handleSwapAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        RequiredSolrParams required = params.required();
        String cname = params.get("core");
        boolean doPersist = params.getBool("persistent", this.coreContainer.isPersistent());
        String other = required.get("other");
        this.coreContainer.swap(cname, other);
        return doPersist;
    }

    protected void handleRequestRecoveryAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        final SolrParams params = req.getParams();
        log.info("It has been requested that we recover");
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    String cname = params.get("core");
                    if (cname == null) {
                        cname = "";
                    }
                    SolrCore core = null;
                    try {
                        core = CoreAdminHandler.this.coreContainer.getCore(cname);
                        if (core != null) {
                            try {
                                CoreAdminHandler.this.coreContainer.getZkController().publish(core.getCoreDescriptor(), "recovering");
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                SolrException.log((Logger)log, (String)"", (Throwable)e);
                            }
                            catch (Throwable t) {
                                SolrException.log((Logger)log, (String)"", (Throwable)t);
                            }
                            core.getUpdateHandler().getSolrCoreState().doRecovery(CoreAdminHandler.this.coreContainer, core.getCoreDescriptor());
                            break block9;
                        }
                        SolrException.log((Logger)log, (String)("Cound not find core to call recovery:" + cname));
                    }
                    finally {
                        if (core != null) {
                            core.close();
                        }
                    }
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequestSyncAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SolrParams params = req.getParams();
        log.info("I have been requested to sync up my shard");
        ZkController zkController = this.coreContainer.getZkController();
        if (zkController == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
        }
        String cname = params.get("core");
        if (cname == null) {
            throw new IllegalArgumentException("core is required");
        }
        SolrCore core = null;
        SyncStrategy syncStrategy = null;
        try {
            core = this.coreContainer.getCore(cname);
            if (core != null) {
                syncStrategy = new SyncStrategy();
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("base_url", zkController.getBaseUrl());
                props.put("core", cname);
                props.put("node_name", zkController.getNodeName());
                boolean success = syncStrategy.sync(zkController, core, new ZkNodeProps(props));
                if (!success) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Sync Failed");
                }
            } else {
                SolrException.log((Logger)log, (String)("Cound not find core to call sync:" + cname));
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
            if (syncStrategy != null) {
                syncStrategy.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWaitForStateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, InterruptedException, KeeperException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        if (cname == null) {
            cname = "";
        }
        String nodeName = params.get("nodeName");
        String coreNodeName = params.get("coreNodeName");
        String waitForState = params.get("state");
        Boolean checkLive = params.getBool("checkLive");
        Boolean onlyIfLeader = params.getBool("onlyIfLeader");
        log.info("Going to wait for coreNodeName: " + coreNodeName + ", state: " + waitForState + ", checkLive: " + checkLive + ", onlyIfLeader: " + onlyIfLeader);
        String state = null;
        boolean live = false;
        int retry = 0;
        while (true) {
            SolrCore core = null;
            try {
                core = this.coreContainer.getCore(cname);
                if (core == null && retry == 30) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "core not found:" + cname);
                }
                if (core != null) {
                    ZkNodeProps nodeProps;
                    String collection;
                    ClusterState clusterState;
                    Slice slice;
                    if (onlyIfLeader != null && onlyIfLeader.booleanValue() && !core.getCoreDescriptor().getCloudDescriptor().isLeader()) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We are not the leader");
                    }
                    CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                    if (retry == 15 || retry == 60) {
                        this.coreContainer.getZkController().getZkStateReader().updateClusterState(true);
                    }
                    if ((slice = (clusterState = this.coreContainer.getZkController().getClusterState()).getSlice(collection = cloudDescriptor.getCollectionName(), cloudDescriptor.getShardId())) != null && (nodeProps = (ZkNodeProps)slice.getReplicasMap().get(coreNodeName)) != null) {
                        state = nodeProps.getStr("state");
                        live = clusterState.liveNodesContain(nodeName);
                        if (nodeProps != null && state.equals(waitForState) && (checkLive == null || checkLive.booleanValue() && live || !checkLive.booleanValue() && !live)) break;
                    }
                }
                if (retry++ == 120) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "I was asked to wait on state " + waitForState + " for " + nodeName + " but I still do not see the requested state. I see state: " + state + " live:" + live);
                }
                if (this.coreContainer.isShutDown()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr is shutting down");
                }
            }
            finally {
                if (core != null) {
                    core.close();
                }
            }
            Thread.sleep(1000L);
        }
        log.info("Waited coreNodeName: " + coreNodeName + ", state: " + waitForState + ", checkLive: " + checkLive + ", onlyIfLeader: " + onlyIfLeader + " for: " + retry + " seconds.");
    }

    private void handleRequestApplyUpdatesAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("name", "");
        SolrCore core = this.coreContainer.getCore(cname);
        try {
            UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
            if (updateLog.getState() != UpdateLog.State.BUFFERING) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in buffering state");
            }
            Future<UpdateLog.RecoveryInfo> future = updateLog.applyBufferedUpdates();
            if (future == null) {
                log.info("No buffered updates available. core=" + cname);
                rsp.add("core", cname);
                rsp.add("status", "EMPTY_BUFFER");
                return;
            }
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                SolrException.log((Logger)log, (String)"Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
            this.coreContainer.getZkController().publish(core.getCoreDescriptor(), "active");
            rsp.add("core", cname);
            rsp.add("status", "BUFFER_APPLIED");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Recovery was interrupted", (Throwable)e);
        }
        catch (Throwable e) {
            if (e instanceof SolrException) {
                throw (SolrException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not apply buffered updates", e);
        }
        finally {
            if (req != null) {
                req.close();
            }
            if (core != null) {
                core.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedList<Object> getCoreStatus(CoreContainer cores, String cname, boolean isIndexInfoNeeded) throws IOException {
        SimpleOrderedMap info;
        block13: {
            info = new SimpleOrderedMap();
            if (!cores.isLoaded(cname)) {
                CoreDescriptor desc = cores.getUnloadedCoreDescriptor(cname);
                if (desc != null) {
                    info.add("name", (Object)desc.getName());
                    info.add("isDefaultCore", (Object)desc.getName().equals(cores.getDefaultCoreName()));
                    info.add("instanceDir", (Object)desc.getInstanceDir());
                    String tmp = desc.getDataDir();
                    if (StringUtils.isNotBlank((String)tmp)) {
                        info.add("dataDir", (Object)tmp);
                    }
                    if (StringUtils.isNotBlank((String)(tmp = desc.getConfigName()))) {
                        info.add("config", (Object)tmp);
                    }
                    if (StringUtils.isNotBlank((String)(tmp = desc.getSchemaName()))) {
                        info.add("schema", (Object)tmp);
                    }
                    info.add("isLoaded", (Object)"false");
                }
            } else {
                SolrCore core = cores.getCore(cname);
                if (core != null) {
                    try {
                        info.add("name", (Object)core.getName());
                        info.add("isDefaultCore", (Object)core.getName().equals(cores.getDefaultCoreName()));
                        info.add("instanceDir", (Object)CoreAdminHandler.normalizePath(core.getResourceLoader().getInstanceDir()));
                        info.add("dataDir", (Object)CoreAdminHandler.normalizePath(core.getDataDir()));
                        info.add("config", (Object)core.getConfigResource());
                        info.add("schema", (Object)core.getSchemaResource());
                        info.add("startTime", (Object)new Date(core.getStartTime()));
                        info.add("uptime", (Object)(System.currentTimeMillis() - core.getStartTime()));
                        if (!isIndexInfoNeeded) break block13;
                        RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                        try {
                            SimpleOrderedMap<Object> indexInfo = LukeRequestHandler.getIndexInfo(searcher.get().getIndexReader());
                            long size = this.getIndexSize(core);
                            indexInfo.add("sizeInBytes", (Object)size);
                            indexInfo.add("size", (Object)NumberUtils.readableSize(size));
                            info.add("index", indexInfo);
                        }
                        finally {
                            searcher.decref();
                        }
                    }
                    finally {
                        core.close();
                    }
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIndexSize(SolrCore core) {
        long size = 0L;
        try {
            Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
            try {
                size = DirectoryFactory.sizeOfDirectory(dir);
            }
            finally {
                core.getDirectoryFactory().release(dir);
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)"IO error while trying to get the size of the Directory", (Throwable)e);
        }
        return size;
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_3/solr/core/src/java/org/apache/solr/handler/admin/CoreAdminHandler.java $";
    }
}

