/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.ConfigSolrXml;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.update.SolrCoreState;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;

class CoreMaps {
    private static Object locker = new Object();
    private final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    private Map<String, SolrCore> transientCores = new LinkedHashMap<String, SolrCore>();
    private final Map<String, CoreDescriptor> dynamicDescriptors = new LinkedHashMap<String, CoreDescriptor>();
    private final Map<String, SolrCore> createdCores = new LinkedHashMap<String, SolrCore>();
    private Map<SolrCore, String> coreToOrigName = new ConcurrentHashMap<SolrCore, String>();
    private final CoreContainer container;
    private static final Set<String> pendingCoreOps = new HashSet<String>();
    private static final List<SolrCore> pendingCloses = new ArrayList<SolrCore>();

    CoreMaps(CoreContainer container) {
        this.container = container;
    }

    protected void allocateLazyCores(ConfigSolr cfg, SolrResourceLoader loader) {
        final int transientCacheSize = cfg.getInt(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, Integer.MAX_VALUE);
        if (transientCacheSize != Integer.MAX_VALUE) {
            CoreContainer.log.info("Allocating transient cache for {} transient cores", (Object)transientCacheSize);
            this.transientCores = new LinkedHashMap<String, SolrCore>(transientCacheSize, 0.75f, true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean removeEldestEntry(Map.Entry<String, SolrCore> eldest) {
                    if (this.size() > transientCacheSize) {
                        Object object = locker;
                        synchronized (object) {
                            pendingCloses.add(eldest.getValue());
                            locker.notifyAll();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putDynamicDescriptor(String rawName, CoreDescriptor p) {
        Object object = locker;
        synchronized (object) {
            this.dynamicDescriptors.put(rawName, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void clearMaps(ConfigSolr cfg) {
        block45: while (true) {
            Object core;
            ArrayList<SolrCore> pendingToClose;
            ArrayList<String> transientNames;
            ArrayList<String> coreNames;
            Object object = locker;
            synchronized (object) {
                coreNames = new ArrayList<String>(this.cores.keySet());
                transientNames = new ArrayList<String>(this.transientCores.keySet());
                pendingToClose = new ArrayList<SolrCore>(pendingCloses);
            }
            if (coreNames.size() == 0 && transientNames.size() == 0 && pendingToClose.size() == 0) return;
            for (String coreName : coreNames) {
                core = this.cores.get(coreName);
                if (core == null) {
                    CoreContainer.log.info("Core " + coreName + " moved from core container list before closing.");
                    continue;
                }
                try {
                    this.addPersistOneCore(cfg, this.container.loader, ((SolrCore)core).getCoreDescriptor(), this.getCoreToOrigName((SolrCore)core));
                    ((SolrCore)core).close();
                }
                catch (Throwable t) {
                    SolrException.log((Logger)CoreContainer.log, (String)"Error shutting down core", (Throwable)t);
                }
                finally {
                    Object object2 = locker;
                    synchronized (object2) {
                        this.cores.remove(coreName);
                    }
                }
            }
            for (String coreName : transientNames) {
                core = this.transientCores.get(coreName);
                if (core == null) {
                    CoreContainer.log.info("Core " + coreName + " moved from transient core container list before closing.");
                    continue;
                }
                try {
                    ((SolrCore)core).close();
                }
                catch (Throwable t) {
                    SolrException.log((Logger)CoreContainer.log, (String)"Error shutting down core", (Throwable)t);
                }
                finally {
                    Object t = locker;
                    synchronized (t) {
                        this.transientCores.remove(coreName);
                    }
                }
            }
            Iterator i$ = pendingToClose.iterator();
            while (true) {
                if (!i$.hasNext()) continue block45;
                SolrCore core2 = (SolrCore)i$.next();
                try {
                    core2.close();
                    continue;
                }
                catch (Throwable t) {
                    SolrException.log((Logger)CoreContainer.log, (String)"Error shutting down core", (Throwable)t);
                    continue;
                }
                finally {
                    core = locker;
                    synchronized (core) {
                        pendingCloses.remove(core2);
                    }
                    continue;
                }
                break;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCoresToList(ArrayList<SolrCoreState> coreStates) {
        ArrayList<SolrCore> addCores;
        Object object = locker;
        synchronized (object) {
            addCores = new ArrayList<SolrCore>(this.cores.values());
        }
        for (SolrCore core : addCores) {
            coreStates.add(core.getUpdateHandler().getSolrCoreState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putTransientCore(ConfigSolr cfg, String name, SolrCore core, SolrResourceLoader loader) {
        SolrCore retCore;
        CoreContainer.log.info("Opening transient core {}", (Object)name);
        Object object = locker;
        synchronized (object) {
            retCore = this.transientCores.put(name, core);
        }
        return retCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putCore(String name, SolrCore core) {
        Object object = locker;
        synchronized (object) {
            return this.cores.put(name, core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SolrCore> getCores() {
        ArrayList<SolrCore> lst = new ArrayList<SolrCore>();
        Object object = locker;
        synchronized (object) {
            lst.addAll(this.cores.values());
            return lst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = locker;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            set.addAll(this.transientCores.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getCoreNames(SolrCore core) {
        ArrayList<String> lst = new ArrayList<String>();
        Object object = locker;
        synchronized (object) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
            for (Map.Entry<String, SolrCore> entry : this.transientCores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = locker;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            set.addAll(this.transientCores.keySet());
            set.addAll(this.dynamicDescriptors.keySet());
            set.addAll(this.createdCores.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolrCore getCore(String name) {
        Object object = locker;
        synchronized (object) {
            return this.cores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swap(String n0, String n1) {
        Object object = locker;
        synchronized (object) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c0.getCoreDescriptor().putProperty("name", n1);
            c1.setName(n0);
            c1.getCoreDescriptor().putProperty("name", n0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore remove(String name, boolean removeOrig) {
        Object object = locker;
        synchronized (object) {
            SolrCore tmp = this.cores.remove(name);
            SolrCore ret = null;
            if (removeOrig && tmp != null) {
                this.coreToOrigName.remove(tmp);
            }
            ret = ret == null ? tmp : ret;
            tmp = this.transientCores.remove(name);
            ret = ret == null ? tmp : ret;
            tmp = this.createdCores.remove(name);
            ret = ret == null ? tmp : ret;
            this.dynamicDescriptors.remove(name);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putCoreToOrigName(SolrCore c, String name) {
        Object object = locker;
        synchronized (object) {
            this.coreToOrigName.put(c, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCoreToOrigName(SolrCore newCore, SolrCore core) {
        Object object = locker;
        synchronized (object) {
            String origName = this.coreToOrigName.remove(core);
            if (origName != null) {
                this.coreToOrigName.put(newCore, origName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreFromAnyList(String name) {
        Object object = locker;
        synchronized (object) {
            SolrCore core = this.cores.get(name);
            if (core != null) {
                return core;
            }
            if (this.dynamicDescriptors.size() == 0) {
                return null;
            }
            return this.transientCores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getDynamicDescriptor(String name) {
        Object object = locker;
        synchronized (object) {
            return this.dynamicDescriptors.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoaded(String name) {
        Object object = locker;
        synchronized (object) {
            if (this.cores.containsKey(name)) {
                return true;
            }
            if (this.transientCores.containsKey(name)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        Object object = locker;
        synchronized (object) {
            CoreDescriptor desc = this.dynamicDescriptors.get(cname);
            if (desc == null) {
                return null;
            }
            return new CoreDescriptor(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCoreToOrigName(SolrCore solrCore) {
        Object object = locker;
        synchronized (object) {
            return this.coreToOrigName.get(solrCore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishCoresAsDown(ZkController zkController) {
        Object object = locker;
        synchronized (object) {
            for (SolrCore core : this.cores.values()) {
                try {
                    zkController.publish(core.getCoreDescriptor(), "down");
                }
                catch (KeeperException e) {
                    CoreContainer.log.error("", (Throwable)e);
                }
                catch (InterruptedException e) {
                    CoreContainer.log.error("", (Throwable)e);
                }
            }
            for (SolrCore core : this.transientCores.values()) {
                try {
                    zkController.publish(core.getCoreDescriptor(), "down");
                }
                catch (KeeperException e) {
                    CoreContainer.log.error("", (Throwable)e);
                }
                catch (InterruptedException e) {
                    CoreContainer.log.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistCores(ConfigSolr cfg, Properties containerProperties, Map<String, String> rootSolrAttribs, Map<String, String> coresAttribs, File file, File configFile, SolrResourceLoader loader) {
        Object object = locker;
        synchronized (object) {
            if (cfg == null) {
                ConfigSolrXml.initPersistStatic();
                this.persistCores(cfg, this.cores, loader);
                this.persistCores(cfg, this.transientCores, loader);
                for (Map.Entry<String, CoreDescriptor> entry : this.dynamicDescriptors.entrySet()) {
                    if (this.cores.containsKey(entry.getKey()) || this.transientCores.containsKey(entry.getKey())) continue;
                    this.addPersistOneCore(cfg, loader, entry.getValue(), null);
                }
                for (Map.Entry<String, Object> entry : this.createdCores.entrySet()) {
                    if (this.cores.containsKey(entry.getKey()) || this.transientCores.containsKey(entry.getKey()) || this.dynamicDescriptors.containsKey(entry.getKey())) continue;
                    this.addPersistOneCore(cfg, loader, ((SolrCore)entry.getValue()).getCoreDescriptor(), null);
                }
                ConfigSolrXml.addPersistAllCoresStatic(containerProperties, rootSolrAttribs, coresAttribs, file == null ? configFile : file);
            } else {
                cfg.initPersist();
                this.persistCores(cfg, this.cores, loader);
                this.persistCores(cfg, this.transientCores, loader);
                for (Map.Entry<String, CoreDescriptor> entry : this.dynamicDescriptors.entrySet()) {
                    if (this.cores.containsKey(entry.getKey()) || this.transientCores.containsKey(entry.getKey())) continue;
                    this.addPersistOneCore(cfg, loader, entry.getValue(), null);
                }
                for (Map.Entry<String, Object> entry : this.createdCores.entrySet()) {
                    if (this.cores.containsKey(entry.getKey()) || this.transientCores.containsKey(entry.getKey()) || this.dynamicDescriptors.containsKey(entry.getKey())) continue;
                    this.addPersistOneCore(cfg, loader, ((SolrCore)entry.getValue()).getCoreDescriptor(), null);
                }
                cfg.addPersistAllCores(containerProperties, rootSolrAttribs, coresAttribs, file == null ? configFile : file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore waitAddPendingCoreOps(String name) {
        Object object = locker;
        synchronized (object) {
            boolean pending;
            do {
                if (!(pending = pendingCoreOps.contains(name))) {
                    for (SolrCore core : pendingCloses) {
                        if (!core.getName().equals(name)) continue;
                        pending = true;
                        break;
                    }
                }
                if (this.container.isShutDown()) {
                    return null;
                }
                if (!pending) continue;
                try {
                    locker.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            } while (pending);
            if (!this.container.isShutDown()) {
                if (!pendingCoreOps.add(name)) {
                    CoreContainer.log.warn("Replaced an entry in pendingCoreOps {}, we should not be doing this", (Object)name);
                }
                return this.getCoreFromAnyList(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromPendingOps(String name) {
        Object object = locker;
        synchronized (object) {
            if (!pendingCoreOps.remove(name)) {
                CoreContainer.log.warn("Tried to remove core {} from pendingCoreOps and it wasn't there. ", (Object)name);
            }
            locker.notifyAll();
        }
    }

    protected void persistCores(ConfigSolr cfg, Map<String, SolrCore> whichCores, SolrResourceLoader loader) {
        for (SolrCore solrCore : whichCores.values()) {
            this.addPersistOneCore(cfg, loader, solrCore.getCoreDescriptor(), this.getCoreToOrigName(solrCore));
        }
    }

    private void addIfNotNull(Map<String, String> coreAttribs, String key, String value) {
        if (value == null) {
            return;
        }
        coreAttribs.put(key, value);
    }

    protected void addPersistOneCore(ConfigSolr cfg, SolrResourceLoader loader, CoreDescriptor dcore, String origCoreName) {
        String coreName = dcore.getProperty("name");
        Map<String, String> coreAttribs = new HashMap<String, String>();
        Properties persistProps = new Properties();
        CloudDescriptor cd = dcore.getCloudDescriptor();
        String collection = null;
        if (cd != null) {
            collection = cd.getCollectionName();
        }
        String instDir = dcore.getRawInstanceDir();
        if (cfg == null) {
            this.addIfNotNull(coreAttribs, "name", coreName);
            this.addIfNotNull(coreAttribs, "config", dcore.getDefaultConfigName());
            this.addIfNotNull(coreAttribs, "schema", dcore.getDefaultSchemaName());
            this.addIfNotNull(coreAttribs, "dataDir", dcore.getProperty("dataDir"));
            this.addIfNotNull(coreAttribs, "ulogDir", dcore.getProperty("ulogDir"));
            this.addIfNotNull(coreAttribs, "transient", dcore.getProperty("transient"));
            this.addIfNotNull(coreAttribs, "loadOnStartup", dcore.getProperty("loadOnStartup"));
            this.addIfNotNull(coreAttribs, "properties", dcore.getPropertiesName());
            TreeSet<String> std = new TreeSet<String>();
            Properties allProps = dcore.getCoreProperties();
            std.addAll(Arrays.asList(CoreDescriptor.standardPropNames));
            for (String prop : allProps.stringPropertyNames()) {
                if (std.contains(prop)) continue;
                persistProps.put(prop, dcore.getProperty(prop));
            }
            if (StringUtils.isNotBlank((String)collection) && !collection.equals(coreName)) {
                coreAttribs.put("collection", collection);
            }
        } else {
            String tmp;
            if (origCoreName == null) {
                origCoreName = coreName;
            }
            if ((tmp = cfg.getCoreNameFromOrig(origCoreName, loader, coreName)) != null) {
                coreName = tmp;
            }
            coreAttribs = cfg.readCoreAttributes(origCoreName);
            persistProps = cfg.readCoreProperties(origCoreName);
            coreAttribs.put("name", coreName);
            if (coreAttribs.containsKey("collection")) {
                collection = coreAttribs.get("collection");
            }
            if (coreAttribs.containsKey("instanceDir")) {
                instDir = coreAttribs.get("instanceDir");
            }
            this.addIfNotNull(coreAttribs, "instanceDir", dcore.getRawInstanceDir());
            coreAttribs.put("collection", StringUtils.isNotBlank((String)collection) ? collection : dcore.getName());
        }
        this.addIfNotNull(coreAttribs, "instanceDir", instDir);
        if (cd != null) {
            this.addIfNotNull(coreAttribs, "shard", cd.getShardId());
            this.addIfNotNull(coreAttribs, "roles", cd.getRoles());
        }
        coreAttribs.put("loadOnStartup", Boolean.toString(dcore.isLoadOnStartup()));
        coreAttribs.put("transient", Boolean.toString(dcore.isTransient()));
        if (cfg != null) {
            cfg.addPersistCore(coreName, persistProps, coreAttribs);
        } else {
            ConfigSolrXml.addPersistCore(persistProps, coreAttribs);
        }
    }

    protected Object getLocker() {
        return locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreToClose() {
        Object object = locker;
        synchronized (object) {
            for (SolrCore core : pendingCloses) {
                if (pendingCoreOps.contains(core.getName())) continue;
                pendingCoreOps.add(core.getName());
                pendingCloses.remove(core);
                return core;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreated(SolrCore core) {
        Object object = locker;
        synchronized (object) {
            this.createdCores.put(core.getName(), core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String checkUniqueDataDir(String targetPath) {
        Object object = locker;
        synchronized (object) {
            for (SolrCore core : this.cores.values()) {
                if (!targetPath.equals(core.getDataDir())) continue;
                return core.getName();
            }
            for (SolrCore core : this.transientCores.values()) {
                if (!targetPath.equals(core.getDataDir())) continue;
                return core.getName();
            }
            for (CoreDescriptor desc : this.dynamicDescriptors.values()) {
                if (!targetPath.equals(desc.getDataDir())) continue;
                return desc.getName();
            }
        }
        return null;
    }
}

