/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CoreDescriptorPlus;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXMLSerializer;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.PropertiesUtil;
import org.apache.solr.util.SystemIdResolver;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigSolrXml
extends Config
implements ConfigSolr {
    private boolean is50OrLater = false;
    private final Map<String, CoreDescriptorPlus> coreDescriptorPlusMap = new HashMap<String, CoreDescriptorPlus>();
    private NodeList coreNodes = null;
    private final Map<String, String> badConfigCores = new HashMap<String, String>();
    private Map<ConfigSolr.CfgProp, String> propMap = new HashMap<ConfigSolr.CfgProp, String>();
    static List<SolrXMLSerializer.SolrCoreXMLDef> solrCoreXMLDefs = new ArrayList<SolrXMLSerializer.SolrCoreXMLDef>();
    private static SolrXMLSerializer solrXMLSerializer = new SolrXMLSerializer();
    static final String DEF_SOLR_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>";

    public ConfigSolrXml(SolrResourceLoader loader, String name, InputStream is, String prefix, boolean subProps, CoreContainer container) throws ParserConfigurationException, IOException, SAXException {
        super(loader, name, new InputSource(is), prefix, subProps);
        this.init(container);
    }

    public ConfigSolrXml(SolrResourceLoader loader, Config cfg, CoreContainer container) throws TransformerException, IOException {
        super(loader, null, ConfigSolrXml.copyDoc(cfg.getDocument()));
        this.init(container);
    }

    private void init(CoreContainer container) throws IOException {
        boolean bl = this.is50OrLater = this.getNode("solr/cores", false) == null;
        if (this.is50OrLater()) {
            this.failIfFound("solr/@coreLoadThreads");
            this.failIfFound("solr/@persist");
            this.failIfFound("solr/@sharedLib");
            this.failIfFound("solr/@zkHost");
            this.failIfFound("solr/logging/@class");
            this.failIfFound("solr/logging/@enabled");
            this.failIfFound("solr/logging/watcher/@size");
            this.failIfFound("solr/logging/watcher/@threshold");
            this.failIfFound("solr/cores/@adminHandler");
            this.failIfFound("solr/cores/@distribUpdateConnTimeout");
            this.failIfFound("solr/cores/@distribUpdateSoTimeout");
            this.failIfFound("solr/cores/@host");
            this.failIfFound("solr/cores/@hostContext");
            this.failIfFound("solr/cores/@hostPort");
            this.failIfFound("solr/cores/@leaderVoteWait");
            this.failIfFound("solr/cores/@managementPath");
            this.failIfFound("solr/cores/@shareSchema");
            this.failIfFound("solr/cores/@transientCacheSize");
            this.failIfFound("solr/cores/@zkClientTimeout");
            this.failIfFound("solr/cores/@defaultCoreName");
            this.failIfFound("solr/@persistent");
            this.failIfFound("solr/cores/@adminPath");
        } else {
            this.failIfFound("solr/str[@name='adminHandler']");
            this.failIfFound("solr/int[@name='coreLoadThreads']");
            this.failIfFound("solr/str[@name='coreRootDirectory']");
            this.failIfFound("solr/solrcloud/int[@name='distribUpdateConnTimeout']");
            this.failIfFound("solr/solrcloud/int[@name='distribUpdateSoTimeout']");
            this.failIfFound("solr/solrcloud/str[@name='host']");
            this.failIfFound("solr/solrcloud/str[@name='hostContext']");
            this.failIfFound("solr/solrcloud/int[@name='hostPort']");
            this.failIfFound("solr/solrcloud/int[@name='leaderVoteWait']");
            this.failIfFound("solr/str[@name='managementPath']");
            this.failIfFound("solr/str[@name='sharedLib']");
            this.failIfFound("solr/str[@name='shareSchema']");
            this.failIfFound("solr/int[@name='transientCacheSize']");
            this.failIfFound("solr/solrcloud/int[@name='zkClientTimeout']");
            this.failIfFound("solr/solrcloud/int[@name='zkHost']");
            this.failIfFound("solr/logging/str[@name='class']");
            this.failIfFound("solr/logging/str[@name='enabled']");
            this.failIfFound("solr/logging/watcher/int[@name='size']");
            this.failIfFound("solr/logging/watcher/int[@name='threshold']");
        }
        this.fillPropMap();
        this.initCoreList(container);
    }

    private void failIfFound(String xPath) {
        if (this.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + " solr.xml may be a mix of old and new style formats.");
        }
    }

    private String doSub(String path) {
        String val = this.getVal(path, false);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val;
    }

    private void fillPropMap() {
        if (this.is50OrLater) {
            this.propMap.put(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, this.doSub("solr/str[@name='adminHandler']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, this.doSub("solr/int[@name='coreLoadThreads']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_COREROOTDIRECTORY, this.doSub("solr/str[@name='coreRootDirectory']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, this.doSub("solr/solrcloud/int[@name='distribUpdateConnTimeout']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, this.doSub("solr/solrcloud/int[@name='distribUpdateSoTimeout']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_HOST, this.doSub("solr/solrcloud/str[@name='host']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, this.doSub("solr/solrcloud/str[@name='hostContext']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTPORT, this.doSub("solr/solrcloud/int[@name='hostPort']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, this.doSub("solr/solrcloud/int[@name='leaderVoteWait']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, this.doSub("solr/str[@name='managementPath']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHAREDLIB, this.doSub("solr/str[@name='sharedLib']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, this.doSub("solr/str[@name='shareSchema']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, this.doSub("solr/int[@name='transientCacheSize']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, this.doSub("solr/solrcloud/int[@name='zkClientTimeout']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKHOST, this.doSub("solr/solrcloud/str[@name='zkHost']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, this.doSub("solr/logging/str[@name='class']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, this.doSub("solr/logging/str[@name='enabled']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, this.doSub("solr/logging/watcher/int[@name='size']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, this.doSub("solr/logging/watcher/int[@name='threshold']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_CLASS, this.doSub("solr/shardHandlerFactory/@class"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_NAME, this.doSub("solr/shardHandlerFactory/@name"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_CONNTIMEOUT, this.doSub("solr/shardHandlerFactory/int[@name='connTimeout']"));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_SOCKETTIMEOUT, this.doSub("solr/shardHandlerFactory/int[@name='socketTimeout']"));
        } else {
            this.propMap.put(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, this.getVal("solr/@coreLoadThreads", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHAREDLIB, this.getVal("solr/@sharedLib", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKHOST, this.getVal("solr/@zkHost", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, this.getVal("solr/logging/@class", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, this.getVal("solr/logging/@enabled", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, this.getVal("solr/logging/watcher/@size", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, this.getVal("solr/logging/watcher/@threshold", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, this.getVal("solr/cores/@adminHandler", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, this.getVal("solr/cores/@distribUpdateConnTimeout", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, this.getVal("solr/cores/@distribUpdateSoTimeout", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_HOST, this.getVal("solr/cores/@host", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, this.getVal("solr/cores/@hostContext", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTPORT, this.getVal("solr/cores/@hostPort", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, this.getVal("solr/cores/@leaderVoteWait", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, this.getVal("solr/cores/@managementPath", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, this.getVal("solr/cores/@shareSchema", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, this.getVal("solr/cores/@transientCacheSize", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, this.getVal("solr/cores/@zkClientTimeout", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_CLASS, this.getVal("solr/shardHandlerFactory/@class", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_NAME, this.getVal("solr/shardHandlerFactory/@name", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_CONNTIMEOUT, this.getVal("solr/shardHandlerFactory/int[@connTimeout]", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARDHANDLERFACTORY_SOCKETTIMEOUT, this.getVal("solr/shardHandlerFactory/int[@socketTimeout]", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, this.getVal("solr/cores/@defaultCoreName", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_PERSISTENT, this.getVal("solr/@persistent", false));
            this.propMap.put(ConfigSolr.CfgProp.SOLR_ADMINPATH, this.getVal("solr/cores/@adminPath", false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCoreList(CoreContainer container) throws IOException {
        if (this.is50OrLater) {
            if (container != null) {
                Map<String, CoreDescriptorPlus> map = this.coreDescriptorPlusMap;
                synchronized (map) {
                    String coreRoot = this.get(ConfigSolr.CfgProp.SOLR_COREROOTDIRECTORY, container.getSolrHome());
                    this.walkFromHere(new File(coreRoot), container, new HashMap<String, String>(), new HashMap<String, String>());
                }
            }
        } else {
            this.coreNodes = (NodeList)this.evaluate("solr/cores/core", XPathConstants.NODESET);
            HashSet<String> names = new HashSet<String>();
            HashMap<String, String> dirs = new HashMap<String, String>();
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                String msg;
                Node node = this.coreNodes.item(idx);
                String name = DOMUtil.getAttr(node, "name", null);
                String dataDir = DOMUtil.getAttr(node, "dataDir", null);
                if (name != null) {
                    if (!names.contains(name)) {
                        names.add(name);
                    } else {
                        msg = String.format(Locale.ROOT, "More than one core defined for core named %s", name);
                        log.error(msg);
                    }
                }
                if (dataDir == null) continue;
                if (!dirs.containsKey(dataDir)) {
                    dirs.put(dataDir, name);
                    continue;
                }
                msg = String.format(Locale.ROOT, "More than one core points to data dir %s. They are in %s and %s", dataDir, dirs.get(dataDir), name);
                log.warn(msg);
            }
        }
    }

    @Override
    public String getBadConfigCoreMessage(String name) {
        return this.badConfigCores.get(name);
    }

    public static Document copyDoc(Document doc) throws TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer tx = tfactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        DOMResult result = new DOMResult();
        tx.transform(source, result);
        return (Document)result.getNode();
    }

    @Override
    public int getInt(ConfigSolr.CfgProp prop, int def) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? def : Integer.parseInt(val);
    }

    @Override
    public boolean getBool(ConfigSolr.CfgProp prop, boolean defValue) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? defValue : Boolean.parseBoolean(val);
    }

    @Override
    public String get(ConfigSolr.CfgProp prop, String def) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? def : val;
    }

    @Override
    public String getOrigProp(ConfigSolr.CfgProp prop, String def) {
        String val = this.propMap.get((Object)prop);
        return val == null ? def : val;
    }

    @Override
    public ShardHandlerFactory initShardHandler() {
        ShardHandlerFactory fac;
        PluginInfo info = null;
        Node shfn = this.getNode("solr/cores/shardHandlerFactory", false);
        if (shfn != null) {
            info = new PluginInfo(shfn, "shardHandlerFactory", false, true);
        } else {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("class", HttpShardHandlerFactory.class.getName());
            info = new PluginInfo("shardHandlerFactory", m, null, Collections.<PluginInfo>emptyList());
        }
        try {
            fac = this.getResourceLoader().findClass(info.className, ShardHandlerFactory.class).newInstance();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating shardHandlerFactory class " + info.className);
        }
        if (fac instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)((Object)fac)).init(info);
        }
        return fac;
    }

    @Override
    public Properties getSolrProperties(String path) {
        try {
            return this.readProperties(((NodeList)this.evaluate(path, XPathConstants.NODESET)).item(0));
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, null, (Throwable)e);
            return null;
        }
    }

    Properties readProperties(Node node) throws XPathExpressionException {
        XPath xpath = this.getXPath();
        NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node prop = props.item(i);
            properties.setProperty(DOMUtil.getAttr(prop, "name"), DOMUtil.getAttr(prop, "value"));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> readCoreAttributes(String coreName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.is50OrLater) {
            return attrs;
        }
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    String val = attribute.getNodeValue();
                    if (("dataDir".equals(attribute.getNodeName()) || "instanceDir".equals(attribute.getNodeName())) && val.indexOf(36) == -1) {
                        val = val != null && !val.endsWith("/") ? val + '/' : val;
                    }
                    attrs.put(attribute.getNodeName(), val);
                }
                return attrs;
            }
        }
        return attrs;
    }

    private void walkFromHere(File file, CoreContainer container, Map<String, String> seenDirs, HashMap<String, String> seenCores) throws IOException {
        log.info("Looking for cores in " + file.getCanonicalPath());
        if (!file.exists()) {
            return;
        }
        for (File childFile : file.listFiles()) {
            File propFile = new File(childFile, "core.properties");
            if (propFile.exists()) {
                this.addCore(container, seenDirs, seenCores, childFile, propFile);
                continue;
            }
            if (!childFile.isDirectory()) continue;
            this.walkFromHere(childFile, container, seenDirs, seenCores);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCore(CoreContainer container, Map<String, String> seenDirs, Map<String, String> seenCores, File childFile, File propFile) throws IOException {
        String msg;
        log.info("Discovered properties file {}, adding to cores", (Object)propFile.getAbsolutePath());
        Properties propsOrig = new Properties();
        FileInputStream is = new FileInputStream(propFile);
        try {
            propsOrig.load(is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        Properties props = new Properties();
        for (String prop : propsOrig.stringPropertyNames()) {
            props.put(prop, PropertiesUtil.substituteProperty(propsOrig.getProperty(prop), null));
        }
        props.setProperty("instanceDir", childFile.getPath());
        if (props.getProperty("name") == null) {
            props.setProperty("name", childFile.getName());
        }
        CoreDescriptor desc = new CoreDescriptor(container, props);
        CoreDescriptorPlus plus = new CoreDescriptorPlus(propFile.getAbsolutePath(), desc, propsOrig);
        if (!seenCores.containsKey(desc.getName()) && !seenDirs.containsKey(desc.getAbsoluteDataDir())) {
            this.coreDescriptorPlusMap.put(desc.getName(), plus);
            seenCores.put(desc.getName(), propFile.getAbsolutePath());
            seenDirs.put(desc.getAbsoluteDataDir(), propFile.getAbsolutePath());
            return;
        }
        if (seenCores.containsKey(desc.getName())) {
            msg = String.format(Locale.ROOT, "More than one core defined for core named '%s', paths are '%s' and '%s'  Removing both cores.", desc.getName(), propFile.getAbsolutePath(), seenCores.get(desc.getName()));
            log.error(msg);
            if (this.badConfigCores.containsKey(desc.getName())) {
                msg = msg + " " + this.badConfigCores.get(desc.getName());
            }
            this.badConfigCores.put(desc.getName(), msg);
        }
        if (seenDirs.containsKey(desc.getAbsoluteDataDir())) {
            msg = String.format(Locale.ROOT, "More than one core points to data dir '%s'. They are in '%s' and '%s'. Removing all offending cores.", desc.getAbsoluteDataDir(), propFile.getAbsolutePath(), seenDirs.get(desc.getAbsoluteDataDir()));
            if (this.badConfigCores.containsKey(desc.getName())) {
                msg = msg + " " + this.badConfigCores.get(desc.getName());
            }
            log.warn(msg);
        }
        this.coreDescriptorPlusMap.remove(desc.getName());
    }

    public IndexSchema getSchemaFromZk(ZkController zkController, String zkConfigName, String schemaName, SolrConfig config) throws KeeperException, InterruptedException {
        byte[] configBytes = zkController.getConfigFileData(zkConfigName, schemaName);
        InputSource is = new InputSource(new ByteArrayInputStream(configBytes));
        is.setSystemId(SystemIdResolver.createSystemIdFromResourceName(schemaName));
        IndexSchema schema = new IndexSchema(config, schemaName, is);
        return schema;
    }

    @Override
    public SolrConfig getSolrConfigFromZk(ZkController zkController, String zkConfigName, String solrConfigFileName, SolrResourceLoader resourceLoader) {
        SolrConfig cfg = null;
        try {
            byte[] config = zkController.getConfigFileData(zkConfigName, solrConfigFileName);
            InputSource is = new InputSource(new ByteArrayInputStream(config));
            is.setSystemId(SystemIdResolver.createSystemIdFromResourceName(solrConfigFileName));
            cfg = solrConfigFileName == null ? new SolrConfig(resourceLoader, "solrconfig.xml", is) : new SolrConfig(resourceLoader, solrConfigFileName, is);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "getSolrConfigFromZK failed for " + zkConfigName + " " + solrConfigFileName, (Throwable)e);
        }
        return cfg;
    }

    @Override
    public void initPersist() {
        ConfigSolrXml.initPersistStatic();
    }

    public static void initPersistStatic() {
        solrCoreXMLDefs = new ArrayList<SolrXMLSerializer.SolrCoreXMLDef>();
        solrXMLSerializer = new SolrXMLSerializer();
    }

    @Override
    public void addPersistCore(String coreName, Properties attribs, Map<String, String> props) {
        ConfigSolrXml.addPersistCore(attribs, props);
    }

    static void addPersistCore(Properties props, Map<String, String> attribs) {
        SolrXMLSerializer.SolrCoreXMLDef solrCoreXMLDef = new SolrXMLSerializer.SolrCoreXMLDef();
        solrCoreXMLDef.coreAttribs = attribs;
        solrCoreXMLDef.coreProperties = props;
        solrCoreXMLDefs.add(solrCoreXMLDef);
    }

    @Override
    public void addPersistAllCores(Properties containerProperties, Map<String, String> rootSolrAttribs, Map<String, String> coresAttribs, File file) {
        ConfigSolrXml.addPersistAllCoresStatic(containerProperties, rootSolrAttribs, coresAttribs, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCoreNameFromOrig(String origCoreName, SolrResourceLoader loader, String coreName) {
        if (this.is50OrLater) {
            String name;
            for (Map.Entry<String, CoreDescriptorPlus> ent : this.coreDescriptorPlusMap.entrySet()) {
                name = ent.getValue().getCoreDescriptor().getProperty("name", null);
                if (!origCoreName.equals(name)) continue;
                if (coreName.equals(origCoreName)) {
                    return name;
                }
                return coreName;
            }
            for (Map.Entry<String, CoreDescriptorPlus> ent : this.coreDescriptorPlusMap.entrySet()) {
                name = ent.getValue().getCoreDescriptor().getProperty("name", null);
                if (!origCoreName.equals(PropertiesUtil.substituteProperty(name, loader.getCoreProperties()))) continue;
                if (coreName.equals(origCoreName)) {
                    return name;
                }
                return coreName;
            }
        } else {
            NodeList nodeList = this.coreNodes;
            synchronized (nodeList) {
                String name;
                Node node;
                int i;
                Object coreNode = null;
                for (i = 0; i < this.coreNodes.getLength(); ++i) {
                    node = this.coreNodes.item(i);
                    name = DOMUtil.getAttr(node, "name", null);
                    if (!origCoreName.equals(name)) continue;
                    if (coreName.equals(origCoreName)) {
                        return name;
                    }
                    return coreName;
                }
                if (coreNode == null) {
                    for (i = 0; i < this.coreNodes.getLength(); ++i) {
                        node = this.coreNodes.item(i);
                        name = DOMUtil.getAttr(node, "name", null);
                        if (!origCoreName.equals(PropertiesUtil.substituteProperty(name, loader.getCoreProperties()))) continue;
                        if (coreName.equals(origCoreName)) {
                            return name;
                        }
                        return coreName;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllCoreNames() {
        ArrayList<String> ret = new ArrayList();
        if (this.is50OrLater) {
            ret = new ArrayList<String>(this.coreDescriptorPlusMap.keySet());
        } else {
            NodeList nodeList = this.coreNodes;
            synchronized (nodeList) {
                for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                    Node node = this.coreNodes.item(idx);
                    ret.add(DOMUtil.getAttr(node, "name", null));
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String coreName, String property, String defaultVal) {
        if (this.is50OrLater) {
            CoreDescriptorPlus plus = this.coreDescriptorPlusMap.get(coreName);
            if (plus == null) {
                return defaultVal;
            }
            CoreDescriptor desc = plus.getCoreDescriptor();
            if (desc == null) {
                return defaultVal;
            }
            return desc.getProperty(property, defaultVal);
        }
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                return DOMUtil.getAttr(node, property, defaultVal);
            }
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties readCoreProperties(String coreName) {
        if (this.is50OrLater) {
            CoreDescriptorPlus plus = this.coreDescriptorPlusMap.get(coreName);
            if (plus == null) {
                return null;
            }
            return new Properties(plus.getCoreDescriptor().getCoreProperties());
        }
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                try {
                    return this.readProperties(node);
                }
                catch (XPathExpressionException e) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public boolean is50OrLater() {
        return this.is50OrLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getCoreProperties(String instanceDir, CoreDescriptor dcore) {
        File corePropsFile;
        String file = dcore.getPropertiesName();
        if (file == null) {
            file = "conf" + File.separator + "solrcore.properties";
        }
        if (!(corePropsFile = new File(file)).isAbsolute()) {
            corePropsFile = new File(instanceDir, file);
        }
        Properties p = dcore.getCoreProperties();
        if (corePropsFile.exists() && corePropsFile.isFile()) {
            p = new Properties(dcore.getCoreProperties());
            FileInputStream is = null;
            try {
                is = new FileInputStream(corePropsFile);
                p.load(is);
            }
            catch (IOException e) {
                try {
                    log.warn("Error loading properties ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return p;
    }

    static void addPersistAllCoresStatic(Properties containerProperties, Map<String, String> rootSolrAttribs, Map<String, String> coresAttribs, File file) {
        SolrXMLSerializer.SolrXMLDef solrXMLDef = new SolrXMLSerializer.SolrXMLDef();
        solrXMLDef.coresDefs = solrCoreXMLDefs;
        solrXMLDef.containerProperties = containerProperties;
        solrXMLDef.solrAttribs = rootSolrAttribs;
        solrXMLDef.coresAttribs = coresAttribs;
        solrXMLSerializer.persistFile(file, solrXMLDef);
    }
}

