/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionProcessor
implements Runnable,
ClosableThread {
    public static final String NUM_SLICES = "numShards";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String DELETECOLLECTION = "deletecollection";
    public static final String CREATECOLLECTION = "createcollection";
    public static final String RELOADCOLLECTION = "reloadcollection";
    public static final String CREATEALIAS = "createalias";
    public static final String DELETEALIAS = "deletealias";
    public static final String SPLITSHARD = "splitshard";
    private static final String QUEUE_OPERATION = "operation";
    private static Logger log = LoggerFactory.getLogger(OverseerCollectionProcessor.class);
    private DistributedQueue workQueue;
    private String myId;
    private ShardHandler shardHandler;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private boolean isClosed;

    public OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath) {
        this(zkStateReader, myId, shardHandler, adminPath, Overseer.getCollectionQueue(zkStateReader.getZkClient()));
    }

    protected OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath, DistributedQueue workQueue) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
        this.workQueue = workQueue;
    }

    @Override
    public void run() {
        log.info("Process current queue of collection creations");
        while (this.amILeader() && !this.isClosed) {
            try {
                DistributedQueue.QueueEvent head = this.workQueue.peek(true);
                ZkNodeProps message = ZkNodeProps.load((byte[])head.getBytes());
                log.info("Overseer Collection Processor: Get the message id:" + head.getId() + " message:" + message.toString());
                String operation = message.getStr(QUEUE_OPERATION);
                SolrResponse response = this.processMessage(message, operation);
                head.setBytes(SolrResponse.serializable((SolrResponse)response));
                this.workQueue.remove(head);
                log.info("Overseer Collection Processor: Message id:" + head.getId() + " complete, response:" + response.getResponse().toString());
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.warn("Overseer cannot talk to ZK");
                    return;
                }
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable e) {
                SolrException.log((Logger)log, (String)"", (Throwable)e);
            }
        }
    }

    public void close() {
        this.isClosed = true;
    }

    protected boolean amILeader() {
        try {
            ZkNodeProps props = ZkNodeProps.load((byte[])this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                return true;
            }
        }
        catch (KeeperException e) {
            log.warn("", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrResponse processMessage(ZkNodeProps message, String operation) {
        NamedList results = new NamedList();
        try {
            if (CREATECOLLECTION.equals(operation)) {
                this.createCollection(this.zkStateReader.getClusterState(), message, results);
            }
            if (DELETECOLLECTION.equals(operation)) {
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
                params.set("deleteInstanceDir", true);
                params.set("deleteDataDir", true);
                this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, null);
                ZkNodeProps m = new ZkNodeProps(new String[]{QUEUE_OPERATION, "removecollection", "name", message.getStr("name")});
                Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)m));
                long now = System.currentTimeMillis();
                long timeout = now + 30000L;
                boolean removed = false;
                while (System.currentTimeMillis() < timeout) {
                    Thread.sleep(100L);
                    removed = !this.zkStateReader.getClusterState().getCollections().contains(message.getStr("name"));
                    if (!removed) continue;
                    Thread.sleep(100L);
                    break;
                }
                if (!removed) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + message.getStr("name"));
                }
            } else {
                if (RELOADCOLLECTION.equals(operation)) {
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
                    this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, "active");
                }
                if (CREATEALIAS.equals(operation)) {
                    this.createAlias(this.zkStateReader.getAliases(), message);
                }
                if (DELETEALIAS.equals(operation)) {
                    this.deleteAlias(this.zkStateReader.getAliases(), message);
                }
                if (SPLITSHARD.equals(operation)) {
                    this.splitShard(this.zkStateReader.getClusterState(), message, results);
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
        }
        catch (Exception ex) {
            SolrException.log((Logger)log, (String)("Collection " + operation + " of " + operation + " failed"), (Throwable)ex);
            results.add("Operation " + operation + " caused exception:", (Object)ex);
            SimpleOrderedMap nl = new SimpleOrderedMap();
            nl.add("msg", (Object)ex.getMessage());
            nl.add("rspCode", (Object)(ex instanceof SolrException ? ((SolrException)((Object)ex)).code() : -1));
            results.add("exception", (Object)nl);
        }
        finally {
            return new OverseerSolrResponse(results);
        }
    }

    private void createAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        String collections = message.getStr("collections");
        HashMap newAliasesMap = new HashMap();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        Map prevColAliases = aliases.getCollectionAliasMap();
        if (prevColAliases != null) {
            newCollectionAliasesMap.putAll(prevColAliases);
        }
        newCollectionAliasesMap.put(aliasName, collections);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAlias(aliasName, collections);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForAlias(String name, String value) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections == null || !collections.equals(value)) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void checkForAliasAbsence(String name) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections != null) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void deleteAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        HashMap newAliasesMap = new HashMap();
        HashMap newCollectionAliasesMap = new HashMap();
        newCollectionAliasesMap.putAll(aliases.getCollectionAliasMap());
        newCollectionAliasesMap.remove(aliasName);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAliasAbsence(aliasName);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private boolean splitShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        log.info("Split shard invoked");
        String collectionName = message.getStr("collection");
        String slice = message.getStr("shard");
        Slice parentSlice = clusterState.getSlice(collectionName, slice);
        if (parentSlice == null) {
            if (clusterState.getCollections().contains(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collectionName);
        }
        Replica parentShardLeader = clusterState.getLeader(collectionName, slice);
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        List subRanges = router.partitionRange(2, range);
        try {
            int i;
            String subShardName;
            String subSlice;
            int i2;
            ArrayList<String> subSlices = new ArrayList<String>(subRanges.size());
            ArrayList<String> subShardNames = new ArrayList<String>(subRanges.size());
            String nodeName = parentShardLeader.getNodeName();
            for (i2 = 0; i2 < subRanges.size(); ++i2) {
                subSlice = slice + "_" + i2;
                subSlices.add(subSlice);
                subShardName = collectionName + "_" + subSlice + "_replica1";
                subShardNames.add(subShardName);
                Slice oSlice = clusterState.getSlice(collectionName, subSlice);
                if (oSlice == null) continue;
                if (Slice.ACTIVE.equals(oSlice.getState())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                if (!Slice.CONSTRUCTION.equals(oSlice.getState())) continue;
                for (Replica replica : oSlice.getReplicas()) {
                    String core = replica.getStr("core");
                    log.info("Unloading core: " + core + " from node: " + replica.getNodeName());
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
                    params.set("core", new String[]{core});
                    params.set("deleteIndex", new String[]{"true"});
                    this.sendShardRequest(replica.getNodeName(), params);
                }
            }
            this.collectShardResponses(results, false, null);
            for (i2 = 0; i2 < subRanges.size(); ++i2) {
                subSlice = (String)subSlices.get(i2);
                subShardName = (String)subShardNames.get(i2);
                DocRouter.Range subRange = (DocRouter.Range)subRanges.get(i2);
                log.info("Creating shard " + subShardName + " as part of slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                params.set("name", new String[]{subShardName});
                params.set("collection", new String[]{collectionName});
                params.set("shard", new String[]{subSlice});
                params.set("shard.range", new String[]{subRange.toString()});
                params.set("shard.state", new String[]{Slice.CONSTRUCTION});
                this.sendShardRequest(nodeName, params);
                log.info("Asking parent leader to wait for: " + subShardName + " to be alive on: " + nodeName);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(nodeName + "_" + subShardName);
                cmd.setState("active");
                cmd.setCheckLive(Boolean.valueOf(true));
                cmd.setOnlyIfLeader(true);
                this.sendShardRequest(nodeName, new ModifiableSolrParams(cmd.getParams()));
            }
            this.collectShardResponses(results, true, "SPLTSHARD failed to create subshard leaders or timed out waiting for them to come up");
            log.info("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
            params.set("core", new String[]{parentShardLeader.getStr("core")});
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", new String[]{subShardName});
            }
            this.sendShardRequest(parentShardLeader.getNodeName(), params);
            this.collectShardResponses(results, true, "SPLITSHARD failed to invoke SPLIT core admin command");
            log.info("Index on shard: " + nodeName + " split into two successfully");
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                log.info("Applying buffered updates on : " + subShardName);
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                params.set("name", new String[]{subShardName});
                this.sendShardRequest(nodeName, params);
            }
            this.collectShardResponses(results, true, "SPLITSHARD failed while asking sub shard leaders to apply buffered updates");
            log.info("Successfully applied buffered updates on : " + subShardNames);
            int repFactor = clusterState.getSlice(collectionName, slice).getReplicas().size();
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            Collections.shuffle(nodeList);
            nodeList.remove(nodeName);
            for (int i3 = 1; i3 <= subSlices.size(); ++i3) {
                Collections.shuffle(nodeList);
                String sliceName = (String)subSlices.get(i3 - 1);
                for (int j = 2; j <= repFactor; ++j) {
                    String subShardNodeName = (String)nodeList.get((repFactor * (i3 - 1) + (j - 2)) % nodeList.size());
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating replica shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + subShardNodeName);
                    params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                    params.set("name", new String[]{shardName});
                    params.set("collection", new String[]{collectionName});
                    params.set("shard", new String[]{sliceName});
                    this.sendShardRequest(subShardNodeName, params);
                    log.info("Asking sub shard leader to wait for: " + shardName + " to be alive on: " + subShardNodeName);
                    CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                    cmd.setCoreName((String)subShardNames.get(i3 - 1));
                    cmd.setNodeName(subShardNodeName);
                    cmd.setCoreNodeName(subShardNodeName + "_" + shardName);
                    cmd.setState("active");
                    cmd.setCheckLive(Boolean.valueOf(true));
                    cmd.setOnlyIfLeader(true);
                    this.sendShardRequest(nodeName, new ModifiableSolrParams(cmd.getParams()));
                }
            }
            this.collectShardResponses(results, true, "SPLTSHARD failed to create subshard replicas or timed out waiting for them to come up");
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            log.info("Requesting update shard state");
            DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put(QUEUE_OPERATION, "updateshardstate");
            propMap.put(slice, Slice.INACTIVE);
            for (String subSlice2 : subSlices) {
                propMap.put(subSlice2, Slice.ACTIVE);
            }
            propMap.put("collection", collectionName);
            ZkNodeProps m = new ZkNodeProps(propMap);
            inQueue.offer(ZkStateReader.toJSON((Object)m));
            return true;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
    }

    private void collectShardResponses(NamedList results, boolean abortOnError, String msgOnError) {
        ShardResponse srsp;
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
            if (!abortOnError || srsp.getException() == null) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, srsp.getException());
        } while (srsp != null);
    }

    private void sendShardRequest(String nodeName, ModifiableSolrParams params) {
        ShardRequest sreq = new ShardRequest();
        params.set("qt", new String[]{this.adminPath});
        sreq.purpose = 1;
        String replica = this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName);
        if (replica.startsWith("http://")) {
            replica = replica.substring(7);
        }
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private void createCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        String collectionName = message.getStr("name");
        if (clusterState.getCollections().contains(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        try {
            ShardResponse srsp;
            int requestedShardsToCreate;
            int maxShardsAllowedToCreate;
            List createNodeList;
            int repFactor = this.msgStrToInt(message, REPLICATION_FACTOR, 1);
            Integer numSlices = this.msgStrToInt(message, NUM_SLICES, null);
            if (numSlices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param");
            }
            int maxShardsPerNode = this.msgStrToInt(message, MAX_SHARDS_PER_NODE, 1);
            String createNodeSetStr = message.getStr(CREATE_NODE_SET);
            List list = createNodeList = createNodeSetStr == null ? null : StrUtils.splitSmart((String)createNodeSetStr, (String)",", (boolean)true);
            if (repFactor <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "replicationFactor must be greater than or equal to 0");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            String configName = message.getStr("collection.configName");
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            if (createNodeList != null) {
                nodeList.retainAll(createNodeList);
            }
            Collections.shuffle(nodeList);
            if (nodeList.size() <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". No live Solr-instances" + (createNodeList != null ? " among Solr-instances specified in createNodeSet:" + createNodeSetStr : ""));
            }
            if (repFactor > nodeList.size()) {
                log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or part of your " + CREATE_NODE_SET + "(" + nodeList.size() + "). Its unusual to run two replica of the same slice on the same Solr-instance.");
            }
            if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + MAX_SHARDS_PER_NODE + " is " + maxShardsPerNode + ", and the number of live nodes is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + NUM_SLICES + " is " + numSlices + " and value of " + REPLICATION_FACTOR + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
            }
            for (int i = 1; i <= numSlices; ++i) {
                for (int j = 1; j <= repFactor; ++j) {
                    String nodeName = (String)nodeList.get((repFactor * (i - 1) + (j - 1)) % nodeList.size());
                    String sliceName = "shard" + i;
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                    params.set("name", new String[]{shardName});
                    params.set("collection.configName", new String[]{configName});
                    params.set("collection", new String[]{collectionName});
                    params.set("shard", new String[]{sliceName});
                    params.set(NUM_SLICES, numSlices.intValue());
                    ShardRequest sreq = new ShardRequest();
                    params.set("qt", new String[]{this.adminPath});
                    sreq.purpose = 1;
                    String replica = this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName);
                    if (replica.startsWith("http://")) {
                        replica = replica.substring(7);
                    }
                    sreq.shards = new String[]{replica};
                    sreq.actualShards = sreq.shards;
                    sreq.params = params;
                    this.shardHandler.submit(sreq, replica, sreq.params);
                }
            }
            do {
                if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
                this.processResponse(results, srsp);
            } while (srsp != null);
            log.info("Finished create command on all shards for collection: " + collectionName);
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    private void collectionCmd(ClusterState clusterState, ZkNodeProps message, ModifiableSolrParams params, NamedList results, String stateMatcher) {
        ShardResponse srsp;
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        DocCollection coll = clusterState.getCollection(collectionName);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection:" + collectionName);
        }
        for (Map.Entry entry : coll.getSlicesMap().entrySet()) {
            Slice slice = (Slice)entry.getValue();
            Map shards = slice.getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
                if (!clusterState.liveNodesContain(node.getStr("node_name")) || stateMatcher != null && !node.getStr("state").equals(stateMatcher)) continue;
                ModifiableSolrParams cloneParams = new ModifiableSolrParams();
                cloneParams.add((SolrParams)params);
                cloneParams.set("core", new String[]{node.getStr("core")});
                String replica = node.getStr("base_url");
                ShardRequest sreq = new ShardRequest();
                sreq.nodeName = node.getStr("node_name");
                cloneParams.set("qt", new String[]{this.adminPath});
                sreq.purpose = 1;
                if (replica.startsWith("http://")) {
                    replica = replica.substring(7);
                }
                sreq.shards = new String[]{replica};
                sreq.actualShards = sreq.shards;
                sreq.params = cloneParams;
                log.info("Collection Admin sending CoreAdmin cmd to " + replica + " params:" + sreq.params);
                this.shardHandler.submit(sreq, replica, sreq.params);
            }
        }
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
        } while (srsp != null);
    }

    private void processResponse(NamedList results, ShardResponse srsp) {
        Throwable e = srsp.getException();
        if (e != null) {
            log.error("Error from shard: " + srsp.getShard(), e);
            SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
            if (failure == null) {
                failure = new SimpleOrderedMap();
                results.add("failure", (Object)failure);
            }
            failure.add(srsp.getNodeName(), (Object)(e.getClass().getName() + ":" + e.getMessage()));
        } else {
            SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
            if (success == null) {
                success = new SimpleOrderedMap();
                results.add("success", (Object)success);
            }
            success.add(srsp.getNodeName(), (Object)srsp.getSolrResponse().getResponse());
        }
    }

    private Integer msgStrToInt(ZkNodeProps message, String key, Integer def) throws Exception {
        String str = message.getStr(key);
        try {
            return str == null ? def : Integer.parseInt(str);
        }
        catch (Exception ex) {
            SolrException.log((Logger)log, (String)("Could not parse " + key), (Throwable)ex);
            throw ex;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

